
#ifndef __D_GOB_INIT_C__
#define __D_GOB_INIT_C__

#include "D_GOB.h"


/*
 * void D_GOB::Init_Structure(const unsigned char *const src_Y_c, 
 *							const unsigned char *const src_U_c,
 *							const unsigned char *const src_V_c, 
 *							const int group_id)
 * 
 * Initialize basic data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_group_id, _MB_list
 * Ensures:		call D_Macroblock::Init_Structure() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Init_Structure(const unsigned char *const src_Y_c, const unsigned char *const src_U_c,
					  const unsigned char *const src_V_c, const int group_id)
{
	D_Macroblock *ptr_MB;
	int i;
	const unsigned char *y_this_MB;
	const unsigned char *u_this_MB;
	const unsigned char *v_this_MB;

	y_this_MB = src_Y_c;
	u_this_MB = src_U_c;
	v_this_MB = src_V_c;
	_group_id = group_id;
	
	// We only need to traverse the macroblocks on current GOB
	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {
		ptr_MB->Init_Structure(y_this_MB, u_this_MB, v_this_MB);
		ptr_MB++;
		y_this_MB += _MB_Y_offset;
		u_this_MB += _MB_UV_offset;
		v_this_MB += _MB_UV_offset;		
	}
}


/*
 * Overloaded function for advanced prediction
 * void D_GOB::Fast_Structure(short *const src_Y_c, 
 *								short *const src_U_c,
 *								short *const src_V_c,
 *								short *const zsrc_Y_s,
 *								short *const zsrc_U_s,
 *								short *const zsrc_V_s,
 *								const bool *const src_cgi,
 *								bool *const src_cmi,
 *								const bool *const src_flag_zero_mv,
 *								short *const src_mcbpc,
 *								short *const src_mcbpy,
 *								const short *const src_mtype,
 *								const short *const src_mquant,
 *								const short *const src_mv_type1,
 *								const short *const src_mv_x1,
 *								const short *const src_mv_y1,
 *								const short *const src_mv_type2,
 *								const short *const src_mv_x2, 
 *								const short *const src_mv_y2,
 *								const short *const src_mv_type3,
 *								const short *const src_mv_x3,
 *								const short *const src_mv_y3, 
 *								const short *const src_mv_type4,
 *								const short *const src_mv_x4,
 *								const short *const src_mv_y4)
 * 
 * Initialize fast data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_cgi, _gmquant, _MB_list
 * Ensures:		. Set above listed pointers
 *				. call D_Macroblock::Fast_Structure() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Fast_Structure(short *const src_Y_c, short *const src_U_c, short *const src_V_c,
	short *const zsrc_Y_s, short *const zsrc_U_s, short *const zsrc_V_s,
	const bool *const src_cgi, bool *const src_cmi, const bool *const src_flag_zero_mv,
	short *const src_mcbpc, short *const src_mcbpy, const short *const src_mtype,
	const short *const src_mquant,
	const short *const src_mv_type1, const short *const src_mv_x1, const short *const src_mv_y1,
	const short *const src_mv_type2, const short *const src_mv_x2, const short *const src_mv_y2,
	const short *const src_mv_type3, const short *const src_mv_x3, const short *const src_mv_y3,
	const short *const src_mv_type4, const short *const src_mv_x4, const short *const src_mv_y4)
{
	D_Macroblock *ptr_MB;
	int i;
	short *y_this_MB;
	short *u_this_MB;
	short *v_this_MB;
	short *zigzag_y_this_MB, *zigzag_u_this_MB, *zigzag_v_this_MB;
	short *ptr_mcbpc, *ptr_mcbpy;
	const short *ptr_mtype, *ptr_mquant;
	const short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	const short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	const short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	const short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;
	bool *ptr_cmi;
	const bool *ptr_flag_zero_mv;

	// Enable fast access to optimized data structures
	y_this_MB = src_Y_c;
	u_this_MB = src_U_c;
	v_this_MB = src_V_c;

	zigzag_y_this_MB = zsrc_Y_s;
	zigzag_u_this_MB = zsrc_U_s;
	zigzag_v_this_MB = zsrc_V_s;

	// Enable access to Mode Decision Data
	_cgi = src_cgi;
	ptr_cmi = src_cmi;
	ptr_flag_zero_mv = src_flag_zero_mv;
	ptr_mcbpc = src_mcbpc;
	ptr_mcbpy = src_mcbpy;

	// Enable access to header data, memory-allocated at frame level
	ptr_mtype = src_mtype;
	ptr_mquant = src_mquant;

	ptr_mv_type1 = src_mv_type1; ptr_mv_x1 = src_mv_x1; ptr_mv_y1 = src_mv_y1;
	ptr_mv_type2 = src_mv_type2; ptr_mv_x2 = src_mv_x2; ptr_mv_y2 = src_mv_y2;
	ptr_mv_type3 = src_mv_type3; ptr_mv_x3 = src_mv_x3; ptr_mv_y3 = src_mv_y3;
	ptr_mv_type4 = src_mv_type4; ptr_mv_x4 = src_mv_x4; ptr_mv_y4 = src_mv_y4;
	
	// Set GQuant to point MQuant of the first macroblock in this GOB
	_gquant = ptr_mquant;

	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {

		ptr_MB->Fast_Structure(y_this_MB, u_this_MB, v_this_MB,
			zigzag_y_this_MB, zigzag_u_this_MB, zigzag_v_this_MB,
			_cgi, ptr_cmi, ptr_flag_zero_mv, 
			ptr_mcbpc, ptr_mcbpy, ptr_mtype, ptr_mquant, 
			ptr_mv_type1, ptr_mv_x1, ptr_mv_y1,
			ptr_mv_type2, ptr_mv_x2, ptr_mv_y2,
			ptr_mv_type3, ptr_mv_x3, ptr_mv_y3,
			ptr_mv_type4, ptr_mv_x4, ptr_mv_y4);

		ptr_MB++;
		y_this_MB += 256;
		u_this_MB += 64;
		v_this_MB += 64;
		zigzag_y_this_MB += 256;
		zigzag_u_this_MB += 64;
		zigzag_v_this_MB += 64;
		
		ptr_cmi++;
		ptr_flag_zero_mv++;
		ptr_mcbpc++;
		ptr_mcbpy++;
		
		ptr_mtype++;
		ptr_mquant++;

		ptr_mv_type1++; ptr_mv_x1++; ptr_mv_y1++;
		ptr_mv_type2++; ptr_mv_x2++; ptr_mv_y2++;
		ptr_mv_type3++; ptr_mv_x3++; ptr_mv_y3++;
		ptr_mv_type4++; ptr_mv_x4++; ptr_mv_y4++;
	}
}


void D_GOB::Fast_RPS_Structure(const int *const src_trp, const int *const src_fr_num)
{
	_trp = src_trp;
	_fr_num = src_fr_num;
}


/*
 * void D_GOB::Fast_PB_Structure(short *const src_Y_c, 
 *								short *const src_U_c,
 *								short *const src_V_c,
 *								short *const zsrc_Y_s,
 *								short *const zsrc_U_s,
 *								short *const zsrc_V_s,
 *								const bool *const src_cgi,
 *								bool *const src_cmi,
 *								const bool *const src_flag_zero_mv,
 *								short *const src_mcbpc,
 *								short *const src_mcbpy,
 *								const short *const src_mtype,
 *								const short *const src_mquant,
 *								const short *const src_mv_type1,
 *								const short *const src_mv_x1,
 *								const short *const src_mv_y1,
 *								const short *const src_mv_type2,
 *								const short *const src_mv_x2, 
 *								const short *const src_mv_y2,
 *								const short *const src_mv_type3,
 *								const short *const src_mv_x3,
 *								const short *const src_mv_y3, 
 *								const short *const src_mv_type4,
 *								const short *const src_mv_x4, 
 *								const short *const src_mv_y4)
 * 
 * Initialize fast data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_cgi, _gmquant, _MB_list
 * Ensures:		. Set above listed pointers
 *				. call D_Macroblock::Fast_Structure() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Fast_PB_Structure(short *const src_mcbpb, const short *dbquant, const short *const src_bquant,
	const short *const src_mvd_type, const short *const src_mvd_x, const short *const src_mvd_y,
	const short *const src_mv_type1_f, const short *const src_mv_x1_f, const short *const src_mv_y1_f,
	const short *const src_mv_type2_f, const short *const src_mv_x2_f, const short *const src_mv_y2_f,
	const short *const src_mv_type3_f, const short *const src_mv_x3_f, const short *const src_mv_y3_f,
	const short *const src_mv_type4_f, const short *const src_mv_x4_f, const short *const src_mv_y4_f,
	const short *const src_mv_type1_b, const short *const src_mv_x1_b, const short *const src_mv_y1_b,
	const short *const src_mv_type2_b, const short *const src_mv_x2_b, const short *const src_mv_y2_b,
	const short *const src_mv_type3_b, const short *const src_mv_x3_b, const short *const src_mv_y3_b,
	const short *const src_mv_type4_b, const short *const src_mv_x4_b, const short *const src_mv_y4_b,
	const short *const src_mv_type_uv_f, const short *const src_mv_uvx_f, const short *const src_mv_uvy_f,
	const short *const src_mv_type_uv_b, const short *const src_mv_uvx_b, const short *const src_mv_uvy_b)
{
	D_Macroblock *ptr_MB;
	int i;
	short *ptr_mcbpb;
	const short *ptr_bquant;
	const short *ptr_mvd_type, *ptr_mvd_x, *ptr_mvd_y;				// delta motion vector
	const short *ptr_mv_type1_f, *ptr_mv_x1_f, *ptr_mv_y1_f;		// Forward motion vectors
	const short *ptr_mv_type2_f, *ptr_mv_x2_f, *ptr_mv_y2_f;
	const short *ptr_mv_type3_f, *ptr_mv_x3_f, *ptr_mv_y3_f;
	const short *ptr_mv_type4_f, *ptr_mv_x4_f, *ptr_mv_y4_f;
	const short *ptr_mv_type1_b, *ptr_mv_x1_b, *ptr_mv_y1_b;		// Backward motion vectors
	const short *ptr_mv_type2_b, *ptr_mv_x2_b, *ptr_mv_y2_b;	
	const short *ptr_mv_type3_b, *ptr_mv_x3_b, *ptr_mv_y3_b;	
	const short *ptr_mv_type4_b, *ptr_mv_x4_b, *ptr_mv_y4_b;	
	const short *ptr_mv_type_uv_f, *ptr_mv_uvx_f, *ptr_mv_uvy_f;	// Chrominance forward motion vector
	const short *ptr_mv_type_uv_b, *ptr_mv_uvx_b, *ptr_mv_uvy_b;	// Chrominance backware motion vector

	// Enable fast access to optimized data structures
	ptr_mcbpb = src_mcbpb;
	ptr_bquant = src_bquant;
	ptr_mvd_type = src_mvd_type;
	ptr_mvd_x = src_mvd_x;
	ptr_mvd_y = src_mvd_y;

	ptr_mv_type1_f = src_mv_type1_f; ptr_mv_x1_f = src_mv_x1_f; ptr_mv_y1_f = src_mv_y1_f;
	ptr_mv_type2_f = src_mv_type2_f; ptr_mv_x2_f = src_mv_x2_f; ptr_mv_y2_f = src_mv_y2_f;
	ptr_mv_type3_f = src_mv_type3_f; ptr_mv_x3_f = src_mv_x3_f; ptr_mv_y3_f = src_mv_y3_f;
	ptr_mv_type4_f = src_mv_type4_f; ptr_mv_x4_f = src_mv_x4_f; ptr_mv_y4_f = src_mv_y4_f;

	ptr_mv_type1_b = src_mv_type1_b; ptr_mv_x1_b = src_mv_x1_b; ptr_mv_y1_b = src_mv_y1_b;
	ptr_mv_type2_b = src_mv_type2_b; ptr_mv_x2_b = src_mv_x2_b; ptr_mv_y2_b = src_mv_y2_b;
	ptr_mv_type3_b = src_mv_type3_b; ptr_mv_x3_b = src_mv_x3_b; ptr_mv_y3_b = src_mv_y3_b;
	ptr_mv_type4_b = src_mv_type4_b; ptr_mv_x4_b = src_mv_x4_b; ptr_mv_y4_b = src_mv_y4_b;

	ptr_mv_type_uv_f = src_mv_type_uv_f; ptr_mv_uvx_f = src_mv_uvx_f; ptr_mv_uvy_f = src_mv_uvy_f;
	ptr_mv_type_uv_b = src_mv_type_uv_b; ptr_mv_uvx_b = src_mv_uvx_b; ptr_mv_uvy_b = src_mv_uvy_b;

	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {

		ptr_MB->Fast_PB_Structure(ptr_mcbpb, dbquant, ptr_bquant, 
			ptr_mvd_type, ptr_mvd_x, ptr_mvd_y,
			ptr_mv_type1_f, ptr_mv_x1_f, ptr_mv_y1_f,
			ptr_mv_type2_f, ptr_mv_x2_f, ptr_mv_y2_f,
			ptr_mv_type3_f, ptr_mv_x3_f, ptr_mv_y3_f,
			ptr_mv_type4_f, ptr_mv_x4_f, ptr_mv_y4_f,
			ptr_mv_type1_b, ptr_mv_x1_b, ptr_mv_y1_b,
			ptr_mv_type2_b, ptr_mv_x2_b, ptr_mv_y2_b,
			ptr_mv_type3_b, ptr_mv_x3_b, ptr_mv_y3_b,
			ptr_mv_type4_b, ptr_mv_x4_b, ptr_mv_y4_b,
			ptr_mv_type_uv_f, ptr_mv_uvx_f, ptr_mv_uvy_f,
			ptr_mv_type_uv_b, ptr_mv_uvx_b, ptr_mv_uvy_b);

		ptr_MB++;

		ptr_mcbpb++; ptr_bquant++;
		ptr_mvd_type++; ptr_mvd_x++; ptr_mvd_y++;

		ptr_mv_type1_f++; ptr_mv_x1_f++; ptr_mv_y1_f++;
		ptr_mv_type2_f++; ptr_mv_x2_f++; ptr_mv_y2_f++;
		ptr_mv_type3_f++; ptr_mv_x3_f++; ptr_mv_y3_f++;
		ptr_mv_type4_f++; ptr_mv_x4_f++; ptr_mv_y4_f++;

		ptr_mv_type1_b++; ptr_mv_x1_b++; ptr_mv_y1_b++;
		ptr_mv_type2_b++; ptr_mv_x2_b++; ptr_mv_y2_b++;
		ptr_mv_type3_b++; ptr_mv_x3_b++; ptr_mv_y3_b++;
		ptr_mv_type4_b++; ptr_mv_x4_b++; ptr_mv_y4_b++;
		
		ptr_mv_type_uv_f++; ptr_mv_uvx_f++; ptr_mv_uvy_f++;
		ptr_mv_type_uv_b++; ptr_mv_uvx_b++; ptr_mv_uvy_b++;

	}
}


/*
 * void D_GOB::Fast_Slice_Structure(short *const src_seg_ID, const short *src_seg_size, 
 *	const short *const src_right_span, const short *const src_left_span,
 *	const short *const src_x_bound_high, const short *const src_x_bound_low,
 *	const short *const src_y_bound_high, const short *const src_y_bound_low,
 *	const short *const src_mvx0_high, const short *const src_mvx0_low, 
 *	const short *const src_mvy0_high, const short *const src_mvy0_low,
 *	const short *const src_mvx1_high, const short *const src_mvx1_low,
 *	const short *const src_mvy1_high, const short *const src_mvy1_low,
 *	const short *const src_mvx2_high, const short *const src_mvx2_low,
 *	const short *const src_mvy2_high, const short *const src_mvy2_low,
 *	const short *const src_mvx3_high, const short *const src_mvx3_low,
 *	const short *const src_mvy3_high, const short *const src_mvy3_low,
 *	const short *const src_mvx4_high, const short *const src_mvx4_low,
 *	const short *const src_mvy4_high, const short *const src_mvy4_low,
 *	const bool *const src_x_border_high, const bool *const src_x_border_low,
 *	const bool *const src_y_border_high, const bool *const src_y_border_low)
 * 
 * Initialize fast data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_seg_ID
 * Ensures:		. call D_Macroblock::Fast_Slice_Structure() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Fast_Slice_Structure(const short *const src_seg_ID, const short *const src_seg_size, 
	const short *const src_right_span, const short *const src_left_span,
	const short *const src_x_bound_high, const short *const src_x_bound_low,
	const short *const src_y_bound_high, const short *const src_y_bound_low,
	const short *const src_mvx0_high, const short *const src_mvx0_low, 
	const short *const src_mvy0_high, const short *const src_mvy0_low,
	const short *const src_mvx1_high, const short *const src_mvx1_low,
	const short *const src_mvy1_high, const short *const src_mvy1_low,
	const short *const src_mvx2_high, const short *const src_mvx2_low,
	const short *const src_mvy2_high, const short *const src_mvy2_low,
	const short *const src_mvx3_high, const short *const src_mvx3_low,
	const short *const src_mvy3_high, const short *const src_mvy3_low,
	const short *const src_mvx4_high, const short *const src_mvx4_low,
	const short *const src_mvy4_high, const short *const src_mvy4_low,
	const bool *const src_mvx_border_high, const bool *const src_mvx_border_low,
	const bool *const src_mvy_border_high, const bool *const src_mvy_border_low)
{
	D_Macroblock *ptr_MB;
	int i;
	const short *ptr_seg_ID, *ptr_seg_size;
	const short *ptr_right_span, *ptr_left_span;
	const short *ptr_x_bound_high, *ptr_x_bound_low;
	const short *ptr_y_bound_high, *ptr_y_bound_low;
	const short *ptr_mvx0_high, *ptr_mvx0_low;
	const short *ptr_mvx1_high, *ptr_mvx1_low;
	const short *ptr_mvx2_high, *ptr_mvx2_low;
	const short *ptr_mvx3_high, *ptr_mvx3_low;
	const short *ptr_mvx4_high, *ptr_mvx4_low;
	const short *ptr_mvy0_high, *ptr_mvy0_low;
	const short *ptr_mvy1_high, *ptr_mvy1_low;
	const short *ptr_mvy2_high, *ptr_mvy2_low;
	const short *ptr_mvy3_high, *ptr_mvy3_low;
	const short *ptr_mvy4_high, *ptr_mvy4_low;
	const bool *ptr_mvx_border_high, *ptr_mvx_border_low;
	const bool *ptr_mvy_border_high, *ptr_mvy_border_low;

	// Enable fast access to optimized data structures
	_seg_ID = src_seg_ID;
	ptr_seg_ID = src_seg_ID; ptr_seg_size = src_seg_size;
	ptr_right_span = src_right_span; ptr_left_span = src_left_span;
	ptr_x_bound_high = src_x_bound_high; ptr_x_bound_low = src_x_bound_low;
	ptr_y_bound_high = src_y_bound_high; ptr_y_bound_low = src_y_bound_low;
	ptr_mvx0_high = src_mvx0_high; ptr_mvx0_low = src_mvx0_low;
	ptr_mvx1_high = src_mvx1_high; ptr_mvx1_low = src_mvx1_low;
	ptr_mvx2_high = src_mvx2_high; ptr_mvx2_low = src_mvx2_low;
	ptr_mvx3_high = src_mvx3_high; ptr_mvx3_low = src_mvx3_low;
	ptr_mvx4_high = src_mvx4_high; ptr_mvx4_low = src_mvx4_low;
	ptr_mvy0_high = src_mvy0_high; ptr_mvy0_low = src_mvy0_low;
	ptr_mvy1_high = src_mvy1_high; ptr_mvy1_low = src_mvy1_low;
	ptr_mvy2_high = src_mvy2_high; ptr_mvy2_low = src_mvy2_low;
	ptr_mvy3_high = src_mvy3_high; ptr_mvy3_low = src_mvy3_low;
	ptr_mvy4_high = src_mvy4_high; ptr_mvy4_low = src_mvy4_low;
	ptr_mvx_border_high = src_mvx_border_high; ptr_mvx_border_low = src_mvx_border_low;
	ptr_mvy_border_high = src_mvy_border_high; ptr_mvy_border_low = src_mvy_border_low;
	
	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {

		ptr_MB->Fast_Slice_Structure(ptr_seg_ID, ptr_seg_size,
			ptr_right_span, ptr_left_span,
			ptr_x_bound_high, ptr_x_bound_low,
			ptr_y_bound_high, ptr_y_bound_low,
			ptr_mvx0_high, ptr_mvx0_low, ptr_mvy0_high, ptr_mvy0_low,
			ptr_mvx1_high, ptr_mvx1_low, ptr_mvy1_high, ptr_mvy1_low,
			ptr_mvx2_high, ptr_mvx2_low, ptr_mvy2_high, ptr_mvy2_low,
			ptr_mvx3_high, ptr_mvx3_low, ptr_mvy3_high, ptr_mvy3_low,
			ptr_mvx4_high, ptr_mvx4_low, ptr_mvy4_high, ptr_mvy4_low,
			ptr_mvx_border_high, ptr_mvx_border_low,
			ptr_mvy_border_high, ptr_mvy_border_low);

		ptr_MB++;

		ptr_seg_ID++; ptr_seg_size++;
		ptr_right_span++; ptr_left_span++;
		ptr_x_bound_high++; ptr_x_bound_low++;
		ptr_y_bound_high++; ptr_y_bound_low++;

		ptr_mvx0_high++; ptr_mvx0_low++; ptr_mvy0_high++; ptr_mvy0_low++;
		ptr_mvx1_high++; ptr_mvx1_low++; ptr_mvy1_high++; ptr_mvy1_low++;
		ptr_mvx2_high++; ptr_mvx2_low++; ptr_mvy2_high++; ptr_mvy2_low++;
		ptr_mvx3_high++; ptr_mvx3_low++; ptr_mvy3_high++; ptr_mvy3_low++;
		ptr_mvx4_high++; ptr_mvx4_low++; ptr_mvy4_high++; ptr_mvy4_low++;
		ptr_mvx_border_high++; ptr_mvx_border_low++;
		ptr_mvy_border_high++; ptr_mvy_border_low++;

	}
}


/*
 * void D_GOB::Fast_Decoded_Structure(const unsigned char *const src_Y_c,
 *										const unsigned char *const src_U_c,
 *										const unsigned char *const src_V_c)V_c)
 * 
 * Initialize fast decoded structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Fast_Decoded_Structure() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Fast_Decoded_Structure(const unsigned char *const src_Y_c,
	const unsigned char *const src_U_c, const unsigned char *const src_V_c)
{
	D_Macroblock *ptr_MB;
	int i;
	const unsigned char *y_decoded_MB;
	const unsigned char *u_decoded_MB;
	const unsigned char *v_decoded_MB;

	// Enable fast access to decoded frame data
	y_decoded_MB = src_Y_c;
	u_decoded_MB = src_U_c;
	v_decoded_MB = src_V_c;

	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {

		ptr_MB->Fast_Decoded_Structure(y_decoded_MB, u_decoded_MB, v_decoded_MB);

		ptr_MB++;
		y_decoded_MB += 256;
		u_decoded_MB += 64;
		v_decoded_MB += 64;
	}
}


/*
 * void D_GOB::Fast_Differential_Motion_Vector(const bool first_GOB,
 *	const short *const fake_ID, const short *const zero_mv_type, const short *const zero_mv_x, const short *const zero_mv_y,
 *	const short *const src_seg_ID01, const short *const src_mv_type01, const short *const src_mv_x01, const short *const src_mv_y01,
 *	const short *const src_seg_ID02, const short *const src_mv_type02, const short *const src_mv_x02, const short *const src_mv_y02,
 *	const short *const src_seg_ID03, const short *const src_mv_type03, const short *const src_mv_x03, const short *const src_mv_y03)
 *
 * Initialize fast differential motion vectors
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Fast_Differential_Motion_Vector() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Fast_Differential_Motion_Vector(const bool first_GOB,
	const short *const fake_ID, const short *const zero_mv_type, const short *const zero_mv_x, const short *const zero_mv_y,
	const short *const src_seg_ID01, const short *const src_mv_type01, const short *const src_mv_x01, const short *const src_mv_y01,
	const short *const src_seg_ID02, const short *const src_mv_type02, const short *const src_mv_x02, const short *const src_mv_y02,
	const short *const src_seg_ID03, const short *const src_mv_type03, const short *const src_mv_x03, const short *const src_mv_y03)
{
	D_Macroblock *ptr_MB;
	int i, j;
	const short *ptr_seg_ID01, *ptr_seg_ID02, *ptr_seg_ID03;
	const short *ptr_mv_type01, *ptr_mv_type02, *ptr_mv_type03;
	const short *ptr_mv_x01, *ptr_mv_x02, *ptr_mv_x03;
	const short *ptr_mv_y01, *ptr_mv_y02, *ptr_mv_y03;

	ptr_seg_ID01 = src_seg_ID01;	ptr_seg_ID02 = src_seg_ID02;	ptr_seg_ID03 = src_seg_ID03;
	ptr_mv_type01 = src_mv_type01;	ptr_mv_x01 = src_mv_x01;		ptr_mv_y01 = src_mv_y01;
	ptr_mv_type02 = src_mv_type02;	ptr_mv_x02 = src_mv_x02;		ptr_mv_y02 = src_mv_y02;
	ptr_mv_type03 = src_mv_type03;	ptr_mv_x03 = src_mv_x03;		ptr_mv_y03 = src_mv_y03;

	ptr_MB = _MB_list;

	if (first_GOB) {
		ptr_MB++->Fast_Differential_Motion_Vector(
			fake_ID, fake_ID, fake_ID, zero_mv_type, zero_mv_type, zero_mv_type,
			zero_mv_x, zero_mv_x, zero_mv_x, zero_mv_y, zero_mv_y, zero_mv_y);
	}
	else {
		ptr_MB++->Fast_Differential_Motion_Vector(
			fake_ID, ptr_seg_ID02++, ptr_seg_ID03++, zero_mv_type, ptr_mv_type02++, ptr_mv_type03++,
			zero_mv_x, ptr_mv_x02++, ptr_mv_x03++, zero_mv_y, ptr_mv_y02++, ptr_mv_y03++);
	}

	j = (_MB_per_gob - 1);
	for (i=1, j=_MB_per_gob-1; i<j; i++) {
		ptr_MB++->Fast_Differential_Motion_Vector(
			ptr_seg_ID01++, ptr_seg_ID02++, ptr_seg_ID03++, 
			ptr_mv_type01++, ptr_mv_type02++, ptr_mv_type03++,
			ptr_mv_x01++, ptr_mv_x02++, ptr_mv_x03++, 
			ptr_mv_y01++, ptr_mv_y02++, ptr_mv_y03++);
	}

	ptr_MB->Fast_Differential_Motion_Vector(
		ptr_seg_ID01, ptr_seg_ID02, ptr_seg_ID03, ptr_mv_type01, ptr_mv_type02, zero_mv_type,
		ptr_mv_x01, ptr_mv_x02, zero_mv_x, ptr_mv_y01, ptr_mv_y02, zero_mv_y);
}


/* 
 * Overloaded function for Advanced Prediction Mode
 * void D_GOB::Fast_Differential_Motion_Vector(const bool first_GOB,
 *		const short *const fake_ID, const short *const zero_mv_type, const short *const zero_mv_x, const short *const zero_mv_y,
 *		const short *const src_seg_ID01, const short *const src_mvd_type1, const short *const src_mvd_x1, const short *const src_mvd_y1,
 *		const short *const src_seg_ID02, const short *const src_mvd_type2, const short *const src_mvd_x2, const short *const src_mvd_y2,
 *		const short *const src_seg_ID03, const short *const src_mvd_type3, const short *const src_mvd_x3, const short *const src_mvd_y3,
 *		const short *const src_seg_ID11, const short *const src_mv_type11, const short *const src_mv_x11, const short *const src_mv_y11,
 *		const short *const src_seg_ID12, const short *const src_mv_type12, const short *const src_mv_x12, const short *const src_mv_y12,
 *		const short *const src_seg_ID13, const short *const src_mv_type13, const short *const src_mv_x13, const short *const src_mv_y13,
 *		const short *const src_seg_ID21, const short *const src_mv_type21, const short *const src_mv_x21, const short *const src_mv_y21,
 *		const short *const src_seg_ID22, const short *const src_mv_type22, const short *const src_mv_x22, const short *const src_mv_y22,
 *		const short *const src_seg_ID23, const short *const src_mv_type23, const short *const src_mv_x23, const short *const src_mv_y23,
 *		const short *const src_seg_ID31, const short *const src_mv_type31, const short *const src_mv_x31, const short *const src_mv_y31,
 *		const short *const src_seg_ID32, const short *const src_mv_type32, const short *const src_mv_x32, const short *const src_mv_y32,
 *		const short *const src_seg_ID33, const short *const src_mv_type33, const short *const src_mv_x33, const short *const src_mv_y33,
 *		const short *const src_seg_ID41, const short *const src_mv_type41, const short *const src_mv_x41, const short *const src_mv_y41,
 *		const short *const src_seg_ID42, const short *const src_mv_type42, const short *const src_mv_x42, const short *const src_mv_y42,
 *		const short *const src_seg_ID43, const short *const src_mv_type43, const short *const src_mv_x43, const short *const src_mv_y43);
 * 
 * Initialize fast differential motion vectors
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Fast_Differential_Motion_Vector() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Fast_Differential_Motion_Vector(const bool first_GOB,
		const short *const fake_ID, const short *const zero_mv_type, const short *const zero_mv_x, const short *const zero_mv_y,
		const short *const src_seg_ID01, const short *const src_mvd_type1, const short *const src_mvd_x1, const short *const src_mvd_y1,
		const short *const src_seg_ID02, const short *const src_mvd_type2, const short *const src_mvd_x2, const short *const src_mvd_y2,
		const short *const src_seg_ID03, const short *const src_mvd_type3, const short *const src_mvd_x3, const short *const src_mvd_y3,
		const short *const src_seg_ID11, const short *const src_mv_type11, const short *const src_mv_x11, const short *const src_mv_y11,
		const short *const src_seg_ID12, const short *const src_mv_type12, const short *const src_mv_x12, const short *const src_mv_y12,
		const short *const src_seg_ID13, const short *const src_mv_type13, const short *const src_mv_x13, const short *const src_mv_y13,
		const short *const src_seg_ID21, const short *const src_mv_type21, const short *const src_mv_x21, const short *const src_mv_y21,
		const short *const src_seg_ID22, const short *const src_mv_type22, const short *const src_mv_x22, const short *const src_mv_y22,
		const short *const src_seg_ID23, const short *const src_mv_type23, const short *const src_mv_x23, const short *const src_mv_y23,
		const short *const src_seg_ID31, const short *const src_mv_type31, const short *const src_mv_x31, const short *const src_mv_y31,
		const short *const src_seg_ID32, const short *const src_mv_type32, const short *const src_mv_x32, const short *const src_mv_y32,
		const short *const src_seg_ID33, const short *const src_mv_type33, const short *const src_mv_x33, const short *const src_mv_y33,
		const short *const src_seg_ID41, const short *const src_mv_type41, const short *const src_mv_x41, const short *const src_mv_y41,
		const short *const src_seg_ID42, const short *const src_mv_type42, const short *const src_mv_x42, const short *const src_mv_y42,
		const short *const src_seg_ID43, const short *const src_mv_type43, const short *const src_mv_x43, const short *const src_mv_y43)
{
	D_Macroblock *ptr_MB;
	int i, j;
	// Delta motion vectors
	const short *ptr_seg_ID01, *ptr_seg_ID02, *ptr_seg_ID03;
	const short *ptr_mvd_type1, *ptr_mvd_x1, *ptr_mvd_y1;
	const short *ptr_mvd_type2, *ptr_mvd_x2, *ptr_mvd_y2;
	const short *ptr_mvd_type3, *ptr_mvd_x3, *ptr_mvd_y3;

	// 4 Motion vectors
	const short *ptr_seg_ID11, *ptr_seg_ID12, *ptr_seg_ID13;
	const short *ptr_mv_type11, *ptr_mv_type12, *ptr_mv_type13;
	const short *ptr_mv_x11, *ptr_mv_x12, *ptr_mv_x13;
	const short *ptr_mv_y11, *ptr_mv_y12, *ptr_mv_y13;
	
	const short *ptr_seg_ID21, *ptr_seg_ID22, *ptr_seg_ID23;
	const short *ptr_mv_type21, *ptr_mv_type22, *ptr_mv_type23;
	const short *ptr_mv_x21, *ptr_mv_x22, *ptr_mv_x23;
	const short *ptr_mv_y21, *ptr_mv_y22, *ptr_mv_y23;
	
	const short *ptr_seg_ID31, *ptr_seg_ID32, *ptr_seg_ID33;
	const short *ptr_mv_type31, *ptr_mv_type32, *ptr_mv_type33;
	const short *ptr_mv_x31, *ptr_mv_x32, *ptr_mv_x33;
	const short *ptr_mv_y31, *ptr_mv_y32, *ptr_mv_y33;
	
	const short *ptr_seg_ID41, *ptr_seg_ID42, *ptr_seg_ID43;
	const short *ptr_mv_type41, *ptr_mv_type42, *ptr_mv_type43;
	const short *ptr_mv_x41, *ptr_mv_x42, *ptr_mv_x43;
	const short *ptr_mv_y41, *ptr_mv_y42, *ptr_mv_y43;
	
	// Delta motion vectors
	ptr_seg_ID01 = src_seg_ID01;	ptr_seg_ID02 = src_seg_ID02;	ptr_seg_ID03 = src_seg_ID03;
	ptr_mvd_type1 = src_mvd_type1;	ptr_mvd_x1 = src_mvd_x1;		ptr_mvd_y1 = src_mvd_y1;
	ptr_mvd_type2 = src_mvd_type2;	ptr_mvd_x2 = src_mvd_x2;		ptr_mvd_y2 = src_mvd_y2;
	ptr_mvd_type3 = src_mvd_type3;	ptr_mvd_x3 = src_mvd_x3;		ptr_mvd_y3 = src_mvd_y3;

	// 4 motion vectors
	ptr_seg_ID11 = src_seg_ID11;	ptr_seg_ID12 = src_seg_ID12;	ptr_seg_ID13 = src_seg_ID13;
	ptr_mv_type11 = src_mv_type11;	ptr_mv_x11 = src_mv_x11;		ptr_mv_y11 = src_mv_y11;
	ptr_mv_type12 = src_mv_type12;	ptr_mv_x12 = src_mv_x12;		ptr_mv_y12 = src_mv_y12;
	ptr_mv_type13 = src_mv_type13;	ptr_mv_x13 = src_mv_x13;		ptr_mv_y13 = src_mv_y13;
	
	ptr_seg_ID21 = src_seg_ID21;	ptr_seg_ID22 = src_seg_ID22;	ptr_seg_ID23 = src_seg_ID23;
	ptr_mv_type21 = src_mv_type21;	ptr_mv_x21 = src_mv_x21;		ptr_mv_y21 = src_mv_y21;
	ptr_mv_type22 = src_mv_type22;	ptr_mv_x22 = src_mv_x22;		ptr_mv_y22 = src_mv_y22;
	ptr_mv_type23 = src_mv_type23;	ptr_mv_x23 = src_mv_x23;		ptr_mv_y23 = src_mv_y23;
	
	ptr_seg_ID31 = src_seg_ID31;	ptr_seg_ID32 = src_seg_ID32;	ptr_seg_ID33 = src_seg_ID33;
	ptr_mv_type31 = src_mv_type31;	ptr_mv_x31 = src_mv_x31;		ptr_mv_y31 = src_mv_y31;
	ptr_mv_type32 = src_mv_type32;	ptr_mv_x32 = src_mv_x32;		ptr_mv_y32 = src_mv_y32;
	ptr_mv_type33 = src_mv_type33;	ptr_mv_x33 = src_mv_x33;		ptr_mv_y33 = src_mv_y33;
	
	ptr_seg_ID41 = src_seg_ID41;	ptr_seg_ID42 = src_seg_ID42;	ptr_seg_ID43 = src_seg_ID43;
	ptr_mv_type41 = src_mv_type41;	ptr_mv_x41 = src_mv_x41;		ptr_mv_y41 = src_mv_y41;
	ptr_mv_type42 = src_mv_type42;	ptr_mv_x42 = src_mv_x42;		ptr_mv_y42 = src_mv_y42;
	ptr_mv_type43 = src_mv_type43;	ptr_mv_x43 = src_mv_x43;		ptr_mv_y43 = src_mv_y43;
	
	
	ptr_MB = _MB_list;

	// First Macroblock
	if (first_GOB) {
		ptr_MB->Fast_Differential_Motion_Vector(
			fake_ID, fake_ID, fake_ID,
			zero_mv_type, zero_mv_type, zero_mv_type,
			zero_mv_x, zero_mv_x, zero_mv_x, zero_mv_y, zero_mv_y, zero_mv_y,
			ptr_seg_ID21++, ptr_seg_ID22++, ptr_seg_ID23++,
			ptr_mv_type21++, ptr_mv_type22++, ptr_mv_type23++, 
			ptr_mv_x21++, ptr_mv_x22++, ptr_mv_x23++, ptr_mv_y21++, ptr_mv_y22++, ptr_mv_y23++,
			fake_ID, ptr_seg_ID32++, ptr_seg_ID33++,
			zero_mv_type, ptr_mv_type32++, ptr_mv_type33++, 
			zero_mv_x, ptr_mv_x32++, ptr_mv_x33++, zero_mv_y, ptr_mv_y32++, ptr_mv_y33++,
			ptr_seg_ID41++, ptr_seg_ID42++, ptr_seg_ID43++,
			ptr_mv_type41++, ptr_mv_type42++, ptr_mv_type43++,
			ptr_mv_x41++, ptr_mv_x42++, ptr_mv_x43++, ptr_mv_y41++, ptr_mv_y42++, ptr_mv_y43++,
			fake_ID, fake_ID, fake_ID,
			zero_mv_type, zero_mv_type, zero_mv_type,
			zero_mv_x, zero_mv_x, zero_mv_x, zero_mv_y, zero_mv_y, zero_mv_y);
	}
	else {
		ptr_MB->Fast_Differential_Motion_Vector(
			fake_ID, ptr_seg_ID12++, ptr_seg_ID13++,
			zero_mv_type, ptr_mv_type12++, ptr_mv_type13++,
			zero_mv_x, ptr_mv_x12++, ptr_mv_x13++, zero_mv_y, ptr_mv_y12++, ptr_mv_y13++,
			ptr_seg_ID21++, ptr_seg_ID22++, ptr_seg_ID23++,
			ptr_mv_type21++, ptr_mv_type22++, ptr_mv_type23++,
			ptr_mv_x21++, ptr_mv_x22++, ptr_mv_x23++, ptr_mv_y21++, ptr_mv_y22++, ptr_mv_y23++,
			fake_ID, ptr_seg_ID32++, ptr_seg_ID33++,
			zero_mv_type, ptr_mv_type32++, ptr_mv_type33++,
			zero_mv_x, ptr_mv_x32++, ptr_mv_x33++, zero_mv_y, ptr_mv_y32++, ptr_mv_y33++,
			ptr_seg_ID41++, ptr_seg_ID42++, ptr_seg_ID43++,
			ptr_mv_type41++, ptr_mv_type42++, ptr_mv_type43++,
			ptr_mv_x41++, ptr_mv_x42++, ptr_mv_x43++, ptr_mv_y41++, ptr_mv_y42++, ptr_mv_y43++,
			fake_ID, ptr_seg_ID02++, ptr_seg_ID03++,
			zero_mv_type, ptr_mvd_type2++, ptr_mvd_type3++,
			zero_mv_x, ptr_mvd_x2++, ptr_mvd_x3++, zero_mv_y, ptr_mvd_y2++, ptr_mvd_y3++);
	}

	ptr_MB++;

	// Macroblocks except first and last ones
	j = (_MB_per_gob - 1);
	for (i=1; i<j; i++) {
		ptr_MB->Fast_Differential_Motion_Vector(
			ptr_seg_ID11++, ptr_seg_ID12++, ptr_seg_ID13++,
			ptr_mv_type11++, ptr_mv_type12++, ptr_mv_type13++,
			ptr_mv_x11++, ptr_mv_x12++, ptr_mv_x13++, ptr_mv_y11++, ptr_mv_y12++, ptr_mv_y13++,
			ptr_seg_ID21++, ptr_seg_ID22++, ptr_seg_ID23++,
			ptr_mv_type21++, ptr_mv_type22++, ptr_mv_type23++,
			ptr_mv_x21++, ptr_mv_x22++, ptr_mv_x23++, ptr_mv_y21++, ptr_mv_y22++, ptr_mv_y23++,
			ptr_seg_ID31++, ptr_seg_ID32++, ptr_seg_ID33++,
			ptr_mv_type31++, ptr_mv_type32++, ptr_mv_type33++,
			ptr_mv_x31++, ptr_mv_x32++, ptr_mv_x33++, ptr_mv_y31++, ptr_mv_y32++, ptr_mv_y33++,
			ptr_seg_ID41++, ptr_seg_ID42++, ptr_seg_ID43++,
			ptr_mv_type41++, ptr_mv_type42++, ptr_mv_type43++,
			ptr_mv_x41++, ptr_mv_x42++, ptr_mv_x43++, ptr_mv_y41++, ptr_mv_y42++, ptr_mv_y43++,
			ptr_seg_ID01++, ptr_seg_ID02++, ptr_seg_ID03++,
			ptr_mvd_type1++, ptr_mvd_type2++, ptr_mvd_type3++,
			ptr_mvd_x1++, ptr_mvd_x2++, ptr_mvd_x3++, ptr_mvd_y1++, ptr_mvd_y2++, ptr_mvd_y3++);
		ptr_MB++;
	}

	// Last Macroblock
	// The last macroblock of the GOB has same ptr_mv_types etc. for blocks 0 & 1
	ptr_MB->Fast_Differential_Motion_Vector(
		ptr_seg_ID11, ptr_seg_ID12, fake_ID,
		ptr_mv_type11, ptr_mv_type12, zero_mv_type,
		ptr_mv_x11, ptr_mv_x12, zero_mv_x, ptr_mv_y11, ptr_mv_y12, zero_mv_y,
		ptr_seg_ID21, ptr_seg_ID22, fake_ID,
		ptr_mv_type21, ptr_mv_type22, zero_mv_type,
		ptr_mv_x21, ptr_mv_x22, zero_mv_x, ptr_mv_y21, ptr_mv_y22, zero_mv_y,
		ptr_seg_ID31, ptr_seg_ID32, ptr_seg_ID33,
		ptr_mv_type31, ptr_mv_type32, ptr_mv_type33,
		ptr_mv_x31, ptr_mv_x32, ptr_mv_x33, ptr_mv_y31, ptr_mv_y32, ptr_mv_y33,
		ptr_seg_ID41, ptr_seg_ID42, ptr_seg_ID43,
		ptr_mv_type41, ptr_mv_type42, ptr_mv_type43,
		ptr_mv_x41, ptr_mv_x42, ptr_mv_x43, ptr_mv_y41, ptr_mv_y42, ptr_mv_y43,
		ptr_seg_ID01, ptr_seg_ID02, fake_ID,
		ptr_mvd_type1, ptr_mvd_type2, zero_mv_type,
		ptr_mvd_x1, ptr_mvd_x2, zero_mv_x, ptr_mvd_y1, ptr_mvd_y2, zero_mv_y);
}


#endif

