
#ifndef __D_GOB_ENTROPY_ENCODER_C__
#define __D_GOB_ENTROPY_ENCODER_C__

#include "D_GOB.h"
/*
 * void D_GOB::Entropy_Encoder(PSC_Fifo &bit_ostream)
 * 
 * Entropy encode the current GOB,
 * then call D_Macroblock::Entropy_Encoder() of macroblocks pointed by _MB_list
 * This is a public method
 *
 * Requires:	Encode_GOB() is called before evoking this method from the Frame layer
 * Modifies:	bit_ostream
 * Ensures:		Entropy encode the GOB header according to the standard
 *
 * Warning:		baseline implementation
 */
void D_GOB::Entropy_Encoder(PSC_Fifo &bit_ostream)
{
	bool bits[60];	// PSTUFF(7)+GBSC(17)+GN(5)+GFID(2)+GQUANT(5)+
	bool *ptr_b;	// TRI(1)+TR(10)+TRPI(1)+TRP(10)+BCI(2)+BCM(for now:0) = 
	int i, k, bitcount;
	D_Macroblock *ptr_MB;

	// I'm assuming cgi is always false for first frame
	if (*_cgi == false) goto BYPASS;

	ptr_b = bits;

	// GBSC - Group of Block Start Code - 17 bits
	bitcount = 17;
	for (i=0; i<16; i++) *ptr_b++ = false;
	*ptr_b++ = true;

	// GN - Group Number
	k = _group_id;
	bitcount += 5;
	for (i=0; i<5; i++, k <<= 1) {
		if (k & 16) *ptr_b++ = true;
		else *ptr_b++ = false;
	}

	// GFID - GOB Frame ID - 2 bits
	bitcount += 2;	// GOB Frame ID, set according to frame mode
	*ptr_b++ = _PB_Ppicture_flag;
	*ptr_b++ = _inter_frame_mode;
	if (EDEBUG) fprintf(stdout, "GFID %d%d\n", _PB_Ppicture_flag, _inter_frame_mode);

	// GQUANT - Quantizer Information - 5 bits
	k = *_gquant;
	bitcount += 5;
	for (i=0; i<5; i++, k <<= 1) {
		if (k & 16) *ptr_b++ = true;
		else *ptr_b++ = false;
	}
	if (EDEBUG) fprintf(stdout, "GQUANT %d\n", *_gquant);
	
	// Send Reference Picture Selection Mode info
	if (_reference_picture_selection) {
		// TRI - Temporal Reference Indicator - 1 bit
		bitcount++;
		*ptr_b++ = 0; // TR field is not present (BCM must be implemented)

		// TR - Temporal Reference - 8 bits
		// bitcount += 8;
		// k = *_fr_num;	// We're not supporting GOB's from previous frames yet
		// for (i=0; i<8; i++, k <<= 1) {
		// 	if (k & 128) *ptr_b++ = true;
		// 	else *ptr_b++ = false;
		// }
		// if (EDEBUG) fprintf(stdout, "GTR %d\n", (*(_fr_num) & 255));

		// TRPI - Temporal Reference for Prediction Indicator - 1 bit
		bitcount++;
		if (*_trp != 0) {
			*ptr_b++ = 1;
			
			bitcount += 10;
			// TRP - Temporal Reference for Prediction - 10 bits
			*ptr_b++ = 0;	// For Extended TR
			*ptr_b++ = 0;
			k = *_fr_num - *_trp;
			if (EDEBUG) fprintf(stdout, "GTRP %d - TRP %d\n", (k & 255), *_trp);
			for (i=0; i<8; i++, k <<= 1) {
				if (k & 128) *ptr_b++ = true;
				else *ptr_b++ = false;			}
		}
		else *ptr_b++ = 0;

		// BCI - Back-Channel Message Indication - Variable Length
		bitcount += 2;
		*ptr_b++ = 0;	// Absence or the end of the video back-channel message field
		*ptr_b++ = 1;
	}

	bit_ostream.WriteNBits(bits, bitcount);
	
BYPASS:
	ptr_MB = _MB_list;
	
	for (i=0; i<_MB_per_gob; i++) {
		if (EDEBUG) fprintf(stdout, "\n --> MB %d\n", i);
		ptr_MB->Entropy_Encoder(bit_ostream);
		ptr_MB++;
	}
	
}

#endif
