
#ifndef __D_GOB_ENCODE_GOB_C__
#define __D_GOB_ENCODE_GOB_C__

#include "D_GOB.h"


/*
 * void D_GOB::Encode_GOB(void)
 * 
 * Intiates GOB encoding, which will call D_Macroblock::Encode_MB()
 * This is a public method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Encode_MB() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Encode_GOB(void)
{
	D_Macroblock *ptr_MB;
	int i;
	
	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {
		ptr_MB->Encode_MB();
		ptr_MB++;
	}
}


/*
 * void D_GOB::Encode_GOB(bool P_picture)
 * 
 * Intiates GOB encoding, which will call D_Macroblock::Encode_MB()
 * This is a public method
 *
 * Requires:	_fast_frame contains residual pixel
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		call D_Macroblock::Encode_MB() of macroblocks pointed by _MB_list
 *
 * Warning:		
 */
void D_GOB::Encode_GOB(bool P_picture)
{
	D_Macroblock *ptr_MB;
	int i;
	
	ptr_MB = _MB_list;
	for (i=0; i<_MB_per_gob; i++) {
		ptr_MB->Encode_MB(P_picture);
		ptr_MB++;
	}
}
#endif

