
#ifndef D_GOB_H
#define D_GOB_H		/*+ To stop multiple inclusions. +*/

#include "PSC_Fifo.h"
#include "Constants.h"
#include "D_Macroblock.h"


class D_GOB {
protected:
	D_Macroblock *_MB_list;

	int _group_id;								// ID tag
	int _frame_xsize;
	int _MB_per_gob;							// dynamically determined based on picture format	
	int _MB_Y_offset, _MB_UV_offset;			// block offset, to traverse 1D data structure

	const short *_gquant;						// group quant
	const short *_seg_ID;						// segment ID
	const bool *_cgi;							// Coded group indicator
	const int *_trp;							// Temporal Reference Predictor
	const int *_fr_num;							// Pointer to Frame's _fr_num

public:
	static bool _encode_mode;

	static int _sformat;						// picture type; defined in Constants.h
	static int _PB_offset;
	static bool _inter_frame_mode;				// current frame mode: INTRA (false) vs. INTER (true)
	static bool _PB_frame_mode;
	static bool _PB_Ppicture_flag;
	static bool _syntax_arithmetic_coding_mode;
	static bool _coded_mvd_flag;
	static bool _advanced_prediction_mode;
	static bool _reference_picture_selection;
	static bool _independent_segment_mode;
	static bool _advanced_intra_coding_mode;

	D_GOB(void);
	~D_GOB(void);

	void Create_Data_Structure(D_Macroblock *src_head);
	void Init_Structure(const unsigned char *const src_Y_c, const unsigned char *const src_U_c,
		const unsigned char *const src_V_c, const int group_id);

	void Fast_Structure(
		short *const src_Y_c, short *const src_U_c, short *const src_V_c,
		short *const zsrc_Y_s, short *const zsrc_U_s, short *const zsrc_V_s,
		const bool *const src_cgi, bool *const src_cmi, const bool *const src_flag_zero_mv,
		short *const src_mcbpc, short *const src_mcbpy, const short *const src_mtype,
		const short *const src_mquant,
		const short *const src_mv_type1, const short *const src_mv_x1, const short *const src_mv_y1,
		const short *const src_mv_type2, const short *const src_mv_x2, const short *const src_mv_y2,
		const short *const src_mv_type3, const short *const src_mv_x3, const short *const src_mv_y3,
		const short *const src_mv_type4, const short *const src_mv_x4, const short *const src_mv_y4);
	
	void Fast_PB_Structure(short *const src_mcbpb, const short *dbquant, const short *const src_bquant,
		const short *const src_mvd_type, const short *const src_mvd_x, const short *const src_mvd_y,
		const short *const src_mv_type1_f, const short *const src_mv_x1_f, const short *const src_mv_y1_f,
		const short *const src_mv_type2_f, const short *const src_mv_x2_f, const short *const src_mv_y2_f,
		const short *const src_mv_type3_f, const short *const src_mv_x3_f, const short *const src_mv_y3_f,
		const short *const src_mv_type4_f, const short *const src_mv_x4_f, const short *const src_mv_y4_f,
		const short *const src_mv_type1_b, const short *const src_mv_x1_b, const short *const src_mv_y1_b,
		const short *const src_mv_type2_b, const short *const src_mv_x2_b, const short *const src_mv_y2_b,
		const short *const src_mv_type3_b, const short *const src_mv_x3_b, const short *const src_mv_y3_b,
		const short *const src_mv_type4_b, const short *const src_mv_x4_b, const short *const src_mv_y4_b,
		const short *const src_mv_type_uv_f, const short *const src_mv_uvx_f, const short *const src_mv_uvy_f,
		const short *const src_mv_type_uv_b, const short *const src_mv_uvx_b, const short *const src_mv_uvy_b);
	
	void Fast_RPS_Structure(const int *const src_trp, const int*const src_fr_num);

	void Fast_Slice_Structure(const short *const src_seg_ID, const short *const src_seg_size, 
		const short *const src_right_span, const short *const src_left_span,
		const short *const src_x_bound_high, const short *const src_x_bound_low,
		const short *const src_y_bound_high, const short *const src_y_bound_low,
		const short *const src_mvx0_high, const short *const src_mvx0_low, 
		const short *const src_mvy0_high, const short *const src_mvy0_low,
		const short *const src_mvx1_high, const short *const src_mvx1_low,
		const short *const src_mvy1_high, const short *const src_mvy1_low,
		const short *const src_mvx2_high, const short *const src_mvx2_low,
		const short *const src_mvy2_high, const short *const src_mvy2_low,
		const short *const src_mvx3_high, const short *const src_mvx3_low,
		const short *const src_mvy3_high, const short *const src_mvy3_low,
		const short *const src_mvx4_high, const short *const src_mvx4_low,
		const short *const src_mvy4_high, const short *const src_mvy4_low,
		const bool *const src_mvx_border_high, const bool *const src_mvx_border_low,
		const bool *const src_mvy_border_high, const bool *const src_mvy_border_low);

	void Fast_Decoded_Structure(const unsigned char *const src_Y_c,
		const unsigned char *const src_U_c, const unsigned char *const src_V_c);

	void Fast_Differential_Motion_Vector(const bool first_GOB,
		const short *const fake_ID, const short *const zero_mv_type, const short *const zero_mv_x, const short *const zero_mv_y,
		const short *const src_seg_ID01, const short *const src_mv_type01, const short *const src_mv_x01, const short *const src_mv_y01,
		const short *const src_seg_ID02, const short *const src_mv_type02, const short *const src_mv_x02, const short *const src_mv_y02,
		const short *const src_seg_ID03, const short *const src_mv_type03, const short *const src_mv_x03, const short *const src_mv_y03);
	
	void Fast_Differential_Motion_Vector(const bool first_GOB,
		const short *const fake_ID, const short *const zero_mv_type, const short *const zero_mv_x, const short *const zero_mv_y,
		const short *const src_seg_ID01, const short *const src_mvd_type1, const short *const src_mvd_x1, const short *const src_mvd_y1,
		const short *const src_seg_ID02, const short *const src_mvd_type2, const short *const src_mvd_x2, const short *const src_mvd_y2,
		const short *const src_seg_ID03, const short *const src_mvd_type3, const short *const src_mvd_x3, const short *const src_mvd_y3,
		const short *const src_seg_ID11, const short *const src_mv_type11, const short *const src_mv_x11, const short *const src_mv_y11,
		const short *const src_seg_ID12, const short *const src_mv_type12, const short *const src_mv_x12, const short *const src_mv_y12,
		const short *const src_seg_ID13, const short *const src_mv_type13, const short *const src_mv_x13, const short *const src_mv_y13,
		const short *const src_seg_ID21, const short *const src_mv_type21, const short *const src_mv_x21, const short *const src_mv_y21,
		const short *const src_seg_ID22, const short *const src_mv_type22, const short *const src_mv_x22, const short *const src_mv_y22,
		const short *const src_seg_ID23, const short *const src_mv_type23, const short *const src_mv_x23, const short *const src_mv_y23,
		const short *const src_seg_ID31, const short *const src_mv_type31, const short *const src_mv_x31, const short *const src_mv_y31,
		const short *const src_seg_ID32, const short *const src_mv_type32, const short *const src_mv_x32, const short *const src_mv_y32,
		const short *const src_seg_ID33, const short *const src_mv_type33, const short *const src_mv_x33, const short *const src_mv_y33,
		const short *const src_seg_ID41, const short *const src_mv_type41, const short *const src_mv_x41, const short *const src_mv_y41,
		const short *const src_seg_ID42, const short *const src_mv_type42, const short *const src_mv_x42, const short *const src_mv_y42,
		const short *const src_seg_ID43, const short *const src_mv_type43, const short *const src_mv_x43, const short *const src_mv_y43);


	void Encode_GOB(void);
	void Encode_GOB(bool P_picture);
	void Entropy_Encoder(PSC_Fifo &bit_ostream);
	void SAC_Encoder(PSC_Fifo &bis_ostream, symbol *, bool plusptype);
	
	void Decode_GOB(void);
	void Decode_GOB(bool P_picture);
};


#endif


