
#ifndef __D_GOB_C__
#define __D_GOB_C__

#include "D_GOB.h"

bool D_Macroblock::_PB_frame_mode;
int D_Macroblock::_sformat;
int D_Macroblock::_PB_offset;


/*
 * D_GOB::D_GOB(void)
 * 
 * Constructor
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_frame_xsize, D_Macroblock::_sformat
 *				_MB_per_gob, _MB_Y_offset, _MB_UV_offset
 *				_MB_list
 * Ensures:		. Set (_frame_xsize, D_Macroblock::ptype) according to picture format 
 *				. _MB_per_gob dynamically set according to picture format
 *				. _MB_Y_offset = 256
 *				. _MB_UV_offset = 64
 *				. _MB_list is dynamically allocated according to picture format
 *
 * Warning:		
 */
D_GOB::D_GOB (void) 
{
	switch (_sformat) {
	case (SQCIF):
		_frame_xsize = SQCIFX; 
		_MB_per_gob  = SQCIFX >> 4;
		break;
	case (QCIF):
		_frame_xsize = QCIFX; 
		_MB_per_gob  = QCIFX >> 4;
		break;
	case (CIF):
		_frame_xsize = CIFX; 
		_MB_per_gob  = CIFX >> 4;
		break;
	case (CIF4):
		_frame_xsize = CIFX4;
		_MB_per_gob  = CIFX4 >> 4;
		break;
	case (CIF16):
		_frame_xsize = CIFX16; 
		_MB_per_gob  = CIFX16 >> 4;
		break;
	}

	D_Macroblock::_sformat = _sformat;
	D_Macroblock::_PB_frame_mode = _PB_frame_mode;
	D_Macroblock::_PB_offset = _PB_offset;
	D_Macroblock::_coded_mvd_flag = _coded_mvd_flag;
	D_Macroblock::_advanced_prediction_mode = _advanced_prediction_mode;

	_MB_list = NULL;
	_MB_Y_offset = 256;
	_MB_UV_offset = 64;
}


/*
 * D_GOB::~D_GOB(void)
 * 
 * Destructor
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	macroblocks pointed by _MB_list
 * Ensures:		delete[] _MB_list
 *
 * Warning:		
 */
D_GOB::~D_GOB(void) 
{
}


#endif

