
#ifndef __D_FRAME_VOTING_ME_C__
#define __D_FRAME_VOTING_ME_C__

#include "D_Frame.h"


/*
 * void D_Frame::Voting_ME(int current_pos, int *medianx, int *mediany)
 * 
 * Compute the sum of absolute pixel difference of 2 macroblocks
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	median_x, median_y
 * Ensures:		Return the decision to pick either 3 step search or 4 steop search
 *				. Return median neighbouring motion vector X and Y component independently,
 *						from 3 adjacent blocks as depicted in H.263 differential vector coding format
 *						by calling D_Frame::Median_ME();
 *
 * Warning:		
 */
int D_Frame::Voting_ME(int current_posy, int current_posx, int *medianx, int *mediany)
{
	int posx, posy;
	int a1, a2, a3;
	int b1, b2, b3;
	int result, maj;

	a1 = a2 = a3 = 0;
	b1 = b2 = b3 = 0;
	result = 2;
	maj = 0;
	/* (posy,posx) the current position of the macroblock*/
	posy = current_posy;
	posx = current_posx;
	
	/*  (of the 4 macroblocks used for prediction)
	 *	a1 holds the x component of the motion vector for macroblock 1 
	 *	a2 holds the x component of the motion vector for macroblock 2 
	 *	a3 holds the x component of the motion vector for macroblock 3
	 *	b1 holds the y component of the motion vector for macroblock 1 
	 *	b2 holds the y component of the motion vector for macroblock 2
	 *	b3 holds the y component of the motion vector for macroblock 3
	 */
	if (posx > 0) {
		a1 = _mv_x1[posx-1 + posy * _MB_per_gob];
		b1 = _mv_y1[posx-1 + posy * _MB_per_gob];

		if (posy != 0) {
			
			a2 = _mv_x1[posx + (posy - 1) * _MB_per_gob];
			b2 = _mv_y1[posx + (posy - 1) * _MB_per_gob];

			if ( posx != (_MB_per_gob - 1) ) {
				a3 = _mv_x1[posx+1 + (posy - 1) * _MB_per_gob];
				b3 = _mv_y1[posx+1 + (posy - 1) * _MB_per_gob];
			}
		}
		else {
			a2 = a1;
			a3 = a1;
			b2 = b1;
			b3 = b1;
		}
	}
	else {
		if (posy != 0) {
			a2 = _mv_x1[(posy - 1) * _MB_per_gob];
			b2 = _mv_y1[(posy - 1) * _MB_per_gob];
			a3 = _mv_x1[1 + (posy - 1) * _MB_per_gob];
			b3 = _mv_y1[1 + (posy - 1) * _MB_per_gob];
		}
	}

	/* Voting procedure*/
	if ((abs(a1) > 2) || (abs(b1) > 2)) maj++;
	if ((abs(a2) > 2) || (abs(b2) > 2)) maj++;
	if ((abs(a3) > 2) || (abs(b3) > 2)) maj++;
	
	if(maj >= 2) result = 1;

	/* Move the search centre to the predicted value*/
	*medianx = Median_ME(a1,a2,a3);
	*mediany = Median_ME(b1,b2,b3);
	return result;
}

// Overloaded function for advanced prediction 
int D_Frame::Voting_ME(int current_posy, int current_posx, int *medianx, int *mediany, int whichblock)
{
	int posx, posy;
	int a1, a2, a3;
	int b1, b2, b3;
	int result, maj;
	
	a1 = a2 = a3 = 0;
	b1 = b2 = b3 = 0;
	result = 2;
	maj = 0;
	/* (posy,posx) the current position of the macroblock*/
	posy = current_posy;
	posx = current_posx;
	
	/*  (of the 4 macroblocks used for prediction)
	*	a1 holds the x component of the motion vector for macroblock 1 
	*	a2 holds the x component of the motion vector for macroblock 2 
	*	a3 holds the x component of the motion vector for macroblock 3
	*	b1 holds the y component of the motion vector for macroblock 1 
	*	b2 holds the y component of the motion vector for macroblock 2
	*	b3 holds the y component of the motion vector for macroblock 3
	*/
	switch(whichblock) {
	case 0 : 
		{
			if (posx > 0) {
				a1 = _mv_x2[posx-1 + posy * _MB_per_gob];
				b1 = _mv_y2[posx-1 + posy * _MB_per_gob];				
				if (posy != 0) {
					a2 = _mv_x3[posx + (posy - 1) * _MB_per_gob];
					b2 = _mv_y3[posx + (posy - 1) * _MB_per_gob];
					if ( posx != (_MB_per_gob - 1) ) {
						a3 = _mv_x3[posx+1 + (posy - 1) * _MB_per_gob];
						b3 = _mv_y3[posx+1 + (posy - 1) * _MB_per_gob];
					}
				}//if (posy != 0)
				else {
					a2 = a1;
					a3 = a1;
					b2 = b1;
					b3 = b1;
				}
			}
			else {
				if (posy != 0) {
					a2 = _mv_x3[(posy - 1) * _MB_per_gob];
					b2 = _mv_y3[(posy - 1) * _MB_per_gob];
					a3 = _mv_x3[1 + (posy - 1) * _MB_per_gob];
					b3 = _mv_y3[1 + (posy - 1) * _MB_per_gob];
				}
			}
			
			/* Voting procedure*/
			if ((abs(a1) > 2) || (abs(b1) > 2)) maj++;
			if ((abs(a2) > 2) || (abs(b2) > 2)) maj++;
			if ((abs(a3) > 2) || (abs(b3) > 2)) maj++;
			
			if(maj >= 2) result = 1;
			
			/* Move the search centre to the predicted value*/
			*medianx = Median_ME(a1,a2,a3);
			*mediany = Median_ME(b1,b2,b3);			
		}
		break;
	case 1 : 
		{
			a1 = _mv_x1[posx + posy * _MB_per_gob];
			b1 = _mv_y1[posx + posy * _MB_per_gob];
			if (posy != 0) {
				a2 = _mv_x4[posx + (posy - 1) * _MB_per_gob];
				b2 = _mv_y4[posx + (posy - 1) * _MB_per_gob];
				if ( posx != (_MB_per_gob - 1) ) {
					a3 = _mv_x3[posx+1 + (posy - 1) * _MB_per_gob];
					b3 = _mv_y3[posx+1 + (posy - 1) * _MB_per_gob];
				}
			}
			else {
				a2 = a1;
				a3 = a1;
				b2 = b1;
				b3 = b1;
			}
			
			/* Voting procedure*/
			if ((abs(a1) > 2) || (abs(b1) > 2)) maj++;
			if ((abs(a2) > 2) || (abs(b2) > 2)) maj++;
			if ((abs(a3) > 2) || (abs(b3) > 2)) maj++;
			
			if(maj >= 2) result = 1;
			/* Move the search centre to the predicted value*/
			*medianx = Median_ME(a1,a2,a3);
			*mediany = Median_ME(b1,b2,b3);
		}
		break;
	case 2 :
		{
			if (posx > 0) {
				a1 = _mv_x4[posx-1 + posy * _MB_per_gob];
				b1 = _mv_y4[posx-1 + posy * _MB_per_gob];
				
				a2 = _mv_x1[posx + posy * _MB_per_gob];
				b2 = _mv_y1[posx + posy  * _MB_per_gob];				
				a3 = _mv_x2[posx + posy * _MB_per_gob];
				b3 = _mv_y2[posx + posy * _MB_per_gob];
			}//if (posx > 0)
			else {
					a2 = _mv_x1[posy * _MB_per_gob];
					b2 = _mv_y1[posy * _MB_per_gob];
					a3 = _mv_x2[posy * _MB_per_gob];
					b3 = _mv_y2[posy * _MB_per_gob];
			}
			/* Voting procedure*/
			if ((abs(a1) > 2) || (abs(b1) > 2)) maj++;
			if ((abs(a2) > 2) || (abs(b2) > 2)) maj++;
			if ((abs(a3) > 2) || (abs(b3) > 2)) maj++;
			
			if(maj >= 2) result = 1;
			/* Move the search centre to the predicted value*/
			*medianx = Median_ME(a1,a2,a3);
			*mediany = Median_ME(b1,b2,b3);
		}
		break;
	default :
		{
			if (posx > 0) {
				a1 = _mv_x1[posx + posy * _MB_per_gob];
				b1 = _mv_y1[posx + posy * _MB_per_gob];

				a2 = _mv_x2[posx + posy * _MB_per_gob];
				b2 = _mv_y2[posx + posy * _MB_per_gob];
				
				a3 = _mv_x3[posx + posy * _MB_per_gob];
				b3 = _mv_y3[posx + posy * _MB_per_gob];
				
				/* Voting procedure*/
				if ((abs(a1) > 2) || (abs(b1) > 2)) maj++;
				if ((abs(a2) > 2) || (abs(b2) > 2)) maj++;
				if ((abs(a3) > 2) || (abs(b3) > 2)) maj++;
				
				if(maj >= 2) result = 1;
				/* Move the search centre to the predicted value*/
				*medianx = Median_ME(a1,a2,a3);
				*mediany = Median_ME(b1,b2,b3);
			}
			break;
		}
	}
	return result;
}

#endif

