
#ifndef __D_FRAME_TRANSFORM_2D_TO_1D_C__
#define __D_FRAME_TRANSFORM_2D_TO_1D_C__

#include "D_Frame.h"


/*
 * void D_Frame::Transform_2D_To_1D(void)
 * 
 * Create a 1D representation of the current frame
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	this_1D_frame
 * Ensures:		copy the pixel data from 2D representation of this_2D_frame to this_1D_frame of the current frame
 *
 * Warning:		
 */
void D_Frame::Transform_2D_To_1D(void)
{
	int i, j, k, l;
	short *ptr_des_sa, *ptr_des_sb;
	unsigned char *ptr_des_ca, *ptr_des_cb;
	unsigned char *ptr_src_ca, *ptr_src_cb;


	ptr_src_ca = _this_2D_frame;
	ptr_src_cb = _this_2D_frame + (_frame_xsize << 3);
	ptr_des_ca = _this_1D_frame;
	ptr_des_cb = _this_1D_frame + 128;
	
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {	

			// Y Frame conversion 

			/* loop to write out blocks 0 and 2 (left two) of the macroblock*/
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					*ptr_des_ca++ = *ptr_src_ca++;
					*ptr_des_cb++ = *ptr_src_cb++;
				}
				ptr_src_ca += (_frame_xsize - 8);
				ptr_src_cb += (_frame_xsize - 8);
			}
			ptr_src_ca -= ((_frame_xsize << 3) - 8);
			ptr_src_cb -= ((_frame_xsize << 3) - 8);
			
			/* loop to write out blocks 1 and 3 (right two) of the macroblock*/
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					*ptr_des_ca++ = *ptr_src_ca++;
					*ptr_des_cb++ = *ptr_src_cb++;
				}
				ptr_src_ca += (_frame_xsize - 8);
				ptr_src_cb += (_frame_xsize - 8);
			}
			ptr_src_ca -= ((_frame_xsize << 3) - 8);
			ptr_src_cb -= ((_frame_xsize << 3) - 8);
			ptr_des_ca += 128;
			ptr_des_cb += 128;			
		}
		ptr_src_ca += ((_frame_xsize << 4) - _frame_xsize);
		ptr_src_cb += ((_frame_xsize << 4) - _frame_xsize);
	}

	// U and V Frame Conversion 
	
	// ptr_src_ca points to U block ptr_src_cb points to V block

	ptr_src_cb = _this_2D_frame + _picture_size + _picture_size_quarter;
	ptr_des_cb = _this_1D_frame + _picture_size + _picture_size_quarter;
	
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					*ptr_des_ca++ = *ptr_src_ca++;
					*ptr_des_cb++ = *ptr_src_cb++;
				}
				ptr_src_ca += (_frame_xsize_half - 8);
				ptr_src_cb += (_frame_xsize_half - 8);
			}
			ptr_src_ca -= ((_frame_xsize_half << 3) - 8);
			ptr_src_cb -= ((_frame_xsize_half << 3) - 8);
		}
		ptr_src_ca += ((_frame_xsize_half << 3) - _frame_xsize_half);
		ptr_src_cb += ((_frame_xsize_half << 3) - _frame_xsize_half);
	}

	// For INTRA FRAME write directly to _fast_frame

	if (_inter_frame_mode == false) {		// Special case: rare, INTRA FRAME CODE
		
		ptr_src_ca = _this_2D_frame;
		ptr_src_cb = _this_2D_frame + (_frame_xsize << 3);
		
		ptr_des_sa = _fast_frame;
		ptr_des_sb = _fast_frame + 128;
		
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {	
	
				// Y Blocks conversion 

				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_des_sa++ = (short) *ptr_src_ca++;
						*ptr_des_sb++ = (short) *ptr_src_cb++;
					}
					ptr_src_ca += (_frame_xsize - 8);
					ptr_src_cb += (_frame_xsize - 8);
				}
				ptr_src_ca -= ((_frame_xsize << 3) - 8);
				ptr_src_cb -= ((_frame_xsize << 3) - 8);
				
				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_des_sa++ = (short) *ptr_src_ca++;
						*ptr_des_sb++ = (short) *ptr_src_cb++;
					}
					ptr_src_ca += (_frame_xsize - 8);
					ptr_src_cb += (_frame_xsize - 8);
				}
				ptr_src_ca -= ((_frame_xsize << 3) - 8);
				ptr_src_cb -= ((_frame_xsize << 3) - 8);
				ptr_des_sa += 128;
				ptr_des_sb += 128;			
			}
			ptr_src_ca += ((_frame_xsize << 4) - _frame_xsize);
			ptr_src_cb += ((_frame_xsize << 4) - _frame_xsize);
		}
		
		// U and V block conversion
		ptr_src_cb = _this_2D_frame + _picture_size + _picture_size_quarter;
		ptr_des_sb = _fast_frame + _picture_size + _picture_size_quarter;
		
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				for (k=0; k<8; k++) {
					for (l=0; l<8; l++) {
						*ptr_des_sa++ = (short) *ptr_src_ca++;
						*ptr_des_sb++ = (short) *ptr_src_cb++;
					}
					ptr_src_ca += (_frame_xsize_half - 8);
					ptr_src_cb += (_frame_xsize_half - 8);
				}
				ptr_src_ca -= ((_frame_xsize_half << 3) - 8);
				ptr_src_cb -= ((_frame_xsize_half << 3) - 8);
			}
			ptr_src_ca += ((_frame_xsize_half << 3) - _frame_xsize_half);
			ptr_src_cb += ((_frame_xsize_half << 3) - _frame_xsize_half);
		}
	}
}


/*
 * void D_Frame::Transform_2D_To_1D(bool void)
 * 
 * Create a 1D representation of the current frame
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	this_1D_frame
 * Ensures:		copy the pixel data from 2D representation of this_2D_frame to this_1D_frame of the current frame
 *
 * Warning:		
 */
void D_Frame::Transform_2D_To_1D(bool P_picture)
{
	int i, j, k, l, offset;
	unsigned char *ptr_des_ca, *ptr_des_cb;
	unsigned char *ptr_src_ca, *ptr_src_cb;

	offset = 0;
	if (P_picture) offset = _PB_offset;

	ptr_src_ca = _this_2D_frame + offset;
	ptr_src_cb = _this_2D_frame + (_frame_xsize << 3) + offset;
	ptr_des_ca = _this_1D_frame + offset;
	ptr_des_cb = _this_1D_frame + 128 + offset;
	
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {	

			// Y Frame conversion 

			/* loop to write out blocks 1 and 3 (left two) of the macroblock*/
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					*ptr_des_ca++ = *ptr_src_ca++;
					*ptr_des_cb++ = *ptr_src_cb++;
				}
				ptr_src_ca += (_frame_xsize - 8);
				ptr_src_cb += (_frame_xsize - 8);
			}
			ptr_src_ca -= ((_frame_xsize << 3) - 8);
			ptr_src_cb -= ((_frame_xsize << 3) - 8);
			
			/* loop to write out blocks 2 and 4 (right two) of the macroblock*/
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					*ptr_des_ca++ = *ptr_src_ca++;
					*ptr_des_cb++ = *ptr_src_cb++;
				}
				ptr_src_ca += (_frame_xsize - 8);
				ptr_src_cb += (_frame_xsize - 8);
			}
			ptr_src_ca -= ((_frame_xsize << 3) - 8);
			ptr_src_cb -= ((_frame_xsize << 3) - 8);
			ptr_des_ca += 128;
			ptr_des_cb += 128;			
		}
		ptr_src_ca += ((_frame_xsize << 4) - _frame_xsize);
		ptr_src_cb += ((_frame_xsize << 4) - _frame_xsize);
	}

	// U and V Frame Conversion 
	
	// ptr_src_ca points to U block ptr_src_cb points to V block

	ptr_src_cb = _this_2D_frame + _picture_size + _picture_size_quarter + offset;
	ptr_des_cb = _this_1D_frame + _picture_size + _picture_size_quarter + offset;
	
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					*ptr_des_ca++ = *ptr_src_ca++;
					*ptr_des_cb++ = *ptr_src_cb++;
				}
				ptr_src_ca += (_frame_xsize_half - 8);
				ptr_src_cb += (_frame_xsize_half - 8);
			}
			ptr_src_ca -= ((_frame_xsize_half << 3) - 8);
			ptr_src_cb -= ((_frame_xsize_half << 3) - 8);
		}
		ptr_src_ca += ((_frame_xsize_half << 3) - _frame_xsize_half);
		ptr_src_cb += ((_frame_xsize_half << 3) - _frame_xsize_half);
	}

}


#endif

