
#ifndef __D_FRAME_TRANSFORM_1D_TO_2D_C__
#define __D_FRAME_TRANSFORM_1D_TO_2D_C__

#include "D_Frame.h"


/*
 * void D_Frame::Transform_1D_To_2D(void)
 * 
 * This copies the reconstructed frame to _decoded_frame, to be written to YUV output file
 * This is a private
 *
 * Requires:	nothing
 * Modifies:	_decoded_frame
 * Ensures:		. the reconstructed frame is copied to 2-D representation of _decoded_frame
 *				. the pixel values are clipped to within 0 and 22
 *
 * Warning:		
 */
void D_Frame::Transform_1D_To_2D(void)
{
	int i, j, k, l;
	unsigned char *ptr_des_ca, *ptr_des_cb;
	short *ptr_src_sa, *ptr_src_sb;
	
	ptr_src_sa = _recov_frame;
	ptr_src_sb = _recov_frame + 128;

	ptr_des_ca = _decoded_frame;
	ptr_des_cb = _decoded_frame + (_frame_xsize << 3);

	//Luminance (Y) Frame

	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {	

			//Loop for converting blocks 0 and 2 (left blocks) of the macroblock
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					//Clipping before assignment
					if (*ptr_src_sa > 255) *ptr_src_sa = 255;
					if (*ptr_src_sb > 255) *ptr_src_sb = 255;
					if (*ptr_src_sa < 0) *ptr_src_sa = 0;
					if (*ptr_src_sb < 0) *ptr_src_sb = 0;
					*ptr_des_ca++ = (unsigned char) *ptr_src_sa++;
					*ptr_des_cb++ = (unsigned char) *ptr_src_sb++;
				}
				ptr_des_ca += (_frame_xsize - 8);
				ptr_des_cb += (_frame_xsize - 8);
			}
			ptr_des_ca -= ((_frame_xsize << 3) - 8);
			ptr_des_cb -= ((_frame_xsize << 3) - 8);

			//Loop for converting blocks 1 and 3 (right two) of the macroblock			
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					if (*ptr_src_sa > 255) *ptr_src_sa = 255;
					if (*ptr_src_sb > 255) *ptr_src_sb = 255;
					if (*ptr_src_sa < 0) *ptr_src_sa = 0;
					if (*ptr_src_sb < 0) *ptr_src_sb = 0;
					*ptr_des_ca++ = (unsigned char) *ptr_src_sa++;
					*ptr_des_cb++ = (unsigned char) *ptr_src_sb++;
				}
				ptr_des_ca += (_frame_xsize - 8);
				ptr_des_cb += (_frame_xsize - 8);
			}
			ptr_des_ca -= ((_frame_xsize << 3) - 8);
			ptr_des_cb -= ((_frame_xsize << 3) - 8);
			ptr_src_sa += 128;
			ptr_src_sb += 128;			
		}
		ptr_des_ca += ((_frame_xsize << 4) - _frame_xsize);
		ptr_des_cb += ((_frame_xsize << 4) - _frame_xsize);
	}
	
	ptr_src_sb = _recov_frame + _picture_size + _picture_size_quarter;
	ptr_des_cb = _decoded_frame + _picture_size + _picture_size_quarter;

	// Chrominance (U, V) Frame
	
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					if (*ptr_src_sa > 255) *ptr_src_sa = 255;
					if (*ptr_src_sb > 255) *ptr_src_sb = 255;
					if (*ptr_src_sa < 0) *ptr_src_sa = 0;
					if (*ptr_src_sb < 0) *ptr_src_sb = 0;
					*ptr_des_ca++ = (unsigned char) *ptr_src_sa++;
					*ptr_des_cb++ = (unsigned char) *ptr_src_sb++;
				}
				ptr_des_ca += (_frame_xsize_half - 8);
				ptr_des_cb += (_frame_xsize_half - 8);
			}
			ptr_des_ca -= ((_frame_xsize_half << 3) - 8);
			ptr_des_cb -= ((_frame_xsize_half << 3) - 8);
		}
		ptr_des_ca += ((_frame_xsize_half << 3) - _frame_xsize_half);
		ptr_des_cb += ((_frame_xsize_half << 3) - _frame_xsize_half);
	}
}


/*
 * void D_Frame::Transform_1D_To_2D(bool P_picture)
 * 
 * This copies the reconstructed frame to _decoded_frame, to be written to YUV output file
 * This is a private
 *
 * Requires:	nothing
 * Modifies:	_decoded_frame
 * Ensures:		. the reconstructed frame is copied to 2-D representation of _decoded_frame
 *				. the pixel values are clipped to within 0 and 22
 *
 * Warning:		
 */
void D_Frame::Transform_1D_To_2D(bool P_picture)
{
	int i, j, k, l, offset;
	unsigned char *ptr_des_ca, *ptr_des_cb;
	short *ptr_src_sa, *ptr_src_sb;
	

	offset = 0;
	if (P_picture) offset = _PB_offset;
	ptr_src_sa = _recov_frame;
	ptr_src_sb = _recov_frame + 128;

	ptr_des_ca = _decoded_frame + offset;
	ptr_des_cb = _decoded_frame + (_frame_xsize << 3) + offset;

	//Luminance (Y) Frame

	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {	

			//Loop for converting blocks 0 and 2 (left blocks) of the macroblock
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					//Clipping before assignment
					if (*ptr_src_sa > 255) *ptr_src_sa = 255;
					if (*ptr_src_sb > 255) *ptr_src_sb = 255;
					if (*ptr_src_sa < 0) *ptr_src_sa = 0;
					if (*ptr_src_sb < 0) *ptr_src_sb = 0;
					*ptr_des_ca++ = (unsigned char) *ptr_src_sa++;
					*ptr_des_cb++ = (unsigned char) *ptr_src_sb++;
				}
				ptr_des_ca += (_frame_xsize - 8);
				ptr_des_cb += (_frame_xsize - 8);
			}
			ptr_des_ca -= ((_frame_xsize << 3) - 8);
			ptr_des_cb -= ((_frame_xsize << 3) - 8);

			//Loop for converting blocks 1 and 3 (right two) of the macroblock			
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					if (*ptr_src_sa > 255) *ptr_src_sa = 255;
					if (*ptr_src_sb > 255) *ptr_src_sb = 255;
					if (*ptr_src_sa < 0) *ptr_src_sa = 0;
					if (*ptr_src_sb < 0) *ptr_src_sb = 0;
					*ptr_des_ca++ = (unsigned char) *ptr_src_sa++;
					*ptr_des_cb++ = (unsigned char) *ptr_src_sb++;
				}
				ptr_des_ca += (_frame_xsize - 8);
				ptr_des_cb += (_frame_xsize - 8);
			}
			ptr_des_ca -= ((_frame_xsize << 3) - 8);
			ptr_des_cb -= ((_frame_xsize << 3) - 8);
			ptr_src_sa += 128;
			ptr_src_sb += 128;			
		}
		ptr_des_ca += ((_frame_xsize << 4) - _frame_xsize);
		ptr_des_cb += ((_frame_xsize << 4) - _frame_xsize);
	}
	
	ptr_src_sb = _recov_frame + _picture_size + _picture_size_quarter;
	ptr_des_cb = _decoded_frame + _picture_size + _picture_size_quarter + offset;

	// Chrominance (U, V) Frame
	
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {
			for (k=0; k<8; k++) {
				for (l=0; l<8; l++) {
					if (*ptr_src_sa > 255) *ptr_src_sa = 255;
					if (*ptr_src_sb > 255) *ptr_src_sb = 255;
					if (*ptr_src_sa < 0) *ptr_src_sa = 0;
					if (*ptr_src_sb < 0) *ptr_src_sb = 0;
					*ptr_des_ca++ = (unsigned char) *ptr_src_sa++;
					*ptr_des_cb++ = (unsigned char) *ptr_src_sb++;
				}
				ptr_des_ca += (_frame_xsize_half - 8);
				ptr_des_cb += (_frame_xsize_half - 8);
			}
			ptr_des_ca -= ((_frame_xsize_half << 3) - 8);
			ptr_des_cb -= ((_frame_xsize_half << 3) - 8);
		}
		ptr_des_ca += ((_frame_xsize_half << 3) - _frame_xsize_half);
		ptr_des_cb += ((_frame_xsize_half << 3) - _frame_xsize_half);
	}
}


#endif

