
#ifndef __D_FRAME_THREE_STEP_SEARCH_ME_C__
#define __D_FRAME_THREE_STEP_SEARCH_ME_C__

#include "D_Frame.h"


/*
 * void D_Frame::Three_Step_Search_ME(int x1, int y1, int x2, int y2, int *x3, int *y3)
 * 
 * Compute the sum of absolute pixel difference of 2 macroblocks
 * This is a private method
 *
 * Requires:	position of the macroblock in current frame and previous frame
 * Modifies:	_min_MAD
 * Ensures:		This does the 3 step search to find the best match for the current macroblock
 *				** This function calls D_Frame::Distance_ME() to calculate MAD
 *
 * Warning:		
 */
void D_Frame::Three_Step_Search_ME(int x1, int y1, int x2, int y2, int *x3, int *y3, 
								   int blocksize, int ylow, int yhigh, int xlow,
								   int xhigh)
{
	int xcentre, ycentre, ystart, xstart;
	int loop, stepsize;
	int temp2, temp3;
	int dx, dy, ymotion, xmotion;
	
	xcentre = x1;
	ycentre = y1;
	ystart = y2;
	xstart = x2;

	stepsize = 8;
	xmotion = 0;
	ymotion = 0;

	while (stepsize > 0) {
		dx = -1 * stepsize;
		dy = -1 * stepsize;

		for (loop=0; loop<9; loop++) {
			
			if ( ((ystart + dy + ycentre) >= ylow) && ((ystart + dy + ycentre) <= yhigh) &&
				 ((xstart + dx + xcentre) >= xlow) && ((xstart + dx + xcentre) <= xhigh) &&
				 ((dx != 0) || (dy != 0)) ) {
				
				if(_advanced_prediction_mode) {
					if (_independent_segment_mode)
						Distance_ME(_ISD_extrapolated_frame, ystart, xstart, (ystart + ycentre + dy + 16),
						(xstart + xcentre + dx + 16));
					else
						Distance_ME(_padded_UMV_frame, ystart, xstart, (ystart + ycentre + dy + 16),
						(xstart + xcentre + dx + 16));
				} 
				else {
					if (_reference_picture_selection) 
						Distance_ME(_prev_frames->GetFrame(_ref_index), ystart, xstart, (ystart + ycentre + dy),
						(xstart + xcentre + dx));
					
					else
						Distance_ME(_decoded_frame, ystart, xstart, (ystart + ycentre + dy),
						(xstart + xcentre + dx));
				}

				if(_current_MAD<_min_MAD) {
					
					ymotion = dy+ycentre;
					xmotion = dx+xcentre;
					_min_MAD = _current_MAD;
					
					if (_min_MAD < _thresh_no_residue*blocksize*blocksize/256) {
						*x3 = xmotion;
						*y3 = ymotion;
						return;
					}
				}
				else if (_current_MAD ==_min_MAD) {
					
					temp2 = xmotion * xmotion + ymotion * ymotion;
					temp3 = (dx + xcentre) * (dx + xcentre) + (dy + ycentre) * (dy + ycentre);
					
					if (temp3 < temp2) {
						ymotion = dy + ycentre;
						xmotion = dx + xcentre;
						_min_MAD = _current_MAD;
					}
				}
			}

			if (dx <= 0) dx += stepsize;
			else  {
				dx = -1 * stepsize;
				dy += stepsize;
			}
		}

		xcentre = xmotion; 
		ycentre = ymotion;
		stepsize >>= 1;      

	} // while (stepsize > 0)

	*x3 = xmotion;
	*y3 = ymotion;
}


#endif

