
#ifndef __D_FRAME_TEMPORAL_COMPRESSER_C__
#define __D_FRAME_TEMPORAL_COMPRESSER_C__

#include "D_Frame.h"


/*
 * void D_Frame::Temporal_Compresser(void)
 * 
 * Calculates the residual frame
 * This is a private method
 *
 * Requires:	D_Frame::Temporal_Compression_Control() must be called first
 * Modifies:	_fast_frame
 * Ensures:		Calculate and then store the residual frame into _fast_frame
 *
 * Warning:		
 */
void D_Frame::Temporal_Compresser(void)
{
	int i, j, m;
	short *ptr_des_Y_s, *ptr_des_U_s, *ptr_des_V_s;
	short *ptr_evil_predict_Y_s, *ptr_evil_predict_U_s, *ptr_evil_predict_V_s;
	short *ptr_mtype;
	unsigned char *ptr_this_Y_c, *ptr_this_U_c, *ptr_this_V_c;
	unsigned char *ptr_shift_Y_c, *ptr_shift_U_c, *ptr_shift_V_c; 
	
	// Current frame			
	ptr_this_Y_c = _this_1D_frame;
	ptr_this_U_c = _this_1D_frame + _picture_size;
	ptr_this_V_c = _this_1D_frame + _picture_size + _picture_size_quarter;

	// Predicton Frame
	// not used in evil speed mode
	ptr_shift_Y_c = _shift_frame;
	ptr_shift_U_c = _shift_frame + _picture_size;
	ptr_shift_V_c = _shift_frame + _picture_size + _picture_size_quarter;
	
	// Prediction frame
	// only used in evil speed mode
	ptr_evil_predict_Y_s = _evil_predict_frame;
	ptr_evil_predict_U_s = _evil_predict_frame + _picture_size;
	ptr_evil_predict_V_s = _evil_predict_frame + _picture_size + _picture_size_quarter;
	
	// Destination buffer, residual frame
	ptr_des_Y_s = _fast_frame;
	ptr_des_U_s = _fast_frame + _picture_size;
	ptr_des_V_s = _fast_frame + _picture_size + _picture_size_quarter;


	ptr_mtype = _mtype;

	if (_evil_speed_mode) {

		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++, ptr_mtype++) {
				
				// If Frame is INTRA just copy the values 
				if ((*ptr_mtype == INTRA) || (*ptr_mtype == INTRAQ)) { 
					
					// Y frame
					for (m=0; m<256; m++) *ptr_des_Y_s++ = (short) *ptr_this_Y_c++;
					// U and V frames
					for (m=0; m<64; m++) {
						*ptr_des_U_s++ = (short) *ptr_this_U_c++;
						*ptr_des_V_s++ = (short) *ptr_this_V_c++;
					}

					ptr_evil_predict_Y_s += 256;
					ptr_evil_predict_U_s += 64;
					ptr_evil_predict_V_s += 64;
					
				}
				else {
					
					//Y residue
					for (m=0; m<256; m++) 
						*ptr_des_Y_s++ = (short) ((short)*ptr_this_Y_c++ -  *ptr_evil_predict_Y_s++);
					
					//U and V residues
					for (m=0; m<64; m++) {
						*ptr_des_U_s++ = (short) ((short)*ptr_this_U_c++ -  *ptr_evil_predict_U_s++);
						*ptr_des_V_s++ = (short) ((short)*ptr_this_V_c++ -  *ptr_evil_predict_V_s++);
					}
					
				}
				
			} // for (j=0; j<11; j++)
		} // for (i=0; i<9; i++)

	}
	else {	// regular mode

		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++, ptr_mtype++) {
				
				// If Frame is INTRA just copy the values 
				if ((*ptr_mtype == INTRA) || (*ptr_mtype == INTRAQ)) { 
					
					// Y frame
					for (m=0; m<256; m++) *ptr_des_Y_s++ = (short) *ptr_this_Y_c++;
					// U and V frames
					for (m=0; m<64; m++) {
						*ptr_des_U_s++ = (short) *ptr_this_U_c++;
						*ptr_des_V_s++ = (short) *ptr_this_V_c++;
					}
					
					ptr_shift_Y_c += 256;
					ptr_shift_U_c += 64;
					ptr_shift_V_c += 64;
				}
				else {
					
					//Y residue
					for (m=0; m<256; m++) 
						*ptr_des_Y_s++ = (short) (*ptr_this_Y_c++ -  *ptr_shift_Y_c++);
					
					//U and V residues
					for (m=0; m<64; m++) {
						*ptr_des_U_s++ = (short) (*ptr_this_U_c++ -  *ptr_shift_U_c++);
						*ptr_des_V_s++ = (short) (*ptr_this_V_c++ -  *ptr_shift_V_c++);
					}
					
				}
				
			} // for (j=0; j<11; j++)
		} // for (i=0; i<9; i++)
	} // else {

}


/*
 * void D_Frame::Temporal_Compresser(bool P_picture)
 * 
 * Calculates the residual frame
 * This is a private method
 *
 * Requires:	D_Frame::Temporal_Compression_Control() must be called first
 * Modifies:	_fast_frame
 * Ensures:		Calculate and then store the residual frame into _fast_frame
 *
 * Warning:		
 */
void D_Frame::Temporal_Compresser(bool P_picture)
{
	int i, j, m, offset;
	short *ptr_des_Y_s, *ptr_des_U_s, *ptr_des_V_s;
	short *ptr_mtype;
	unsigned char *ptr_this_Y_c, *ptr_this_U_c, *ptr_this_V_c;
	unsigned char *ptr_shift_Y_c, *ptr_shift_U_c, *ptr_shift_V_c; 
	
	offset = 0;
	if (P_picture) offset = _PB_offset;
	// Current frame			
	ptr_this_Y_c = _this_1D_frame + offset;
	ptr_this_U_c = _this_1D_frame + _picture_size + offset;
	ptr_this_V_c = _this_1D_frame + _picture_size + _picture_size_quarter + offset;

	// Predicton Frame
	ptr_shift_Y_c = _shift_frame + offset;
	ptr_shift_U_c = _shift_frame + _picture_size + offset;
	ptr_shift_V_c = _shift_frame + _picture_size + _picture_size_quarter + offset;
	
	// Destination buffer, residual frame
	ptr_des_Y_s = _fast_frame + offset;
	ptr_des_U_s = _fast_frame + _picture_size + offset;
	ptr_des_V_s = _fast_frame + _picture_size + _picture_size_quarter + offset;


	ptr_mtype = _mtype;

	
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++, ptr_mtype++) {
			
			// If Frame is INTRA just copy the values 
			if (((*ptr_mtype == INTRA) || (*ptr_mtype == INTRAQ)) && P_picture) { 
				
				// Y frame
				for (m=0; m<256; m++) *ptr_des_Y_s++ = (short) *ptr_this_Y_c++;
				// U and V frames
				for (m=0; m<64; m++) {
					*ptr_des_U_s++ = (short) *ptr_this_U_c++;
					*ptr_des_V_s++ = (short) *ptr_this_V_c++;
				}
				
				ptr_shift_Y_c += 256;
				ptr_shift_U_c += 64;
				ptr_shift_V_c += 64;
			}
			else {
				
				//Y residue
				for (m=0; m<256; m++) 
					*ptr_des_Y_s++ = (short) (*ptr_this_Y_c++ -  *ptr_shift_Y_c++);
				
				//U and V residues
				for (m=0; m<64; m++) {
					*ptr_des_U_s++ = (short) (*ptr_this_U_c++ -  *ptr_shift_U_c++);
					*ptr_des_V_s++ = (short) (*ptr_this_V_c++ -  *ptr_shift_V_c++);
				}
				
			}
			
		} // for (j=0; j<11; j++)
	} // for (i=0; i<9; i++)

}


#endif

