
#ifndef __D_FRAME_SUBPIXEL_INTERPOLATION_MODULE_C__
#define __D_FRAME_SUBPIXEL_INTERPOLATION_MODULE_C__

#include "D_Frame.h"


/*
 * void D_GOB::Init_Structure(const unsigned char *const src_Y_c, 
 *							const unsigned char *const src_U_c,
 *							const unsigned char *const src_V_c, 
 *							const int group_id)
 * 
 * Initialize basic data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_decoded_frame_half_full, _decoded_frame_full_half, _decoded_frame_half_half
 *				_left_shift, _upper_shift, _upper_shift_left
 * Ensures:		Generate 3 sub-pixel frames in _decoded_frame_half_full, _decoded_full_half, and
 *				_decoded_half_half respectively. _left_shift, _upper_shift, and _upper_shift_left
 *				stores the intermediate result
 *
 * Warning:		
 */
void D_Frame::Subpixel_Interpolation_Module(void)
{
	int i, j, E1, E2, offset;
	int frame_xsize, frame_ysize, frame_xsize_half, frame_ysize_half;
	unsigned char *ptr_des_ca, *ptr_des_cb, *ptr_des_cc;
	unsigned char *ptr_src_ca, *ptr_src_cb, *ptr_src_cc, *ptr_src_cd;


	if(_advanced_prediction_mode) {
		frame_xsize = _frame_xsize + 32; 
		frame_ysize = _frame_ysize + 32;
	}
	else {
		frame_xsize = _frame_xsize;
		frame_ysize = _frame_ysize;
	}
	frame_xsize_half = frame_xsize >> 1;
	frame_ysize_half = frame_ysize >> 1;

	offset = 0;
	if (_PB_Ppicture_flag) offset = _PB_offset;
	// Generate _left_shift
	// shift left, skip 1st column in pixel copy and write zeros to last column
	if(_advanced_prediction_mode) {
		if (_independent_segment_mode)
			ptr_src_ca = _ISD_extrapolated_frame;
		else
			ptr_src_ca = _padded_UMV_frame;
		ptr_des_ca = _padded_left_shift;
	}
	else {
		ptr_src_ca = _decoded_frame + offset;
		ptr_des_ca = _left_shift;
	}
	for (i=0; i<frame_ysize; i++) {		// Y Frame
		ptr_src_ca++;
		for (j=1; j<frame_xsize; j++) *ptr_des_ca++ = *ptr_src_ca++;
		*ptr_des_ca++ = 0;
	}
	for (i=0; i<frame_ysize_half; i++) {	// U Frame
		ptr_src_ca++;
		for (j=1; j<frame_xsize_half; j++) *ptr_des_ca++ = *ptr_src_ca++;
		*ptr_des_ca++ = 0;
	}
	for (i=0; i<frame_ysize_half; i++) {	// V Frame
		ptr_src_ca++;
		for (j=1; j<frame_xsize_half; j++) *ptr_des_ca++ = *ptr_src_ca++;
		*ptr_des_ca++ = 0;
	}


	// Generate _upper_shift
	// shift up, skip 1st row in pixel copy and write zeros to last row
	if(_advanced_prediction_mode) {
		if (_independent_segment_mode)
			ptr_src_ca = _ISD_extrapolated_frame + frame_xsize;
		else
			ptr_src_ca = _padded_UMV_frame + frame_xsize;
		ptr_des_ca = _padded_upper_shift;
	}
	else {
		ptr_src_ca = _decoded_frame + frame_xsize + offset;
		ptr_des_ca = _upper_shift;
	}
	for (i=1; i<frame_ysize; i++) {		// Y Frame
		for (j=0; j<frame_xsize; j++) *ptr_des_ca++ = *ptr_src_ca++;
	}
	for (j=0; j<frame_xsize; j++) *ptr_des_ca++ = 0;
	
	ptr_src_ca += frame_xsize_half;
	for (i=1; i<frame_ysize_half; i++) {	// U Frame
		for (j=0; j<frame_xsize_half; j++) *ptr_des_ca++ = *ptr_src_ca++;
	}
	for (j=0; j<frame_xsize_half; j++) *ptr_des_ca++ = 0;
	
	ptr_src_ca += frame_xsize_half;
	for (i=1; i<frame_ysize_half; i++) {	// V Frame
		for (j=0; j<frame_xsize_half; j++) *ptr_des_ca++ = *ptr_src_ca++;
	}
	for (j=0; j<frame_xsize_half; j++) *ptr_des_ca++ = 0;
	
	
	// Generate _upper_left_shift
	// shift up and left, skip 1st column and 1st row in pixel copy
	// copy zeros into last row and column
	if(_advanced_prediction_mode) {
		if (_independent_segment_mode)
			ptr_src_ca = _ISD_extrapolated_frame + frame_xsize;
		else
			ptr_src_ca = _padded_UMV_frame + frame_xsize;
		ptr_des_ca = _padded_upper_left_shift;
	}
	else {
		ptr_src_ca = _decoded_frame + frame_xsize + offset;
		ptr_des_ca = _upper_left_shift;
	}
	for (i=1; i<frame_ysize; i++) {
		ptr_src_ca++;
		for (j=1; j<frame_xsize; j++) *ptr_des_ca++ = *ptr_src_ca++;
		*ptr_des_ca++ = 0;
	}
	for (j=0; j<frame_xsize; j++) *ptr_des_ca++ = 0;
	
	ptr_src_ca += frame_xsize_half;
	for (i=1; i<frame_ysize_half; i++) {
		ptr_src_ca++;
		for (j=1; j<frame_xsize_half; j++) *ptr_des_ca++ = *ptr_src_ca++;
		*ptr_des_ca++ = 0;
	}
	for (j=0; j<frame_xsize_half; j++) *ptr_des_ca++ = 0;
	
	ptr_src_ca += frame_xsize_half;
	for (i=1; i<frame_ysize_half; i++) {
		ptr_src_ca++;
		for (j=1; j<frame_xsize_half; j++) *ptr_des_ca++ = *ptr_src_ca++;
		*ptr_des_ca++ = 0;
	}
	for (j=0; j<frame_xsize_half; j++) *ptr_des_ca++ = 0;
	
	
	// Rate Control Affects Interpolation module, however, we have not implemented 
	// it yet.
	if (_RCONTROL) {
		E1 = 0;
		E2 = 1;
	}
	else {
		E1 = 1;
		E2 = 2;
	}
	
	if(_advanced_prediction_mode) {
		if (_independent_segment_mode) {
			ptr_src_ca = _ISD_extrapolated_frame;
			ptr_src_cb = _padded_left_shift;
			ptr_src_cc = _padded_upper_shift;
			ptr_src_cd = _padded_upper_left_shift;
			
			ptr_des_ca = _ISD_extrapolated_frame_half_full;
			ptr_des_cb = _ISD_extrapolated_frame_full_half;
			ptr_des_cc = _ISD_extrapolated_frame_half_half;
		} else {
			ptr_src_ca = _padded_UMV_frame;
			ptr_src_cb = _padded_left_shift;
			ptr_src_cc = _padded_upper_shift;
			ptr_src_cd = _padded_upper_left_shift;
			
			ptr_des_ca = _padded_UMV_frame_half_full;
			ptr_des_cb = _padded_UMV_frame_full_half;
			ptr_des_cc = _padded_UMV_frame_half_half;
		}
	}
	else {
		ptr_src_ca = _decoded_frame + offset;
		ptr_src_cb = _left_shift;
		ptr_src_cc = _upper_shift;
		ptr_src_cd = _upper_left_shift;
		
		ptr_des_ca = _decoded_frame_half_full + offset;
		ptr_des_cb = _decoded_frame_full_half + offset;
		ptr_des_cc = _decoded_frame_half_half + offset;
	}

	// Y frame pixels
	for (i=0; i<frame_ysize; i++) {
		for (j=0; j<frame_xsize; j++) {
			*ptr_des_ca++ = (unsigned char) (((short)(*ptr_src_ca) + (short)(*ptr_src_cb) + E1) >> 1);
			*ptr_des_cb++ = (unsigned char) (((short)(*ptr_src_ca) + (short)(*ptr_src_cc) + E1) >> 1);
			*ptr_des_cc++ = (unsigned char) (((short)(*ptr_src_ca++) + (short)(*ptr_src_cb++) + 
											(short)(*ptr_src_cc++) + (short)(*ptr_src_cd++) + E2) >> 2);
		}
	}

	// U Frame pixels
	for (i=0; i<frame_ysize_half; i++) {
		for (j=0; j<frame_xsize_half; j++) {
			*ptr_des_ca++ = (unsigned char) (((short)(*ptr_src_ca) + (short)(*ptr_src_cb) + E1) >> 1);
			*ptr_des_cb++ = (unsigned char) (((short)(*ptr_src_ca) + (short)(*ptr_src_cc) + E1) >> 1);
			*ptr_des_cc++ = (unsigned char) (((short)(*ptr_src_ca++) + (short)(*ptr_src_cb++) + 
				(short)(*ptr_src_cc++) + (short)(*ptr_src_cd++) + E2) >> 2);
		}
	}

	// V frame pixels
	for (i=0; i<frame_ysize_half; i++) {
		for (j=0; j<frame_xsize_half; j++) {
			*ptr_des_ca++ = (unsigned char) (((short)(*ptr_src_ca) + (short)(*ptr_src_cb) + E1) >> 1);
			*ptr_des_cb++ = (unsigned char) (((short)(*ptr_src_ca) + (short)(*ptr_src_cc) + E1) >> 1);
			*ptr_des_cc++ = (unsigned char) (((short)(*ptr_src_ca++) + (short)(*ptr_src_cb++) + 
				(short)(*ptr_src_cc++) + (short)(*ptr_src_cd++) + E2) >> 2);
		}
	}

}

#endif

