
#ifndef __D_FRAME_SET_MCBP_C__
#define __D_FRAME_SET_MCBP_C__

#include "D_Frame.h"


/*
 * void D_Frame::Set_MCBP(void)
 * 
 * Set up macroblock control information
 * For INTER-coded macroblock, if the block energy of the residue is less than camera noise
 * threshold, then the macroblock CBP (coded block pattern) is set to 0.
 * If all 6 blocks in the macroblock are all not coded, coded macroblock indicator (ptr_cmi) will
 * be set to 1 if the motion vector is zero (ptr_flag_zero_mv == true)
 * For INTRA-coded macroblock, coded block patterns for all 6 blocks are set to 1.
 * NOTE: these cbp values are not final. It is double checked after DCT-Quantization step.
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	_cmi, _mtype, _mcbpc, _mcbpy, _mv_type0, _mv_x0, and _mv_y0
 * Ensures:		Set up macroblock control information to allow for proper processing in entropy encoding
 *
 * Warning:		
 */
void D_Frame::Set_MCBP(void)
{
	int i, j, k, m, temp, offset;
	short *ptr_fast_Y_s, *ptr_fast_U_s, *ptr_fast_V_s;
	short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;
	short *ptr_mcbpc, *ptr_mcbpy, *ptr_mtype;
	bool  *ptr_flag_zero_mv, *ptr_cmi;
	

	offset = 0;
	if (_PB_Ppicture_flag) offset = _PB_offset;

	ptr_fast_Y_s = _fast_frame + offset;
	ptr_fast_U_s = _fast_frame + _picture_size + offset;
	ptr_fast_V_s = _fast_frame + _picture_size + _picture_size_quarter + offset;
	
	ptr_mtype = _mtype;
	ptr_mcbpc = _mcbpc;
	ptr_mcbpy = _mcbpy;
	
	ptr_mv_type1 = _mv_type1; ptr_mv_x1 = _mv_x1; ptr_mv_y1 = _mv_y1;
	ptr_mv_type2 = _mv_type2; ptr_mv_x2 = _mv_x2; ptr_mv_y2 = _mv_y2;
	ptr_mv_type3 = _mv_type3; ptr_mv_x3 = _mv_x3; ptr_mv_y3 = _mv_y3;
	ptr_mv_type4 = _mv_type4; ptr_mv_x4 = _mv_x4; ptr_mv_y4 = _mv_y4;

	ptr_flag_zero_mv = _flag_zero_mv;
	ptr_cmi = _cmi;


	/* For blocks in Intra frame set all MCBPs to 1 */
	if (_inter_frame_mode == false) {			// INTRA picture
	
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				
				*ptr_mtype++ = INTRA;
				*ptr_cmi++ = false;
				*ptr_mcbpy++ = 15;
				*ptr_mcbpc++ = 3;

				*ptr_mv_type1++ = 1; *ptr_mv_x1++ = 0; *ptr_mv_y1++ = 0;
				
				if (_advanced_prediction_mode || _PB_frame_mode) {
					*ptr_mv_type2++ = 1; *ptr_mv_x2++ = 0; *ptr_mv_y2++ = 0;
					*ptr_mv_type3++ = 1; *ptr_mv_x3++ = 0; *ptr_mv_y3++ = 0;
					*ptr_mv_type4++ = 1; *ptr_mv_x4++ = 0; *ptr_mv_y4++ = 0;
				}

			}	// for (j=0; j<_MB_per_gob; j++) {
		}	// for (i=0; i<_GOB_per_frame; i++) {

		return;
	}


	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {

			/* For all intra blocks in inter frames, set MCBPs to 1*/
			if ((*ptr_mtype == INTRA) || (*ptr_mtype == INTRAQ)) {
				
				*ptr_cmi++ = false;
				*ptr_mcbpy++ = 15;
				*ptr_mcbpc++ = 3;

				*ptr_mv_type1++ = 1; *ptr_mv_x1++ = 0; *ptr_mv_y1++ = 0;

				if (_advanced_prediction_mode || _PB_frame_mode) {
					*ptr_mv_type2++ = 1; *ptr_mv_x2++ = 0; *ptr_mv_y2++ = 0;
					*ptr_mv_type3++ = 1; *ptr_mv_x3++ = 0; *ptr_mv_y3++ = 0;
					*ptr_mv_type4++ = 1; *ptr_mv_x4++ = 0; *ptr_mv_y4++ = 0;
				}

				ptr_mtype++;
				ptr_flag_zero_mv++;

				ptr_fast_Y_s += 256;
				ptr_fast_U_s += 64;
				ptr_fast_V_s += 64;
				continue;
			}
				

			// Compute block residue energy for INTER macroblocks and compare with _thresh_no_residue 
			// Y blocks
			*ptr_mcbpy = 0;
			for (k=0; k<4; k++) {
				
				temp = 0;
				*ptr_mcbpy <<= 1;
				for (m=0; m<64; m++) temp += abs(*ptr_fast_Y_s++);
				
				if (temp > (_thresh_no_residue >> 2)) *ptr_mcbpy |= 1;
			}

			// U Block
			temp = 0;
			*ptr_mcbpc = 0;
			for (k=0; k<64; k++) temp += abs(*ptr_fast_U_s++);
			if (temp > (_thresh_no_residue >> 2)) *ptr_mcbpc = 2;

			// V Block
			temp = 0;
			for (k=0; k<64; k++) temp += abs(*ptr_fast_V_s++);
			if (temp > (_thresh_no_residue >> 2)) *ptr_mcbpc += 1;


			// If all CBPs are 0 and *_flag_zero_mv is true send nothing 
			// -->> *_cmi = true

			*ptr_cmi = false;
			if ((*ptr_mcbpy == 0) && (*ptr_mcbpc == 0) && (*ptr_flag_zero_mv == true)) {

				if (!_PB_Ppicture_flag) *ptr_cmi = true;
				*ptr_mv_type1 = 1; *ptr_mv_x1 = 0; *ptr_mv_y1 = 0;

				if (_advanced_prediction_mode || _PB_Ppicture_flag) {
					*ptr_mv_type2 = 1; *ptr_mv_x2 = 0; *ptr_mv_y2 = 0;
					*ptr_mv_type3 = 1; *ptr_mv_x3 = 0; *ptr_mv_y3 = 0;
					*ptr_mv_type4 = 1; *ptr_mv_x4 = 0; *ptr_mv_y4 = 0;
				}
			}


			ptr_mv_type1++; ptr_mv_x1++; ptr_mv_y1++;

			if(_advanced_prediction_mode || _PB_Ppicture_flag) {
				ptr_mv_type2++; ptr_mv_x2++; ptr_mv_y2++;
				ptr_mv_type3++; ptr_mv_x3++; ptr_mv_y3++;
				ptr_mv_type4++; ptr_mv_x4++; ptr_mv_y4++;
			}

			ptr_cmi++;
			ptr_mtype++;
			ptr_mcbpy++;
			ptr_mcbpc++;
			ptr_flag_zero_mv++;

		} //for(j=0;j<MB_per_gob;j++)
	} //for(i=0;i<_GOB_per_frame;i++)

}


#endif

