
#ifndef __D_FRAME_SET_FRAME_MODE_C__
#define __D_FRAME_SET_FRAME_MODE_C__

#include "D_Frame.h"


/*
 * void D_Frame::Set_Frame_Mode_INTER(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Set_Frame_Mode_INTER(void)
{
	if (_ME_enabled) {
		_inter_frame_mode = true;
		D_GOB::_inter_frame_mode = true;
		D_Macroblock::_inter_frame_mode = true;
		D_Block::_inter_frame_mode = true;
	}
	else {
		fprintf(stderr, "Motion Estimation is Disabled. No Inter Frame Coding\n\n");
		exit(-1);
	}
}


/*
 * void D_Frame::Set_Frame_Mode_INTRA(void)
 * 
 * turn off INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder is coding using strictly in INTRA mode
 *
 * Warning:		
 */
void D_Frame::Set_Frame_Mode_INTRA(void)
{
	_inter_frame_mode = false;
	D_GOB::_inter_frame_mode = false;
	D_Macroblock::_inter_frame_mode = false;
	D_Block::_inter_frame_mode = false;
}


#endif

