
#ifndef __D_FRAME_SAC_DECODE_MB_C__
#define __D_FRAME_SAC_DECODE_MB_C__

#include "D_Frame.h"
#include "PSC_Fifo.h"

/*
* bool D_Frame::SAC_Decode_MB (PSC_Fifo& input)
*
* Entropy Decoding of the MB Layer
*
* Requires: Valid input Bitstream
*           EDEBUG activates on-screen information
*
* Modifies: _cmi (COD as bool)
*           _mv_x1, _mv_y1, _mv_type1 (Motion Vectors as integers)
*                _mv_x1 and _mv_y1 are modified by _mv_type1
*                _mv_type1 of 1 (no change)      _mv_type1 of 2 (_mv_x1 += 0.5)
*                _mv_type1 of 3 (_mv_y0 += 0.5)   _mv_type1 of 4 (_mv_x1 += 0.5 and _mv_y1 += 0.5)
*           _mcbpc, _mcbpy (Coded block patterns for Chrominance and Luminance as integers)
*           _mquant (Current quantization level defined by Picture, GOB, and MB layers
*           _zigzaged_central (Holds coefficient data read in from bitstream)
*                first _picture_size bits are for the all 4 Y (Luminance) blocks
*                   grouped first by the blocks, then by the macroblocks, and then by the gn
*                the next _picture_size_quarter bits are for the U (Chrominance 1) block
*                   grouped first by the macroblocks, and then by the gn
*                and then the next _picture_size_quarter bits for the V (Chrominance 2) block
*                   grouped first by the macroblocks, and then by the gn
*           
* Ensures:  Setting of variables and _zigzaged_central for correct decoding
*/
bool D_Frame::SAC_Decode_MB(PSC_Fifo& input, symbol * sac) {

	static int SAC_run[102] = {
		0,0,0,0,0,0,0,0,0,0,
		0,0,1,1,1,1,1,1,2,2,
		2,2,3,3,3,4,4,4,5,5,
		5,6,6,6,7,7,8,8,9,9,
		10,10,11,12,13,14,15,16,17,18,
		19,20,21,22,23,24,25,26,0,0,
		0,1,1,2,3,4,5,6,7,8,
		9,10,11,12,13,14,15,16,17,18,
		19,20,21,22,23,24,25,26,27,28,
		29,30,31,32,33,34,35,36,37,38,39,40};
	static int SAC_level[102] = {
		1,2,3,4,5,6,7,8,9,10,
		11,12,1,2,3,4,5,6,1,2,
		3,4,1,2,3,1,2,3,1,2,
		3,1,2,3,1,2,1,2,1,2,
		1,2,1,1,1,1,1,1,1,1,
		1,1,1,1,1,1,1,1,1,2,
		3,1,2,1,1,1,1,1,1,1,
		1,1,1,1,1,1,1,1,1,1,
		1,1,1,1,1,1,1,1,1,1,
		1,1,1,1,1,1,1,1,1,1,1,1};

	double median_x, median_y;
	int i, blockind, mbaindex, tcoefn;
	int count, max_count;
	short cbp, mtype, mcbpy, mcbpc, mcbpb, modb;
	short index, tx, ty, aipm;
	short run, level;
	short *zigzag_y, *zigzag_u, *zigzag_v;
	short *zigzag_y_pb, *zigzag_u_pb, *zigzag_v_pb;
	short dquant;
	short bquant;
	short mv_x1, mv_y1, mv_type1;
	short mv_x2, mv_y2, mv_type2;
	short mv_x3, mv_y3, mv_type3;
	short mv_x4, mv_y4, mv_type4;
	short mv_xb, mv_yb, mv_typeb;
	short *blockptr;
	short blocks[768];
	bool mvdb_used = false;
	bool last;
	
	aipm = (short) 0;
	bquant = (short) 0;
	
	if (input.FoundHeader()) return false;

	if (EDEBUG) { cout << "--> MB " << _ed_mba << endl; cout.flush(); }
	
	if (_slice_mode) mbaindex = _ed_mba;
	else mbaindex = (_ed_gn * _MB_per_gob) + _ed_mba;
	
	// COD - Coded Macroblock Indication - 1 bit (0 = coded, 1 = !coded)
	// Present only if MB Layer is not 'INTRA'
	if (_inter_frame_mode) {  // Is_inter?
		sac->decode(cumf_COD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC COD -> Found Header" << endl; }
		if (input.FoundHeader()) return false;

		if (index) {  // Sets MV to 0
			_cmi[mbaindex] = true;
			_mv_x1[mbaindex] = 0;
			_mv_y1[mbaindex] = 0;
			_mv_type1[mbaindex] = 1;
			_mcbpc[mbaindex] = 0;
			_mcbpy[mbaindex] = 0;
			_mtype[mbaindex] = 0;
			_mquant[mbaindex] = _ed_quant;
			// Advanced prediction mode variables
			if (_advanced_prediction_mode) _mtype[mbaindex] = 2;
			else _mtype[mbaindex] = 0;
			_mv_x2[mbaindex] = _mv_x3[mbaindex] = _mv_x4[mbaindex] = 0;
			_mv_y2[mbaindex] = _mv_y3[mbaindex] = _mv_y4[mbaindex] = 0;
			_mv_type2[mbaindex] = _mv_type3[mbaindex] = _mv_type4[mbaindex] = 1;
			// PB-frame mode variables
			_mcbpb[mbaindex] = 0;
			_bquant[mbaindex] = (short) (_ed_quant + (((_dbquant + 1) * _ed_quant) >> 2));
			_mvd_x[mbaindex] = _mvd_y[mbaindex] = 0;
			_mvd_type[mbaindex] = 1;
			if (EDEBUG) { cout << "COD 1" << endl; cout.flush(); }
			return (true);
		}
		if (EDEBUG) { cout << "COD 0" << endl; cout.flush(); }
	}

	// MCBPC - Macroblock type & Coded block pattern for chrominance - VLC
	// Changes needed: Mtype Stuffing needs to be supported
	cbp = 0;
	if (_inter_frame_mode) {  // Is_inter?
		if (_plusptype && _advanced_prediction_mode) { // DF to be inserted later
			sac->decode(cumf_MCBPC_4MVQ, index, input);
			if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MCBPC_4MVQ -> Found Header" << endl; }
			if (input.FoundHeader()) return false;
		}
		else {
			sac->decode(cumf_MCBPC_no4MVQ, index, input);
			if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MCBPC_no4MVQ -> Found Header" << endl; }
			if (input.FoundHeader()) return false;
		}
		if (index == 20) {
			cout << "MCBPC: Mtype Stuffing not supported yet" << endl;
			return (false);
		}
		if (index > 20) { index--; }
		cbp = (short)(index & 3);
		mtype = (short)(index >> 2);
	}
	else { // Intra
		sac->decode(cumf_MCBPC_intra, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MCBPC_intra -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		if (index == 8) {
			cout << "MCBPC: Mtype Stuffing not supported yet" << endl;
			return (false);
		}
		cbp = (short) (index & 3);
		mtype = (short) ((index >> 2) + 3);
	}
	mcbpc = cbp;
	if (EDEBUG) { cout << "MTYPE " << mtype << endl; cout.flush(); }
	if (EDEBUG) { cout << "CBPC " << ((cbp&2) > 0) << ((cbp&1) > 0) << endl; cout.flush(); }
	
	// INTRA_MODE - Prediction mode for AIC
	if (_advanced_intra_coding_mode && (mtype == INTRA || mtype == INTRAQ)) {
		sac->decode(cumf_INTRA_AC_DC, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC INTRA_MODE -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		aipm = index;
		if (EDEBUG) { cout << "INTRA_MODE " << aipm << endl; cout.flush(); }
	}
	
	// MODB - Macroblock mode for B-blocks - VLC
	modb = 0;
	mcbpb = 0;
	if (_PB_frame_mode) {	// Only present in PB-frames
		sac->decode(cumf_MODB_G, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MODB_G -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		modb = (short)(index);
		if (EDEBUG) { cout << "MODB " << modb << endl; cout.flush(); }

		// CBPB - Coded Block Pattern for B-blocks - 6 bits
		if (modb == 2) {
			if (EDEBUG) { cout << "CBPB "; }
			for (i=0; i<4; i++) {
				sac->decode(cumf_YCBPB, index, input);
				if (EDEBUG) { if (input.FoundHeader()) cout << "SAC YCBPB -> Found Header" << endl; }
				if (input.FoundHeader()) return false;
				mcbpb = (short) ((mcbpb << 1) + index);
				if (EDEBUG) { cout << index; }
			}

			for (i=0; i<2; i++) {
				sac->decode(cumf_UVCBPB, index, input);
				if (EDEBUG) { if (input.FoundHeader()) cout << "SAC UVCBPB -> Found Header" << endl; }
				if (input.FoundHeader()) return false;
				mcbpb = (short) ((mcbpb << 1) + index);
				if (EDEBUG) { cout << index; }
			}
			if (EDEBUG) { cout << endl; cout.flush(); }
		}
	}
	
	// CBPY - Coded Block Pattern for Luminance - SAC
	if (mtype == INTRA || mtype == INTRAQ){ // Is this an intra block?
		sac->decode(cumf_CBPY_intra, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC CBPY_intra -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		cbp = (short) (cbp + (index << 2));
	}  
	else {									//Is this an inter block?
		sac->decode(cumf_CBPY, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC CBPY -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		cbp = (short) (cbp + ((15-index) << 2)); 
	}
	mcbpy = (short) (cbp >> 2);
	if (EDEBUG) { cout << "CBPY " << ((cbp&32) > 0) << ((cbp&16) > 0) << ((cbp&8) > 0)
		<< ((cbp&4) > 0) << endl; cout.flush(); }

	// DQUANT - Quantizer Information - 2 bits
	// This will be executed depending on the MCBPC
	if (mtype == 1 || mtype >= 4) {
		sac->decode(cumf_DQUANT, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC DQUANT -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		switch(index) {
		case 0:
			dquant = (short) (_ed_quant - 1);
			break;
		case 1:
			dquant = (short) (_ed_quant - 2);
			break;
		case 2:
			dquant = (short) (_ed_quant + 1);
			break;
		case 3:
			dquant = (short) (_ed_quant + 2);
			break;
		default:
			cout << "UhOh, I got a wierd Dquant:" << index << endl;
			return (false);
		}
		if (EDEBUG) { cout << "DQUANT " << dquant << endl; cout.flush(); }
	}
	else dquant = _ed_quant;
	if (_PB_frame_mode) bquant = (short) (dquant + (((_dbquant + 1) * dquant) >> 2));
	
	// MVD - Motion Vector Data - VLC
	if (mtype < 3 || mtype == 5 || _PB_frame_mode) { // PB mode always has MVDs
		if (mtype == INTER4V || mtype == INTER4VQ) {
			_MB_list[mbaindex].Median_Predictor_1(&median_x, &median_y);
		}
		else _MB_list[mbaindex].Median_Predictor(&median_x, &median_y, false);

		// Grab values
		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { cout << "MVDx SAC " << index << endl; cout.flush(); }
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVDx -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		tx = (short) ((median_x*2) + index-32);
		if (tx < -32 || tx > 31) {
			if (index < 32) tx += 64;
			else tx -= 64;
		}
		mv_type1 = (short) (abs(tx % 2) + 1);
		
		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { cout << "MVDy SAC " << index << endl; cout.flush(); }
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVDy -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		ty = (short) ((median_y*2) + index-32);
		if (ty < -32 || ty > 31) {
			if (index < 32) ty += 64;
			else ty -= 64;
		}
		mv_type1 = (short) (mv_type1 + abs((ty % 2) * 2));
		
		if (tx >= 0) mv_x1 = (short) (tx >> 1);
		else mv_x1 = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_y1 = (short) (ty >> 1);
		else mv_y1 = (short) ((int) ((ty/2.0) - 0.5));

		if (EDEBUG) { cout << "MVD " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_type1
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }
	}
	else {	// Case 1: When MB is in INTRA mode
		mv_x1 = 0;
		mv_y1 = 0;
		mv_type1 = 1;
	}

	// MVD2-4 - Motion Vector Data - VLC
	if (mtype == INTER4V || mtype == INTER4VQ) {	// Only present if MBTYPE says so
		_MB_list[mbaindex].Median_Predictor_2(mv_x1, mv_y1, mv_type1,
			&median_x, &median_y);

		// MVD2
		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVD2x -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		tx = (short) ((median_x*2) + index-32);
		if (tx < -32 || tx > 31) {
			if (index < 32) tx += 64;
			else tx -= 64;
		}
		mv_type2 = (short) (abs(tx % 2) + 1);
		
		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVD2y -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		ty = (short) ((median_y*2) + index-32);
		if (ty < -32 || ty > 31) {
			if (index < 32) ty += 64;
			else ty -= 64;
		}
		mv_type2 = (short) (mv_type2 + abs((ty % 2) * 2));
		
		if (tx >= 0) mv_x2 = (short) (tx >> 1);
		else mv_x2 = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_y2 = (short) (ty >> 1);
		else mv_y2 = (short) ((int) ((ty/2.0) - 0.5));
		if (EDEBUG) { cout << "MVD2 " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_type2
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }
		
		// MVD3
		_MB_list[mbaindex].Median_Predictor_3(mv_x1, mv_y1, mv_type1,
			mv_x2, mv_y2, mv_type2, &median_x, &median_y);

		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVD3x -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		tx = (short) ((median_x*2) + index-32);
		if (tx < -32 || tx > 31) {
			if (index < 32) tx += 64;
			else tx -= 64;
		}
		mv_type3 = (short) (abs(tx % 2) + 1);
		
		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVD3y -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		ty = (short) ((median_y*2) + index-32);
		if (ty < -32 || ty > 31) {
			if (index < 32) ty += 64;
			else ty -= 64;
		}
		mv_type3 = (short) (mv_type3 + abs((ty % 2) * 2));
		
		if (tx >= 0) mv_x3 = (short) (tx >> 1);
		else mv_x3 = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_y3 = (short) (ty >> 1);
		else mv_y3 = (short) ((int) ((ty/2.0) - 0.5));
		if (EDEBUG) { cout << "MVD3 " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_type3
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }
		
		// MVD4
		_MB_list[mbaindex].Median_Predictor_4(mv_x1, mv_y1, mv_type1,
			mv_x2, mv_y2, mv_type2, mv_x3, mv_y3, mv_type3,
			&median_x, &median_y);

		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVD4x -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		tx = (short) ((median_x*2) + index-32);
		if (tx < -32 || tx > 31) {
			if (index < 32) tx += 64;
			else tx -= 64;
		}
		mv_type4 = (short) (abs(tx % 2) + 1);
		
		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVD4y -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		ty = (short) ((median_y*2) + index-32);
		if (ty < -32 || ty > 31) {
			if (index < 32) ty += 64;
			else ty -= 64;
		}
		mv_type4 = (short) (mv_type4 + abs((ty % 2) << 1));
		
		if (tx >= 0) mv_x4 = (short) (tx >> 1);
		else mv_x4 = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_y4 = (short) (ty >> 1);
		else mv_y4 = (short) ((int) ((ty/2.0) - 0.5));
		if (EDEBUG) { cout << "MVD4 " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_type4
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }
	}
	else {
		mv_x4 = mv_x3 = mv_x2 = mv_x1;
		mv_y4 = mv_y3 = mv_y2 = mv_y1;
		mv_type4 = mv_type3 = mv_type2 = mv_type1;
	}

	// MVDB - Motion Vector Data for B-macroblock - (Variable Length)
	if (modb >= 1) {	// If MODB says MVDB is present
		_MB_list[mbaindex].Median_Predictor(&median_x, &median_y, true);
		
		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVDBx -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		tx = (short) ((median_x*2) + index-32);
		if (tx < -32 || tx > 31) {
			if (index < 32) tx += 64;
			else tx -= 64;
		}
		mv_typeb = (short) (abs(tx % 2) + 1);
		
		sac->decode(cumf_MVD, index, input);
		if (EDEBUG) { if (input.FoundHeader()) cout << "SAC MVDBy -> Found Header" << endl; }
		if (input.FoundHeader()) return false;
		ty = (short) ((median_y*2) + index-32);
		if (ty < -32 || ty > 31) {
			if (index < 32) ty += 64;
			else ty -= 64;
		}
		mv_typeb = (short) (mv_typeb + abs((ty % 2) << 1));
		
		if (tx >= 0) mv_xb = (short) (tx >> 1);
		else mv_xb = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_yb = (short) (ty >> 1);
		else mv_yb = (short) ((int) ((ty/2.0) - 0.5));

		if (!_coded_mvd_flag) {
			if ((mv_xb != 0) || (mv_yb != 0) || (mv_typeb != 1)) mvdb_used = true;
		}		
		if (EDEBUG) { cout << "MVDB " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_typeb
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }
	}
	else {
		mv_xb = 0;
		mv_yb = 0;
		mv_typeb = 1;
	}

	blockptr = blocks;
	// Block Layer for PB-Frames **************************************************
	if (_PB_frame_mode) {
		for (blockind = 0; blockind < 6; blockind++, cbp <<= 1) {
			tcoefn = 0;	// Initialize coeficient counter for SAC
			count = blockind*64;
			max_count = count + 64;
			// Set pointers
			
			if (EDEBUG) { cout << "Block " << blockind << " -> "; cout.flush(); }
			
			// INTRADC - DC Coefficient for INTRA blocks - 8 bits
			// Only present for MB Types #3 or #4
			if (mtype == INTRA || mtype == INTRAQ) {
				sac->decode(cumf_INTRADC, index, input);
				if (EDEBUG) { if (input.FoundHeader()) cout << "SAC INTRADC -> Found Header" << endl; }
				if (input.FoundHeader()) return false;
				if (index == 127) level = 255;
				else level = (short) (index + 1);
				
				if (level == 0 || level == 128) {
					cout << "Invalid INTRADC: " << level << endl;
					return(false);
				}
				*blockptr++ = level;
				count++;
				if (EDEBUG) { cout << "INTRADC " << level << " "; cout.flush(); }
			}
			if (cbp & 32) {
				// TCOEF - Transform coefficient - VLC
				while (count < max_count) {
					if (mtype == INTRA || mtype == INTRAQ) {
						switch(tcoefn) {
						case 0:
							sac->decode(cumf_TCOEF1_intra, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF1_intra -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							break;
						case 1:
							sac->decode(cumf_TCOEF2_intra, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF2_intra -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							break;
						case 2:
							sac->decode(cumf_TCOEF3_intra, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF3_intra -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							break;
						default:
							sac->decode(cumf_TCOEFr_intra, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEFr_intra -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							break;
						}
					}
					else {
						switch(tcoefn) {
						case 0:
							sac->decode(cumf_TCOEF1, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF1 -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							break;
						case 1:
							sac->decode(cumf_TCOEF2, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF2 -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							break;
						case 2:
							sac->decode(cumf_TCOEF3, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF3 -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							break;
						default:
							sac->decode(cumf_TCOEFr, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEFr -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							break;
						}
					}
					tcoefn++;
					if (index == 102) { // FLC coding
						if (mtype == INTRA || mtype == INTRAQ) {
							sac->decode(cumf_LAST_intra, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC LAST_intra -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							if (index) last = true;
							else last = false;
							sac->decode(cumf_RUN_intra, run, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC RUN_intra -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							sac->decode(cumf_LEVEL_intra, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC LEVEL_intra -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
						} else {
							sac->decode(cumf_LAST, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC LAST -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							if (index) last = true;
							else last = false;
							sac->decode(cumf_RUN, run, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC RUN -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
							sac->decode(cumf_LEVEL, index, input);
							if (EDEBUG) { if (input.FoundHeader()) cout << "SAC LEVEL -> Found Header" << endl; }
							if (input.FoundHeader()) return false;
						}
						if (index < 127) {level = (short) (index - 127);}
						else {level = (short) (index - 126);}
					} else {
						last = (index > 57);		// Last
						run = (short) SAC_run[index];	// Run
						level = (short) SAC_level[index];	// Level
						sac->decode(cumf_SIGN, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC SIGN -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						if (index) level = (short) -level; //Sign
					}
					for (i=0; i < run; i++) { // Fill in zeros defined by run
						*blockptr++ = 0;
						count++;
						if (EDEBUG) { cout << "0 "; cout.flush(); }
					}
					
					*blockptr++ = level;
					count++;
					if (EDEBUG) { if (index == 102) cout << "E"; cout << level << " "; cout.flush(); }
					if (last) {
						if (EDEBUG) { cout << "LAST" << count-1-(blockind*64) << endl; cout.flush(); }
						while (count < max_count) { // Fill zeros after last
							*blockptr++ = 0;
							count++;
						}
					}
				} // while (count < max_count)
			} // if (cbp & 32)
			else { // Zero out this block
				while (count < max_count) {
					*blockptr++ = 0;
					count++;
				}
				if (EDEBUG) { cout << endl; cout.flush(); }
			}

		} // for (blockind = 0; blockind < 6; blockind++, cbp <<= 1)
	} // if (_PB_frame_mode)
	
	
	// Block Layer for Normal Frames or B frames ***************************************
	if (_PB_frame_mode) cbp = mcbpb;	// B-frames
	for (blockind = 0; blockind < 6; blockind++, cbp <<= 1) {
		tcoefn = 0;		// Initialize coeficient counter for SAC
		count = blockind*64;
		max_count = count + 64;
		// Set pointers
		
		if (EDEBUG) { cout << "Block "; if (_PB_frame_mode) cout << blockind+6;
		else cout << blockind; cout << " -> "; cout.flush(); }
		
		if (!_PB_frame_mode && !_advanced_intra_coding_mode) {	// Not for B-frames
			// INTRADC - DC Coefficient for INTRA blocks - 8 bits
			// Only present for MB Types #3 or #4
			if (mtype == INTRA || mtype == INTRAQ) {
				sac->decode(cumf_INTRADC, index, input);
				if (EDEBUG) { if (input.FoundHeader()) cout << "SAC INTRADC -> Found Header" << endl; }
				if (input.FoundHeader()) return false;
				if (index == 127) level = (short) 255;
				else level = (short) (index + 1);
				
				if (level == 0 || level == 128) {
					cout << "Invalid INTRADC: " << level << endl;
					return(false);
				}
				*blockptr++ = level;
				count++;
				if (EDEBUG) { cout << "INTRADC " << level << " "; cout.flush(); }
			}
		}
		if (cbp & 32) {
			// TCOEF - Transform coefficient - VLC
			while (count < max_count) {
				if (mtype == INTRA || mtype == INTRAQ) {
					switch(tcoefn) {
					case 0:
						sac->decode(cumf_TCOEF1_intra, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF1_intra -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						break;
					case 1:
						sac->decode(cumf_TCOEF2_intra, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF2_intra -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						break;
					case 2:
						sac->decode(cumf_TCOEF3_intra, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF3_intra -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						break;
					default:
						sac->decode(cumf_TCOEFr_intra, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEFr_intra -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						break;
					}
				}
				else {
					switch(tcoefn) {
					case 0:
						sac->decode(cumf_TCOEF1, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF1 -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						break;
					case 1:
						sac->decode(cumf_TCOEF2, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF2 -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						break;
					case 2:
						sac->decode(cumf_TCOEF3, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEF3 -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						break;
					default:
						sac->decode(cumf_TCOEFr, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC TCOEFr -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						break;
					}
				}
				tcoefn++;
				if (index == 102) { // FLC coding
					if (mtype == INTRA || mtype == INTRAQ) {
						sac->decode(cumf_LAST_intra, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC LAST_intra -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						if (index) last = true;
						else last = false;
						sac->decode(cumf_RUN_intra, run, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC RUN_intra -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						sac->decode(cumf_LEVEL_intra, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC LEVEL_intra -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
					}
					else {
						sac->decode(cumf_LAST, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC LAST -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						if (index) last = true;
						else last = false;
						sac->decode(cumf_RUN, run, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC RUN -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
						sac->decode(cumf_LEVEL, index, input);
						if (EDEBUG) { if (input.FoundHeader()) cout << "SAC LEVEL -> Found Header" << endl; }
						if (input.FoundHeader()) return false;
					}
					if (index < 127) {level = (short) (index - 127);}
					else {level = (short) (index - 126);}
				}
				else {
					last = (index > 57);		// Last
					run = (short) SAC_run[index];	// Run
					level = (short) SAC_level[index];	// Level
					sac->decode(cumf_SIGN, index, input);
					if (EDEBUG) { if (input.FoundHeader()) cout << "SAC SIGN -> Found Header" << endl; }
					if (input.FoundHeader()) return false;
					if (index) level = (short) -level; //Sign
				}
				for (i=0; i < run; i++) { // Fill in zeros defined by run
					*blockptr++ = 0;
					count++;
					if (EDEBUG) { cout << "0 "; cout.flush(); }
				}
				*blockptr++ = level;
				count++;
				if (EDEBUG) { if (index == 102) cout << "E"; cout << level << " "; cout.flush(); }
				if (last) {
					if (EDEBUG) { cout << "LAST" << count-1-(blockind*64) << endl; cout.flush(); }
					while (count < max_count) { // Fill zeros after last
						*blockptr++ = 0;
						count++;
					}
				}
			} // while (count < max_count)
		} // if (cbp & 32)
		else { // Zero out this block
			while (count < max_count) {
				*blockptr++ = 0;
				count++;
			}
			if (EDEBUG) { cout << endl; cout.flush(); }
		}
	} // for (blockind = 0; blockind < 6; blockind++, cbp <<= 1)
	
	// Save the values ************************************************************
	_cmi[mbaindex] = false;
	_mcbpc[mbaindex] = mcbpc;
	_mtype[mbaindex] = mtype;
	_mcbpb[mbaindex] = mcbpb;
	_mcbpy[mbaindex] = mcbpy;
	_ed_quant = dquant;
	_mquant[mbaindex] = dquant;
	_mv_x1[mbaindex] = mv_x1;
	_mv_y1[mbaindex] = mv_y1;
	_mv_type1[mbaindex] = mv_type1;
	_mv_x2[mbaindex] = mv_x2;
	_mv_y2[mbaindex] = mv_y2;
	_mv_type2[mbaindex] = mv_type2;
	_mv_x3[mbaindex] = mv_x3;
	_mv_y3[mbaindex] = mv_y3;
	_mv_type3[mbaindex] = mv_type3;
	_mv_x4[mbaindex] = mv_x4;
	_mv_y4[mbaindex] = mv_y4;
	_mv_type4[mbaindex] = mv_type4;
	_mvd_x[mbaindex] = mv_xb;
	_mvd_y[mbaindex] = mv_yb;
	_mvd_type[mbaindex] = mv_typeb;
	if (mvdb_used) {
		_coded_mvd_flag = true;
		D_GOB::_coded_mvd_flag = true;
		D_Slice::_coded_mvd_flag = true;
		D_Macroblock::_coded_mvd_flag = true;
	}

	zigzag_y = _zigzaged_central + (mbaindex << 8);
	zigzag_u = _zigzaged_central + _picture_size + (mbaindex << 6);
	zigzag_v = zigzag_u + _picture_size_quarter;

	blockptr = blocks;
	if (_PB_frame_mode) {
		zigzag_y_pb = zigzag_y + _PB_offset;
		zigzag_u_pb = zigzag_u + _PB_offset;
		zigzag_v_pb = zigzag_v + _PB_offset;
		_bquant[mbaindex] = bquant;
		for (blockind = 0; blockind < 256; blockind++) *zigzag_y_pb++ = *blockptr++;
		for (blockind = 0; blockind < 64; blockind++) *zigzag_u_pb++ = *blockptr++;
		for (blockind = 0; blockind < 64; blockind++) *zigzag_v_pb++ = *blockptr++;
	}

	for (blockind = 0; blockind < 256; blockind++) *zigzag_y++ = *blockptr++;
	for (blockind = 0; blockind < 64; blockind++) *zigzag_u++ = *blockptr++;
	for (blockind = 0; blockind < 64; blockind++) *zigzag_v++ = *blockptr++;

	// For AIC
	if (_advanced_intra_coding_mode) {
		_MB_list[mbaindex]._advanced_intra_prediction_mode = aipm;
	}

	return (true);
}

			
			
#endif
			
