
#ifndef __D_FRAME_RESET_SEGMENT_C__
#define __D_FRAME_RESET_SEGMENT_C__

#include "D_Frame.h"


/*
 * void D_Frame::Reset_Segment(void)
 * 
 * Prepare update segment resources for video/entropy encoder/decoder
 *
 * Requires:	_MB_per_gob and _GOB_per_frame, _seg_id, _seg_right_span, _seg_left_span
 * Modifies:	_seg_x_high, _seg_x_low, _seg_y_high, _seg_y_low
 * Ensures:		Accouting for segment, compute the legal range for motion vectors for each macroblock
 *
 * Warning:		
 */
void D_Frame::Reset_Segment(void)
{
	int i, j, k, l;
	const short *ptr_slice_size;
	short *ptr_seg_ID, *ptr_seg_size;
	short *ptr_right_span, *ptr_left_span;
	const bool *ptr_cgi;

	_reset_segment_flag = false;

	// We are assuming that segment decisions are stored in macroblock segment ID
	ptr_slice_size = _slice_size;
	ptr_seg_ID = _seg_ID; ptr_seg_size = _seg_size;
	ptr_right_span = _right_span; ptr_left_span = _left_span;
	ptr_cgi = _cgi;


	// Video segment is a notion only well defined in slice or ISD mode
	// Definition of Video segment is based on CGI or Slice
	if (_slice_mode) {

		for (i=0; i<_SLICE_per_frame; i++) {
			l = *ptr_slice_size++;
			for (j=l; j>0; j--) {
				*ptr_seg_ID++ =		(short) i;
				*ptr_seg_size++ =	(short) l;
				*ptr_right_span++ = (short) (j - 1);
				*ptr_left_span++ =	(short) (l - j);
			}
			//fprintf(stdout, "si %i size %i\n", i, l);
		}
		_Segment_per_frame = _SLICE_per_frame;

	}	// if (_slice_mode) {
	else if (_independent_segment_mode) {

		//for (i=0; i<_GOB_per_frame; i++) {
		//	if (*ptr_cgi++ == true) fprintf(stdout, "true\n");
		//	else fprintf(stdout, "false\n");
		//}
		ptr_cgi = _cgi;

		// First GOB, by definition, is the beginning of a video segment
		k = 0;
		for (i=0, l=_MB_per_gob-1; i<_MB_per_gob; i++) {
			*ptr_seg_ID++ =		(short) k;
			*ptr_seg_size++ =	(short) _MB_per_gob;
			*ptr_right_span++ = (short) (l - 1);
			*ptr_left_span++ =	(short) i;
		}
//		fprintf(stdout, "i 0 ID %i\n", k);
		
		// Rest of GOBs
		ptr_cgi++;
		for (i=1, l=_MB_per_gob-1; i<_GOB_per_frame; i++) {
			
			if (*ptr_cgi++) k++;			// new video segment
//			fprintf(stdout, "i %i ID %i\n", i, k);
			for (j=0; j<_MB_per_gob; j++) {
				*ptr_seg_ID++ =		(short) k;
				*ptr_seg_size++ =	(short) _MB_per_gob;
				*ptr_right_span++ = (short) (l - j);
				*ptr_left_span++ =	(short) j;
			}
		}
		_Segment_per_frame = k + 1;

	}	// else if (_independent_segment_mode) {

	//exit(-1);
}


#endif

