
#ifndef __D_FRAME_MOTION_ESTIMATION_C__
#define __D_FRAME_MOTION_ESTIMATION_C__

#include "D_Frame.h"


/*
* void D_Frame::Motion_Estimation(void)
* 
* Find the best match for each macroblock and set the motion vector
* This is a private method
*
* Requires:	D_Frame::Subpixel_Interpolation_Module() must be called for previous frame
* Modifies:	_mv_type0, _mv_x0, _mv_y0
* Ensures:		Find the best match for each macroblock and set the motion vector
*				. Call D_Frame::Distance_ME and D_frame::Voting_ME() to determine spatial correlation
*				. Based on spatial correlation, call either D_Frame::Four_Step_Search_ME() or D_Frame::Three_Step_Search_ME()
*				. Call D_Frame::Full_Search_ME on subpixel decoded frames around the best motion vector found above
*
* Warning:		
*/
void D_Frame::Motion_Estimation(void)
{
	int i, j; 
	int onemv_MAD, fourmv_MAD;
	int last_seg_ID = -1;
	int xstart, ystart, xmotion, ymotion;
	int xcentre, ycentre, result, newcount;
	short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;
	short *ptr_mvy0_low, *ptr_mvy0_high, *ptr_mvx0_low, *ptr_mvx0_high;
	short *ptr_mvy1_low, *ptr_mvy1_high, *ptr_mvx1_low, *ptr_mvx1_high;
	short *ptr_mvy2_low, *ptr_mvy2_high, *ptr_mvx2_low, *ptr_mvx2_high;
	short *ptr_mvy3_low, *ptr_mvy3_high, *ptr_mvx3_low, *ptr_mvx3_high;
	short *ptr_mvy4_low, *ptr_mvy4_high, *ptr_mvx4_low, *ptr_mvx4_high;
	short mvx, mvy, mvtype;
	bool *ptr_flag_zero_mv;
	
	// Variables to support rps and slice
	int slicenum = 0, slicesize = 0, slicecount = 0;
	
	xstart = 0;
	ystart = 0;
	newcount = 0;
	mvtype = (short) 0;
	mvx = (short) 0;
	mvy = (short) 0;
	
	ptr_flag_zero_mv = _flag_zero_mv;
	ptr_mv_type1 = _mv_type1; ptr_mv_x1 = _mv_x1; ptr_mv_y1 = _mv_y1;
	ptr_mv_type2 = _mv_type2; ptr_mv_x2 = _mv_x2; ptr_mv_y2 = _mv_y2;
	ptr_mv_type3 = _mv_type3; ptr_mv_x3 = _mv_x3; ptr_mv_y3 = _mv_y3;
	ptr_mv_type4 = _mv_type4; ptr_mv_x4 = _mv_x4; ptr_mv_y4 = _mv_y4;

	ptr_mvy0_low = _mvy0_low; ptr_mvy0_high = _mvy0_high;
	ptr_mvx0_low = _mvx0_low; ptr_mvx0_high = _mvx0_high;
	ptr_mvy1_low = _mvy1_low; ptr_mvy1_high = _mvy1_high;
	ptr_mvx1_low = _mvx1_low; ptr_mvx1_high = _mvx1_high;
	ptr_mvy2_low = _mvy2_low; ptr_mvy2_high = _mvy2_high;
	ptr_mvx2_low = _mvx2_low; ptr_mvx2_high = _mvx2_high;
	ptr_mvy3_low = _mvy3_low; ptr_mvy3_high = _mvy3_high;
	ptr_mvx3_low = _mvx3_low; ptr_mvx3_high = _mvx3_high;
	ptr_mvy4_low = _mvy4_low; ptr_mvy4_high = _mvy4_high;
	ptr_mvx4_low = _mvx4_low; ptr_mvx4_high = _mvx4_high;

	
	// This indicates no delta motion vectors are being generated here at all!
	_coded_mvd_flag = false;
	D_GOB::_coded_mvd_flag = _coded_mvd_flag;
	D_Macroblock::_coded_mvd_flag = _coded_mvd_flag;
	
	for (i=0; i<_GOB_per_frame; i++) {
		// Set information only if it's the first GOB or when the GOB header is sent
		if (_reference_picture_selection && !_slice_mode) {
			if (_cgi[i] || i == 0)
				_ref_index = GetReferenceIndex();
			_trp[i] = _ref_index;
			if (_advanced_prediction_mode) {
				Make_UMV_Padded_Frame(_prev_frames->GetFrame(_ref_index));
				Subpixel_Interpolation_Module();
			}
		}
		
		for (j=0; j<_MB_per_gob; j++) {
			
			if (_reference_picture_selection && _slice_mode) {
				if (slicecount == slicesize) {
					slicesize = _slice_size[slicenum];
					slicenum++; slicecount = 0;
					_ref_index = GetReferenceIndex();
					_trp[i] = _ref_index;
					if (_advanced_prediction_mode) {
						Make_UMV_Padded_Frame(_prev_frames->GetFrame(_ref_index));
						Subpixel_Interpolation_Module();
					}
				}
				slicecount++;
			}

			if (_advanced_prediction_mode && _independent_segment_mode && last_seg_ID != _seg_ID[i*_MB_per_gob+j]) {
					last_seg_ID = _seg_ID[i*_MB_per_gob+j];
					short x_low, y_low, x_high, y_high;
					x_low = _x_bound_low[i*_MB_per_gob+j];
					y_low = _y_bound_low[i*_MB_per_gob+j];
					x_high = _x_bound_high[i*_MB_per_gob+j];
					y_high = _y_bound_high[i*_MB_per_gob+j];
					Make_ISD_Extrapolated_Frame(x_low, x_high, y_low, y_high);
					Subpixel_Interpolation_Module();
//					Make_ISD_Extrapolated_Frame(0, 175, 0, 143);
			}
			
			onemv_MAD = 0;
			fourmv_MAD = 0;
			*ptr_flag_zero_mv = false;
			xcentre = 0; 
			ycentre = 0;
			xmotion = 0;
			ymotion = 0;
			_min_MAD = 65530;
			
			if(_advanced_prediction_mode) {
				//First do a search for the entire macroblock after which 
				//do block by block search if necessary
				
				_first_search_in_AP = true;
				if (_independent_segment_mode)
					Distance_ME(_ISD_extrapolated_frame, ystart, xstart, ystart + 16, 
						xstart + 16);
				else
					Distance_ME(_padded_UMV_frame, ystart, xstart, ystart + 16, 
						xstart + 16);
				_min_MAD = _current_MAD;
				
				// Check to see if the residue at the centre is already smaller than camera noise
				if (_min_MAD > _thresh_no_residue) {
					// Do a majority voting based on spatial correlation information in the current frame 
					// and pick one of the fast algorithms based on that
					result = Voting_ME(i, j, &xcentre, &ycentre);
					if (result == 1) Three_Step_Search_ME(xcentre, ycentre, xstart, ystart,
						&xmotion, &ymotion, 16, *ptr_mvy1_low, *ptr_mvy1_high,
						*ptr_mvx1_low, *ptr_mvx1_high);
					else Four_Step_Search_ME(xcentre, ycentre, xstart, ystart, &xmotion,
						&ymotion, 16, *ptr_mvy1_low, *ptr_mvy1_high, *ptr_mvx1_low, 
						*ptr_mvx1_high);
				}//if (_min_MAD > _thresh_no_residue)
				else {
					// If the centre provided the best match, set the ptr_flag_zero_mv to true
					onemv_MAD = _min_MAD;
					*ptr_flag_zero_mv = true;
					*ptr_mv_type1 = 1;
					*ptr_mv_x1 = 0;
					*ptr_mv_y1 = 0;
					
					*ptr_mv_type2 = *ptr_mv_type1; *ptr_mv_x2 = *ptr_mv_x1; *ptr_mv_y2 = *ptr_mv_y1;
					*ptr_mv_type3 = *ptr_mv_type1; *ptr_mv_x3 = *ptr_mv_x1; *ptr_mv_y3 = *ptr_mv_y1;
					*ptr_mv_type4 = *ptr_mv_type1; *ptr_mv_x4 = *ptr_mv_x1; *ptr_mv_y4 = *ptr_mv_y1;
					mvx = *ptr_mv_x1;
					mvy = *ptr_mv_y1;
					mvtype = *ptr_mv_type1;
				}
				
				
				
				// For each motion vector now obtained do a search around the same point in the 
				// other three sub-pixel interpolated images except if we have already decided that
				// the residue at the centre is good enough
				if (*ptr_flag_zero_mv == false) {
					
					*ptr_mv_type1 = (short) 
						Full_Search_ME(ystart, xstart, ymotion+ystart, xmotion+xstart, &xmotion,
						&ymotion, 16, *ptr_mvy0_low, *ptr_mvy0_high, *ptr_mvx0_low, 
						*ptr_mvx0_high);
					onemv_MAD = _min_MAD;
					*ptr_mv_x1 = (short) xmotion;
					*ptr_mv_y1 = (short) ymotion;
					
					*ptr_mv_type2 = *ptr_mv_type1; *ptr_mv_x2 = *ptr_mv_x1; *ptr_mv_y2 = *ptr_mv_y1;
					*ptr_mv_type3 = *ptr_mv_type1; *ptr_mv_x3 = *ptr_mv_x1; *ptr_mv_y3 = *ptr_mv_y1;
					*ptr_mv_type4 = *ptr_mv_type1; *ptr_mv_x4 = *ptr_mv_x1; *ptr_mv_y4 = *ptr_mv_y1;
					mvx = *ptr_mv_x1;
					mvy = *ptr_mv_y1;
					mvtype = *ptr_mv_type1;
				}			
				// Even after all the searches if the best match is at the centre, set *ptr_flag_zero_mv to true
				if ((xmotion == 0) && (ymotion == 0) && (*ptr_mv_type1 == 1))
					*ptr_flag_zero_mv = true;
				
				_first_search_in_AP = false;
				
				if(_min_MAD > _thresh_no_residue << 1) {
					*ptr_flag_zero_mv = false;
					
					//Block Zero
					_min_MAD = 65530;
					xcentre = 0; 
					ycentre = 0;
					xmotion = 0;
					ymotion = 0;
					if (_independent_segment_mode) 
						Distance_ME(_ISD_extrapolated_frame, ystart, xstart, ystart + 16, xstart + 16); 
					else
						Distance_ME(_padded_UMV_frame, ystart, xstart, ystart + 16, xstart + 16); 
					_min_MAD = _current_MAD;
					if (_min_MAD > _thresh_no_residue>>2) {
						result = Voting_ME(i, j, &xcentre, &ycentre,0);
						if (result == 1) Three_Step_Search_ME(xcentre, ycentre, xstart, 
							ystart, &xmotion, &ymotion, 8, *ptr_mvy1_low, *ptr_mvy1_high,
							*ptr_mvx1_low, *ptr_mvx1_high);
						else Four_Step_Search_ME(xcentre, ycentre, xstart, ystart, 
							&xmotion, &ymotion, 8, *ptr_mvy1_low, *ptr_mvy1_high,
							*ptr_mvx1_low, *ptr_mvx1_high);
						//Half pixel Estimation
						*ptr_mv_type1 = (short) 
							Full_Search_ME(ystart, xstart, ymotion+ystart, xmotion+xstart, 
							&xmotion, &ymotion, 8, *ptr_mvy1_low, *ptr_mvy1_high,
							*ptr_mvx1_low, *ptr_mvx1_high);
						*ptr_mv_x1 = (short) xmotion;
						*ptr_mv_y1 = (short) ymotion;
					}//if (_min_MAD > _thresh_no_residue>>2) 
					else {
						*ptr_mv_type1 = 1;
						*ptr_mv_x1 = 0;
						*ptr_mv_y1 = 0;
					}
					
					fourmv_MAD += _min_MAD;
					
					//Block One
					xcentre = 0; 
					ycentre = 0;
					xmotion = 0;
					ymotion = 0;
					_min_MAD = 65530;
					if(_independent_segment_mode)
						Distance_ME(_ISD_extrapolated_frame, ystart, xstart + 8, ystart + 16, 
							xstart + 8 + 16); 
					else
						Distance_ME(_padded_UMV_frame, ystart, xstart + 8, ystart + 16, 
							xstart + 8 + 16); 
					_min_MAD = _current_MAD;
					if (_min_MAD > _thresh_no_residue>>2) {
						result = Voting_ME(i, j, &xcentre, &ycentre, 1);
						if (result == 1) Three_Step_Search_ME(xcentre, ycentre, xstart + 8, 
							ystart, &xmotion, &ymotion, 8, *ptr_mvy2_low, *ptr_mvy2_high,
							*ptr_mvx2_low, *ptr_mvx2_high);
						else Four_Step_Search_ME(xcentre, ycentre, xstart + 8, ystart, 
							&xmotion, &ymotion, 8, *ptr_mvy2_low, *ptr_mvy2_high,
							*ptr_mvx2_low, *ptr_mvx2_high);
						//Half pixel Estimation
						*ptr_mv_type2 = (short) 
							Full_Search_ME(ystart, xstart + 8, ymotion+ystart, xmotion+xstart+8, 
							&xmotion, &ymotion, 8, *ptr_mvy2_low, *ptr_mvy2_high,
							*ptr_mvx2_low, *ptr_mvx2_high);
						*ptr_mv_x2 = (short) xmotion;
						*ptr_mv_y2 = (short) ymotion;
						
					}//if (_min_MAD > _thresh_no_residue>>2)
					else {
						*ptr_mv_type2 = 1;
						*ptr_mv_x2 = 0;
						*ptr_mv_y2 = 0;
					}
					fourmv_MAD += _min_MAD;
					
					//Block Two
					xcentre = 0; 
					ycentre = 0;
					xmotion = 0;
					ymotion = 0;
					_min_MAD = 65530;

					if(_independent_segment_mode)
						Distance_ME(_ISD_extrapolated_frame, ystart + 8, xstart, ystart + 8 + 16, 
							xstart + 16); 
					else					
						Distance_ME(_padded_UMV_frame, ystart + 8, xstart, ystart + 8 + 16, 
							xstart + 16); 
					
					_min_MAD = _current_MAD;
					if (_min_MAD > _thresh_no_residue>>2) {
						result = Voting_ME(i, j, &xcentre, &ycentre, 2);
						if (result == 1) Three_Step_Search_ME(xcentre, ycentre, xstart, 
							ystart+8, &xmotion, &ymotion, 8, *ptr_mvy3_low, *ptr_mvy3_high,
							*ptr_mvx3_low, *ptr_mvx3_high);
						else Four_Step_Search_ME(xcentre, ycentre, xstart, ystart+8, 
							&xmotion, &ymotion, 8, *ptr_mvy3_low, *ptr_mvy3_high,
							*ptr_mvx3_low, *ptr_mvx3_high);
						//Half pixel Estimation
						*ptr_mv_type3 = (short) 
							Full_Search_ME(ystart+8, xstart, ymotion+ystart+8, xmotion+xstart, 
							&xmotion, &ymotion, 8, *ptr_mvy3_low, *ptr_mvy3_high,
							*ptr_mvx3_low, *ptr_mvx3_high);
						*ptr_mv_x3 = (short) xmotion;
						*ptr_mv_y3 = (short) ymotion;
					}//if (_min_MAD > _thresh_no_residue>>2)
					else {
						*ptr_mv_type3 = 1;
						*ptr_mv_x3 = 0;
						*ptr_mv_y3 = 0;
					}
					fourmv_MAD += _min_MAD;
					
					//Block Three
					xcentre = 0; 
					ycentre = 0;
					xmotion = 0;
					ymotion = 0;
					_min_MAD = 65530;
					if (_independent_segment_mode)
						Distance_ME(_ISD_extrapolated_frame, ystart + 8, xstart + 8, ystart + 8 + 16,
							xstart+ 8 + 16);
					else
						Distance_ME(_padded_UMV_frame, ystart + 8, xstart + 8, ystart + 8 + 16,
							xstart+ 8 + 16); 
					_min_MAD = _current_MAD;
					if (_min_MAD > _thresh_no_residue>>2) {
						result = Voting_ME(i, j, &xcentre, &ycentre, 3);
						if (result == 1) Three_Step_Search_ME(xcentre, ycentre, xstart+8, 
							ystart+8, &xmotion, &ymotion, 8, *ptr_mvy4_low, *ptr_mvy4_high,
							*ptr_mvx4_low, *ptr_mvx4_high);
						else Four_Step_Search_ME(xcentre, ycentre, xstart+8, ystart+8, 
							&xmotion, &ymotion, 8, *ptr_mvy4_low, *ptr_mvy4_high,
							*ptr_mvx4_low, *ptr_mvx4_high);
						//Half pixel Estimation
						*ptr_mv_type4 = (short) 
							Full_Search_ME(ystart+8, xstart+8, ymotion+ystart+8, xmotion+xstart+8, 
							&xmotion, &ymotion, 8, *ptr_mvy4_low, *ptr_mvy4_high,
							*ptr_mvx4_low, *ptr_mvx4_high);
						*ptr_mv_x4 = (short) xmotion;
						*ptr_mv_y4 = (short) ymotion;
						
					}//if (_min_MAD > _thresh_no_residue>>2) 
					else {
						*ptr_mv_type4 = 1;
						*ptr_mv_x4 = 0;
						*ptr_mv_y4 = 0;
					}
					fourmv_MAD += _min_MAD;
					
					if(!(onemv_MAD - fourmv_MAD > 200)) {
						*ptr_mv_type1 = mvtype; *ptr_mv_x1 = mvx; *ptr_mv_y1 = mvy;
						*ptr_mv_type2 = mvtype; *ptr_mv_x2 = mvx; *ptr_mv_y2 = mvy;
						*ptr_mv_type3 = mvtype; *ptr_mv_x3 = mvx; *ptr_mv_y3 = mvy;
						*ptr_mv_type4 = mvtype; *ptr_mv_x4 = mvx; *ptr_mv_y4 = mvy;
					}
					
					if((*ptr_mv_type1==1)&&(*ptr_mv_type2==1)&&(*ptr_mv_type3==1)&&(*ptr_mv_type4==1))
						if((*ptr_mv_x1==0)&&(*ptr_mv_x2==0)&&(*ptr_mv_x3==0)&&(*ptr_mv_x4==0))
							if((*ptr_mv_y1==0)&&(*ptr_mv_y2==0)&&(*ptr_mv_y3==0)&&(*ptr_mv_y4==0))
								*ptr_flag_zero_mv = true;
							
							
				}//if(_min_MAD > _thresh_no_residue * 3)
						
			}//if(_advanced_prediction_mode)
			
			else {
				// Initial search at the search centre for initialization of the smalles mad stored in _min_MAD
				if (_reference_picture_selection)
					Distance_ME(_prev_frames->GetFrame(_ref_index), ystart, xstart, ystart, xstart); 
				else Distance_ME(_decoded_frame, ystart, xstart, ystart, xstart);
				_min_MAD = _current_MAD;
				
				// Check to see if the residue at the centre is already smaller than camera noise
				if (_min_MAD > _thresh_no_residue) {
					
					// Do a majority voting based on spatial correlation information in the current frame 
					// and pick one of the fast algorithms based on that
					result = Voting_ME(i, j, &xcentre, &ycentre);
					if (result == 1) Three_Step_Search_ME(xcentre, ycentre, xstart, ystart,
						&xmotion, &ymotion, 16, *ptr_mvy0_low, *ptr_mvy0_high,
						*ptr_mvx0_low, *ptr_mvx0_high);
					else Four_Step_Search_ME(xcentre, ycentre, xstart, ystart, &xmotion,
						&ymotion, 16, *ptr_mvy0_low, *ptr_mvy0_high, *ptr_mvx0_low, 
						*ptr_mvx0_high);
				}	
				else {
					// If the centre provided the best match, set the ptr_flag_zero_mv to true
					*ptr_flag_zero_mv = true;
					*ptr_mv_type1 = 1;
					*ptr_mv_x1 = 0;
					*ptr_mv_y1 = 0;
					
					if (_PB_frame_mode) {
						*ptr_mv_type2 = *ptr_mv_type1; *ptr_mv_x2 = *ptr_mv_x1; *ptr_mv_y2 = *ptr_mv_y1;
						*ptr_mv_type3 = *ptr_mv_type1; *ptr_mv_x3 = *ptr_mv_x1; *ptr_mv_y3 = *ptr_mv_y1;
						*ptr_mv_type4 = *ptr_mv_type1; *ptr_mv_x4 = *ptr_mv_x1; *ptr_mv_y4 = *ptr_mv_y1;
					}
				}
				
				
				// For each motion vector now obtained do a search around the same point in the 
				// other three sub-pixel interpolated images except if we have already decided that
				// the residue at the centre is good enough
				if (*ptr_flag_zero_mv == false) {
					
					*ptr_mv_type1 = (short) 
						Full_Search_ME(ystart, xstart, ymotion+ystart, xmotion+xstart, &xmotion,
						&ymotion, 16, *ptr_mvy0_low, *ptr_mvy0_high, *ptr_mvx0_low, 
						*ptr_mvx0_high);
					*ptr_mv_x1 = (short) xmotion;
					*ptr_mv_y1 = (short) ymotion;
					
					if (_PB_frame_mode) {
						*ptr_mv_type2 = *ptr_mv_type1; *ptr_mv_x2 = *ptr_mv_x1; *ptr_mv_y2 = *ptr_mv_y1;
						*ptr_mv_type3 = *ptr_mv_type1; *ptr_mv_x3 = *ptr_mv_x1; *ptr_mv_y3 = *ptr_mv_y1;
						*ptr_mv_type4 = *ptr_mv_type1; *ptr_mv_x4 = *ptr_mv_x1; *ptr_mv_y4 = *ptr_mv_y1;
					}
				}			
				// Even after all the searches if the best match is at the centre, set *ptr_flag_zero_mv to true
				if ((xmotion == 0) && (ymotion == 0) && (*ptr_mv_type1 == 1))
					*ptr_flag_zero_mv = true;
			}//else.... i.e. not advanced prediction mod
			
			// Increment the loop variables to be able to traverse the 2-D previously decoded frame
			if (xstart < (_frame_xsize-16)) xstart += 16;
			else {
				xstart=0;
				ystart += 16;
			}
			
			ptr_flag_zero_mv++;
			ptr_mv_type1++; ptr_mv_x1++; ptr_mv_y1++;
			ptr_mv_type2++; ptr_mv_x2++; ptr_mv_y2++;
			ptr_mv_type3++; ptr_mv_x3++; ptr_mv_y3++;
			ptr_mv_type4++; ptr_mv_x4++; ptr_mv_y4++;
			ptr_mvy0_low++; ptr_mvy0_high++;
			ptr_mvx0_low++; ptr_mvx0_high++;
			if(_advanced_prediction_mode) {
				ptr_mvy1_low++; ptr_mvy1_high++;
				ptr_mvx1_low++; ptr_mvx1_high++;
				ptr_mvy2_low++; ptr_mvy2_high++;
				ptr_mvx2_low++; ptr_mvx2_high++;
				ptr_mvy3_low++; ptr_mvy3_high++;
				ptr_mvx3_low++; ptr_mvx3_high++;
				ptr_mvy4_low++; ptr_mvy4_high++;
				ptr_mvx4_low++; ptr_mvx4_high++;
			}
			
		}	// for (j=0; j_MB_per_gob; j++) {
	}	// for (i=0; i<_GOB_per_frame; i++) {
}

#endif

