
#ifndef __D_FRAME_MISC_C__
#define __D_FRAME_MISC_C__

#include "D_Frame.h"


/*
 * void D_Frame::Set_Skip(int skip)
 * 
 * Set quantization level
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_fr_to_skip
 * Ensures:		Set _fr_to_skip
 *
 * Warning:		
 */
void D_Frame::Set_Skip(const int skip)
{
	_fr_to_skip = skip;
}


/*
 * void D_Frame::Set_PQuant(int pquant)
 * 
 * Set quantization level
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_pquant
 * Ensures:		Set _pquant and then call D_Frame::Reset_MQuant()
 *
 * Warning:		
 */
void D_Frame::Set_PQuant(const int pquant, const int dbquant)
{
	_pquant = pquant;
	_dbquant = dbquant;
	Reset_MQuant();
}


/*
 * void D_Frame::Reset_MQuant(void)
 * 
 * Set quantization level
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_mquant
 * Ensures:		Set every mquant of current frame to _pquant
 *
 * Warning:		
 */
void D_Frame::Reset_MQuant(void)
{
	int i, j, k;
	short *ptr_quant;

	ptr_quant = _mquant;
	j = (_MB_per_gob * _GOB_per_frame);
	for (i=0; i<j; i++) *ptr_quant++ = (short) _pquant;

	if (_PB_frame_mode) {

		ptr_quant = _bquant;
		k = _pquant + (((_dbquant + 1) * _pquant) >> 2);
		if (k > 31) k = 31;
		
		for (i=0; i<j; i++) *ptr_quant++ = (short) k;
	}
}


/*
 * void D_Frame::Enable_ME(void)
 * 
 * Enable motion estimation
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_ME_enabled
 * Ensures:		Set _ME_enabled to true
 *
 * Warning:		
 */
void D_Frame::Enable_ME(void)
{
	_ME_enabled = true;
}


/*
 * void D_Frame::Disable_ME(void)
 * 
 * Set quantization level
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_ME_enabled
 * Ensures:		Set _ME_enabled to false, then call D_Frame::Set_Frame_Mode_INTRA()
 *
 * Warning:		
 */
void D_Frame::Disable_ME(void)
{
	_ME_enabled = false;
	Set_Frame_Mode_INTRA();
}


#endif

