#ifndef __D_FRAME_MAKE_UMV_PADDED_FRAME_C__
#define __D_FRAME_MAKE_UMV_PADDED_FRAME_C__

#include "D_Frame.h"

void D_Frame::Make_UMV_Padded_Frame(unsigned char * source_frame) 
{
	unsigned char *ptr_padded_frame, *ptr_decoded_frame;
	int i,j, picture_size_padded, picture_size_padded_quarter;

	picture_size_padded = (_frame_xsize + 32) * (_frame_ysize + 32);
	picture_size_padded_quarter = picture_size_padded >> 2;

	//Decoded Frame
	ptr_padded_frame = _padded_UMV_frame;
	ptr_decoded_frame = source_frame;

	for(i=0;i<16;i++) {
		for(j=0;j<_frame_xsize+32;j++) {
			if(j<16)
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize + 15)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
		ptr_decoded_frame -= _frame_xsize;
	}

	//Reached the top of decoded_frame
	for(i=0;i<_frame_ysize;i++) {
		for(j=0;j<_frame_xsize+32;j++) {
			if(j<16) 
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize + 15)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
	}

	//Reached the bottom of the frame
	ptr_decoded_frame -= _frame_xsize;

	for(i=0;i<16;i++) {
		for(j=0;j<_frame_xsize+32;j++) {
			if(j<16)
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize + 15)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
		ptr_decoded_frame -= _frame_xsize;
	}

	// U Component

	ptr_padded_frame = _padded_UMV_frame + picture_size_padded;
	ptr_decoded_frame = source_frame + _picture_size;

	for(i=0;i<8;i++) {
		for(j=0;j<_frame_xsize_half+16;j++) {
			if(j<8)
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize_half + 7)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
		ptr_decoded_frame -= _frame_xsize_half;
	}

	//Reached the top of decoded_frame
	for(i=0;i<_frame_ysize_half;i++) {
		for(j=0;j<_frame_xsize_half+16;j++) {
			if(j<8) 
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize_half + 7)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
	}

	//Reached the bottom of the frame
	ptr_decoded_frame -= _frame_xsize_half;

	for(i=0;i<8;i++) {
		for(j=0;j<_frame_xsize_half+16;j++) {
			if(j<8)
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize_half + 7)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
		ptr_decoded_frame -= _frame_xsize_half;
	}

	//V component
	ptr_padded_frame = _padded_UMV_frame + picture_size_padded + picture_size_padded_quarter;
	ptr_decoded_frame = source_frame + _picture_size + _picture_size_quarter;

	for(i=0;i<8;i++) {
		for(j=0;j<_frame_xsize_half+16;j++) {
			if(j<8)
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize_half + 7)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
		ptr_decoded_frame -= _frame_xsize_half;
	}

	//Reached the top of decoded_frame
	for(i=0;i<_frame_ysize_half;i++) {
		for(j=0;j<_frame_xsize_half+16;j++) {
			if(j<8) 
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize_half + 7)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
	}

	//Reached the bottom of the frame
	ptr_decoded_frame -= _frame_xsize_half;

	for(i=0;i<8;i++) {
		for(j=0;j<_frame_xsize_half+16;j++) {
			if(j<8)
				*ptr_padded_frame++ = *ptr_decoded_frame;
			else if(j> _frame_xsize_half + 7)
				*ptr_padded_frame++ = *(ptr_decoded_frame-1);
			else
				*ptr_padded_frame++ = *ptr_decoded_frame++;
		}
		ptr_decoded_frame -= _frame_xsize_half;
	}
}


#endif