
#ifndef __D_FRAME_MAKE_OPMC_FRAME_C__
#define __D_FRAME_MAKE_OPMC_FRAME_C__

#include "D_Frame.h"


void D_Frame::Make_OPMC_Frame(bool encoder) {

	double tempx, tempy;
	int i, j, k, l, m, o, temporary;
	int dx0, dy0, dx1, dy1, dx2, dy2;
	int residuex, residuey;
	int picture_size, picture_size_quarter;
	int energy_residue, energy_block, mean, offset;				// Mode decision parameters
	int Y_frame_disp0, Y_frame_disp1, Y_frame_disp2;
	int Y_frame_left, Y_frame_right, Y_frame_top, Y_frame_bottom;
	short *ptr_mtype, a = 1;
	short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;
	short *ptr_zero_mv_type;
	unsigned char *ptr_opmc_Y_c1, *ptr_opmc_Y_c2; 
	unsigned char *ptr_prev_Y_c0, *ptr_prev_Y_c1, *ptr_prev_Y_c2;
	unsigned char *ptr_prev_Y_c_top, *ptr_prev_Y_c_bottom;
	unsigned char *ptr_prev_Y_c_left, *ptr_prev_Y_c_right;
	unsigned char *ptr_this_Y_c, temp;	// Mode decision parameters
	int frame_xsize_extrapolated, frame_xsize_extrapolated_half;
	int last_seg_ID = -1;

	//U and V components
	short t1;
	unsigned char *ptr_prev_U_c, *ptr_prev_V_c;
	unsigned char *ptr_opmc_U_c, *ptr_opmc_V_c;

	short H0[8][8] = {4,5,5,5,5,5,5,4, 5,5,5,5,5,5,5,5, 5,5,6,6,6,6,5,5,
		5,5,6,6,6,6,5,5, 5,5,6,6,6,6,5,5, 5,5,6,6,6,6,5,5, 5,5,5,5,5,5,5,5,
		4,5,5,5,5,5,5,4};
	short H1[8][8] = {2,2,2,2,2,2,2,2, 1,1,2,2,2,2,1,1, 1,1,1,1,1,1,1,1,
		1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,1,1,1,1,1,1, 1,1,2,2,2,2,1,1,
		2,2,2,2,2,2,2,2};
	short H2[8][8] = {2,1,1,1,1,1,1,2, 2,2,1,1,1,1,2,2, 2,2,1,1,1,1,2,2,
		2,2,1,1,1,1,2,2, 2,2,1,1,1,1,2,2, 2,2,1,1,1,1,2,2, 2,2,1,1,1,1,2,2,
		2,1,1,1,1,1,1,2};

/*	short H1[8][8] = {8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8,
		8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8, 8,8,8,8,8,8,8,8,
		8,8,8,8,8,8,8,8};
	short H0[8][8] = {0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0};
	short H2[8][8] = {0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0,
		0,0,0,0,0,0,0,0};
*/

	// Variables to support rps and slice
	int slicenum = 0, slicesize = 0, slicecount = 0;

	offset = 0;
	if (_PB_Ppicture_flag) offset = _PB_offset;

	ptr_prev_U_c = ptr_prev_V_c = NULL;
	// Write out the two subparts of the block simultaneously	
	ptr_opmc_Y_c1 = _shift_frame + offset;
	ptr_opmc_Y_c2 = _shift_frame + 4 + offset;
	ptr_opmc_U_c = _shift_frame + _picture_size + offset;
	ptr_opmc_V_c = _shift_frame + _picture_size + _picture_size_quarter + offset;

	// Motion Vectors
	ptr_mv_type1 = _mv_type1; ptr_mv_x1 = _mv_x1; ptr_mv_y1 = _mv_y1;
	ptr_mv_type2 = _mv_type2; ptr_mv_x2 = _mv_x2; ptr_mv_y2 = _mv_y2;
	ptr_mv_type3 = _mv_type3; ptr_mv_x3 = _mv_x3; ptr_mv_y3 = _mv_y3;
	ptr_mv_type4 = _mv_type4; ptr_mv_x4 = _mv_x4; ptr_mv_y4 = _mv_y4;
	ptr_zero_mv_type = &a;

	frame_xsize_extrapolated = _frame_xsize + 32;
	frame_xsize_extrapolated_half = frame_xsize_extrapolated >> 1;
	picture_size = frame_xsize_extrapolated * (_frame_ysize + 32);
	picture_size_quarter = picture_size >> 2;


	// Mode decision parameters
	ptr_mtype = _mtype;
	ptr_this_Y_c = _this_1D_frame + offset;

	for (i=0; i<_GOB_per_frame; i++) {
		if (_reference_picture_selection) {
			_ref_index = _trp[i];
			Make_UMV_Padded_Frame(_prev_frames->GetFrame(_ref_index));
			Subpixel_Interpolation_Module();
		}

		for (j=0; j<_MB_per_gob; j++) {
			if (_reference_picture_selection && _slice_mode) {
				if (slicecount == slicesize) {
					slicesize = _slice_size[slicenum];
					slicenum++; slicecount = 0;
					_ref_index = GetReferenceIndex();
					_trp[i] = _ref_index;
					Make_UMV_Padded_Frame(_prev_frames->GetFrame(_ref_index));
					Subpixel_Interpolation_Module();
				}
				slicecount++;
			}	

			if (_independent_segment_mode && last_seg_ID != _seg_ID[i*_MB_per_gob+j]) {
				last_seg_ID = _seg_ID[i*_MB_per_gob+j];
				short x_low, y_low, x_high, y_high;
				x_low = _x_bound_low[i*_MB_per_gob+j];
				y_low = _y_bound_low[i*_MB_per_gob+j];
				x_high = _x_bound_high[i*_MB_per_gob+j];
				y_high = _y_bound_high[i*_MB_per_gob+j];
				Make_ISD_Extrapolated_Frame(x_low, x_high, y_low, y_high);
//				Make_ISD_Extrapolated_Frame(0,175,0,143);
				Subpixel_Interpolation_Module();
			}
			
			//Block 1
			// q->block 1 same for all block 1 cases
			dx0 = ((j + 1) << 4) + *ptr_mv_x1;
			dy0 = ((i + 1) << 4) + *ptr_mv_y1;
			Y_frame_disp0 = dx0 + (dy0 * frame_xsize_extrapolated);	
			
			if (i==0) Y_frame_top = Y_frame_disp0;		//missing block
			else {
				if ((INTRA == (*(ptr_mtype - _MB_per_gob)))  && !_PB_Ppicture_flag)
					Y_frame_top = Y_frame_disp0;
				else {
					dx1 = ((j + 1) << 4) + *(ptr_mv_x3 - _MB_per_gob);
					dy1 = ((i + 1) << 4) +  *(ptr_mv_y3 - _MB_per_gob);
					Y_frame_top = dx1 + (dy1 * frame_xsize_extrapolated);	
				}
			}
			
			dx1 = ((j + 1) << 4) + *ptr_mv_x3;
			dy1 = ((i + 1) << 4) + *ptr_mv_y3 + 4;
			Y_frame_bottom = dx1 + (dy1 * frame_xsize_extrapolated);	
			
			if(j==0) //missing block
				Y_frame_left = Y_frame_disp0;
			else if(*(ptr_mtype - 1) == INTRA && !_PB_Ppicture_flag) //Intra coded block
				Y_frame_left = Y_frame_disp0;
			else {
				dx2 = ((j + 1) << 4) + *(ptr_mv_x2 - 1);
				dy2 = ((i + 1) << 4) + *(ptr_mv_y2 - 1);
				Y_frame_left = dx2 + (dy2 * frame_xsize_extrapolated);	
			}
			
			dx2 = ((j + 1) << 4) + *ptr_mv_x2 + 4;
			dy2 = ((i + 1) << 4) + *ptr_mv_y2;
			Y_frame_right = dx2 + (dy2 * frame_xsize_extrapolated);	

			if(i==0) {//missing block
				if(j==0) {//missing block 
					Help_OPMC(ptr_mv_type1, ptr_mv_type1, ptr_mv_type3,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else if(*(ptr_mtype - 1) == INTRA && !_PB_Ppicture_flag) { //Intra coded block
					Help_OPMC(ptr_mv_type1, ptr_mv_type1, ptr_mv_type3,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else {
					Help_OPMC(ptr_mv_type1, ptr_mv_type1, ptr_mv_type3,
						ptr_mv_type2-1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}

			}
			else if(*(ptr_mtype - _MB_per_gob) == INTRA && !_PB_Ppicture_flag) {//Intra
				if(j==0) {//missing block 
					Help_OPMC(ptr_mv_type1, ptr_mv_type1, ptr_mv_type3,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else if(*(ptr_mtype - 1) == INTRA && !_PB_Ppicture_flag) { //Intra coded block
					Help_OPMC(ptr_mv_type1, ptr_mv_type1, ptr_mv_type3,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else {
					Help_OPMC(ptr_mv_type1, ptr_mv_type1, ptr_mv_type3,
						ptr_mv_type2 - 1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
			}
			else {
				if(j==0) {//missing block 
					Help_OPMC(ptr_mv_type1, ptr_mv_type3 - _MB_per_gob, ptr_mv_type3,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else if(*(ptr_mtype - 1) == INTRA && !_PB_Ppicture_flag) { //Intra coded block
					Help_OPMC(ptr_mv_type1, ptr_mv_type3 - _MB_per_gob, ptr_mv_type3,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else {
					Help_OPMC(ptr_mv_type1, ptr_mv_type3 - _MB_per_gob, ptr_mv_type3,
						ptr_mv_type2 - 1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
			}
				
			ptr_prev_Y_c0 += Y_frame_disp0;
			//Block 1 Top Left Half
			
			Y_frame_disp1 = Y_frame_top;
			Y_frame_disp2 = Y_frame_left;
			ptr_prev_Y_c1 = ptr_prev_Y_c_top + Y_frame_disp1;
			ptr_prev_Y_c2 = ptr_prev_Y_c_left + Y_frame_disp2;
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k][l] + (*ptr_prev_Y_c1++) * H1[k][l]
						+ (*ptr_prev_Y_c2++) * H2[k][l] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c1++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c1 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)

			//Block 1 Top Right Half

			ptr_prev_Y_c0 -= (4 * frame_xsize_extrapolated) - 4;
			ptr_prev_Y_c1 -= (4 * frame_xsize_extrapolated) - 4;
			//ptr_prev_Y_c1 = ptr_prev_Y_c_top + Y_frame_disp1; //this remains same 
			Y_frame_disp2 = Y_frame_right;
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2;			
			
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k][l+4] + (*ptr_prev_Y_c1++) * H1[k][l+4]
						+ (*ptr_prev_Y_c2++) * H2[k][l+4] + 4) >> 3);

					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c2++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c2 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)

			//Block 1 Bottom Left Half
			ptr_prev_Y_c0 -= 4;
			//ptr_opmc_Y_c -= 4;
			Y_frame_disp1 = Y_frame_bottom;	
			Y_frame_disp2 = Y_frame_left;
			ptr_prev_Y_c1 = ptr_prev_Y_c_bottom + Y_frame_disp1;
			ptr_prev_Y_c2 = ptr_prev_Y_c_left + Y_frame_disp2 + 4 * frame_xsize_extrapolated;						
			
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k+4][l] + (*ptr_prev_Y_c1++) * H1[k+4][l]
						+ (*ptr_prev_Y_c2++) * H2[k+4][l] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c1++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c1 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)

			//Block 1 Bottom Right Half 
			ptr_prev_Y_c0 -= (4 * frame_xsize_extrapolated) - 4;
			ptr_prev_Y_c1 -= (4 * frame_xsize_extrapolated) - 4;
			//ptr_prev_Y_c1 = ptr_prev_Y_c_bottom + Y_frame_disp1;
			Y_frame_disp2 = Y_frame_right;	
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2 + 4 * frame_xsize_extrapolated;	

			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k+4][l+4] + (*ptr_prev_Y_c1++) * H1[k+4][l+4]
						+ (*ptr_prev_Y_c2++) * H2[k+4][l+4] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c2++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c2 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			
			//Block 2
			//ptr_opmc_Y_c -= (8 * frame_xsize_extrapolated) - 4;
			
			// q->block 1 same for all block 1 cases
			dx0 = ((j + 1) << 4) + 8 + *ptr_mv_x2;
			dy0 = ((i + 1) << 4) + *ptr_mv_y2;
			Y_frame_disp0 = dx0 + (dy0 * frame_xsize_extrapolated);	

			if(i==0) //missing block
				Y_frame_top = Y_frame_disp0;
			else if(*(ptr_mtype - _MB_per_gob) == INTRA && !_PB_Ppicture_flag) //Intra block
				Y_frame_top = Y_frame_disp0;
			else {
				dx1 = ((j + 1) << 4) + 8 + *(ptr_mv_x4 - _MB_per_gob);
				dy1 = ((i + 1) << 4) + *(ptr_mv_y4 - _MB_per_gob);
				Y_frame_top = dx1 + (dy1 * frame_xsize_extrapolated);	
			}
			
			dx1 = ((j + 1) << 4) + 8 + *ptr_mv_x4;
			dy1 = ((i + 1) << 4) + *ptr_mv_y4 + 4;
			Y_frame_bottom = dx1 + (dy1 * frame_xsize_extrapolated);	
			
			dx2 = ((j + 1) << 4) + 8 + *ptr_mv_x1;
			dy2 = ((i + 1) << 4) + *ptr_mv_y1;
			Y_frame_left = dx2 + (dy2 * frame_xsize_extrapolated);	

// block to right not coded so far make special case for missing block
			if(j==_MB_per_gob - 1) //missing block
				Y_frame_right = Y_frame_disp0 + 4;
			else {
				dx2 = ((j + 1) << 4) + 8 + 4;
				dy2 = ((i + 1) << 4);
				Y_frame_right = dx2 + (dy2 * frame_xsize_extrapolated);
			}


			if(i==0) {//missing block
				if(j==_MB_per_gob - 1) {
					Help_OPMC(ptr_mv_type2, ptr_mv_type2, ptr_mv_type4,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else {
					Help_OPMC(ptr_mv_type2, ptr_mv_type2, ptr_mv_type4,
						ptr_mv_type1, ptr_zero_mv_type, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
			}
			else if(*(ptr_mtype - _MB_per_gob) == INTRA && !_PB_Ppicture_flag) {//Intra block
				if(j==_MB_per_gob - 1) {
					Help_OPMC(ptr_mv_type2, ptr_mv_type2, ptr_mv_type4,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else {
					Help_OPMC(ptr_mv_type2, ptr_mv_type2, ptr_mv_type4,
						ptr_mv_type1, ptr_zero_mv_type, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
			}
			else {
				if(j==_MB_per_gob - 1) {
					Help_OPMC(ptr_mv_type2, ptr_mv_type4 - _MB_per_gob, ptr_mv_type4,
						ptr_mv_type1, ptr_mv_type2, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
						&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
				else {
				Help_OPMC(ptr_mv_type2, ptr_mv_type4 - _MB_per_gob, ptr_mv_type4,
					ptr_mv_type1, ptr_zero_mv_type, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
					&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
				}
			}
			
			ptr_prev_Y_c0 += Y_frame_disp0;

			//Block 2 Top Left Half
			
			Y_frame_disp1 = Y_frame_top;
			Y_frame_disp2 = Y_frame_left;
			ptr_prev_Y_c1 = ptr_prev_Y_c_top + Y_frame_disp1;
			ptr_prev_Y_c2 = ptr_prev_Y_c_left + Y_frame_disp2;

			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k][l] + (*ptr_prev_Y_c1++) * H1[k][l]
						+ (*ptr_prev_Y_c2++) * H2[k][l] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c1++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c1 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			
			//Block 1 Top Right Half
			ptr_prev_Y_c0 -= (4 * frame_xsize_extrapolated) - 4;
			ptr_prev_Y_c1 -= (4 * frame_xsize_extrapolated) - 4;
			Y_frame_disp2 = Y_frame_right;	
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2;			
			//ptr_prev_Y_c1 = ptr_prev_Y_c_top + Y_frame_disp1; //this remains same 
			
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k][l+4] + (*ptr_prev_Y_c1++) * H1[k][l+4]
						+ (*ptr_prev_Y_c2++) * H2[k][l+4] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c2++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++) 
				ptr_opmc_Y_c2 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			//Block 1 Bottom Left Half
			ptr_prev_Y_c0 -= 4;
			Y_frame_disp1 = Y_frame_bottom;	
			Y_frame_disp2 = Y_frame_left;
			ptr_prev_Y_c1 = ptr_prev_Y_c_bottom + Y_frame_disp1;
			ptr_prev_Y_c2 = ptr_prev_Y_c_left + Y_frame_disp2 + 4 * frame_xsize_extrapolated;						
			
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k+4][l] + (*ptr_prev_Y_c1++) * H1[k+4][l]
						+ (*ptr_prev_Y_c2++) * H2[k+4][l] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c1++ = (unsigned char) temporary; 
				}//for(l=0;l<4;l++) 
				ptr_opmc_Y_c1 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)

			//Block 1 Bottom Right Half 
			ptr_prev_Y_c0 -= (4 * frame_xsize_extrapolated) - 4;
			ptr_prev_Y_c1 -= (4 * frame_xsize_extrapolated) - 4;
			Y_frame_disp2 = Y_frame_right;	
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2 + 4 * frame_xsize_extrapolated;	
			//ptr_prev_Y_c1 = ptr_prev_Y_c_bottom + Y_frame_disp1;//remains same

			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary =  (((*ptr_prev_Y_c0++) * H0[k+4][l+4] + (*ptr_prev_Y_c1++) * H1[k+4][l+4]
						+ (*ptr_prev_Y_c2++) * H2[k+4][l+4] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c2++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c2 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			
			//Block 3
			//ptr_opmc_Y_c -= 12;
			
			// q->block 2 same for all block 2 cases
			dx0 = ((j + 1) << 4) + *ptr_mv_x3;
			dy0 = ((i + 1) << 4) + 8 + *ptr_mv_y3;
			Y_frame_disp0 = dx0 + (dy0 * frame_xsize_extrapolated);	
			
			dx1 = ((j + 1) << 4) + *ptr_mv_x1;
			dy1 = ((i + 1) << 4) + 8 + *ptr_mv_y1;
			Y_frame_top = dx1 + (dy1 * frame_xsize_extrapolated);	
			
			Y_frame_bottom = Y_frame_disp0 + 4 * frame_xsize_extrapolated; //because block below is not coded
			
			if(j==0) //missing block
				Y_frame_left = Y_frame_disp0;
			else if(*(ptr_mtype - 1) == INTRA && !_PB_Ppicture_flag) // Intra block
				Y_frame_left = Y_frame_disp0;
			else {
				dx2 = ((j + 1) << 4) + *(ptr_mv_x4 - 1);
				dy2 = ((i + 1) << 4) + 8 + *(ptr_mv_y4 - 1);
				Y_frame_left = dx2 + (dy2 * frame_xsize_extrapolated);	
			}
			
			dx2 = ((j + 1) << 4) + *ptr_mv_x4 + 4;
			dy2 = ((i + 1) << 4) + 8 + *ptr_mv_y4;
			Y_frame_right = dx2 + (dy2 * frame_xsize_extrapolated);	
			
			
			if(j==0) {//missing block
				Help_OPMC(ptr_mv_type3, ptr_mv_type1, ptr_mv_type3,
					ptr_mv_type3, ptr_mv_type4, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
					&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
			}
			else if(*(ptr_mtype - 1) == INTRA && !_PB_Ppicture_flag) { // Intra block
				Help_OPMC(ptr_mv_type3, ptr_mv_type1, ptr_mv_type3,
					ptr_mv_type3, ptr_mv_type4, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
					&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
			}
			else {
				Help_OPMC(ptr_mv_type3, ptr_mv_type1, ptr_mv_type3,
					ptr_mv_type4 - 1, ptr_mv_type4, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
					&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
			}
			
			
			ptr_prev_Y_c0 += Y_frame_disp0;

			//Block 2 Top Left Half
			
			Y_frame_disp1 = Y_frame_top;
			Y_frame_disp2 = Y_frame_left;
			ptr_prev_Y_c1 = ptr_prev_Y_c_top + Y_frame_disp1;
			ptr_prev_Y_c2 = ptr_prev_Y_c_left + Y_frame_disp2;

			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k][l] + (*ptr_prev_Y_c1++) * H1[k][l]
						+ (*ptr_prev_Y_c2++) * H2[k][l] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c1++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c1 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			
			//Block 2 Top Right Half
			ptr_prev_Y_c0 -= (4 * frame_xsize_extrapolated) - 4;
			ptr_prev_Y_c1 -= (4 * frame_xsize_extrapolated) - 4;
			Y_frame_disp2 = Y_frame_right;	
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2;			
			//ptr_prev_Y_c1 = ptr_prev_Y_c_top + Y_frame_disp1; //this remains same 
			
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k][l+4] + (*ptr_prev_Y_c1++) * H1[k][l+4]
						+ (*ptr_prev_Y_c2++) * H2[k][l+4] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c2++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c2 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			//Block 2 Bottom Left Half
			ptr_prev_Y_c0 -= 4;
			Y_frame_disp1 = Y_frame_bottom;	
			Y_frame_disp2 = Y_frame_left;
			ptr_prev_Y_c1 = ptr_prev_Y_c_bottom + Y_frame_disp1;
			ptr_prev_Y_c2 = ptr_prev_Y_c_left + Y_frame_disp2 + 4 * frame_xsize_extrapolated;						
			
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k+4][l] + (*ptr_prev_Y_c1++) * H1[k+4][l]
						+ (*ptr_prev_Y_c2++) * H2[k+4][l] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c1++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c1 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++) 
			
			//Block 2 Bottom Right Half 
			ptr_prev_Y_c0 -= (4 * frame_xsize_extrapolated) - 4;
			ptr_prev_Y_c1 -= (4 * frame_xsize_extrapolated) - 4;
			Y_frame_disp2 = Y_frame_right;	
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2 + 4 * frame_xsize_extrapolated;	
			//ptr_prev_Y_c1 = ptr_prev_Y_c_bottom + Y_frame_disp1; //remains the same

			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k+4][l+4] + (*ptr_prev_Y_c1++) * H1[k+4][l+4]
						+ (*ptr_prev_Y_c2++) * H2[k+4][l+4] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c2++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c2 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++) 
			
			
			//Block 3
			
			// q->block 3 same for all block 3 cases
			dx0 = ((j + 1) << 4) + 8 + *ptr_mv_x4;
			dy0 = ((i + 1) << 4) + 8 + *ptr_mv_y4;
			Y_frame_disp0 = dx0 + (dy0 * frame_xsize_extrapolated);	
			
			dx1 = ((j + 1) << 4) + 8 + *ptr_mv_x2;
			dy1 = ((i + 1) << 4) + 8 + *ptr_mv_y2;
			Y_frame_top = dx1 + (dy1 * frame_xsize_extrapolated);	

			Y_frame_bottom = Y_frame_disp0 + 4 * frame_xsize_extrapolated; // not coded yet
			
			dx2 = ((j + 1) << 4) + 8 + *ptr_mv_x3;
			dy2 = ((i + 1) << 4) + 8 + *ptr_mv_y3;
			Y_frame_left = dx2 + (dy2 * frame_xsize_extrapolated);	
			
			// not coded yet. use 0 motion vectors make special case for missing block
			if(j==_MB_per_gob - 1) //missing block
				Y_frame_right = Y_frame_disp0 + 4;
			else {
				dx2 = ((j + 1) << 4) + 8 + 4;
				dy2 = ((i + 1) << 4) + 8;
				Y_frame_right = dx2 + (dy2 * frame_xsize_extrapolated);	
			}
			
			if(j==_MB_per_gob - 1) {
				Help_OPMC(ptr_mv_type4, ptr_mv_type2, ptr_mv_type4,
					ptr_mv_type3, ptr_mv_type4, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
					&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
			}
			else {
				Help_OPMC(ptr_mv_type4, ptr_mv_type2, ptr_mv_type4,
					ptr_mv_type3, ptr_zero_mv_type, &ptr_prev_Y_c0, &ptr_prev_Y_c_top,
					&ptr_prev_Y_c_bottom, &ptr_prev_Y_c_left, &ptr_prev_Y_c_right);
			}
			
			
			ptr_prev_Y_c0 += Y_frame_disp0;

			//Block 3 Top Left Half
			
			Y_frame_disp1 = Y_frame_top;
			Y_frame_disp2 = Y_frame_left;
			ptr_prev_Y_c1 = ptr_prev_Y_c_top + Y_frame_disp1;
			ptr_prev_Y_c2 = ptr_prev_Y_c_left + Y_frame_disp2;

			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k][l] + (*ptr_prev_Y_c1++) * H1[k][l]
						+ (*ptr_prev_Y_c2++) * H2[k][l] + 4) >> 3);
					if(temporary>255) temporary = 255;	
					*ptr_opmc_Y_c1++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c1 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			
			//Block 3 Top Right Half
			ptr_prev_Y_c0 -= (4 * frame_xsize_extrapolated) - 4;
			ptr_prev_Y_c1 -= (4 * frame_xsize_extrapolated) - 4;
			Y_frame_disp2 = Y_frame_right;	
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2;			
			//ptr_prev_Y_c1 = ptr_prev_Y_c_top + Y_frame_disp1; //this remains same 
			
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k][l+4] + (*ptr_prev_Y_c1++) * H1[k][l+4]
						+ (*ptr_prev_Y_c2++) * H2[k][l+4] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c2++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c2 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			//Block 3 Bottom Left Half
			ptr_prev_Y_c0 -= 4;
			Y_frame_disp1 = Y_frame_bottom;	
			Y_frame_disp2 = Y_frame_left;
			ptr_prev_Y_c1 = ptr_prev_Y_c_bottom + Y_frame_disp1;
			ptr_prev_Y_c2 = ptr_prev_Y_c_left + Y_frame_disp2 + 4 * frame_xsize_extrapolated;						
			
			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k+4][l] + (*ptr_prev_Y_c1++) * H1[k+4][l]
						+ (*ptr_prev_Y_c2++) * H2[k+4][l] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c1++ = (unsigned char) temporary; 
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c1 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)
			
			//Block 3 Bottom Right Half 
			Y_frame_disp2 = Y_frame_right;	
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2;	

			ptr_prev_Y_c0 -= (4 * frame_xsize_extrapolated) - 4;
			ptr_prev_Y_c1 -= (4 * frame_xsize_extrapolated) - 4;
			Y_frame_disp2 = Y_frame_right;	
			ptr_prev_Y_c2 = ptr_prev_Y_c_right + Y_frame_disp2 + 4 * frame_xsize_extrapolated;	
			//ptr_prev_Y_c1 = ptr_prev_Y_c_bottom + Y_frame_disp1;

			for(k=0;k<4;k++) {
				for(l=0;l<4;l++) {
					temporary = (((*ptr_prev_Y_c0++) * H0[k+4][l+4] + (*ptr_prev_Y_c1++) * H1[k+4][l+4]
						+ (*ptr_prev_Y_c2++) * H2[k+4][l+4] + 4) >> 3);
					if(temporary>255) temporary = 255;
					*ptr_opmc_Y_c2++ = (unsigned char) temporary;
				}//for(l=0;l<4;l++)
				ptr_opmc_Y_c2 += 4;
				ptr_prev_Y_c0 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c1 += frame_xsize_extrapolated - 4;
				ptr_prev_Y_c2 += frame_xsize_extrapolated - 4;
			}//for(k=0;k<4;k++)


			// Mode decision for the macroblock just plugged in
			
			if(encoder) {
				ptr_opmc_Y_c1 -= 256; // go back to beginning of the macroblock
				
				mean = 0;
				energy_block = 0;
				energy_residue = 0;
				for (m=0; m<256; m++) mean += *ptr_this_Y_c++;
				for (m=0, mean/=256, ptr_this_Y_c-=256; m<256; m++) {
					temp = *ptr_this_Y_c++;
					energy_block += abs(temp - mean);
					energy_residue += abs(temp - *ptr_opmc_Y_c1++);
				}
				
				if (energy_residue - energy_block > _thresh_large){
					*ptr_mtype = INTRA;
					*ptr_mv_type1 = 1; *ptr_mv_x1 = 0; *ptr_mv_y1 = 0;
					*ptr_mv_type2 = 1; *ptr_mv_x2 = 0; *ptr_mv_y2 = 0;
					*ptr_mv_type3 = 1; *ptr_mv_x3 = 0; *ptr_mv_y3 = 0;
					*ptr_mv_type4 = 1; *ptr_mv_x4 = 0; *ptr_mv_y4 = 0;
				}
				else {
					if(*ptr_mv_type1 == *ptr_mv_type2 && *ptr_mv_type1 == *ptr_mv_type3
					&&*ptr_mv_type1 == *ptr_mv_type4 && *ptr_mv_x1 == *ptr_mv_x2 
					&& *ptr_mv_x1 == *ptr_mv_x3 && *ptr_mv_x1 == *ptr_mv_x4
					&& *ptr_mv_y1 == *ptr_mv_y2 && *ptr_mv_y1 == *ptr_mv_y3
					&& *ptr_mv_y1 == *ptr_mv_y4)
						*ptr_mtype = INTER;
					else
						*ptr_mtype = INTER4V;
				}
			}

			
			//U and V components
			tempx  = (float) (*ptr_mv_x1 + ((*ptr_mv_type1 + 1) % 2) * 0.5);
			tempx += (float) (*ptr_mv_x2 + ((*ptr_mv_type2 + 1) % 2) * 0.5);
			tempx += (float) (*ptr_mv_x3 + ((*ptr_mv_type3 + 1) % 2) * 0.5);
			tempx += (float) (*ptr_mv_x4 + ((*ptr_mv_type4 + 1) % 2) * 0.5);
			
			tempy  = (float) (*ptr_mv_y1 + ((*ptr_mv_type1 - 1) >> 1) * 0.5);
			tempy += (float) (*ptr_mv_y2 + ((*ptr_mv_type2 - 1) >> 1) * 0.5);
			tempy += (float) (*ptr_mv_y3 + ((*ptr_mv_type3 - 1) >> 1) * 0.5);
			tempy += (float) (*ptr_mv_y4 + ((*ptr_mv_type4 - 1) >> 1) * 0.5);
			
			residuex = (int)(2 * tempx) % 16;
			residuey = (int)(2 * tempy) % 16;
			
			tempx /= 8;
			tempy /= 8;
			
			// Table F.1 implemented below. Check efficiency !
			t1 = 1;
			if (residuex >= 0) {
				if (residuex <= 2) tempx = floor(tempx);
				else if(residuex >= 14) tempx = ceil(tempx);
				else {
					tempx = floor(tempx);
					t1 = 2;
				}
			}
			else {
				if (residuex >= -2) tempx = ceil(tempx);
				else if (residuex <= -14) tempx = floor(tempx);
				else {
					tempx = floor(tempx);
					t1 = 2;
				}
			}
			
			if (residuey >= 0) {
				if(residuey <= 2) tempy = floor(tempy);
				else if (residuey >= 14) tempy = ceil(tempy);
				else {
					tempy = floor(tempy);
					t1 += 2;
				}
			}
			else {
				if (residuey >= -2) tempy = ceil(tempy);
				else if (residuey <= -14) tempy = floor(tempy);
				else {
					tempy = floor(tempy);
					t1 += 2;
				}
			}
			
			o = ((int) tempx) + ((int) tempy) * frame_xsize_extrapolated_half;
			//o += (j+1) << 3 + ((i+1) << 3) * frame_xsize_extrapolated_half;
			o += (j+1)*8 + (i+1)*8*frame_xsize_extrapolated_half;
			/*if(_fr_num == 1 && i == 0 && j == 0) {
				fprintf(stdout,"mvx %d mvy %d mvtype %d %d %d\n",(int)tempx, (int)tempy, t1, o, frame_xsize_extrapolated_half);
				fprintf(stdout,"Result %d %d\n", (j+1)*8 + (i+1)*8*frame_xsize_extrapolated_half, o);
				fprintf(stdout,"%d %d \n",picture_size, picture_size_quarter);
			}*/

			
			switch (t1) {			
			case 1:
				if (_independent_segment_mode) {
					ptr_prev_U_c = _ISD_extrapolated_frame + picture_size;
					ptr_prev_V_c = _ISD_extrapolated_frame + picture_size + picture_size_quarter;
				} else {
					ptr_prev_U_c = _padded_UMV_frame + picture_size;
					ptr_prev_V_c = _padded_UMV_frame + picture_size + picture_size_quarter;
				}
				break;
			case 2:
				if (_independent_segment_mode) {
					ptr_prev_U_c = _ISD_extrapolated_frame_half_full + picture_size;
					ptr_prev_V_c = _ISD_extrapolated_frame_half_full + picture_size + picture_size_quarter;
				} else {
					ptr_prev_U_c = _padded_UMV_frame_half_full + picture_size;
					ptr_prev_V_c = _padded_UMV_frame_half_full + picture_size + picture_size_quarter;
				}
				break;
			case 3:
				if (_independent_segment_mode) {
					ptr_prev_U_c = _ISD_extrapolated_frame_full_half + picture_size;
					ptr_prev_V_c = _ISD_extrapolated_frame_full_half + picture_size + picture_size_quarter;
				} else {
					ptr_prev_U_c = _padded_UMV_frame_full_half + picture_size;
					ptr_prev_V_c = _padded_UMV_frame_full_half + picture_size + picture_size_quarter;
				}
				break;
			case 4:
				if (_independent_segment_mode) {
					ptr_prev_U_c = _ISD_extrapolated_frame_half_half + picture_size;
					ptr_prev_V_c = _ISD_extrapolated_frame_half_half + picture_size + picture_size_quarter;
				} else {
					ptr_prev_U_c = _padded_UMV_frame_half_half + picture_size;
					ptr_prev_V_c = _padded_UMV_frame_half_half + picture_size + picture_size_quarter;
				}
				break;
			default:
				exit(-1);
			}
			ptr_prev_U_c += o;
			ptr_prev_V_c += o;
			
			for (l=0; l<8; l++) {
				for (m=0; m<8; m++) {
					*ptr_opmc_U_c++ = *ptr_prev_U_c++;
					*ptr_opmc_V_c++ = *ptr_prev_V_c++;
				}
				ptr_prev_U_c += (frame_xsize_extrapolated_half - 8);
				ptr_prev_V_c += (frame_xsize_extrapolated_half - 8);
			}

			// Increment all pointers
			ptr_mtype++;
			ptr_mv_type1++; ptr_mv_x1++; ptr_mv_y1++;
			ptr_mv_type2++; ptr_mv_x2++; ptr_mv_y2++;
			ptr_mv_type3++; ptr_mv_x3++; ptr_mv_y3++;
			ptr_mv_type4++; ptr_mv_x4++; ptr_mv_y4++;
		}//for (j=0; j<_MB_per_gob; j++)
	}//for (i=0; i<_GOB_per_frame; i++)	
	
}


void D_Frame::Help_OPMC(short *type0, short *typetop, short *typebottom, 
						short *typeleft, short *typeright, unsigned char **res0, 
						unsigned char **restop, unsigned char **resbottom, 
						unsigned char **resleft, unsigned char **resright) {

	
	switch (*type0) {
	case 1:
		if (_independent_segment_mode) *res0 = _ISD_extrapolated_frame;
		else *res0 = _padded_UMV_frame;
		break;
	case 2:
		if (_independent_segment_mode) *res0 = _ISD_extrapolated_frame_half_full;
		else *res0 = _padded_UMV_frame_half_full;
		break;
	case 3:
		if (_independent_segment_mode) *res0 = _ISD_extrapolated_frame_full_half;
		else *res0 = _padded_UMV_frame_full_half;
		break;
	case 4:
		if (_independent_segment_mode) *res0 = _ISD_extrapolated_frame_half_half;
		else *res0 = _padded_UMV_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid MVTYPE\n");
		exit(-1);
	}
	
	switch (*typetop) {
	case 1:
		if (_independent_segment_mode) *restop = _ISD_extrapolated_frame;
		else *restop = _padded_UMV_frame;
		break;
	case 2:
		if (_independent_segment_mode) *restop = _ISD_extrapolated_frame_half_full;
		else *restop = _padded_UMV_frame_half_full;
		break;
	case 3:
		if (_independent_segment_mode) *restop = _ISD_extrapolated_frame_full_half;
		else *restop = _padded_UMV_frame_full_half;
		break;
	case 4:
		if (_independent_segment_mode) *restop = _ISD_extrapolated_frame_half_half;
		else *restop = _padded_UMV_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid MVTYPE\n");
		exit(-1);
	}
	
	switch (*typebottom) {
	case 1:
		if (_independent_segment_mode) *resbottom = _ISD_extrapolated_frame;
		else *resbottom = _padded_UMV_frame;
		break;
	case 2:
		if (_independent_segment_mode) *resbottom = _ISD_extrapolated_frame_half_full;
		else *resbottom = _padded_UMV_frame_half_full;
		break;
	case 3:
		if (_independent_segment_mode) *resbottom = _ISD_extrapolated_frame_full_half;
		else *resbottom = _padded_UMV_frame_full_half;
		break;
	case 4:
		if (_independent_segment_mode) *resbottom = _ISD_extrapolated_frame_half_half;
		else *resbottom = _padded_UMV_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid MVTYPE\n");
		exit(-1);
	}
	
	switch (*typeleft) {
	case 1:
		if (_independent_segment_mode) *resleft = _ISD_extrapolated_frame;
		else *resleft = _padded_UMV_frame;
		break;
	case 2:
		if (_independent_segment_mode) *resleft = _ISD_extrapolated_frame_half_full;
		else *resleft = _padded_UMV_frame_half_full;
		break;
	case 3:
		if (_independent_segment_mode) *resleft = _ISD_extrapolated_frame_full_half;
		else *resleft = _padded_UMV_frame_full_half;
		break;
	case 4:
		if (_independent_segment_mode) *resleft = _ISD_extrapolated_frame_half_half;
		else *resleft = _padded_UMV_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid MVTYPE\n");
		exit(-1);
	}
	
	
	switch (*typeright) {
	case 1:
		if (_independent_segment_mode) *resright = _ISD_extrapolated_frame;
		else *resright = _padded_UMV_frame;
		break;
	case 2:
		if (_independent_segment_mode) *resright = _ISD_extrapolated_frame_half_full;
		else *resright = _padded_UMV_frame_half_full;
		break;
	case 3:
		if (_independent_segment_mode) *resright = _ISD_extrapolated_frame_full_half;
		else *resright = _padded_UMV_frame_full_half;
		break;
	case 4:
		if (_independent_segment_mode) *resright = _ISD_extrapolated_frame_half_half;
		else *resright = _padded_UMV_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid MVTYPE\n");
		exit(-1);
	}
}


#endif

