#ifndef __D_FRAME_MAKE_ISD_EXTRAPOLATED_FRAME_C__
#define __D_FRAME_MAKE_ISD_EXTRAPOLATED_FRAME_C__

#include "D_Frame.h"


/*
 * void D_Frame::Make_ISD_Extrapolated_Frame(int x_low, int x_high, int y_low, int y_high)
 *
 * Generate padded/extrapolated frame used to form prediction when isd and apm are both enabled
 *
 * Requires: _decoded_frame, _frame_xsize, _frame_ysize
 *
 * Modifies: _ISD_extrapolated_frame
 *
 *
 * Ensures:  
 */

void D_Frame::Make_ISD_Extrapolated_Frame(short x_low, short x_high, short y_low, short y_high)
{
	unsigned char	*ptr_ISD_extrapolated_frame;
	
	unsigned char   *ptr_decoded_frame;

	int picture_size_padded = (_frame_xsize + 32) * (_frame_ysize + 32);
	int picture_size_padded_quarter = picture_size_padded >> 2;
	
	int	i,j;
	short segment_ysize, segment_xsize;
	short segment_ysize_half, segment_xsize_half;
	short abs_x_low, abs_x_high, abs_y_low, abs_y_high;
	short x_low_half, x_high_half, y_low_half, y_high_half;
	short abs_x_low_half, abs_x_high_half, abs_y_low_half, abs_y_high_half;

	int extrap=0, dec=0;

	x_low_half  = (short) (x_low >> 1);
	x_high_half = (short) (x_high >> 1);
	y_low_half  = (short) (y_low >> 1);
	y_high_half = (short) (y_high >> 1);
		
	abs_x_low = (short) (x_low + 16); abs_x_high = (short) (x_high + 16);
	abs_y_low = (short) (y_low + 16); abs_y_high = (short) (y_high + 16);
	abs_x_low_half  = (short) (abs_x_low >> 1);
	abs_y_low_half  = (short) (abs_y_low >> 1);
	abs_x_high_half = (short) (abs_x_high >> 1);
	abs_y_high_half = (short) (abs_y_high >> 1);
	segment_ysize_half = (short) (y_high_half - y_low_half + 1);
	segment_xsize_half = (short) (x_high_half - x_low_half + 1);

	segment_ysize = (short) (y_high - y_low + 1);
	segment_xsize = (short) (x_high - x_low + 1);

	ptr_ISD_extrapolated_frame = _ISD_extrapolated_frame;

	ptr_decoded_frame = _decoded_frame + (y_low * _frame_xsize) + x_low;

	//top
	for(j=0;j<abs_y_low;j++) {
		for(i=0;i<_frame_xsize+32;i++) {
			if(i<abs_x_low) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			}
			else if(i>abs_x_high) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			}
			else
			{
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
		ptr_decoded_frame -= segment_xsize;
		dec -= segment_xsize;
	}

	ptr_ISD_extrapolated_frame = _ISD_extrapolated_frame + (_frame_xsize + 32) * (abs_y_low);
	ptr_decoded_frame = _decoded_frame + (y_low * _frame_xsize) + x_low;

	for(j=0;j<segment_ysize;j++) {
		for(i=0;i<_frame_xsize+32;i++) {
			if(i<abs_x_low) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			} else if(i>abs_x_high) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			} else {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
		ptr_decoded_frame += _frame_xsize - segment_xsize;
		dec += _frame_xsize - segment_xsize;
	}

	ptr_ISD_extrapolated_frame = _ISD_extrapolated_frame + (abs_y_high + 1) * (_frame_xsize + 32);
	ptr_decoded_frame = _decoded_frame + (y_high * _frame_xsize) + x_low;

	for(j=0;j<_frame_ysize + 32 - abs_y_low - segment_ysize;j++) {
		for(i=0;i<_frame_xsize+32;i++) {
			if(i<abs_x_low) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			} else if(i>abs_x_high) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			} else {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
		ptr_decoded_frame -= segment_xsize;
		dec -= segment_xsize;
	}

	//U Component
	ptr_ISD_extrapolated_frame = _ISD_extrapolated_frame + picture_size_padded;

	ptr_decoded_frame = _decoded_frame + _picture_size + (y_low_half * _frame_xsize_half) + x_low_half;

	for (j=0;j<abs_y_low_half;j++) {
		for (i=0;i<_frame_xsize_half+16;i++) {
			if (i < abs_x_low_half) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			} else if (i > abs_x_high_half) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			} else {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
		ptr_decoded_frame -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
		dec -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
	}

	for (j=0;j<segment_ysize_half;j++) {
		for (i=0;i<_frame_xsize_half+16;i++) {
			if (i < abs_x_low_half) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			} else if (i > abs_x_high_half) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			} else{
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
	}

	ptr_decoded_frame -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
	dec -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;

	for (j=0;j<_frame_ysize_half + 16 - (abs_y_low_half) - segment_ysize_half;j++) {
		for (i=0;i<_frame_xsize_half+16;i++) {
			if (i < abs_x_low_half) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			} else if (i > abs_x_high_half) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			} else {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
		ptr_decoded_frame -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
		dec -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
	}

	//V component
	ptr_ISD_extrapolated_frame = _ISD_extrapolated_frame + picture_size_padded + picture_size_padded_quarter;

	ptr_decoded_frame = _decoded_frame + _picture_size + _picture_size_quarter + (y_low_half * _frame_xsize_half) + x_low_half;

	for (j=0;j<abs_y_low>>1;j++) {
		for (i=0;i<_frame_xsize_half+16;i++) {
			if (i < abs_x_low_half) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			} else if (i > abs_x_high_half) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			} else {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
		ptr_decoded_frame -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
		dec -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
	}

	for (j=0;j<segment_ysize_half;j++) {
		for (i=0;i<_frame_xsize_half+16;i++) {
			if (i < abs_x_low_half) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			} else if (i > abs_x_high_half) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			} else{
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
	}

	ptr_decoded_frame -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
	dec -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;

	for (j=0;j<_frame_ysize_half + 16 - (abs_y_low_half) - segment_ysize_half;j++) {
		for (i=0;i<_frame_xsize_half+16;i++) {
			if (i < abs_x_low_half) {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame;
				extrap++;
			} else if (i > abs_x_high_half) {
				*ptr_ISD_extrapolated_frame++ = *(ptr_decoded_frame-1);
				extrap++;
			} else {
				*ptr_ISD_extrapolated_frame++ = *ptr_decoded_frame++;
				extrap++;
				dec++;
			}
		}
		ptr_decoded_frame -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
		dec -= (abs_x_high >> 1) - (abs_x_low >> 1) + 1;
	}
}

#endif
