
#ifndef __D_FRAME_INTERPOLATE_BPICTURE_MOTION_VECTORS_C__
#define __D_FRAME_INTERPOLATE_BPICTURE_MOTION_VECTORS_C__

#include "D_Frame.h"


/*
 * void D_Frame::Interpolate_Bpicture_Motion_Vectors(void)
 * 
 * Calculate forward and backward motion vectors for B-picture
 * This is a private method
 *
 * Requires:	P-picture is first coded to be used as a prediction frame
 * Modifies:	_shift_frame
 * Ensures:		Create prediction frame, based on motion vectors produced for the current frame
 *
 * Warning:		
 */
void D_Frame::Interpolate_Bpicture_Motion_Vectors(void)
{
	double x0, x1, x2, x3, y0, y1, y2, y3;
	double dx, dy, ddx, ddy;
	double tx0, tx1, tx2, tx3, ty0, ty1, ty2, ty3;
	double bd, cd;
	double tempxf, tempxb, tempyf, tempyb;
	int i, j, k, m, p, q;

	// 4 motion vectors from the P picture
	short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;

	// Delta motion vector
	short *ptr_mvd_type, *ptr_mvd_x, *ptr_mvd_y;

	// forward and backward motion vectors
	short *ptr_mv_type1_f, *ptr_mv_x1_f, *ptr_mv_y1_f;
	short *ptr_mv_type1_b, *ptr_mv_x1_b, *ptr_mv_y1_b;	
	short *ptr_mv_type2_f, *ptr_mv_x2_f, *ptr_mv_y2_f;
	short *ptr_mv_type2_b, *ptr_mv_x2_b, *ptr_mv_y2_b;	
	short *ptr_mv_type3_f, *ptr_mv_x3_f, *ptr_mv_y3_f;
	short *ptr_mv_type3_b, *ptr_mv_x3_b, *ptr_mv_y3_b;	
	short *ptr_mv_type4_f, *ptr_mv_x4_f, *ptr_mv_y4_f;
	short *ptr_mv_type4_b, *ptr_mv_x4_b, *ptr_mv_y4_b;	

	// Chrominance forward and backward motion vectors
	short *ptr_mv_type_uv_f, *ptr_mv_uvx_f, *ptr_mv_uvy_f;	
	short *ptr_mv_type_uv_b, *ptr_mv_uvx_b, *ptr_mv_uvy_b;	

	// Source motion vectors
	ptr_mv_type1 = _mv_type1; ptr_mv_x1 = _mv_x1; ptr_mv_y1 = _mv_y1;
	ptr_mv_type2 = _mv_type2; ptr_mv_x2 = _mv_x2; ptr_mv_y2 = _mv_y2;
	ptr_mv_type3 = _mv_type3; ptr_mv_x3 = _mv_x3; ptr_mv_y3 = _mv_y3;
	ptr_mv_type4 = _mv_type4; ptr_mv_x4 = _mv_x4; ptr_mv_y4 = _mv_y4;

	// Delta motion vector
	ptr_mvd_type = _mvd_type; ptr_mvd_x = _mvd_x; ptr_mvd_y = _mvd_y;

	// Forward motion vectors
	ptr_mv_type1_f = _mv_type1_f; ptr_mv_x1_f = _mv_x1_f; ptr_mv_y1_f = _mv_y1_f;
	ptr_mv_type2_f = _mv_type2_f; ptr_mv_x2_f = _mv_x2_f; ptr_mv_y2_f = _mv_y2_f;
	ptr_mv_type3_f = _mv_type3_f; ptr_mv_x3_f = _mv_x3_f; ptr_mv_y3_f = _mv_y3_f;
	ptr_mv_type4_f = _mv_type4_f; ptr_mv_x4_f = _mv_x4_f; ptr_mv_y4_f = _mv_y4_f;

	// Backward motion vectors
	ptr_mv_type1_b = _mv_type1_b; ptr_mv_x1_b = _mv_x1_b; ptr_mv_y1_b = _mv_y1_b;
	ptr_mv_type2_b = _mv_type2_b; ptr_mv_x2_b = _mv_x2_b; ptr_mv_y2_b = _mv_y2_b;
	ptr_mv_type3_b = _mv_type3_b; ptr_mv_x3_b = _mv_x3_b; ptr_mv_y3_b = _mv_y3_b;
	ptr_mv_type4_b = _mv_type4_b; ptr_mv_x4_b = _mv_x4_b; ptr_mv_y4_b = _mv_y4_b;
	
	// Chrominance motion vectors: Forward/Backward
	ptr_mv_type_uv_f = _mv_type_uv_f; ptr_mv_uvx_f = _mv_uvx_f; ptr_mv_uvy_f = _mv_uvy_f;	
	ptr_mv_type_uv_b = _mv_type_uv_b; ptr_mv_uvx_b = _mv_uvx_b; ptr_mv_uvy_b = _mv_uvy_b;	


	bd = _trb / _trd;
	cd = (_trb - _trd) / _trd;

	if (_coded_mvd_flag) {	// _mvd is in use by the encoder

		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {

				// Compute delta motion vector
				dx = *ptr_mvd_x; k = 1; ddx = 0;		// X info
				dy = *ptr_mvd_y; m = 0; ddy = 0;		// Y info

				if ((*ptr_mvd_type & 1) == 0) {
					dx += 0.5;
					ddx = -0.5;
					k = 2;
				}

				if (*ptr_mvd_type > 2) {
					dy += 0.5;
					ddy = -0.5;
					m = 2;
				}
			
				// Compute P picture motion vectors
				x0 = *ptr_mv_x1; y0 = *ptr_mv_y1;
				x1 = *ptr_mv_x2; y1 = *ptr_mv_y2;
				x2 = *ptr_mv_x3; y2 = *ptr_mv_y3;
				x3 = *ptr_mv_x4; y3 = *ptr_mv_y4;

				if ((*ptr_mv_type1 & 1) == 0) x0 += 0.5;
				if ((*ptr_mv_type2 & 1) == 0) x1 += 0.5;
				if ((*ptr_mv_type3 & 1) == 0) x2 += 0.5;
				if ((*ptr_mv_type4 & 1) == 0) x3 += 0.5;

				if (*ptr_mv_type1 > 2) y0 += 0.5;
				if (*ptr_mv_type2 > 2) y1 += 0.5;
				if (*ptr_mv_type3 > 2) y2 += 0.5;
				if (*ptr_mv_type4 > 2) y3 += 0.5;
				

				// Compute X forward motion vectors
				if (dx == 0) {		// delta MV is 0

					*ptr_mv_x1_f = (short) (bd * x0);
					*ptr_mv_x2_f = (short) (bd * x1);
					*ptr_mv_x3_f = (short) (bd * x2);
					*ptr_mv_x4_f = (short) (bd * x3);
					*ptr_mv_type1_f = 1;
					*ptr_mv_type2_f = 1;
					*ptr_mv_type3_f = 1;
					*ptr_mv_type4_f = 1;

					*ptr_mv_x1_b = (short) (cd * x0);
					*ptr_mv_x2_b = (short) (cd * x1);
					*ptr_mv_x3_b = (short) (cd * x2);
					*ptr_mv_x4_b = (short) (cd * x3);
					*ptr_mv_type1_b = 1;
					*ptr_mv_type2_b = 1;
					*ptr_mv_type3_b = 1;
					*ptr_mv_type4_b = 1;

					tempxf = *ptr_mv_x1_f + *ptr_mv_x2_f + *ptr_mv_x3_f + *ptr_mv_x4_f;
					tempxb = *ptr_mv_x1_b + *ptr_mv_x2_b + *ptr_mv_x3_b + *ptr_mv_x4_b;

				}
				else {				// delta MV is not 0

					// Forward Motion Vector
					tx0 = ((short) (bd * x0)) + dx;
					tx1 = ((short) (bd * x1)) + dx;
					tx2 = ((short) (bd * x2)) + dx;
					tx3 = ((short) (bd * x3)) + dx;
					tempxf = tx0 + tx1 + tx2 + tx3;

					// Processing to store into internal storage architecture -> Forward MV
					*ptr_mv_x1_f = (short) (tx0 + ddx);
					*ptr_mv_x2_f = (short) (tx1 + ddx);
					*ptr_mv_x3_f = (short) (tx2 + ddx);
					*ptr_mv_x4_f = (short) (tx3 + ddx);

					*ptr_mv_type1_f = (short) k;
					*ptr_mv_type2_f = (short) k;
					*ptr_mv_type3_f = (short) k;
					*ptr_mv_type4_f = (short) k;

					// Backward Motion Vector
					tx0 = tx0 - x0;
					tx1 = tx1 - x1;
					tx2 = tx2 - x2;
					tx3 = tx3 - x3;
					tempxb = tx0 + tx1 + tx2 + tx3;

					// Processing to store into internal storage architecture -> Backward MV
					if (((int) tx0) != tx0) {
						*ptr_mv_x1_b = (short) (tx0 - 0.5);
						*ptr_mv_type1_b = 2;
					}
					else {
						*ptr_mv_x1_b = (short) tx0;
						*ptr_mv_type1_b = 1;
					}

					if (((int) tx1) != tx1) {
						*ptr_mv_x2_b = (short) (tx1 - 0.5);
						*ptr_mv_type2_b = 2;
					}
					else {
						*ptr_mv_x2_b = (short) tx1;
						*ptr_mv_type2_b = 1;
					}

					if (((int) tx2) != tx2) {
						*ptr_mv_x3_b = (short) (tx2 - 0.5);
						*ptr_mv_type3_b = 2;
					}
					else {
						*ptr_mv_x3_b = (short) tx2;
						*ptr_mv_type3_b = 1;
					}

					if (((int) tx3) != tx3) {
						*ptr_mv_x4_b = (short) (tx3 - 0.5);
						*ptr_mv_type4_b = 2;
					}
					else {
						*ptr_mv_x4_b = (short) tx3;
						*ptr_mv_type4_b = 1;
					}
				}	// else {				// delta MV is not 0


				// Compute Y forward motion vectors
				if (dy == 0) {		// motion vector type does not need to change
					
					*ptr_mv_y1_f = (short) (bd * y0);
					*ptr_mv_y2_f = (short) (bd * y1);
					*ptr_mv_y3_f = (short) (bd * y2);
					*ptr_mv_y4_f = (short) (bd * y3);
					*ptr_mv_y1_b = (short) (cd * y0);
					*ptr_mv_y2_b = (short) (cd * y1);
					*ptr_mv_y3_b = (short) (cd * y2);
					*ptr_mv_y4_b = (short) (cd * y3);

					tempyf = *ptr_mv_y1_f + *ptr_mv_y2_f + *ptr_mv_y3_f + *ptr_mv_y4_f;
					tempyb = *ptr_mv_y1_b + *ptr_mv_y2_b + *ptr_mv_y3_b + *ptr_mv_y4_b;
				}
				else {
					
					// Forward Motion Vector
					ty0 = ((short)(bd * y0)) + dy;
					ty1 = ((short)(bd * y1)) + dy;
					ty2 = ((short)(bd * y2)) + dy;
					ty3 = ((short)(bd * y3)) + dy;
					tempyf = ty0 + ty1 + ty2 + ty3;

					// Processing to store into internal storage architecture -> Forward MV
					*ptr_mv_y1_f = (short)(ty0 + ddy);
					*ptr_mv_y2_f = (short)(ty1 + ddy);
					*ptr_mv_y3_f = (short)(ty2 + ddy);
					*ptr_mv_y4_f = (short)(ty3 + ddy);

					*ptr_mv_type1_f = (short) (*ptr_mv_type1_f + m);
					*ptr_mv_type2_f = (short) (*ptr_mv_type2_f + m);
					*ptr_mv_type3_f = (short) (*ptr_mv_type3_f + m);
					*ptr_mv_type4_f = (short) (*ptr_mv_type4_f + m);

					// Backward motion vector
					ty0 = ty0 - y0;
					ty1 = ty1 - y1;
					ty2 = ty2 - y2;
					ty3 = ty3 - y3;
					tempyb = ty0 + ty1 + ty2 + ty3;

					// Processing to store into internal storage architecture
					if (((int) ty0) != ty0) {
						*ptr_mv_y1_b = (short) (ty0 - 0.5);
						*ptr_mv_type1_b += 2;
					}
					else *ptr_mv_y1_b = (short) ty0;

					if (((int) ty1) != ty1) {
						*ptr_mv_y2_b = (short) (ty1 - 0.5);
						*ptr_mv_type2_b += 2;
					}
					else *ptr_mv_y2_b = (short) ty1;

					if (((int) ty2) != ty2) {
						*ptr_mv_y3_b = (short) (ty2 - 0.5);
						*ptr_mv_type3_b += 2;
					}
					else *ptr_mv_y3_b = (short) ty2;

					if (((int) ty3) != ty3) {
						*ptr_mv_y4_b = (short) (ty3 - 0.5);
						*ptr_mv_type4_b += 2;
					}
					else *ptr_mv_y4_b = (short) ty3;
				}
				// Completed Y forward/backward motion vectors computation


				// UV motion vectors
				// Apply Table F.1 to obtain correct values
				k = ((int) (2 * tempxf)) % 16;
				m = ((int) (2 * tempyf)) % 16;
				p = ((int) (2 * tempxb)) % 16;
				q = ((int) (2 * tempyb)) % 16;
				
				tempxf /= 8;
				tempyf /= 8;
				tempxb /= 8;
				tempyb /= 8;

				// Process UV forward motion vector
				if (tempxf >=0) {
					if (k <= 2) {
						*ptr_mv_type_uv_f = 1;
						*ptr_mv_uvx_f = (short) floor(tempxf);
					}
					else if (k >= 14) {
						*ptr_mv_type_uv_f = 1;
						*ptr_mv_uvx_f = (short) ceil(tempxf);
					}
					else {
						*ptr_mv_type_uv_f = 2;
						*ptr_mv_uvx_f = (short) floor(tempxf);
					}
				}
				else {
					if (k >= -2) {
						*ptr_mv_type_uv_f = 1;
						*ptr_mv_uvx_f = (short) ceil(tempxf);
					}
					else if (k <= -14) {
						*ptr_mv_type_uv_f = 1;
						*ptr_mv_uvx_f = (short) floor(tempxf);
					}
					else {
						*ptr_mv_type_uv_f = 2;
						*ptr_mv_uvx_f = (short) floor(tempxf);
					}
				}

				if (tempyf >=0) {
					if (m <= 2) *ptr_mv_uvy_f = (short) floor(tempyf);
					else if (m >= 14) *ptr_mv_uvy_f = (short) ceil(tempyf);
					else {
						*ptr_mv_type_uv_f += 2;
						*ptr_mv_uvy_f = (short) floor(tempyf);
					}
				}
				else {
					if (m >= -2) *ptr_mv_uvy_f = (short) ceil(tempyf);
					else if (m <= -14) *ptr_mv_uvy_f = (short) floor(tempyf);
					else {
						*ptr_mv_type_uv_f += 2;
						*ptr_mv_uvy_f = (short) floor(tempyf);
					}
				}

				// Process UV backward motion vector
				if (tempxb >=0) {
					if (p <= 2) {
						*ptr_mv_type_uv_b = 1;
						*ptr_mv_uvx_b = (short) floor(tempxb);
					}
					else if (p >= 14) {
						*ptr_mv_type_uv_b = 1;
						*ptr_mv_uvx_b = (short) ceil(tempxb);
					}
					else {
						*ptr_mv_type_uv_b = 2;
						*ptr_mv_uvx_b = (short) floor(tempxb);
					}
				}
				else {
					if (p >= -2) {
						*ptr_mv_type_uv_b = 1;
						*ptr_mv_uvx_b = (short) ceil(tempxb);
					}
					else if (p <= -14) {
						*ptr_mv_type_uv_b = 1;
						*ptr_mv_uvx_b = (short) floor(tempxb);
					}
					else {
						*ptr_mv_type_uv_b = 2;
						*ptr_mv_uvx_b = (short) floor(tempxb);
					}
				}

				if (tempyb >=0) {
					if (q <= 2) *ptr_mv_uvy_b = (short) floor(tempyb);
					else if (q >= 14) *ptr_mv_uvy_b = (short) ceil(tempyb);
					else {
						*ptr_mv_type_uv_b += 2;
						*ptr_mv_uvy_b = (short) floor(tempyb);
					}
				}
				else {
					if (q >= -2) *ptr_mv_uvy_b = (short) ceil(tempyb);
					else if (q <= -14) *ptr_mv_uvy_b = (short) floor(tempyb);
					else {
						*ptr_mv_type_uv_b += 2;
						*ptr_mv_uvy_b = (short) floor(tempyb);
					}
				}


				// Massive pointer increments				
				ptr_mvd_type++; ptr_mvd_x++; ptr_mvd_y++;
				
				// 4 motion vectors from the P picture
				ptr_mv_type1++; ptr_mv_x1++; ptr_mv_y1++;
				ptr_mv_type2++; ptr_mv_x2++; ptr_mv_y2++;
				ptr_mv_type3++; ptr_mv_x3++; ptr_mv_y3++;
				ptr_mv_type4++; ptr_mv_x4++; ptr_mv_y4++;

				// Forward and Backward motion vectors
				ptr_mv_type1_f++; ptr_mv_x1_f++; ptr_mv_y1_f++;
				ptr_mv_type1_b++; ptr_mv_x1_b++; ptr_mv_y1_b++;	
				ptr_mv_type2_f++; ptr_mv_x2_f++; ptr_mv_y2_f++;
				ptr_mv_type2_b++; ptr_mv_x2_b++; ptr_mv_y2_b++;	
				ptr_mv_type3_f++; ptr_mv_x3_f++; ptr_mv_y3_f++;
				ptr_mv_type3_b++; ptr_mv_x3_b++; ptr_mv_y3_b++;	
				ptr_mv_type4_f++; ptr_mv_x4_f++; ptr_mv_y4_f++;
				ptr_mv_type4_b++; ptr_mv_x4_b++; ptr_mv_y4_b++;	
				ptr_mv_type_uv_f++; ptr_mv_uvx_f++; ptr_mv_uvy_f++;
				ptr_mv_type_uv_b++; ptr_mv_uvx_b++; ptr_mv_uvy_b++;
				

			} // for (j=0; j<_MB_per_gob; j++) {
		} // for (i=0; i<_GOB_per_frame; i++) {

		
	} //if (_coded_mvd_flag) {	// _mvd is in use by the encoder
	else {						// _mvd is all 0
		
		for (i=0; i<_GOB_per_frame; i++) {
			for (j=0; j<_MB_per_gob; j++) {
				
				x0 = *ptr_mv_x1;
				x1 = *ptr_mv_x2;
				x2 = *ptr_mv_x3;
				x3 = *ptr_mv_x4;
				y0 = *ptr_mv_y1;
				y1 = *ptr_mv_y2;
				y2 = *ptr_mv_y3;
				y3 = *ptr_mv_y4;
				
				
				// Examine the type to derive corect values
				if ((*ptr_mv_type1 & 1) == 0) x0 += 0.5;
				if ((*ptr_mv_type2 & 1) == 0) x1 += 0.5;
				if ((*ptr_mv_type3 & 1) == 0) x2 += 0.5;
				if ((*ptr_mv_type4 & 1) == 0) x3 += 0.5;
				
				if (*ptr_mv_type1 > 2) y0 += 0.5;
				if (*ptr_mv_type2 > 2) y1 += 0.5;
				if (*ptr_mv_type3 > 2) y2 += 0.5;
				if (*ptr_mv_type4 > 2) y3 += 0.5;
				
				// Newly derived are all type 1, integer motion vectors
				*ptr_mv_type1_f = 1;
				*ptr_mv_type1_b = 1;
				*ptr_mv_type2_f = 1;
				*ptr_mv_type2_b = 1;
				*ptr_mv_type3_f = 1;
				*ptr_mv_type3_b = 1;
				*ptr_mv_type4_f = 1;
				*ptr_mv_type4_b = 1;
				
				*ptr_mv_x1_f = (short) (bd * x0);
				*ptr_mv_x2_f = (short) (bd * x1);
				*ptr_mv_x3_f = (short) (bd * x2);
				*ptr_mv_x4_f = (short) (bd * x3);
				
				*ptr_mv_x1_b = (short) (cd * x0);
				*ptr_mv_x2_b = (short) (cd * x1);
				*ptr_mv_x3_b = (short) (cd * x2);
				*ptr_mv_x4_b = (short) (cd * x3);
				
				*ptr_mv_y1_f = (short) (bd * y0);
				*ptr_mv_y2_f = (short) (bd * y1);
				*ptr_mv_y3_f = (short) (bd * y2);
				*ptr_mv_y4_f = (short) (bd * y3);
				
				*ptr_mv_y1_b = (short) (cd * y0);
				*ptr_mv_y2_b = (short) (cd * y1);
				*ptr_mv_y3_b = (short) (cd * y2);
				*ptr_mv_y4_b = (short) (cd * y3);
				
				
				// UV motion vectors
				// Apply Table F.1 to obtain correct values
				tempxf = *ptr_mv_x1_f + *ptr_mv_x2_f + *ptr_mv_x3_f + *ptr_mv_x4_f;
				tempxb = *ptr_mv_x1_b + *ptr_mv_x2_b + *ptr_mv_x3_b + *ptr_mv_x4_b;
				tempyf = *ptr_mv_y1_f + *ptr_mv_y2_f + *ptr_mv_y3_f + *ptr_mv_y4_f;
				tempyb = *ptr_mv_y1_b + *ptr_mv_y2_b + *ptr_mv_y3_b + *ptr_mv_y4_b;

				k = ((int) (2 * tempxf)) % 16;
				m = ((int) (2 * tempyf)) % 16;
				p = ((int) (2 * tempxb)) % 16;
				q = ((int) (2 * tempyb)) % 16;
				
				tempxf /= 8;
				tempyf /= 8;
				tempxb /= 8;
				tempyb /= 8;
				
				// Process UV forward motion vector
				if (tempxf >= 0) {
					if (k <= 2) {
						*ptr_mv_type_uv_f = 1;
						*ptr_mv_uvx_f = (short) floor(tempxf);
					}
					else if (k >= 14) {
						*ptr_mv_type_uv_f = 1;
						*ptr_mv_uvx_f = (short) ceil(tempxf);
					}
					else {
						*ptr_mv_type_uv_f = 2;
						*ptr_mv_uvx_f = (short) floor(tempxf);
					}
				}
				else {
					if (k >= -2) {
						*ptr_mv_type_uv_f = 1;
						*ptr_mv_uvx_f = (short) ceil(tempxf);
					}
					else if (k <= -14) {
						*ptr_mv_type_uv_f = 1;
						*ptr_mv_uvx_f = (short) floor(tempxf);
					}
					else {
						*ptr_mv_type_uv_f = 2;
						*ptr_mv_uvx_f = (short) floor(tempxf);
					}
				}
				
				if (tempyf >= 0) {
					if (m <= 2) *ptr_mv_uvy_f = (short) floor(tempyf);
					else if (m >= 14) *ptr_mv_uvy_f = (short) ceil(tempyf);
					else {
						*ptr_mv_type_uv_f += 2;
						*ptr_mv_uvy_f = (short) floor(tempyf);
					}
				}
				else {
					if (m >= -2) *ptr_mv_uvy_f = (short) ceil(tempyf);
					else if (m <= -14) *ptr_mv_uvy_f = (short) floor(tempyf);
					else {
						*ptr_mv_type_uv_f += 2;
						*ptr_mv_uvy_f = (short) floor(tempyf);
					}
				}
				
				// Process UV backward motion vector
				if (tempxb >=0) {
					if (p <= 2) {
						*ptr_mv_type_uv_b = 1;
						*ptr_mv_uvx_b = (short) floor(tempxb);
					}
					else if (p >= 14) {
						*ptr_mv_type_uv_b = 1;
						*ptr_mv_uvx_b = (short) ceil(tempxb);
					}
					else {
						*ptr_mv_type_uv_b = 2;
						*ptr_mv_uvx_b = (short) floor(tempxb);
					}
				}
				else {
					if (p >= -2) {
						*ptr_mv_type_uv_b = 1;
						*ptr_mv_uvx_b = (short) ceil(tempxb);
					}
					else if (p <= -14) {
						*ptr_mv_type_uv_b = 1;
						*ptr_mv_uvx_b = (short) floor(tempxb);
					}
					else {
						*ptr_mv_type_uv_b = 2;
						*ptr_mv_uvx_b = (short) floor(tempxb);
					}
				}
				
				if (tempyb >=0) {
					if (q <= 2) *ptr_mv_uvy_b = (short) floor(tempyb);
					else if (q >= 14) *ptr_mv_uvy_b = (short) ceil(tempyb);
					else {
						*ptr_mv_type_uv_b += 2;
						*ptr_mv_uvy_b = (short) floor(tempyb);
					}
				}
				else {
					if (q >= -2) *ptr_mv_uvy_b = (short) ceil(tempyb);
					else if (q <= -14) *ptr_mv_uvy_b = (short) floor(tempyb);
					else {
						*ptr_mv_type_uv_b += 2;
						*ptr_mv_uvy_b = (short) floor(tempyb);
					}
				}

				
				// 4 motion vectors from the P picture
				ptr_mv_type1++; ptr_mv_x1++; ptr_mv_y1++;
				ptr_mv_type2++; ptr_mv_x2++; ptr_mv_y2++;
				ptr_mv_type3++; ptr_mv_x3++; ptr_mv_y3++;
				ptr_mv_type4++; ptr_mv_x4++; ptr_mv_y4++;

				// Forward and Backward motion vectors
				ptr_mv_type1_f++; ptr_mv_x1_f++; ptr_mv_y1_f++;
				ptr_mv_type1_b++; ptr_mv_x1_b++; ptr_mv_y1_b++;	
				ptr_mv_type2_f++; ptr_mv_x2_f++; ptr_mv_y2_f++;
				ptr_mv_type2_b++; ptr_mv_x2_b++; ptr_mv_y2_b++;	
				ptr_mv_type3_f++; ptr_mv_x3_f++; ptr_mv_y3_f++;
				ptr_mv_type3_b++; ptr_mv_x3_b++; ptr_mv_y3_b++;	
				ptr_mv_type4_f++; ptr_mv_x4_f++; ptr_mv_y4_f++;
				ptr_mv_type4_b++; ptr_mv_x4_b++; ptr_mv_y4_b++;	
				ptr_mv_type_uv_f++; ptr_mv_uvx_f++; ptr_mv_uvy_f++;
				ptr_mv_type_uv_b++; ptr_mv_uvx_b++; ptr_mv_uvy_b++;
				
			}	// for (j=0; j<_MB_per_gob; j++) {
		}	// for (i=0; i<_GOB_per_frame; i++) {

	}	// else {					// _mvd is all 0
	
}


#endif

