
#ifndef __D_FRAME_FULL_SEARCH_ME_C__
#define __D_FRAME_FULL_SEARCH_ME_C__

#include "D_Frame.h"


/*
 * int D_Frame::Full_Search_ME(int ysn, int xsn, int yso, int xso, int *xmot, int *ymot)
 * 
 *
 * This is a private method
 *
 * Requires:	current best match position in _decoded_frame (yso, xso)
 * Modifies:	_mv_x1, _mv_y1, _mv_type1
 * Ensures:		A search around the best match in _decoded frame is performed on
 *					_decoded_frame_half_full, _decoded_frame_full_half, _decoded_half_half
 *					_mv_x1, and _mv_y1 updated if a better match is found. _mv_x1 and _mv_y1 are modified
 *
 * Warning:		
 */
int D_Frame::Full_Search_ME(int ysn, int xsn, int yso, int xso, int *xmot, 
							int *ymot, int blocksize, int ylow, int yhigh,
							int xlow, int xhigh)
{
	int p, q, which_frame, xtemp, ytemp;
	
	/* Do the search as following. 
	For _decoded_frame_half_full, look at only the left 2 points
	For _decoded_frame_full_half, look at only the top 2 points
	For _decoded_frame_full_full, look at only the top left top 4 points */
	
	p = blocksize;		// no meaning, just to get rid of compiler warning
	which_frame = 1;
	xtemp = xso;
	ytemp = yso;

	/*Search the left two pixels in _decoded_frame_half_full*/

	for (q=-1; q<=0; q++) {
		
		if ( ((xso + q) >= xlow) && ((xso + q) < xhigh) ) {
			if(_advanced_prediction_mode) {
				if (_independent_segment_mode)
					Distance_ME(_ISD_extrapolated_frame_half_full, ysn, xsn, yso+16, xso+q+16);
				else
					Distance_ME(_padded_UMV_frame_half_full, ysn, xsn, yso+16, xso+q+16);
			} 
			else {
				if (_reference_picture_selection)
					Distance_ME(_prev_half_full->GetFrame(_ref_index), ysn, xsn, yso, xso+q);
				else
					Distance_ME(_decoded_frame_half_full, ysn, xsn, yso, xso+q);
			}
			if ( (_current_MAD < _min_MAD) && ((xso + q - xsn) < 16) && ((xso + q - xsn) > -17) )  {
				which_frame = 2;
				_min_MAD = _current_MAD;
				ytemp = yso;
				xtemp = xso + q;
			}
		}
	}

	/* Search the upper two pixels in _decoded_frame_full_half */

	for (p=-1; p<=0; p++) {
		if ( ((yso + p) >= ylow) && ((yso + p) < yhigh) ) {
			if(_advanced_prediction_mode) {
				if (_independent_segment_mode)
					Distance_ME(_ISD_extrapolated_frame_full_half, ysn, xsn, yso+16, xso+q+16);
				else
					Distance_ME(_padded_UMV_frame_full_half, ysn, xsn, yso+p+16, xso+16);
			} 
			else {
				if (_reference_picture_selection)
					Distance_ME(_prev_full_half->GetFrame(_ref_index), ysn, xsn, yso+p, xso);
				else
					Distance_ME(_decoded_frame_full_half, ysn, xsn, yso+p, xso);
			}
			if ( (_current_MAD < _min_MAD) && ((yso + p - ysn) < 16) && 
				((yso + p - ysn) > -17) ) {
				which_frame = 3;
				_min_MAD = _current_MAD;
				ytemp = yso + p;
				xtemp = xso;
			}
		}
	}

	/* Search four pixels around the centre for _decoded_frame_half_half */

	for (p=-1; p<=0; p++) {
		for (q=-1; q<=0; q++) {

			if ( ((yso + p) >= ylow) && ((yso + p) < yhigh) && ((xso + q) >= xlow) &&
				((xso + q) < xhigh)) {

				if(_advanced_prediction_mode) {
					if (_independent_segment_mode) 
						Distance_ME(_ISD_extrapolated_frame_half_half, ysn, xsn, yso+16, xso+q+16);
					else
						Distance_ME(_padded_UMV_frame_half_half, ysn, xsn, yso+p+16, xso+q+16);
				} 
				else {
					if (_reference_picture_selection)
						Distance_ME(_decoded_frame_half_half, ysn, xsn, yso+p, xso);					
					else
						Distance_ME(_decoded_frame_half_half, ysn, xsn, yso+p, xso+q);
				}
				if ( (_current_MAD < _min_MAD) && ((yso + p - ysn) < 16) && ((yso + p - ysn) > -17) &&
					((xso + q - xsn) < 16) && ((xso + q - xsn) > -17) ) {
					
					which_frame = 4;
					_min_MAD = _current_MAD;
					ytemp = yso + p;
					xtemp = xso + q;
				}
			}

		} // for (q=-1; q<=0; q++)
	} // for (p=-1; p<=0; p++)


	// Assign the motion vector values to the best match
	*xmot = xtemp - xsn;
	*ymot = ytemp - ysn;

	return which_frame;
}


#endif

