
#ifndef __D_FRAME_FOUR_STEP_SEARCH_ME_C__
#define __D_FRAME_FOUR_STEP_SEARCH_ME_C__

#include "D_Frame.h"


/*
 * void D_Frame::Four_Step_Search_ME(int x1, int y1, int x2, int y2, int *x3, int *y3)
 * 
 * Compute the sum of absolute pixel difference of 2 macroblocks
 * This is a private method
 *
 * Requires:	position of the macroblock in current frame and previous frame
 * Modifies:	_min_MAD, _mv_x1, _mv_y1
 * Ensures:		This does the 4 step search to find the best match for the current macroblock
 *				** This function calls D_Frame::Distance_ME() to calculate MAD
 *
 * Warning:		
 */
void D_Frame::Four_Step_Search_ME(int x1, int y1, int x2, int y2, int *x3, int *y3, 
								  int blocksize, int ylow, int yhigh, int xlow,
								  int xhigh)
{
	int xcentre, ycentre, ystart, xstart, stepsize;
	int loop, no_of_times, up_or_down, left_or_right;
	int near_endx, near_endy;
	int temp2, temp3;
	int dx, dy, ymotion, xmotion;
	
	xcentre = x1;
	ycentre = y1;
	ystart = y2;
	xstart = x2;

	xmotion = 0;
	ymotion = 0;
	up_or_down = 0;
	left_or_right = 0;

	stepsize = 2;
	no_of_times = 9;

	dx = -1 * stepsize;
	dy = -1 * stepsize;

	
	while (stepsize > 0) {
		for (loop=0; loop<no_of_times; loop++) {
		
			if ( ((ystart + dy + ycentre) >= ylow) && ((ystart + dy + ycentre) <= yhigh) &&
				 ((xstart + dx + xcentre) >= xlow) && ((xstart + dx + xcentre) <= xhigh) &&
				 ((dx != 0 ) || (dy != 0)) ) {
				
				if(_advanced_prediction_mode) {
					if (_independent_segment_mode)
						Distance_ME(_ISD_extrapolated_frame, ystart, xstart, 
						(ystart + dy + ycentre), (xstart + dx + xcentre) );
					else
						Distance_ME(_padded_UMV_frame, ystart, xstart, 
						(ystart + dy + ycentre + 16), (xstart + dx + xcentre + 16));
				} 
				else {
					if (_reference_picture_selection)
						Distance_ME(_prev_frames->GetFrame(_ref_index), ystart, xstart, 
						(ystart + dy + ycentre), (xstart + dx + xcentre));
					else
						Distance_ME(_decoded_frame, ystart, xstart, 
						(ystart + dy + ycentre), (xstart + dx + xcentre));
				} 

				if (_current_MAD < _min_MAD) {

					ymotion = dy + ycentre;
					xmotion = dx + xcentre;
					_min_MAD = _current_MAD;

					if (_min_MAD < _thresh_no_residue*blocksize*blocksize/256) {
						*x3 = xmotion;
						*y3 = ymotion;
						return;
					}
				}
				else if (_current_MAD == _min_MAD) {
					temp2 = xmotion * xmotion + ymotion * ymotion;
					temp3 = (dx + xcentre) * (dx + xcentre) + (dy + ycentre) * (dy + ycentre);

					if (temp3 < temp2) {
						ymotion = dy + ycentre;
						xmotion = dx + xcentre;
						_min_MAD = _current_MAD;
					}
				}
				
			}

			if (no_of_times == 9) {
				if (dx <= 0) dx += stepsize;
				else {
					dx = -1 * stepsize;
					dy += stepsize;
				}
			}
			else if (no_of_times == 3) {
				if (up_or_down!=0) dx = (2 * stepsize * loop) - stepsize;
				else dy = (2 * stepsize * loop) - stepsize;
			}
			else {
				if (loop < 3) dx = dx - left_or_right;
				else {
					dx = left_or_right;
					dy = dy - up_or_down;
				}
			}
		} // for (loop=0; loop<no_of_times; loop++) 
		
		left_or_right = xmotion - xcentre;
		up_or_down = ymotion - ycentre;
		dx = left_or_right;
		dy = up_or_down;
		
		xcentre = xmotion; 
		ycentre = ymotion;

		if (stepsize == 1) stepsize >>= 1;
		near_endx = 16 - abs(xcentre);
		near_endy = 16 - abs(ycentre);

		if ( (near_endx < stepsize) || (near_endy < stepsize) ) {
			left_or_right=0;
			up_or_down=0;
		}

		no_of_times = 5;
		if ( (left_or_right == 0) && (up_or_down == 0) ) {
			no_of_times = 9;
			stepsize >>= 1;
			dx = -1 * stepsize;
			dy = -1 * stepsize;
		}
		else if ( (left_or_right == 0) || (up_or_down == 0) ) {
			no_of_times = 3;
		}
		
	} // while (stepsize > 0)

	*x3 = xmotion;
	*y3 = ymotion;
}


#endif

