#ifndef __D_FRAME_ESTIMATE_DELTA_MV_C__
#define __D_FRAME_ESTIMATE_DELTA_MV_C__

#include "D_Frame.h"




void D_Frame::Estimate_Delta_mv(void) {
	
	double x0, x1, x2, x3, y0, y1, y2, y3;
	double dx, dy, ddx, ddy;
	double tx0, tx1, tx2, tx3, ty0, ty1, ty2, ty3;
	double bd, cd;
	double tempxf, tempxb, tempyf, tempyb;
	int i, j, k, m;
	//int p,q;
	int min_MAD, current_MAD = 0;
	
	// 4 motion vectors from the P picture
	short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;
	
	// Delta motion vector
	short *ptr_mvd_type, *ptr_mvd_x, *ptr_mvd_y;
	short up_or_down, left_or_right, stepsize, no_of_times;
/*	
	// forward and backward motion vectors
	short *ptr_mv_type1_f, *ptr_mv_x1_f, *ptr_mv_y1_f;
	short *ptr_mv_type1_b, *ptr_mv_x1_b, *ptr_mv_y1_b;	
	short *ptr_mv_type2_f, *ptr_mv_x2_f, *ptr_mv_y2_f;
	short *ptr_mv_type2_b, *ptr_mv_x2_b, *ptr_mv_y2_b;	
	short *ptr_mv_type3_f, *ptr_mv_x3_f, *ptr_mv_y3_f;
	short *ptr_mv_type3_b, *ptr_mv_x3_b, *ptr_mv_y3_b;	
	short *ptr_mv_type4_f, *ptr_mv_x4_f, *ptr_mv_y4_f;
	short *ptr_mv_type4_b, *ptr_mv_x4_b, *ptr_mv_y4_b;	
	short *ptr_mv_type_uv_f,*ptr_mv_uvx_f, *ptr_mv_uvy_f;
	short *ptr_mv_type_uv_b, *ptr_mv_uvx_b, *ptr_mv_uvy_b;
	
	//temporary storage variables
	short best_mv_type1_f=1, best_mv_x1_f=0, best_mv_y1_f=0;
	short best_mv_type1_b=1, best_mv_x1_b=0, best_mv_y1_b=0;	
	short best_mv_type2_f=1, best_mv_x2_f=0, best_mv_y2_f=0;
	short best_mv_type2_b=1, best_mv_x2_b=0, best_mv_y2_b=0;	
	short best_mv_type3_f=1, best_mv_x3_f=0, best_mv_y3_f=0;
	short best_mv_type3_b=1, best_mv_x3_b=0, best_mv_y3_b=0;	
	short best_mv_type4_f=1, best_mv_x4_f=0, best_mv_y4_f=0;
	short best_mv_type4_b=1, best_mv_x4_b=0, best_mv_y4_b=0;	
	short best_mv_type_uv_f=1, best_mv_uvx_f=0, best_mv_uvy_f=0;
	short best_mv_type_uv_b=1, best_mv_uvx_b=0, best_mv_uvy_b=0;

*/	
	short mv_type1_f, mv_x1_f, mv_y1_f;
	short mv_type1_b, mv_x1_b, mv_y1_b;	
	short mv_type2_f, mv_x2_f, mv_y2_f;
	short mv_type2_b, mv_x2_b, mv_y2_b;	
	short mv_type3_f, mv_x3_f, mv_y3_f;
	short mv_type3_b, mv_x3_b, mv_y3_b;	
	short mv_type4_f, mv_x4_f, mv_y4_f;
	short mv_type4_b, mv_x4_b, mv_y4_b;	
/*	short mv_type_uv_f, mv_uvx_f, mv_uvy_f;
	short mv_type_uv_b, mv_uvx_b, mv_uvy_b;
*/	
	short best_mvd_x = 0, best_mvd_y = 0, best_mvd_type = 1;
	short delta_mv_x, delta_mv_y;
	
	//Four Step Search parameters
	
	int dx0, dy0, xcentre, ycentre, xmotion, ymotion;
	int loop, near_endx, near_endy;
	
	
	
	// Source motion vectors
	ptr_mv_type1 = _mv_type1; ptr_mv_x1 = _mv_x1; ptr_mv_y1 = _mv_y1;
	ptr_mv_type2 = _mv_type2; ptr_mv_x2 = _mv_x2; ptr_mv_y2 = _mv_y2;
	ptr_mv_type3 = _mv_type3; ptr_mv_x3 = _mv_x3; ptr_mv_y3 = _mv_y3;
	ptr_mv_type4 = _mv_type4; ptr_mv_x4 = _mv_x4; ptr_mv_y4 = _mv_y4;
	
	// Delta motion vector to be estimated
	ptr_mvd_type = _mvd_type; ptr_mvd_x = _mvd_x; ptr_mvd_y = _mvd_y;
	
/*	
	// Forward motion vectors
	ptr_mv_type1_f = _mv_type1_f; ptr_mv_x1_f = _mv_x1_f; ptr_mv_y1_f = _mv_y1_f;
	ptr_mv_type2_f = _mv_type2_f; ptr_mv_x2_f = _mv_x2_f; ptr_mv_y2_f = _mv_y2_f;
	ptr_mv_type3_f = _mv_type3_f; ptr_mv_x3_f = _mv_x3_f; ptr_mv_y3_f = _mv_y3_f;
	ptr_mv_type4_f = _mv_type4_f; ptr_mv_x4_f = _mv_x4_f; ptr_mv_y4_f = _mv_y4_f;
	ptr_mv_type_uv_f = _mv_type_uv_f; ptr_mv_uvx_f = _mv_uvx_f; ptr_mv_uvy_f = _mv_uvy_f;
	
	// Backward motion vectors
	ptr_mv_type1_b = _mv_type1_b; ptr_mv_x1_b = _mv_x1_b; ptr_mv_y1_b = _mv_y1_b;
	ptr_mv_type2_b = _mv_type2_b; ptr_mv_x2_b = _mv_x2_b; ptr_mv_y2_b = _mv_y2_b;
	ptr_mv_type3_b = _mv_type3_b; ptr_mv_x3_b = _mv_x3_b; ptr_mv_y3_b = _mv_y3_b;
	ptr_mv_type4_b = _mv_type4_b; ptr_mv_x4_b = _mv_x4_b; ptr_mv_y4_b = _mv_y4_b;
	ptr_mv_type_uv_b = _mv_type_uv_b; ptr_mv_uvx_b = _mv_uvx_b; ptr_mv_uvy_b = _mv_uvy_b;
*/	
	_coded_mvd_flag = true;
	D_GOB::_coded_mvd_flag = _coded_mvd_flag;
	D_Macroblock::_coded_mvd_flag = _coded_mvd_flag;
	
	bd = _trb / _trd;
	cd = (_trb - _trd) / _trd;
	
	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {
			
		/*	// Compute delta motion vector
		dx = *ptr_mvd_x; k = 1; ddx = 0;		// X info
		dy = *ptr_mvd_y; m = 0; ddy = 0;		// Y info
		
		  if ((*ptr_mvd_type & 1) == 0) {
		  dx += 0.5;
		  ddx = -0.5;
		  k = 2;
		  }
		  
			if (*ptr_mvd_type > 2) {
			dy += 0.5;
			ddy = -0.5;
			m = 2;
		}*/
			min_MAD = 65535;
			best_mvd_x = 0;
			best_mvd_y = 0;
			best_mvd_type = 1;
			
			//Integer estimation
			
			//Inserting the FSS here
			xmotion = 0;
			ymotion = 0;
			xcentre = 0;
			ycentre = 0;
			
			up_or_down = 0;
			left_or_right = 0;
			
			stepsize = 2;
			no_of_times = 9;
			
			dx0 = -1 * stepsize;
			dy0 = -1 * stepsize;
			
			while (stepsize > 0) {
				for (loop=0; loop<no_of_times; loop++) {
					
					delta_mv_x = (short) (dx0 + xcentre);
					delta_mv_y = (short) (dy0 + ycentre);
					
					// Between these two lines
					dx = delta_mv_x;
					dy = delta_mv_y;
					ddx = 0;
					ddy = 0;
					k = 1;
					m = 0;
					
					// Compute P picture motion vectors
					x0 = *ptr_mv_x1; y0 = *ptr_mv_y1;
					x1 = *ptr_mv_x2; y1 = *ptr_mv_y2;
					x2 = *ptr_mv_x3; y2 = *ptr_mv_y3;
					x3 = *ptr_mv_x4; y3 = *ptr_mv_y4;
					
					if ((*ptr_mv_type1 & 1) == 0) x0 += 0.5;
					if ((*ptr_mv_type2 & 1) == 0) x1 += 0.5;
					if ((*ptr_mv_type3 & 1) == 0) x2 += 0.5;
					if ((*ptr_mv_type4 & 1) == 0) x3 += 0.5;
					
					if (*ptr_mv_type1 > 2) y0 += 0.5;
					if (*ptr_mv_type2 > 2) y1 += 0.5;
					if (*ptr_mv_type3 > 2) y2 += 0.5;
					if (*ptr_mv_type4 > 2) y3 += 0.5;
					
					
					// Compute X forward motion vectors
					if (dx == 0) {		// delta MV is 0
						
						mv_x1_f = (short) (bd * x0);
						mv_x2_f = (short) (bd * x1);
						mv_x3_f = (short) (bd * x2);
						mv_x4_f = (short) (bd * x3);
						mv_type1_f = 1;
						mv_type2_f = 1;
						mv_type3_f = 1;
						mv_type4_f = 1;
						
						mv_x1_b = (short) (cd * x0);
						mv_x2_b = (short) (cd * x1);
						mv_x3_b = (short) (cd * x2);
						mv_x4_b = (short) (cd * x3);
						mv_type1_b = 1;
						mv_type2_b = 1;
						mv_type3_b = 1;
						mv_type4_b = 1;
						
						tempxf = mv_x1_f + mv_x2_f + mv_x3_f + mv_x4_f;
						tempxb = mv_x1_b + mv_x2_b + mv_x3_b + mv_x4_b;
						
					}//if (dx == 0)
					else {				// delta MV is not 0
						
						// Forward Motion Vector
						tx0 = ((short) (bd * x0)) + dx;
						tx1 = ((short) (bd * x1)) + dx;
						tx2 = ((short) (bd * x2)) + dx;
						tx3 = ((short) (bd * x3)) + dx;
						tempxf = tx0 + tx1 + tx2 + tx3;
						
						// Processing to store into internal storage architecture -> Forward MV
						mv_x1_f = (short) (tx0 + ddx);
						mv_x2_f = (short) (tx1 + ddx);
						mv_x3_f = (short) (tx2 + ddx);
						mv_x4_f = (short) (tx3 + ddx);
						
						mv_type1_f = (short) k;
						mv_type2_f = (short) k;
						mv_type3_f = (short) k;
						mv_type4_f = (short) k;
						
						// Backward Motion Vector
						tx0 = tx0 - x0;
						tx1 = tx1 - x1;
						tx2 = tx2 - x2;
						tx3 = tx3 - x3;
						tempxb = tx0 + tx1 + tx2 + tx3;
						
						// Processing to store into internal storage architecture -> Backward MV
						if (((int) tx0) != tx0) {
							mv_x1_b = (short) (tx0 - 0.5);
							mv_type1_b = 2;
						}
						else {
							mv_x1_b = (short) tx0;
							mv_type1_b = 1;
						}
						
						if (((int) tx1) != tx1) {
							mv_x2_b = (short) (tx1 - 0.5);
							mv_type2_b = 2;
						}
						else {
							mv_x2_b = (short) tx1;
							mv_type2_b = 1;
						}
						
						if (((int) tx2) != tx2) {
							mv_x3_b = (short) (tx2 - 0.5);
							mv_type3_b = 2;
						}
						else {
							mv_x3_b = (short) tx2;
							mv_type3_b = 1;
						}
						
						if (((int) tx3) != tx3) {
							mv_x4_b = (short) (tx3 - 0.5);
							mv_type4_b = 2;
						}
						else {
							mv_x4_b = (short) tx3;
							mv_type4_b = 1;
						}
					}	// else 	 delta MV is not 0
					
					
					// Compute Y forward motion vectors
					if (dy == 0) {		// motion vector type does not need to change
						
						mv_y1_f = (short) (bd * y0);
						mv_y2_f = (short) (bd * y1);
						mv_y3_f = (short) (bd * y2);
						mv_y4_f = (short) (bd * y3);
						mv_y1_b = (short) (cd * y0);
						mv_y2_b = (short) (cd * y1);
						mv_y3_b = (short) (cd * y2);
						mv_y4_b = (short) (cd * y3);
						
						tempyf = mv_y1_f + mv_y2_f + mv_y3_f + mv_y4_f;
						tempyb = mv_y1_b + mv_y2_b + mv_y3_b + mv_y4_b;
					}//if (dy == 0)
					else {
						
						// Forward Motion Vector
						ty0 = ((short)(bd * y0)) + dy;
						ty1 = ((short)(bd * y1)) + dy;
						ty2 = ((short)(bd * y2)) + dy;
						ty3 = ((short)(bd * y3)) + dy;
						tempyf = ty0 + ty1 + ty2 + ty3;
						
						// Processing to store into internal storage architecture -> Forward MV
						mv_y1_f = (short)(ty0 + ddy);
						mv_y2_f = (short)(ty1 + ddy);
						mv_y3_f = (short)(ty2 + ddy);
						mv_y4_f = (short)(ty3 + ddy);
						
						mv_type1_f = (short) (mv_type1_f + m);
						mv_type2_f = (short) (mv_type2_f + m);
						mv_type3_f = (short) (mv_type3_f + m);
						mv_type4_f = (short) (mv_type4_f + m);
						
						// Backward motion vector
						ty0 = ty0 - y0;
						ty1 = ty1 - y1;
						ty2 = ty2 - y2;
						ty3 = ty3 - y3;
						tempyb = ty0 + ty1 + ty2 + ty3;
						
						// Processing to store into internal storage architecture
						if (((int) ty0) != ty0) {
							mv_y1_b = (short) (ty0 - 0.5);
							mv_type1_b += 2;
						}
						else mv_y1_b = (short) ty0;
						
						if (((int) ty1) != ty1) {
							mv_y2_b = (short) (ty1 - 0.5);
							mv_type2_b += 2;
						}
						else mv_y2_b = (short) ty1;
						
						if (((int) ty2) != ty2) {
							mv_y3_b = (short) (ty2 - 0.5);
							mv_type3_b += 2;
						}
						else mv_y3_b = (short) ty2;
						
						if (((int) ty3) != ty3) {
							mv_y4_b = (short) (ty3 - 0.5);
							mv_type4_b += 2;
						}
						else mv_y4_b = (short) ty3;
					}	// else 	 delta MV is not 0
/*					
					//U and V motion vectors
					// Apply Table F.1 to obtain correct values
					k = ((int) (2 * tempxf)) % 16;
					m = ((int) (2 * tempyf)) % 16;
					p = ((int) (2 * tempxb)) % 16;
					q = ((int) (2 * tempyb)) % 16;
					
					tempxf /= 8;
					tempyf /= 8;
					tempxb /= 8;
					tempyb /= 8;
					
					// Process UV forward motion vector
					if (tempxf >=0) {
						if (k <= 2) {
							mv_type_uv_f = 1;
							mv_uvx_f = (short) floor(tempxf);
						}
						else if (k >= 14) {
							mv_type_uv_f = 1;
							mv_uvx_f = (short) ceil(tempxf);
						}
						else {
							mv_type_uv_f = 2;
							mv_uvx_f = (short) floor(tempxf);
						}
					}
					else {
						if (k >= -2) {
							mv_type_uv_f = 1;
							mv_uvx_f = (short) ceil(tempxf);
						}
						else if (k <= -14) {
							mv_type_uv_f = 1;
							mv_uvx_f = (short) floor(tempxf);
						}
						else {
							mv_type_uv_f = 2;
							mv_uvx_f = (short) floor(tempxf);
						}
					}
					
					if (tempyf >=0) {
						if (m <= 2) mv_uvy_f = (short) floor(tempyf);
						else if (m >= 14) mv_uvy_f = (short) ceil(tempyf);
						else {
							mv_type_uv_f += 2;
							mv_uvy_f = (short) floor(tempyf);
						}
					}
					else {
						if (m >= -2) mv_uvy_f = (short) ceil(tempyf);
						else if (m <= -14) mv_uvy_f = (short) floor(tempyf);
						else {
							mv_type_uv_f += 2;
							mv_uvy_f = (short) floor(tempyf);
						}
					}
					
					// Process UV backward motion vector
					if (tempxb >=0) {
						if (p <= 2) {
							mv_type_uv_b = 1;
							mv_uvx_b = (short) floor(tempxb);
						}
						else if (p >= 14) {
							mv_type_uv_b = 1;
							mv_uvx_b = (short) ceil(tempxb);
						}
						else {
							mv_type_uv_b = 2;
							mv_uvx_b = (short) floor(tempxb);
						}
					}
					else {
						if (p >= -2) {
							mv_type_uv_b = 1;
							mv_uvx_b = (short) ceil(tempxb);
						}
						else if (p <= -14) {
							mv_type_uv_b = 1;
							mv_uvx_b = (short) floor(tempxb);
						}
						else {
							mv_type_uv_b = 2;
							mv_uvx_b = (short) floor(tempxb);
						}
					}
					
					if (tempyb >=0) {
						if (q <= 2) mv_uvy_b = (short) floor(tempyb);
						else if (q >= 14) mv_uvy_b = (short) ceil(tempyb);
						else {
							mv_type_uv_b += 2;
							mv_uvy_b = (short) floor(tempyb);
						}
					}
					else {
						if (q >= -2) mv_uvy_b = (short) ceil(tempyb);
						else if (q <= -14) mv_uvy_b = (short) floor(tempyb);
						else {
							mv_type_uv_b += 2;
							mv_uvy_b = (short) floor(tempyb);
						}
					}
					*/
					
					//Inserted condition to check if the motion vectors point outside
					// in Find_MAD_B_Macroblock
					current_MAD = Find_MAD_B_Macroblock(i,j,mv_type1_f, mv_x1_f, mv_y1_f,
						mv_type1_b, mv_x1_b, mv_y1_b, mv_type2_f, mv_x2_f, mv_y2_f, 
						mv_type2_b, mv_x2_b, mv_y2_b, mv_type3_f, mv_x3_f, mv_y3_f,
						mv_type3_b, mv_x3_b, mv_y3_b, mv_type4_f, mv_x4_f, mv_y4_f,
						mv_type4_b, mv_x4_b,mv_y4_b);
					
					if(current_MAD < min_MAD) {
/*						
						best_mv_type1_f=mv_type1_f; best_mv_x1_f=mv_x1_f; best_mv_y1_f=mv_y1_f;
						best_mv_type1_b=mv_type1_b; best_mv_x1_b=mv_x1_b; best_mv_y1_b=mv_y1_b;
						best_mv_type2_f=mv_type2_f; best_mv_x2_f=mv_x2_f; best_mv_y2_f=mv_y2_f;
						best_mv_type2_b=mv_type2_b; best_mv_x2_b=mv_x2_b; best_mv_y2_b=mv_y2_b;
						best_mv_type3_f=mv_type3_f; best_mv_x3_f=mv_x3_f; best_mv_y3_f=mv_y3_f;
						best_mv_type3_b=mv_type3_b; best_mv_x3_b=mv_x3_b; best_mv_y3_b=mv_y3_b;
						best_mv_type4_f=mv_type4_f; best_mv_x4_f=mv_x4_f; best_mv_y4_f=mv_y4_f;
						best_mv_type4_b=mv_type4_b; best_mv_x4_b=mv_x4_b; best_mv_y4_b=mv_y4_b;
						best_mv_type_uv_f = mv_type_uv_f; best_mv_uvx_f = mv_uvx_f; best_mv_uvy_f = mv_uvy_f;
						best_mv_type_uv_b = mv_type_uv_b; best_mv_uvx_b = mv_uvx_b; best_mv_uvy_b = mv_uvy_b;
*/						
						min_MAD = current_MAD;
						best_mvd_x = delta_mv_x;
						best_mvd_y = delta_mv_y;
						ymotion = delta_mv_y;
						xmotion = delta_mv_y;
					}
					
					if (no_of_times == 9) {
						if (dx0 <= 0) dx0 += stepsize;
						else {
							dx0 = -1 * stepsize;
							dy0 += stepsize;
						}
					}
					else if (no_of_times == 3) {
						if (up_or_down!=0) dx0 = (2 * stepsize * loop) - stepsize;
						else dy0 = (2 * stepsize * loop) - stepsize;
					}
					else {
						if (loop < 3) dx0 = dx0 - left_or_right;
						else {
							dx0 = left_or_right;
							dy0 = dy0 - up_or_down;
						}
					}
					
				}//for (loop=0; loop<no_of_times; loop++)
				
				left_or_right = (short) (xmotion - xcentre);
				up_or_down    = (short) (ymotion - ycentre);
				dx = left_or_right;
				dy = up_or_down;
				
				xcentre = xmotion; 
				ycentre = ymotion;
				
				if (stepsize == 1) stepsize >>= 1;
				near_endx = 16 - abs(xcentre);
				near_endy = 16 - abs(ycentre);
				
				if ( (near_endx < stepsize) || (near_endy < stepsize) ) {
					left_or_right=0;
					up_or_down=0;
				}
				
				no_of_times = 5;
				if ( (left_or_right == 0) && (up_or_down == 0) ) {
					no_of_times = 9;
					stepsize >>= 1;
					dx0 = -1 * stepsize;
					dy0 = -1 * stepsize;
				}
				else if ( (left_or_right == 0) || (up_or_down == 0) ) {
					no_of_times = 3;
				}
				
			}//while (stepsize > 0) {
			
/*			
			*ptr_mv_type1_f=best_mv_type1_f; *ptr_mv_x1_f=best_mv_x1_f; *ptr_mv_y1_f=best_mv_y1_f;
			*ptr_mv_type1_b=best_mv_type1_b; *ptr_mv_x1_b=best_mv_x1_b; *ptr_mv_y1_b=best_mv_y1_b;
			*ptr_mv_type2_f=best_mv_type2_f; *ptr_mv_x2_f=best_mv_x2_f; *ptr_mv_y2_f=best_mv_y2_f;
			*ptr_mv_type2_b=best_mv_type2_b; *ptr_mv_x2_b=best_mv_x2_b; *ptr_mv_y2_b=best_mv_y2_b;
			*ptr_mv_type3_f=best_mv_type3_f; *ptr_mv_x3_f=best_mv_x3_f; *ptr_mv_y3_f=best_mv_y3_f;
			*ptr_mv_type3_b=best_mv_type3_b; *ptr_mv_x3_b=best_mv_x3_b; *ptr_mv_y3_b=best_mv_y3_b;
			*ptr_mv_type4_f=best_mv_type4_f; *ptr_mv_x4_f=best_mv_x4_f; *ptr_mv_y4_f=best_mv_y4_f;
			*ptr_mv_type4_b=best_mv_type4_b; *ptr_mv_x4_b=best_mv_x4_b; *ptr_mv_y4_b=best_mv_y4_b;
			*ptr_mv_type_uv_f = best_mv_type_uv_f; *ptr_mv_uvx_f = best_mv_uvx_f; *ptr_mv_uvy_f = best_mv_uvy_f;
			*ptr_mv_type_uv_b = best_mv_type_uv_b; *ptr_mv_uvx_b = best_mv_uvx_b; *ptr_mv_uvy_b = best_mv_uvy_b;
*/			
			*ptr_mvd_x = best_mvd_x; *ptr_mvd_y = best_mvd_y; *ptr_mvd_type = 1;
			
			
			//Massive Pointer Increments
			
			//fprintf(stdout,"MAD is %d",min_MAD);
			ptr_mvd_x++; ptr_mvd_y++; ptr_mvd_type++; 
			ptr_mv_type1++; ptr_mv_x1++; ptr_mv_y1++;
			ptr_mv_type2++; ptr_mv_x2++; ptr_mv_y2++;
			ptr_mv_type3++; ptr_mv_x3++; ptr_mv_y3++;
			ptr_mv_type4++; ptr_mv_x4++; ptr_mv_y4++;
/*			
			ptr_mv_x1_f++; ptr_mv_y1_f++; ptr_mv_type1_f++;
			ptr_mv_x2_f++; ptr_mv_y2_f++; ptr_mv_type2_f++;
			ptr_mv_x3_f++; ptr_mv_y3_f++; ptr_mv_type3_f++;
			ptr_mv_x4_f++; ptr_mv_y4_f++; ptr_mv_type4_f++;
			ptr_mv_type_uv_f++; ptr_mv_uvx_f++; ptr_mv_uvy_f++;
			ptr_mv_type_uv_b++; ptr_mv_uvx_b++; ptr_mv_uvy_b++;
*/			
		}//for (j=0; j<_MB_per_gob; j++)
		
	}//for (i=0; i<_GOB_per_frame; i++) {
	
}


int D_Frame::Find_MAD_B_Macroblock(int ypos, int xpos, short mv_type1_f, short mv_x1_f, 
								   short mv_y1_f, short mv_type1_b, short mv_x1_b, short mv_y1_b, short mv_type2_f,
								   short mv_x2_f, short mv_y2_f, short mv_type2_b, short mv_x2_b, short mv_y2_b, 
								   short mv_type3_f, short mv_x3_f, short mv_y3_f, short mv_type3_b, short mv_x3_b, 
								   short mv_y3_b, short mv_type4_f, short mv_x4_f, short mv_y4_f,short mv_type4_b, 
								   short mv_x4_b, short mv_y4_b) {
	
	int k, l, m, n, p, q, r, s;
	int dx, dy, disp1, tx, ty, disp2; 
	int MAD=0, one_d_position;
	unsigned char *ptr_this_Y_c, *ptr_prev_Y_c, *ptr_prev_pY_c;
	unsigned char buffer_1D_one[64], buffer_1D_two[64], *ptr_c;
	
	
	ptr_this_Y_c = _this_1D_frame;
	
	one_d_position = (ypos * _MB_per_gob + xpos) << 8;
	
	ptr_this_Y_c += one_d_position;
	
	
	//First Y Block
	
	dx = (int) ((xpos << 4) + mv_x1_f);
	dy = (int) ((ypos << 4) + mv_y1_f);
	disp1 = dx + (dy * _frame_xsize);
	if(dx < 0 || dy < 0 || dx > _frame_xsize - 8 || dy > _frame_ysize - 8 || 
		mv_x1_f > 15 || mv_x1_f < -16 || mv_y1_f > 15 || mv_y1_f < -16) {
		MAD = 65535;
		return MAD;
	}
	
	tx = mv_x1_b;
	ty = mv_y1_b;
	dx = (int) ((xpos << 4) + tx);
	dy = (int) ((ypos << 4) + ty);
	disp2 = dx + (dy * _frame_xsize);
	
	if(dx < 0 || dy < 0 || dx > _frame_xsize - 8 || dy > _frame_ysize - 8 ||
		tx > 15 || tx < -16 || ty > 15 || ty <-16) {
		MAD = 65535;
		return MAD;
	}
	
	
	m = (int) ((-tx + 1) / 2);
	if (m < 0) m = 0;
	n = 15 - (int) ((-tx + 1) / 2);
	if (n > 7) n = 7;
	
	p = (int) ((-ty + 1) / 2);
	if (p < 0) p = 0;
	q = 15 - (int) ((-ty + 1) / 2);
	if (q > 7) q = 7;
	
	switch (mv_type1_f) {
	case 1:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame;
		break;
	case 2:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_half_full;
		break;
	case 3:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_full_half;
		break;
	case 4:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid forward MVTYPE\n");
		exit(-1);
	}//switch (mv_type1_f)
	
	ptr_prev_Y_c += disp1;
	ptr_c = buffer_1D_one;
	
	for (k=0; k< 8; k++) {
		for (l=0; l<8; l++) {
			*ptr_c++ = *ptr_prev_Y_c++;
		}
		ptr_prev_Y_c += (_frame_xsize - 8); // Changes with AP
	}
	
	if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted
		
		switch (mv_type1_b) {
		case 1:
			ptr_prev_pY_c = _decoded_frame + _PB_offset;
			break;
		case 2:
			ptr_prev_pY_c = _decoded_frame_half_full + _PB_offset;
			break;
		case 3:
			ptr_prev_pY_c = _decoded_frame_full_half + _PB_offset;
			break;
		case 4:
			ptr_prev_pY_c = _decoded_frame_half_half + _PB_offset;
			break;
		default:
			fprintf(stdout, "Invalid backward MVTYPE\n");
			exit(-1);
		}//switch (mv_type1_b)
		
		ptr_prev_pY_c += disp2;
		ptr_c = buffer_1D_two;
		
		for (k=0; k<8; k++) {
			for (l=0; l<8; l++) {
				*ptr_c++ = *ptr_prev_pY_c++;
			}
			ptr_prev_pY_c += (_frame_xsize - 8); // Changes with AP
		}
		
		
		for (k=p; k<=q; k++) {
			r = k << 3;
			for (l=m, s=r+m; l<=n; l++, s++) {
				*(buffer_1D_one + s) = (unsigned char)
					((*(buffer_1D_one + s) + *(buffer_1D_two + s)) / 2);
			}
		}
		
		
	}//if ((m <= n) && (p <= q)) Partially bi-directionally predicted
	
	for(k=0;k<64;k++) MAD += (int) abs(*ptr_this_Y_c++ - buffer_1D_one[k]);
	
	
	// Second Y block
	
	dx = (int) ((xpos << 4) + 8 + mv_x2_f);
	dy = (int) ((ypos << 4) + mv_y2_f);
	disp1 = dx + (dy * _frame_xsize);
	
	if(dx < 0 || dy < 0 || dx > _frame_xsize - 8 || dy > _frame_ysize - 8 ||
		mv_x2_f > 15 || mv_x2_f < -16 || mv_y2_f > 15 || mv_y2_f < -16) {
		MAD = 65535;
		return MAD;
	}
	
	tx = mv_x2_b;
	ty = mv_y2_b;
	dx = (int) ((xpos << 4) + 8 + tx);
	dy = (int) ((ypos << 4) + ty);
	disp2 = dx + (dy * _frame_xsize);
	
	if(dx < 0 || dy < 0 || dx > _frame_xsize - 8 || dy > _frame_ysize - 8 ||
		tx > 15 || tx < -16 || ty > 15 || ty <-16) {
		MAD = 65535;
		return MAD;
	}
	
	m = (int) ((-tx + 1) / 2);
	if (m < 0) m = 0;
	n = 15 - (int) ((-tx + 1) / 2);
	if (n > 7) n = 7;
	
	p = (int) ((-ty + 1) / 2);
	if (p < 0) p = 0;
	q = 15 - (int) ((-ty + 1) / 2);
	if (q > 7) q = 7;
	
	switch (mv_type2_f) {
	case 1:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame;
		break;
	case 2:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_half_full;
		break;
	case 3:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_full_half;
		break;
	case 4:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid forward MVTYPE\n");
		exit(-1);
	}//switch (mv_type2_f)
	
	ptr_prev_Y_c += disp1;
	
	ptr_c = buffer_1D_one;
	
	for (k=0; k< 8; k++) {
		for (l=0; l<8; l++) {
			*ptr_c++ = *ptr_prev_Y_c++;
		}
		ptr_prev_Y_c += (_frame_xsize - 8); // Changes with AP
	}
	
	if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted
		
		switch (mv_type2_b) {
		case 1:
			ptr_prev_pY_c = _decoded_frame + _PB_offset;
			break;
		case 2:
			ptr_prev_pY_c = _decoded_frame_half_full + _PB_offset;
			break;
		case 3:
			ptr_prev_pY_c = _decoded_frame_full_half + _PB_offset;
			break;
		case 4:
			ptr_prev_pY_c = _decoded_frame_half_half + _PB_offset;
			break;
		default:
			fprintf(stdout, "Invalid backward MVTYPE\n");
			exit(-1);
		}//switch (mv_type2_b)
		
		ptr_prev_pY_c += disp2;
		ptr_c = buffer_1D_two;
		
		for (k=0; k<8; k++) {
			for (l=0; l<8; l++) {
				*ptr_c++ = *ptr_prev_pY_c++;
			}
			ptr_prev_pY_c += (_frame_xsize - 8); // Changes with AP
		}
		
		
		for (k=p; k<=q; k++) {
			r = k << 3;
			for (l=m, s=r+m; l<=n; l++, s++) {
				*(buffer_1D_one + s) = (unsigned char)
					((*(buffer_1D_one + s) + *(buffer_1D_two + s)) / 2);
			}
		}
		
	}//if ((m <= n) && (p <= q)) Partially bi-directionally predicted
	
	for(k=0;k<64;k++) MAD += (int) abs(*ptr_this_Y_c++ - buffer_1D_one[k]);
	
	// Third Y block
	
	dx = (int) ((xpos << 4) + mv_x3_f);
	dy = (int) ((ypos << 4) + 8 + mv_y3_f);
	disp1 = dx + (dy * _frame_xsize);
	
	if(dx < 0 || dy < 0 || dx > _frame_xsize - 8 || dy > _frame_ysize - 8 ||
		mv_x3_f > 15 || mv_x3_f < -16 || mv_y3_f > 15 || mv_y3_f < -16) {
		MAD = 65535;
		return MAD;
	}
	
	tx = mv_x3_b;
	ty = mv_y3_b;
	dx = (int) ((xpos << 4) + tx);
	dy = (int) ((ypos << 4) + 8 + ty);
	disp2 = dx + (dy * _frame_xsize);
	
	if(dx < 0 || dy < 0 || dx > _frame_xsize - 8 || dy > _frame_ysize - 8 ||
		tx > 15 || tx < -16 || ty > 15 || ty <-16) {
		MAD = 65535;
		return MAD;
	}
	
	m = (int) ((-tx + 1) / 2);
	if (m < 0) m = 0;
	n = 15 - (int) ((-tx + 1) / 2);
	if (n > 7) n = 7;
	
	p = (int) ((-ty + 1) / 2);
	if (p < 0) p = 0;
	q = 15 - (int) ((-ty + 1) / 2);
	if (q > 7) q = 7;
	
	switch (mv_type3_f) {
	case 1:
		if(_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame;
		break;
	case 2:
		if(_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_half_full;
		break;
	case 3:
		if(_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_full_half;
		break;
	case 4:
		if(_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid forward MVTYPE\n");
		exit(-1);
	}
	
	ptr_prev_Y_c += disp1;
	
	ptr_c = buffer_1D_one;
	
	for (k=0; k< 8; k++) {
		for (l=0; l<8; l++) {
			*ptr_c++ = *ptr_prev_Y_c++;
		}
		ptr_prev_Y_c += (_frame_xsize - 8); // Changes with AP
	}
	
	
	if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted
		
		switch (mv_type3_b) {
		case 1:
			ptr_prev_pY_c = _decoded_frame + _PB_offset;
			break;
		case 2:
			ptr_prev_pY_c = _decoded_frame_half_full + _PB_offset;
			break;
		case 3:
			ptr_prev_pY_c = _decoded_frame_full_half + _PB_offset;
			break;
		case 4:
			ptr_prev_pY_c = _decoded_frame_half_half + _PB_offset;
			break;
		default:
			fprintf(stdout, "Invalid backward MVTYPE\n");
			exit(-1);
		}//switch (mv_type3_b)
		
		ptr_prev_pY_c += disp2;
		ptr_c = buffer_1D_two;
		
		for (k=0; k<8; k++) {
			for (l=0; l<8; l++) {
				*ptr_c++ = *ptr_prev_pY_c++;
			}
			ptr_prev_pY_c += (_frame_xsize - 8); // Changes with AP
		}
		
		
		for (k=p; k<=q; k++) {
			r = k << 3;
			for (l=m, s=r+m; l<=n; l++, s++) {
				*(buffer_1D_one + s) = (unsigned char)
					((*(buffer_1D_one + s) + *(buffer_1D_two + s)) / 2);
			}
		}
		
	}//if ((m <= n) && (p <= q)) Partially bi-directionally predicted
	
	for(k=0;k<64;k++) MAD += (int) abs(*ptr_this_Y_c++ - buffer_1D_one[k]);
	
	// Fourth Y block
	dx = (int) ((xpos << 4) + 8 + mv_x4_f);
	dy = (int) ((ypos << 4) + 8 + mv_y4_f);
	disp1 = dx + (dy * _frame_xsize);
	
	if(dx < 0 || dy < 0 || dx > _frame_xsize - 8 || dy > _frame_ysize - 8 ||
		mv_x4_f > 15 || mv_x4_f < -16 || mv_y4_f > 15 || mv_y4_f < -16) {
		MAD = 65535;
		return MAD;
	}
	
	tx = mv_x4_b;
	ty = mv_y4_b;
	dx = (int) ((xpos << 4) + 8 + tx);
	dy = (int) ((ypos << 4) + 8 + ty);
	disp2 = dx + (dy * _frame_xsize);
	
	if(dx < 0 || dy < 0 || dx > _frame_xsize - 8 || dy > _frame_ysize - 8 ||
		tx > 15 || tx < -16 || ty > 15 || ty <-16) {
		MAD = 65535;
		return MAD;
	}
	
	m = (int) ((-tx + 1) / 2);
	if (m < 0) m = 0;
	n = 15 - (int) ((-tx + 1) / 2);
	if (n > 7) n = 7;
	
	p = (int) ((-ty + 1) / 2);
	if (p < 0) p = 0;
	q = 15 - (int) ((-ty + 1) / 2);
	if (q > 7) q = 7;
	
	switch (mv_type4_f) {
	case 1:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_frames->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame;
		break;
	case 2:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_full->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_half_full;
		break;
	case 3:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_full_half->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_full_half;
		break;
	case 4:
		if (_reference_picture_selection) ptr_prev_Y_c = _prev_half_half->GetFrame(_ref_index);
		else ptr_prev_Y_c = _decoded_frame_half_half;
		break;
	default:
		fprintf(stdout, "Invalid forward MVTYPE\n");
		exit(-1);
	}
	
	ptr_prev_Y_c += disp1;
	
	ptr_c = buffer_1D_one;
	
	for (k=0; k< 8; k++) {
		for (l=0; l<8; l++) {
			*ptr_c++ = *ptr_prev_Y_c++;
		}
		ptr_prev_Y_c += (_frame_xsize - 8); // Changes with AP
	}
	
	if ((m <= n) && (p <= q)) {	// Partially bi-directionally predicted
		
		switch (mv_type4_b) {
		case 1:
			ptr_prev_pY_c = _decoded_frame + _PB_offset;
			break;
		case 2:
			ptr_prev_pY_c = _decoded_frame_half_full + _PB_offset;
			break;
		case 3:
			ptr_prev_pY_c = _decoded_frame_full_half + _PB_offset;
			break;
		case 4:
			ptr_prev_pY_c = _decoded_frame_half_half + _PB_offset;
			break;
		default:
			fprintf(stdout, "Invalid backward MVTYPE\n");
			exit(-1);
		}//switch (mv_type4_b)
		
		ptr_prev_pY_c += disp2;
		ptr_c = buffer_1D_two;
		
		for (k=0; k<8; k++) {
			for (l=0; l<8; l++) {
				*ptr_c++ = *ptr_prev_pY_c++;
			}
			ptr_prev_pY_c += (_frame_xsize - 8); // Changes with AP
		}
		
		
		for (k=p; k<=q; k++) {
			r = k << 3;
			for (l=m, s=r+m; l<=n; l++, s++) {
				*(buffer_1D_one + s) = (unsigned char)
					((*(buffer_1D_one + s) + *(buffer_1D_two + s)) / 2);
			}
		}
		
	}//if ((m <= n) && (p <= q))  Partially bi-directionally predicted
	
	for(k=0;k<64;k++) MAD += (int) abs(*ptr_this_Y_c++ - buffer_1D_one[k]);
	
	return MAD;
}



#endif