
#ifndef __D_FRAME_ENTROPY_ENCODER_C__
#define __D_FRAME_ENTROPY_ENCODER_C__

#include "D_Frame.h"
#include "SAC.h"


/*
 * void D_Frame::Entropy_Encoder(PSC_Fifo &bit_ostream)
 * 
 * Entropy encode the current Frame header,
 * then call D_GOB::Entropy_Encoder() of GOBs pointed by _GOB_list
 * This is a private method
 *
 * Requires:	Encode_GOB() is called before evoking this method from the Frame layer
 * Modifies:	bit_ostream
 * Ensures:		Entropy encode the GOB header according to the standard
 *
 * Warning:		baseline implementation
 */
void D_Frame::Entropy_Encoder(PSC_Fifo &bit_ostream)
{
	bool bits[168]; // PSTUF(7)+PSC(22)+TR(8)+PTYPE(8)+PLUSPTYPE(30)+CPFMT(23)+EPAR(16)+
					// CPCFC(8)+ETR(2)+UUI(2)+SSS(2)+ELNUM(4)+RLNUM(4)+RPSMF(3)+TRPI(1)+
					// TRP(10)+BCI(2)+BCM(?)+RPRP(?)PQUANT(5)+CPM(1)+PSBI(2)
	bool *ptr_b;	// TRB(5)+DBQUANT(2)+PEI(1) = 168 bits
	int i, j, bitcount;
	bool plusptype, ufep_sent;
	D_GOB *ptr_GOB;
	D_Slice *ptr_SLICE;

	ptr_b = bits;

	plusptype = _reference_picture_selection ||
				_independent_segment_mode ||
				_slice_mode || _alternative_inter_vlc_mode ||
				_advanced_intra_coding_mode || _deblocking_filter_mode;
	ufep_sent = false;

	// PSC - Picture Start Code 22 bits
	bitcount = 22;
	for (i=0; i<16; i++) *ptr_b++ = false;
	*ptr_b++ = true;
	for (i=0; i<5; i++) *ptr_b++ = false;

	// TR - Temporal Reference - Does not count B frames - 8 bits
	bitcount += 8;
	j = _fr_num;
	for (i=0; i<8; i++, j <<= 1) {
		if ((j & 128) == 0) *ptr_b++ = false;
		else *ptr_b++ = true;
	}
	if (EDEBUG) fprintf(stdout, "\nTR %d\n", (_fr_num & 255));

	// PTYPE - Type Information - 13 bits
	bitcount += 5;
	// PTYPE Bit 1-2: 10
	*ptr_b++ = true;  // Bit 1: Always '1' to avoid Start Code emulation
	*ptr_b++ = false; // Bit 2: Always '0' for distinction with H.261
	// PTYPE Bit 3: Split Screen Indicator
	*ptr_b++ = false;
	// PTYPE Bit 4: Document Camera Indicator
	*ptr_b++ = false;
	// PTYPE Bit 5: Full Picture Freeze Release
	*ptr_b++ = false;
	if (EDEBUG) fprintf(stdout, "PTYPE 10000\n");
	// PTYPE Bit 6-8: Source Format
	bitcount += 3;
	if (EDEBUG) fprintf(stdout, "SFORMAT ");
	if (plusptype) {
		*ptr_b++ = true; *ptr_b++ = true; *ptr_b++ = true;
		if (EDEBUG) fprintf(stdout, "111");
	}
	else {
		j = _sformat + 1;
		for (i=0; i<3; i++, j <<= 1) {
			if ((j & 4) == 0) *ptr_b++ = false;
			else *ptr_b++ = true;
			if (EDEBUG) fprintf(stdout, "%d", ((j & 4) > 0));
		}
	}
	if (EDEBUG) fprintf(stdout, "\n");

	if (plusptype) {
		// PLUSPTYPE - Plus PTYPE - Consists of UFEP, OPPTYPE, and MPPTYPE
		// UFEP - Update Full Extended PTYPE - 3 bits
		bitcount += 3;
		*ptr_b++ = false;
		*ptr_b++ = false;
		// Have to allow for not sending optional part if already sent!
		if (_reference_picture_selection || _independent_segment_mode || _slice_mode ||
			_alternative_inter_vlc_mode || _advanced_intra_coding_mode ||
			_deblocking_filter_mode) {
			*ptr_b++ = true;
			ufep_sent = true;
		}
		else *ptr_b++ = false;

		// OPPTYPE - Optional Part of PLUSPTYPE - 18 bits
		if (ufep_sent) {
			// OPPTYPE - Source Format - 3 bits
			bitcount += 18;
			// OPPTYPE Bit 1-3: Source Format
			if (EDEBUG) fprintf(stdout, "SFORMAT ");
			j = _sformat + 1;
			for (i=0; i<3; i++, j <<= 1) {
				if ((j & 4) == 0) *ptr_b++ = false;
				else *ptr_b++ = true;
				if (EDEBUG) fprintf(stdout, "%d", ((j & 4) > 0));
			}
			if (EDEBUG) fprintf(stdout, "\n");
			// OPPTYPE Bit 4: Optional Custom PCF
			*ptr_b++ = false; // Picture Clock Frequency - Always 0 for now
			// OPPTYPE Bit 5: Optional Unrestricted Motion Vector (UMV) mode
			*ptr_b++ = _unrestricted_motion_vector_mode;
			if (EDEBUG) fprintf(stdout, "UMV %d\n", _unrestricted_motion_vector_mode);
			// OPPTYPE Bit 6: Optional Syntax-based Arithmetic Coding (SAC) mode
			*ptr_b++ = _syntax_arithmetic_coding_mode;
			if (EDEBUG) fprintf(stdout, "SAC %d\n", _syntax_arithmetic_coding_mode);
			// OPPTYPE Bit 7: Optional Advanced Prediction (AP) mode
			*ptr_b++ = _advanced_prediction_mode;
			if (EDEBUG) fprintf(stdout, "AP %d\n", _advanced_prediction_mode);
			// OPPTYPE Bit 8: Optional Advanced INTRA Coding (AIC) mode
			*ptr_b++ = _advanced_intra_coding_mode;
			if (EDEBUG) fprintf(stdout, "AIC %d\n", _advanced_intra_coding_mode);
			// OPPTYPE Bit 9: Optional Deblocking Filter (DF) mode
			*ptr_b++ = _deblocking_filter_mode;
			if (EDEBUG) fprintf(stdout, "DF %d\n", _deblocking_filter_mode);
			// OPPTYPE Bit 10: Optional Slice Structured (SS) mode
			*ptr_b++ = _slice_mode;
			if (EDEBUG) fprintf(stdout, "SS %d\n", _slice_mode);
			// OPPTYPE Bit 11: Optional Reference Picture Selection (RPS) mode
			*ptr_b++ = _reference_picture_selection;
			if (EDEBUG) fprintf(stdout, "RPS %d\n", _reference_picture_selection);
			// OPPTYPE Bit 12: Optional Independent Segment Decoding (ISD) mode
			*ptr_b++ = _independent_segment_mode;
			if (EDEBUG) fprintf(stdout, "ISD %d\n", _independent_segment_mode);
			// OPPTYPE Bit 13: Optional Alternative INTER VLC (AIV) mode
			*ptr_b++ = _alternative_inter_vlc_mode && _inter_frame_mode;
			if (EDEBUG) fprintf(stdout, "AIV %d\n", _alternative_inter_vlc_mode);
			// OPPTYPE Bit 14: Optional Modified Quantization (MQ) mode
			*ptr_b++ = false;
			if (EDEBUG) fprintf(stdout, "MQ 0\n");
			// OPPTYPE Bit 15-18: 1000
			*ptr_b++ = true;
			*ptr_b++ = false;
			*ptr_b++ = false;
			*ptr_b++ = false;
		}

		// MPPTYPE - Mandatory part of PLUSPTYPE - 9 bits
		bitcount += 9;
		// MPPTYPE Bit 1-3: Picture Type Code
		*ptr_b++ = false;
		*ptr_b++ = false;
		*ptr_b++ = _inter_frame_mode;
		if (EDEBUG) fprintf(stdout, "PCODE %d\n", _inter_frame_mode);
		// MPPTYPE Bit 4: Optional Reference Picture Resampling (RPR) mode
		*ptr_b++ = false;
		if (EDEBUG) fprintf(stdout, "RPR 0\n");
		// MPPTYPE Bit 5: Optional Reduced-Resolution Update (RRU) mode
		*ptr_b++ = false;
		if (EDEBUG) fprintf(stdout, "RRU 0\n");
		// MPPTYPE Bit 6: Rounding Type (RTYPE)
		*ptr_b++ = _RCONTROL; // Rounding Type
		if (EDEBUG) fprintf(stdout, "RTYPE %d\n", _RCONTROL);
		// MPPTYPE Bit 7-9: 001
		*ptr_b++ = false;
		*ptr_b++ = false;
		*ptr_b++ = true;

		// CPM - Continuous Presence Multipoint and Video Multiplex (Option Mode) - 1 bit
		bitcount++;
		*ptr_b++ = false;
		if (EDEBUG) fprintf(stdout, "CPM 0\n");

		// CPFMT - Custom Picture Format - 23 bits
		// EPAR - Extended Pixel Aspect Ratio - 16 bits
		// CPCFC - Custom Picture Clock Frequency Code - 8 bits
		// ETR - Extended Temporal Reference - 2 bits

		// UUI - Unlimited Unrestricted Motion Vectors Indicator - Variable Length
		if (_unrestricted_motion_vector_mode) {
			bitcount++;		// for now...
			*ptr_b++ = true;
		}

		// SSS - Slice Structured submode bits - 2 bits
		if (_slice_mode && ufep_sent) {
			bitcount+=2;
			*ptr_b++ = _rectangular_submode;
			*ptr_b++ = _arbitrary_order_submode;
		}
		if (EDEBUG) fprintf(stdout, "SSS %d%d\n", _rectangular_submode,
			_arbitrary_order_submode);

		// ELNUM - Enhancement layer number - 4 bits
		// RLNUM - Reference Layer Number - 4 bits

		if (_reference_picture_selection) {
			// RPSMF - Reference picture Selection Mode Flags - 3 bits
			if (ufep_sent) {
				bitcount+=3;
				*ptr_b++ = true;	// Neither ACK nor NACK signals needed
				*ptr_b++ = false;
				*ptr_b++ = false;
			}

			// TRPI - Temporal reference for prediction indication - 1 bit
			bitcount++;
			if (_inter_frame_mode && (*_trp != 0)) { // Only sent when an INTER frame
				*ptr_b++ = true;

				bitcount += 10;
				// TRP - Temporal Reference for Prediction - 10 bits
				*ptr_b++ = false;	// For Extended TR
				*ptr_b++ = false;
				j = _fr_num - *_trp;
				if (EDEBUG) fprintf(stdout, "PTRP %d - TRP %d\n", (j & 255), *_trp);
				for (i=0; i<8; i++, j <<= 1) {
					if ((j & 128) == 0) *ptr_b++ = false;
					else *ptr_b++ = true;
				}
			}
			else *ptr_b++ = false;

			// BCI - Back-Channel message indication - Variable Length
			bitcount+=2;
			*ptr_b++ = false;	// Absence or the end of the video back-channel message field
			*ptr_b++ = true;
		}

		// RPRP - Reference picture Resampling Parameters - Variable Length

		// PQUANT - Quantizer Information - 5 bits
		bitcount += 5;
		j = _pquant;
		for (i=0; i<5; i++, j <<= 1) {
			if ((j & 16) == 0) *ptr_b++ = false;
			else *ptr_b++ = true;
		}
		if (EDEBUG) fprintf(stdout, "PQUANT %d\n", _pquant);
	}
	// If no PLUSPTYPE is being sent
	else {
		bitcount += 5;
		// PTYPE Bit 9: Picture Coding Type - Intra or Inter
		*ptr_b++ = _inter_frame_mode;
		if (EDEBUG) fprintf(stdout, "PCODE %d\n", _inter_frame_mode);
		// PTYPE Bit 10: Optional Unrestricted Motion Vector (UMV) mode
		*ptr_b++ = _unrestricted_motion_vector_mode;
		if (EDEBUG) fprintf(stdout, "UMV %d\n", _unrestricted_motion_vector_mode);
		// PTYPE Bit 11: Optional Syntax-based Arithmetic Coding (SAC) mode
		*ptr_b++ = _syntax_arithmetic_coding_mode;
		if (EDEBUG) fprintf(stdout, "SAC %d\n", _syntax_arithmetic_coding_mode);
		// PTYPE Bit 12: Optional Advanced Prediction (AP) mode
		*ptr_b++ = _advanced_prediction_mode;
		if (EDEBUG) fprintf(stdout, "AP %d\n", _advanced_prediction_mode);
		// PTYPE Bit 13: Optional PB-frames (PB) mode
		*ptr_b++ = _PB_Ppicture_flag;
		if (EDEBUG) fprintf(stdout, "PB %d\n", _PB_Ppicture_flag);

		// PQUANT - Quantizer Information - 5 bits
		bitcount += 5;
		j = _pquant;
		for (i=0; i<5; i++, j <<= 1) {
			if ((j & 16) == 0) *ptr_b++ = false;
			else *ptr_b++ = true;
		}
		if (EDEBUG) fprintf(stdout, "PQUANT %d\n", _pquant);
		
		// CPM - Continuous Presence Multipoint and Video Multiplex (Option Mode) - 1 bit
		bitcount++;
		*ptr_b++ = false;
		if (EDEBUG) fprintf(stdout, "CPM 0\n");
	}


	// Only for PB frames
	if (_PB_Ppicture_flag) {
		// TRb - Temporal Reference for B-pictures in PB-frames (3 bits)
		bitcount += 3;
		j = _trb; // Must change to something real -- Must be <= 6
		for (i=0; i<3; i++, j <<= 1) {
			if ((j & 4) == 0) *ptr_b++ = false;
			else *ptr_b++ = true;
		}
		if (EDEBUG) fprintf(stdout, "TRB %d\n", _trb);

		// DBQUANT - Quantization Information for B-pictures in PB frames (DBQUANT) (2 bits)
		bitcount += 2;
		j = _dbquant; // Must change to something real -- Must be from table
		for (i=0; i<2; i++, j <<= 1) {
			if ((j & 2) == 0) *ptr_b++ = false;
			else *ptr_b++ = true;
		}
		if (EDEBUG) fprintf(stdout, "DBQUANT %d\n", _dbquant);
	}

	// PEI - Extra Insertion Information - 1 bit
	bitcount++;
	*ptr_b++ = false;
	if (EDEBUG) fprintf(stdout, "PEI 0\n");

	bit_ostream.WriteNBits(bits, bitcount);

	// Hierarchical layered class structure for entropy encoding 
	
	if (_syntax_arithmetic_coding_mode) {
		if (_slice_mode) {
			// Hard Coded Arbitrary ORDER!!!! BAD!
			if (_arbitrary_order_submode) {
				i = _SLICE_per_frame - 1;
				ptr_SLICE = _SLICE_list + i;
				bit_ostream.Enable_SAC_Zero_Run();
				if (EDEBUG) fprintf(stdout, "-> SLICE %d\n", i);
				ptr_SLICE->SAC_Encoder(bit_ostream, sac, plusptype, true);
				for (i--, ptr_SLICE--; i >= 0; i--) {
					if (EDEBUG) fprintf(stdout, "-> SLICE %d\n", i);
					ptr_SLICE->SAC_Encoder(bit_ostream, sac, plusptype, false);
					ptr_SLICE--;
				}
			}
			else {
				ptr_SLICE = _SLICE_list;
				bit_ostream.Enable_SAC_Zero_Run();
				if (EDEBUG) fprintf(stdout, "-> SLICE 0\n");
				ptr_SLICE->SAC_Encoder(bit_ostream, sac, plusptype, true);
				for (i=1, ptr_SLICE++; i<_SLICE_per_frame; i++) {
					if (EDEBUG) fprintf(stdout, "-> SLICE %d\n", i);
					ptr_SLICE->SAC_Encoder(bit_ostream, sac, plusptype, false);
					ptr_SLICE++;
				}
			}
		}
		else {
			ptr_GOB = _GOB_list;
			bit_ostream.Enable_SAC_Zero_Run();
			for (i=0; i<_GOB_per_frame; i++) {
				if (EDEBUG) fprintf(stdout, "-> GOB %d\n", i);
				ptr_GOB->SAC_Encoder(bit_ostream, sac, plusptype);
				ptr_GOB++;
			}
		}
	}
	else {
		if (_slice_mode) {
			// Hard Coded Arbitrary ORDER!!!! BAD!
			if (_arbitrary_order_submode) {
				i = _SLICE_per_frame - 1;
				ptr_SLICE = _SLICE_list + i;
				if (EDEBUG) fprintf(stdout, "-> SLICE %d\n", i);
				ptr_SLICE->Entropy_Encoder(bit_ostream, true);
				for (i--, ptr_SLICE--; i >= 0; i--) {
					if (EDEBUG) fprintf(stdout, "-> SLICE %d\n", i);
					ptr_SLICE->Entropy_Encoder(bit_ostream, false);
					ptr_SLICE--;
				}
			}
			else {
				ptr_SLICE = _SLICE_list;
				if (EDEBUG) fprintf(stdout, "-> SLICE 0\n");
				ptr_SLICE->Entropy_Encoder(bit_ostream, true);
				for (i=1, ptr_SLICE++; i<_SLICE_per_frame; i++) {
					if (EDEBUG) fprintf(stdout, "-> SLICE %d\n", i);
					ptr_SLICE->Entropy_Encoder(bit_ostream, false);
					ptr_SLICE++;
				}
			}
		}
		else {
			ptr_GOB = _GOB_list;
			for (i=0; i<_GOB_per_frame; i++) {
				if (EDEBUG) fprintf(stdout, "-> GOB %d\n", i);
				ptr_GOB->Entropy_Encoder(bit_ostream);
				ptr_GOB++;
			}
		}
	}

	ptr_b = bits;
	bitcount = 0;
	if (_syntax_arithmetic_coding_mode) {
		sac->encoder_flush(bitcount, ptr_b);
		bit_ostream.WriteNBits(bits, bitcount);
		bit_ostream.Disable_SAC_Zero_Run();
	}
}

#endif
