
#ifndef __D_FRAME_DUMP_C__
#define __D_FRAME_DUMP_C__

#include "D_Frame.h"
extern FILE *outptr;


/*
 * void D_Frame::Dump(bool P_picture)
 * 
 * Extract Data from the data structure for debugging purposes
 * This is a private method
 *
 * Requires:	nothing
 * Modifies:	nothing
 * Ensures:		nothing
 *
 * Warning:		
 */
void D_Frame::Dump(bool P_picture)
{
	int i, j, m, n, p, q, mtype, offset;

	// Macroblock Header Information
	bool *ptr_cmi, *ptr_flag_zero_mv;

	// Macroblock Coded Block Pattern
	short *ptr_mcbpc, *ptr_mcbpy, *ptr_mcbpb;

	// Macroblock Parameters
	short *ptr_mtype, *ptr_mquant, *ptr_bquant;

	// P Motion Vectors
	short *ptr_mv_type1, *ptr_mv_x1, *ptr_mv_y1;
	short *ptr_mv_type2, *ptr_mv_x2, *ptr_mv_y2;
	short *ptr_mv_type3, *ptr_mv_x3, *ptr_mv_y3;
	short *ptr_mv_type4, *ptr_mv_x4, *ptr_mv_y4;

	// Delta Motion Vector
	short *ptr_mvd_type, *ptr_mvd_x, *ptr_mvd_y;

	// B Forward and Backward Motion Vectors
	short *ptr_mv_type1_f, *ptr_mv_x1_f, *ptr_mv_y1_f;
	short *ptr_mv_type1_b, *ptr_mv_x1_b, *ptr_mv_y1_b;	
	short *ptr_mv_type2_f, *ptr_mv_x2_f, *ptr_mv_y2_f;
	short *ptr_mv_type2_b, *ptr_mv_x2_b, *ptr_mv_y2_b;	
	short *ptr_mv_type3_f, *ptr_mv_x3_f, *ptr_mv_y3_f;
	short *ptr_mv_type3_b, *ptr_mv_x3_b, *ptr_mv_y3_b;	
	short *ptr_mv_type4_f, *ptr_mv_x4_f, *ptr_mv_y4_f;
	short *ptr_mv_type4_b, *ptr_mv_x4_b, *ptr_mv_y4_b;	

	// Chrominance forward and backward motion vectors
	short *ptr_mv_type_uv_f, *ptr_mv_uvx_f, *ptr_mv_uvy_f;	
	short *ptr_mv_type_uv_b, *ptr_mv_uvx_b, *ptr_mv_uvy_b;
	
	// ***************************
	// Differential Motion Vectors
	// ***************************
/*	
	// for Delta Motion Vector
	short *ptr_dmvd_type1, *ptr_dmvd_x1, *ptr_dmvd_y1;	// motion vector of previous block
	short *ptr_dmvd_type2, *ptr_dmvd_x2, *ptr_dmvd_y2;	// motion vector of above block
	short *ptr_dmvd_type3, *ptr_dmvd_x3, *ptr_dmvd_y3;	// motion vector of upper right block

	// 1 Motion Vector case support - Baseline
	short *ptr_dmv_type01, *ptr_dmv_x01, *_dmv_y01;	// motion vector of previous block
	short *ptr_dmv_type02, *ptr_dmv_x02, *_dmv_y02;	// motion vector of above block
	short *ptr_dmv_type03, *ptr_dmv_x03, *_dmv_y03;	// motion vector of upper right block

	// 4 Motion Vector case support
	// Y1 Block
	short *ptr_dmv_type11, *ptr_dmv_x11, *ptr_dmv_y11;	// motion vector of previous block
	short *ptr_dmv_type12, *ptr_dmv_x12, *ptr_dmv_y12;	// motion vector of above block
	short *ptr_dmv_type13, *ptr_dmv_x13, *ptr_dmv_y13;	// motion vector of upper right block
	// Y2 block
	short *ptr_dmv_type21, *ptr_dmv_x21, *ptr_dmv_y21;	// motion vector of previous block
	short *ptr_dmv_type22, *ptr_dmv_x22, *ptr_dmv_y22;	// motion vector of above block
	short *ptr_dmv_type23, *ptr_dmv_x23, *ptr_dmv_y23;	// motion vector of upper right block
	// Y3 block
	short *ptr_dmv_type31, *ptr_dmv_x31, *ptr_dmv_y31;	// motion vector of previous block
	short *ptr_dmv_type32, *ptr_dmv_x32, *ptr_dmv_y32;	// motion vector of above block
	short *ptr_dmv_type33, *ptr_dmv_x33, *ptr_dmv_y33;	// motion vector of upper right block
	// Y4 block
	short *ptr_dmv_type41, *ptr_dmv_x41, *ptr_dmv_y41;	// motion vector of previous block
	short *ptr_dmv_type42, *ptr_dmv_x42, *ptr_dmv_y42;	// motion vector of above block
	short *ptr_dmv_type43, *ptr_dmv_x43, *ptr_dmv_y43;	// motion vector of upper right block
*/

	// Frame Pointers
	unsigned char *ptr_src_Y_c, *ptr_src_U_c, *ptr_src_V_c;
	short *ptr_src1_Y_s, *ptr_src1_U_s, *ptr_src1_V_s;
	short *ptr_src2_Y_s, *ptr_src2_U_s, *ptr_src2_V_s;
	
	
	// Initialize Pointers
	// Macroblock Header Information
	ptr_cmi = _cmi; ptr_flag_zero_mv = _flag_zero_mv;

	// Macroblock Coded Block Pattern
	ptr_mcbpc = _mcbpc; ptr_mcbpy = _mcbpy; ptr_mcbpb = _mcbpb;

	// Macroblock Parameters
	ptr_mtype = _mtype; ptr_mquant = _mquant; ptr_bquant = _bquant;

	// P Motion Vectors
	ptr_mv_type1 = _mv_type1; ptr_mv_x1 = _mv_x1; ptr_mv_y1 = _mv_y1;
	ptr_mv_type2 = _mv_type2; ptr_mv_x2 = _mv_x2; ptr_mv_y2 = _mv_y2;
	ptr_mv_type3 = _mv_type3; ptr_mv_x3 = _mv_x3; ptr_mv_y3 = _mv_y3;
	ptr_mv_type4 = _mv_type4; ptr_mv_x4 = _mv_x4; ptr_mv_y4 = _mv_y4;

	// Delta Motion Vector
	ptr_mvd_type = _mvd_type; ptr_mvd_x = _mvd_x; ptr_mvd_y = _mvd_y;

	// B Forward and Backward Motion Vectors
	ptr_mv_type1_f = _mv_type1_f; ptr_mv_x1_f = _mv_x1_f; ptr_mv_y1_f = _mv_y1_f;
	ptr_mv_type1_b = _mv_type1_b; ptr_mv_x1_b = _mv_x1_b; ptr_mv_y1_b = _mv_y1_b;	
	ptr_mv_type2_f = _mv_type2_f; ptr_mv_x2_f = _mv_x2_f; ptr_mv_y2_f = _mv_y2_f;
	ptr_mv_type2_b = _mv_type2_b; ptr_mv_x2_b = _mv_x2_b; ptr_mv_y2_b = _mv_y2_b;	
	ptr_mv_type3_f = _mv_type3_f; ptr_mv_x3_f = _mv_x3_f; ptr_mv_y3_f = _mv_y3_f;
	ptr_mv_type3_b = _mv_type3_b; ptr_mv_x3_b = _mv_x3_b; ptr_mv_y3_b = _mv_y3_b;	
	ptr_mv_type4_f = _mv_type4_f; ptr_mv_x4_f = _mv_x4_f; ptr_mv_y4_f = _mv_y4_f;
	ptr_mv_type4_b = _mv_type4_b; ptr_mv_x4_b = _mv_x4_b; ptr_mv_y4_b = _mv_y4_b;	

	// Chrominance forward and backward motion vectors
	ptr_mv_type_uv_f = _mv_type_uv_f; ptr_mv_uvx_f = _mv_uvx_f; ptr_mv_uvy_f = _mv_uvy_f;
	ptr_mv_type_uv_b = _mv_type_uv_b; ptr_mv_uvx_b = _mv_uvx_b; ptr_mv_uvy_b = _mv_uvy_b;
	
	// ***************************
	// Differential Motion Vectors
	// ***************************
	
	// for Delta Motion Vector
/*	ptr_dmvd_type1 = _dmvd_type1; ptr_dmvd_x1 = _dmvd_x1; ptr_dmvd_y1 = _dmvd_y1;
	ptr_dmvd_type2 = _dmvd_type2; ptr_dmvd_x2 = _dmvd_x2; ptr_dmvd_y2 = _dmvd_y2;
	ptr_dmvd_type3 = _dmvd_type3; ptr_dmvd_x3 = _dmvd_x3; ptr_dmvd_y3 = _dmvd_y3;

	// 1 Motion Vector case support - Baseline
	ptr_dmv_type01 = _dmv_type01; ptr_dmv_x01 = _dmv_x01; ptr_dmv_y01 = _dmv_y01;
	ptr_dmv_type02 = _dmv_type02; ptr_dmv_x02 = _dmv_x02; ptr_dmv_y02 = _dmv_y02;
	ptr_dmv_type03 = _dmv_type03; ptr_dmv_x03 = _dmv_x03; ptr_dmv_y03 = _dmv_y03;

	// 4 Motion Vector case support
	// Y1 Block
	ptr_dmv_type11 = _dmv_type11; ptr_dmv_x11 = _dmv_x11; ptr_dmv_y11 = _dmv_y11;
	ptr_dmv_type12 = _dmv_type12; ptr_dmv_x12 = _dmv_x12; ptr_dmv_y12 = _dmv_y12;
	ptr_dmv_type13 = _dmv_type13; ptr_dmv_x13 = _dmv_x13; ptr_dmv_y13 = _dmv_y13;
	// Y2 block
	ptr_dmv_type21 = _dmv_type21; ptr_dmv_x21 = _dmv_x21; ptr_dmv_y21 = _dmv_y21;
	ptr_dmv_type22 = _dmv_type22; ptr_dmv_x22 = _dmv_x22; ptr_dmv_y22 = _dmv_y22;
	ptr_dmv_type23 = _dmv_type23; ptr_dmv_x23 = _dmv_x23; ptr_dmv_y23 = _dmv_y23;
	// Y3 block
	ptr_dmv_type31 = _dmv_type31; ptr_dmv_x31 = _dmv_x31; ptr_dmv_y31 = _dmv_y31;
	ptr_dmv_type32 = _dmv_type32; ptr_dmv_x32 = _dmv_x32; ptr_dmv_y32 = _dmv_y32;
	ptr_dmv_type33 = _dmv_type33; ptr_dmv_x33 = _dmv_x33; ptr_dmv_y33 = _dmv_y33;
	// Y4 block
	ptr_dmv_type41 = _dmv_type41; ptr_dmv_x41 = _dmv_x41; ptr_dmv_y41 = _dmv_y41;
	ptr_dmv_type42 = _dmv_type42; ptr_dmv_x42 = _dmv_x42; ptr_dmv_y42 = _dmv_y42;
	ptr_dmv_type43 = _dmv_type43; ptr_dmv_x43 = _dmv_x43; ptr_dmv_y43 = _dmv_y43;
*/


	// Calculate offset to accomodate PB frame
	offset = 0;
	if (_PB_Ppicture_flag && P_picture) offset = _PB_offset;

	if (_fr_num < 186) return;

	// Frame Pointers
	ptr_src_Y_c = _shift_frame + offset;
	ptr_src_U_c = _shift_frame + _picture_size + offset;
	ptr_src_V_c = _shift_frame + _picture_size + _picture_size_quarter + offset;
	
	ptr_src1_Y_s = _fast_frame + offset;
	ptr_src1_U_s = _fast_frame + _picture_size + offset;
	ptr_src1_V_s = _fast_frame + _picture_size + _picture_size_quarter + offset;
	
	ptr_src2_Y_s = _recov_frame;
	ptr_src2_U_s = _recov_frame + _picture_size;
	ptr_src2_V_s = _recov_frame + _picture_size + _picture_size_quarter;


	for (i=0; i<_GOB_per_frame; i++) {
		for (j=0; j<_MB_per_gob; j++) {

			if (P_picture) fprintf(outptr, "\nB frame %i, GOB %i, Macroblock %i\n", _fr_num, i, j);
			else fprintf(outptr, "\nB frame %i, GOB %i, Macroblock %i\n", _fr_num-1, i, j);

			mtype = *ptr_mtype;
			q = (*ptr_mcbpy<<2) + *ptr_mcbpc;

			if (_PB_Ppicture_flag) {
				fprintf(outptr, "COD: %i MTYPE %i trb: %i trd %i\n", *ptr_cmi++, *ptr_mtype++, _trb, _trd);
			}
			else fprintf(outptr, "COD: %i MTYPE %i\n", *ptr_cmi++, *ptr_mtype++);

			fprintf(outptr, "MQUANT %i MCBPY %i MCBPC %i\n", *ptr_mquant++, *ptr_mcbpy++, *ptr_mcbpc++);
			if (_PB_Ppicture_flag && (!P_picture)) {
				q = *ptr_mcbpb++;
				fprintf(outptr, "BQUANT %i MCBPB %i\n", *ptr_bquant++, q);
			}


			// Motion Vectors
			if (_inter_frame_mode) {
				
				fprintf(outptr, " mv1(%i %i %i) ", *ptr_mv_type1++, *ptr_mv_x1++, *ptr_mv_y1++);
				
				if (_advanced_prediction_mode || _PB_Ppicture_flag) {
					fprintf(outptr, "mv2(%i %i %i) mv3(%i %i %i) mv4(%i %i %i)\n",
						*ptr_mv_type2++, *ptr_mv_x2++, *ptr_mv_y2++,
						*ptr_mv_type3++, *ptr_mv_x3++, *ptr_mv_y3++,
						*ptr_mv_type4++, *ptr_mv_x4++, *ptr_mv_y4++);
				} else fprintf(outptr, "\n");
			}

				
			if (_PB_Ppicture_flag) {
				fprintf(outptr, "*** Forward and Backward Motion Vectors ***\n");
				fprintf(outptr, " m1f(%i %i %i) m1b(%i %i %i) m2f(%i %i %i) m2b(%i %i %i)\n",
					*ptr_mv_type1_f++, *ptr_mv_x1_f++, *ptr_mv_y1_f++,
					*ptr_mv_type1_b++, *ptr_mv_x1_b++, *ptr_mv_y1_b++,	
					*ptr_mv_type2_f++, *ptr_mv_x2_f++, *ptr_mv_y2_f++,
					*ptr_mv_type2_b++, *ptr_mv_x2_b++, *ptr_mv_y2_b++);	
				fprintf(outptr, " m3f(%i %i %i) m3b(%i %i %i) m4f(%i %i %i) m4b(%i %i %i)\n",
					*ptr_mv_type3_f++, *ptr_mv_x3_f++, *ptr_mv_y3_f++,
					*ptr_mv_type3_b++, *ptr_mv_x3_b++, *ptr_mv_y3_b++,	
					*ptr_mv_type4_f++, *ptr_mv_x4_f++, *ptr_mv_y4_f++,
					*ptr_mv_type4_b++, *ptr_mv_x4_b++, *ptr_mv_y4_b++);	
				fprintf(outptr, " uvf(%i %i %i) uvb(%i %i %i)\n",
					*ptr_mv_type_uv_f++, *ptr_mv_uvx_f++, *ptr_mv_uvy_f++,
					*ptr_mv_type_uv_b++, *ptr_mv_uvx_b++, *ptr_mv_uvy_b++);
			}

/*			fprintf(outptr, "*** Differential Motion Vectors ***\n");
			fprintf(outptr, " -- Baseline Case -->>\n");
			fprintf(outptr, " dmv1(%i %i %i) dmv2(%i %i %i), dmv3(%i %i %i)\n",
				*ptr_dmv_type01++, *ptr_dmv_x01++, *ptr_dmv_y01++,
				*ptr_dmv_type02++, *ptr_dmv_x02++, *ptr_dmv_y02++,
				*ptr_dmv_type03++, *ptr_dmv_x03++, *ptr_dmv_y03++);
			fprintf(outptr, " -- 4 Motion Vector Case -->>\n");
			fprintf(outptr, " dmv11(%i %i %i) dmv12(%i %i %i) dmv13(%i %i %i)\n",
				*ptr_dmv_type11++, *ptr_dmv_x11++, *ptr_dmv_y11++,
				*ptr_dmv_type12++, *ptr_dmv_x12++, *ptr_dmv_y12++,
				*ptr_dmv_type13++, *ptr_dmv_x13++, *ptr_dmv_y13++);
			fprintf(outptr, " dmv21(%i %i %i) dmv22(%i %i %i) dmv23(%i %i %i)\n",
				*ptr_dmv_type21++, *ptr_dmv_x21++, *ptr_dmv_y21++,
				*ptr_dmv_type22++, *ptr_dmv_x22++, *ptr_dmv_y22++,
				*ptr_dmv_type23++, *ptr_dmv_x23++, *ptr_dmv_y23++);
			fprintf(outptr, " dmv31(%i %i %i) dmv32(%i %i %i) dmv33(%i %i %i)\n",
				*ptr_dmv_type31++, *ptr_dmv_x31++, *ptr_dmv_y31++,
				*ptr_dmv_type32++, *ptr_dmv_x32++, *ptr_dmv_y32++,
				*ptr_dmv_type33++, *ptr_dmv_x33++, *ptr_dmv_y33++);
			fprintf(outptr, " dmv41(%i %i %i) dmv42(%i %i %i) dmv43(%i %i %i)\n",
				*ptr_dmv_type41++, *ptr_dmv_x41++, *ptr_dmv_y41++,
				*ptr_dmv_type42++, *ptr_dmv_x42++, *ptr_dmv_y42++,
				*ptr_dmv_type43++, *ptr_dmv_x43++, *ptr_dmv_y43++);
			fprintf(outptr, " -- Delta Case -->>\n");
			if (_PB_Ppicture_flag) {
				fprintf(outptr, " dmvd1(%i %i %i) dmvd2(%i %i %i) dmvd3(%i %i %i)\n",
					*ptr_dmvd_type1++, *ptr_dmvd_x1++, *ptr_dmvd_y1++,
					*ptr_dmvd_type2++, *ptr_dmvd_x2++, *ptr_dmvd_y2++,
					*ptr_dmvd_type3++, *ptr_dmvd_x3++, *ptr_dmvd_y3++);
			}
*/
			// Residual Frame
			fprintf(outptr, "*** %d %i Residual -- Prediction -- Reconstruction Frame ***\n", q, offset);
			for (m=0; m<4; m++, q<<=1) {
				fprintf(outptr, "BLOCK %i\n", m);
				for (n=0; n<8; n++) {
					if ((q & 32) || (((mtype == INTRA) || (mtype == INTRAQ)) && P_picture)) {
						for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src1_Y_s++);
						fprintf(outptr, "\t");
					}
					else ptr_src1_Y_s += 8;
					if (!(((mtype == INTRA) || (mtype == INTRAQ)) && (P_picture == true))) {
						for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src_Y_c++);
						fprintf(outptr, "\t");
					}
					else ptr_src_Y_c += 8;
					for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src2_Y_s++);
					fprintf(outptr, "\n");
				}
			}
			fprintf(outptr, "BLOCK %i\n", m++);
			for (n=0; n<8; n++) {
				if ((q & 32) || (((mtype == INTRA) || (mtype == INTRAQ)) && P_picture)) {
					for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src1_U_s++);
					fprintf(outptr, "\t");
				}
				else ptr_src1_U_s += 8;
				if (!(((mtype == INTRA) || (mtype == INTRAQ)) && (P_picture == true))) {
					for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src_U_c++);
					fprintf(outptr, "\t");
				}
				else ptr_src_U_c += 8;
				for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src2_U_s++);
				fprintf(outptr, "\n");
			}
			fprintf(outptr, "BLOCK %i\n", m);
			for (n=0,q<<=1; n<8; n++) {
				if ((q & 32) || (((mtype == INTRA) || (mtype == INTRAQ)) && P_picture)) {
					for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src1_V_s++);
					fprintf(outptr, "\t");
				}
				else ptr_src1_V_s += 8;
				if (!(((mtype == INTRA) || (mtype == INTRAQ)) && (P_picture == true))) {
					for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src_V_c++);
					fprintf(outptr, "\t");
				}
				else ptr_src_V_c += 8;
				for (p=0; p<8; p++) fprintf(outptr, "%3i ", (int) *ptr_src2_V_s++);
				fprintf(outptr, "\n");
			}

		}	// for (j=0; j<_MB_per_gob; j++) {
	}	// for (i=0; i<_GOB_per_frame; i++) {
				
}


#endif


