
#ifndef __D_FRAME_DECODE_MB_C__
#define __D_FRAME_DECODE_MB_C__

#include "D_Frame.h"


/*
 * bool Entropy_Decoder::Decode_MB (PSC_Fifo& input)
 *
 * Entropy Decoding of the MB Layer
 *
 * Requires: Valid input Bitstream
 *           EDEBUG activates on-screen information
 *
 * Modifies: _cmi (COD as bool)
 *           _mv_x1, _mv_y1, _mv_type1 (Motion Vectors as integers)
 *                _mv_x1 and _mv_y1 are modified by _mv_type1
 *                _mv_type1 of 1 (no change)      _mv_type1 of 2 (_mv_x1 += 0.5)
 *                _mv_type1 of 3 (_mv_y1 += 0.5)   _mv_type1 of 4 (_mv_x1 += 0.5 and _mv_y1 += 0.5)
 *           _mcbpc, _mcbpy (Coded block patterns for Chrominance and Luminance as integers)
 *           _mquant (Current quantization level defined by Picture, GOB, and MB layers
 *           _zigzaged_central (Holds coefficient data read in from bitstream)
 *                first _picture_size bits are for the all 4 Y (Luminance) blocks
 *                   grouped first by the blocks, then by the macroblocks, and then by the gn
 *                the next _picture_size_quarter bits are for the U (Chrominance 1) block
 *                   grouped first by the macroblocks, and then by the gn
 *                and then the next _picture_size_quarter bits for the V (Chrominance 2) block
 *                   grouped first by the macroblocks, and then by the gn
 *           
 * Ensures:  Setting of variables and _zigzaged_central for correct decoding
 */
bool D_Frame::Decode_MB(PSC_Fifo& input) {
	int i, readblocks, blockind, mbaindex;
	short cbp, mtype, mcbpy, mcbpc, mcbpb, modb;
	short index, tx, ty, aipm;
	double median_x, median_y;
	short *zigzag_y, *zigzag_u, *zigzag_v;
	short *zigzag_y_pb, *zigzag_u_pb, *zigzag_v_pb;
	short dquant, bquant;
	short mv_x1, mv_y1, mv_type1;
	short mv_x2, mv_y2, mv_type2;
	short mv_x3, mv_y3, mv_type3;
	short mv_x4, mv_y4, mv_type4;
	short mv_xb, mv_yb, mv_typeb;
	short *blockptr;
	short blocks[780]; // Run, Level (The last coefficient is followed by a run of 65 and level of 0)
	bool mvdb_used = false;
	bool intra, coded;

	bquant = (short) 0;		// rid of compiler warning

	if (EDEBUG) { cout << "--> MB " << _ed_mba << endl; cout.flush(); }

	if (_slice_mode) mbaindex = _ed_mba;
	else mbaindex = (_ed_gn * _MB_per_gob) + _ed_mba;

	// COD - Coded Macroblock Indication - 1 bit (0 = coded, 1 = !coded)
	// Present only if MB Layer is not 'INTRA'
	if (_inter_frame_mode) {  // Is_inter?
		if (input.ReadBit()) {  // Sets MV to 0
			_cmi[mbaindex] = true;
			_mv_x1[mbaindex] = 0;
			_mv_y1[mbaindex] = 0;
			_mv_type1[mbaindex] = 1;
			_mcbpc[mbaindex] = 0;
			_mcbpy[mbaindex] = 0;
			_mtype[mbaindex] = 0;
			_mquant[mbaindex] = _ed_quant;
			// Advanced prediction mode variables
			if (_advanced_prediction_mode) _mtype[mbaindex] = 2;
			else _mtype[mbaindex] = 0;
			_mv_x2[mbaindex] = _mv_x3[mbaindex] = _mv_x4[mbaindex] = 0;
			_mv_y2[mbaindex] = _mv_y3[mbaindex] = _mv_y4[mbaindex] = 0;
			_mv_type2[mbaindex] = _mv_type3[mbaindex] = _mv_type4[mbaindex] = 1;
			// PB-frame mode variables
			_mcbpb[mbaindex] = 0;
			_bquant[mbaindex] = (short) (_ed_quant + (((_dbquant + 1) * _ed_quant) >> 2));
			_mvd_x[mbaindex] = _mvd_y[mbaindex] = 0;
			_mvd_type[mbaindex] = 1;
			if (EDEBUG) { cout << "COD 1" << endl; cout.flush(); }
			return (true);
		}
		if (EDEBUG) { cout << "COD 0" << endl; cout.flush(); }
	}

	// MCBPC - Macroblock type & Coded block pattern for chrominance - VLC
	// Changes needed: Mtype Stuffing needs to be supported
	if (_inter_frame_mode) {  // Is_inter?
		if (_MCBPCP_Tree->Read_Entry(&index, input)) {
			if (index == 20) {
				cout << "MCBPC: Mtype Stuffing not supported yet" << endl;
				return (false);
			}
			if (index > 20) { index--; }
			cbp = (short) (index & 3);
			mtype = (short) (index >> 2);
		}
		else {
			cout << "Invalid MCBPC P-picture entry" << endl;
			return (false);
		}
	}
	else {
		if (_MCBPCI_Tree->Read_Entry(&index, input)) {
			if (index == 8) {
				cout << "MCBPC: Mtype Stuffing not supported yet" << endl;
				return (false);
			}
			cbp = (short) (index & 3);
			mtype = (short) ((index >> 2) + 3);
		}
		else {
			cout << "Invalid MCBPC I-picture entry" << endl;
			return (false);
		}
	}
	mcbpc = cbp;
	if (EDEBUG) { cout << "MTYPE " << mtype << endl; cout.flush(); }
	if (EDEBUG) { cout << "CBPC " << ((cbp&2) > 0) << ((cbp&1) > 0) << endl; cout.flush(); }
	
	// INTRA_MODE - Prediction mode for AIC
	if (_advanced_intra_coding_mode && (mtype == INTRA || mtype == INTRAQ)){
		if (!input.ReadBit()) aipm = 0;
		else {
			if (!input.ReadBit()) aipm = 1;
			else aipm = 2;
		}
		if (EDEBUG) { cout << "INTRA_MODE " << aipm << endl; cout.flush(); }
	}
	else aipm = 0;

	// MODB - Macroblock mode for B-blocks - VLC
	modb = 0;
	mcbpb = 0;
	if (_PB_frame_mode) {	// Only present in PB-frames
		if (input.ReadBit()) {
			modb = (short) (input.ReadBit() + 1);
		}
		if (EDEBUG) { cout << "MODB " << modb << endl; cout.flush(); }

		// CBPB - Coded Block Pattern for B-blocks - 6 bits
		if (modb == 2) {
			input.ReadNBits(_ed_bits, 6);
			for (i=0; i<6; i++) {
				mcbpb = (short) ((mcbpb << 1) + _ed_bits[i]);
			}
			if (EDEBUG) { cout << "CBPB " << _ed_bits[0] << _ed_bits[1] << _ed_bits[2] <<
				_ed_bits[3] << _ed_bits[4] << _ed_bits[5] << endl; cout.flush(); }
		}
	}

	// CBPY - Coded Block Pattern for Luminance - VLC
	if (_CBPY_Tree->Read_Entry(&index, input)) {
		if (_alternative_inter_vlc_mode && (mtype <= 2 || mtype == 5) && (mcbpc == 3)) {
			cbp = (short) (cbp + (index << 2));
		}
		else if (mtype <= 2 || mtype == 5) { cbp = (short) (cbp + ((15-index) << 2)); }  // Is this an inter block?
		else { cbp = (short) (cbp + (index << 2)); }
	}
	else {
		cout << "Invalid CBPY entry" << endl;
		return (false);
	}
	mcbpy = (short) (cbp >> 2);
	if (EDEBUG) { cout << "CBPY " << ((cbp&32) > 0) << ((cbp&16) > 0) << ((cbp&8) > 0)
		<< ((cbp&4) > 0) << endl; cout.flush(); }

	// DQUANT - Quantizer Information - 2 bits
	// This will be executed depending on the MCBPC
	if (mtype == 1 || mtype >= 4) {
		if (input.ReadBit()) { dquant = (short) (_ed_quant + (input.ReadBit() + 1)); }
		else { dquant = (short) (_ed_quant - (input.ReadBit() + 1)); }
		if (EDEBUG) { cout << "DQUANT " << dquant << endl; cout.flush(); }
	}
	else dquant = _ed_quant;
	if (_PB_frame_mode) bquant = (short) (dquant + (((_dbquant + 1) * dquant) >> 2));

	// MVD - Motion Vector Data - VLC
	if (mtype < 3 || mtype == 5 || _PB_frame_mode) { // PB mode always has MVDs
		if (mtype == INTER4V || mtype == INTER4VQ) {
			_MB_list[mbaindex].Median_Predictor_1(&median_x, &median_y);
		}
		else _MB_list[mbaindex].Median_Predictor(&median_x, &median_y, false);

		// Grab values
		if (_MVD_Tree->Read_Entry(&index, input)) {
			tx = (short) ((median_x*2) + index-32);
			if (tx < -32 || tx > 31) {
				if (index < 32) tx += 64;
				else tx -= 64;
			}
			mv_type1 = (short) (abs(tx % 2) + 1);
		}
		else {
			cout << "Invalid MVDx entry" << endl;
			return (false);
		}
		if (_MVD_Tree->Read_Entry(&index, input)) {
			ty = (short) ((median_y*2) + index-32);
			if (ty < -32 || ty > 31) {
				if (index < 32) ty += 64;
				else ty -= 64;
			}
			mv_type1 = (short) (mv_type1 + abs((ty % 2) * 2));
		}
		else {
			cout << "Invalid MVDy entry" << endl;
			return (false);
		}

		if (tx >= 0) mv_x1 = (short) (tx >> 1);
		else mv_x1 = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_y1 = (short) (ty >> 1);
		else mv_y1 = (short) ((int) ((ty/2.0) - 0.5));

		if (EDEBUG) { cout << "MVD " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_type1
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }
	}
	else {	// Case 1: When MB is in INTRA mode
		mv_x1 = 0;
		mv_y1 = 0;
		mv_type1 = 1;
	}

	// MVD2-4 - Motion Vector Data - VLC
	if (mtype == INTER4V || mtype == INTER4VQ) {	// Only present if MTYPE says so
		_MB_list[mbaindex].Median_Predictor_2(mv_x1, mv_y1, mv_type1,
			&median_x, &median_y);
		
		// MVD2
		if (_MVD_Tree->Read_Entry(&index, input)) {
			tx = (short) ((median_x*2) + index-32);
			if (tx < -32 || tx > 31) {
				if (index < 32) tx += 64;
				else tx -= 64;
			}
			mv_type2 = (short) (abs(tx % 2) + 1);
		}
		else {
			cout << "Invalid MVDx entry" << endl;
			return (false);
		}
		if (_MVD_Tree->Read_Entry(&index, input)) {
			ty = (short) ((median_y*2) + index-32);
			if (ty < -32 || ty > 31) {
				if (index < 32) ty += 64;
				else ty -= 64;
			}
			mv_type2 = (short) (mv_type2 + abs((ty % 2) * 2));
		}
		else {
			cout << "Invalid MVDy entry" << endl;
			return (false);
		}
		if (tx >= 0) mv_x2 = (short) (tx >> 1);
		else mv_x2 = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_y2 = (short) (ty >> 1);
		else mv_y2 = (short) ((int) ((ty/2.0) - 0.5));
		if (EDEBUG) { cout << "MVD2 " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_type2
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }

		// MVD3
		_MB_list[mbaindex].Median_Predictor_3(mv_x1, mv_y1, mv_type1,
			mv_x2, mv_y2, mv_type2, &median_x, &median_y);

		if (_MVD_Tree->Read_Entry(&index, input)) {
			tx = (short) ((median_x*2) + index-32);
			if (tx < -32 || tx > 31) {
				if (index < 32) tx += 64;
				else tx -= 64;
			}
			mv_type3 = (short) (abs(tx % 2) + 1);
		}
		else {
			cout << "Invalid MVDx entry" << endl;
			return (false);
		}
		if (_MVD_Tree->Read_Entry(&index, input)) {
			ty = (short) ((median_y*2) + index-32);
			if (ty < -32 || ty > 31) {
				if (index < 32) ty += 64;
				else ty -= 64;
			}
			mv_type3 = (short) (mv_type3 + abs((ty % 2) * 2));
		}
		else {
			cout << "Invalid MVDy entry" << endl;
			return (false);
		}
		if (tx >= 0) mv_x3 = (short) (tx >> 1);
		else mv_x3 = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_y3 = (short) (ty >> 1);
		else mv_y3 = (short) ((int) ((ty/2.0) - 0.5));
		if (EDEBUG) { cout << "MVD3 " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_type3
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }

		// MVD4
		_MB_list[mbaindex].Median_Predictor_4(mv_x1, mv_y1, mv_type1,
			mv_x2, mv_y2, mv_type2, mv_x3, mv_y3, mv_type3,
			&median_x, &median_y);

		if (_MVD_Tree->Read_Entry(&index, input)) {
			tx = (short) ((median_x*2) + index-32);
			if (tx < -32 || tx > 31) {
				if (index < 32) tx += 64;
				else tx -= 64;
			}
			mv_type4 = (short) (abs(tx % 2) + 1);
		}
		else {
			cout << "Invalid MVDx entry" << endl;
			return (false);
		}
		if (_MVD_Tree->Read_Entry(&index, input)) {
			ty = (short) ((median_y*2) + index-32);
			if (ty < -32 || ty > 31) {
				if (index < 32) ty += 64;
				else ty -= 64;
			}
			mv_type4 = (short) (mv_type4 + abs((ty % 2) << 1));
		}
		else {
			cout << "Invalid MVDy entry" << endl;
			return (false);
		}
		if (tx >= 0) mv_x4 = (short) (tx >> 1);
		else mv_x4 = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_y4 = (short) (ty >> 1);
		else mv_y4 = (short) ((int) ((ty/2.0) - 0.5));
		if (EDEBUG) { cout << "MVD4 " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_type4
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }
	}
	else {
		mv_x4 = mv_x3 = mv_x2 = mv_x1;
		mv_y4 = mv_y3 = mv_y2 = mv_y1;
		mv_type4 = mv_type3 = mv_type2 = mv_type1;
	}

	// MVDB - Motion Vector Data for B-macroblock - (Variable Length)
	if (modb >= 1) {	// If MODB says MVDB is present
		_MB_list[mbaindex].Median_Predictor(&median_x, &median_y, true);

		if (_MVD_Tree->Read_Entry(&index, input)) {
			tx = (short) ((median_x*2) + index-32);
			if (tx < -32 || tx > 31) {
				if (index < 32) tx += 64;
				else tx -= 64;
			}
			mv_typeb = (short) (abs(tx % 2) + 1);
		}
		else {
			cout << "Invalid MVDx entry" << endl;
			return (false);
		}
		if (_MVD_Tree->Read_Entry(&index, input)) {
			ty = (short) ((median_y*2) + index-32);
			if (ty < -32 || ty > 31) {
				if (index < 32) ty += 64;
				else ty -= 64;
			}
			mv_typeb = (short) (mv_typeb + abs((ty % 2) << 1));
		}
		else {
			cout << "Invalid MVDy entry" << endl;
			return (false);
		}
		if (tx >= 0) mv_xb = (short) (tx >> 1);
		else mv_xb = (short) ((int) ((tx/2.0) - 0.5));
		if (ty >= 0) mv_yb = (short) (ty >> 1);
		else mv_yb = (short) ((int) ((ty/2.0) - 0.5));

		if (!_coded_mvd_flag) {
			if ((mv_xb != 0) || (mv_yb != 0) || (mv_typeb != 1)) mvdb_used = true;
		}
		if (EDEBUG) { cout << "MVDB " << tx/2.0 << "," << ty/2.0 << " TYPE" << mv_typeb
			<< " - Median " << median_x << "," << median_y << endl; cout.flush(); }
	}
	else {
		mv_xb = 0;
		mv_yb = 0;
		mv_typeb = 1;
	}

	blockptr = blocks;

	// Block Layer **************************************************
	intra = (mtype == INTRA || mtype == INTRAQ);
	if (_PB_frame_mode) { readblocks = 12; cbp = (short) ((cbp << 6) + mcbpb); }
	else { readblocks = 6; cbp = (short) (cbp << 6); }
	for (blockind = 0; blockind < readblocks; blockind++, cbp <<= 1) {
		coded = ((cbp & 2048) > 0);
		if (EDEBUG) { cout << "Block " << blockind << " -> "; cout.flush(); }
		if (!Decode_Block(input, blockptr, (blockind < 6) && intra, coded)) return (false);
		blockptr += 64;
	} // for (blockind = 0; blockind < 6; blockind++, cbp <<= 1)

	// Save the values ************************************************************
	_cmi[mbaindex] = false;
	_mcbpc[mbaindex] = mcbpc;
	_mtype[mbaindex] = mtype;
	_mcbpb[mbaindex] = mcbpb;
	_mcbpy[mbaindex] = mcbpy;
	_ed_quant = dquant;
	_mquant[mbaindex] = dquant;
	_mv_x1[mbaindex] = mv_x1;
	_mv_y1[mbaindex] = mv_y1;
	_mv_type1[mbaindex] = mv_type1;
	_mv_x2[mbaindex] = mv_x2;
	_mv_y2[mbaindex] = mv_y2;
	_mv_type2[mbaindex] = mv_type2;
	_mv_x3[mbaindex] = mv_x3;
	_mv_y3[mbaindex] = mv_y3;
	_mv_type3[mbaindex] = mv_type3;
	_mv_x4[mbaindex] = mv_x4;
	_mv_y4[mbaindex] = mv_y4;
	_mv_type4[mbaindex] = mv_type4;
	_mvd_x[mbaindex] = mv_xb;
	_mvd_y[mbaindex] = mv_yb;
	_mvd_type[mbaindex] = mv_typeb;
	if (mvdb_used) {
		_coded_mvd_flag = true;
		D_GOB::_coded_mvd_flag = true;
		D_Slice::_coded_mvd_flag = true;
		D_Macroblock::_coded_mvd_flag = true;
	}

	zigzag_y = _zigzaged_central + (mbaindex << 8);
	zigzag_u = _zigzaged_central + _picture_size + (mbaindex << 6);
	zigzag_v = zigzag_u + _picture_size_quarter;

	blockptr = blocks;

	if (_PB_frame_mode) {
		zigzag_y_pb = zigzag_y + _PB_offset;
		zigzag_u_pb = zigzag_u + _PB_offset;
		zigzag_v_pb = zigzag_v + _PB_offset;
		_bquant[mbaindex] = bquant;
		for (blockind = 0; blockind < 256; blockind++) *zigzag_y_pb++ = *blockptr++;
		for (blockind = 0; blockind < 64; blockind++) *zigzag_u_pb++ = *blockptr++;
		for (blockind = 0; blockind < 64; blockind++) *zigzag_v_pb++ = *blockptr++;
	}

	for (blockind = 0; blockind < 256; blockind++) *zigzag_y++ = *blockptr++;
	for (blockind = 0; blockind < 64; blockind++) *zigzag_u++ = *blockptr++;
	for (blockind = 0; blockind < 64; blockind++) *zigzag_v++ = *blockptr++;

	// For AIC
	if (_advanced_intra_coding_mode) {
		_MB_list[mbaindex]._advanced_intra_prediction_mode = aipm;
	}

	return (true);
}


#endif

