
#ifndef __D_FRAME_DECODE_HEADER_C__
#define __D_FRAME_DECODE_HEADER_C__

#include "D_Frame.h"


/*
 * bool D_Frame::Decode_Header(PSC_Fifo& input) {
 *
 * Decodes Header bits
 *
 * Requires: Valid input Bitstream
 *
 * Modifies: input is popped only if a PSC or GOB is found
 *           
 * Ensures:  Proper header identification
 */
bool D_Frame::Decode_Header(PSC_Fifo& input, bool &want_header) {
	int i, j;
	int zeros_count;

	if (_syntax_arithmetic_coding_mode) {
		if (input.FoundHeader()) {
			want_header = false;
			input.ResetFifo();
			input.PeekNBits(_ed_bits,5); // PSC requires 5 reset bits
			_ed_header = 0;
			for (i = 0; i < 5; i++) {
				_ed_header = (short) ((_ed_header << 1) + _ed_bits[i]); // Either a PSC or GOB
			}
			if (_slice_mode & (_ed_header != 0)) return (true); // If it's a SSC
			else input.ReadNBits(_ed_bits,5);
			return (true);
		}
		else if (!want_header) {
			_ed_header = -1;
			return false;
		}
	}

	while (true) {
		// Take into consideration optional byte aligning
		zeros_count = 0;
		input.PeekNBits(_ed_bits,25);	// Look ahead to see if it's a MB
		
		// Count how many zeros that we have seen when peeking
		for(i = 0; !_ed_bits[i]; i++, zeros_count++) {
			if (zeros_count > 23) {
				_ed_header = -31;  // Must be EOF (All zeros)
				return (false);
			}
		}

		if (_syntax_arithmetic_coding_mode) {
			zeros_count += input.GetZeroRun();
			input.ResetFifo();
		}
		
		if (zeros_count < 16) { // Must be a MB
			_ed_header = (short) -i;
			if (!want_header) return (false);
			else {
				// The bitstream starts with one's, get rid of them
				if (i == 0) {
					for (j = 0; _ed_bits[j]; j++);
					input.ReadNBits(_ed_bits, j);
				}
				// The zeros are not enough to be a header, get rid of them
				else input.ReadNBits(_ed_bits, i);
			}
		}

		else { // Must be a header
			want_header = false;
			input.ReadNBits(_ed_bits,i+1); // It's okay to pop bits now
			input.PeekNBits(_ed_bits,5); // PSC requires 5 reset bits
			_ed_header = 0;
			for (i = 0; i < 5; i++) {
				_ed_header = (short) ((_ed_header << 1) + _ed_bits[i]); // Either a PSC or GOB
			}
			if (_slice_mode & (_ed_header != 0)) return (true); // If it's a SSC
			else input.ReadNBits(_ed_bits,5);
			return (true);
		}
	}
}


#endif

