
#ifndef __D_FRAME_DECODE_GOB_C__
#define __D_FRAME_DECODE_GOB_C__

#include "D_Frame.h"


/*
 * bool Entropy_Decoder::Decode_GOB (PSC_Fifo& input)
 *
 * Entropy Decoding of the GOB Layer
 * This layer is optional which affects the treatment of the Median Prediction
 * of the Motion Vectors for this GOB
 *
 * Requires: Valid input Bitstream
 *           EDEBUG activates on-screen information
 *
 * Modifies: quant (Quantization value for rest of picture)
 *           
 * Ensures:  Setting of quantization levels and treatment of motion vectors for GOB
 */
bool D_Frame::Decode_GOB(PSC_Fifo& input) {
	int i,j;

	// GN - Group Number - 5 bits
	// Changes needed: must handle skipped group numbers
	_ed_gn = _ed_header;
	if (_ed_gn > _max_gn) { // _max_gn holds (# of GOB's in a pciture) - 1
		cout << "Exceeded Maximum GN: " << _ed_gn << endl;
		return (false);
	}
	if (EDEBUG) { cout << "-> GOB " << _ed_gn << endl; cout.flush(); }

	// GFID - GOB Frame ID - 2 bits
	// Changes needed: must handle when gfid is different
	_ed_gfid = 0;
	input.ReadNBits(_ed_bits,2);
	for (i = 0; i < 2; i++) {
		_ed_gfid = (_ed_gfid << 1) + _ed_bits[i];
	}
	if (EDEBUG) { cout << "GFID " << _ed_gfid << endl; cout.flush(); }

	// GQUANT - Quantizer Information - 5 bits
	_ed_quant = 0;
	input.ReadNBits(_ed_bits,5);
	for (i = 0; i < 5; i++) {
		_ed_quant = (short) ((_ed_quant << 1) + _ed_bits[i]);
	}
	if (EDEBUG) { cout << "GQUANT " << _ed_quant << endl; cout.flush(); }

	// Receive Reference Picture Selection Mode info
	if (_reference_picture_selection) {
		// TRI - Temporal Reference Indicator - 1 bit
		if (input.ReadBit()) {	// (BCM must be implemented)
			input.ReadNBits(_ed_bits, 8);
			for (i=0,j=0; i<8; i++) {
				j = (j<<1) + _ed_bits[i];
			}
			cout << "Ignoring TRI: Decoder does not support GOBs from other TRs" << endl;
			if (EDEBUG) { cout << "GTR " << j << endl; cout.flush(); }
		}

		// TRPI - Temporal reference for prediction indication - 1 bit
		if (input.ReadBit()) {
			// TRP - Temporal Reference for Prediction - 10 bits
			input.ReadNBits(_ed_bits,10);
			
			if (_ed_bits[0] || _ed_bits[1]) {
				cout << "Invalid TRP: Decoder does not support custom PCFs" << endl;
				return (false);
			}
			for (i=2, j=0; i<10; i++) {
				j = (j<<=1) + _ed_bits[i];
			}
			i = _ed_tr - j;
			if (i < 0) i += 256;
			*(_trp+_ed_gn) = i;
			if (EDEBUG) { cout << "GTRP " << j << " - TRP " << *(_trp+_ed_gn) << endl; cout.flush(); }
		}
		else *(_trp+_ed_gn) = 0;

		// BCI - Back-Channel message indication - Variable Length
		if (input.ReadBit()) {
			cout << "Invalid BCI: Decoder does not support Back-Channel messages" << endl;
			return (false);
		}
		else input.ReadBit();
	}

	return (true);
}


#endif

