#ifndef __D_FRAME_DECODE_BLOCK_C__
#define __D_FRAME_DECODE_BLOCK_C__

#include "D_Frame.h"

/*
 * bool Entropy_Decoder::Decode_Block(short *symbols, short& numcoeffs)
 *
 * Entropy Decoding of the Block Layer
 *
 * Requires: Valid input Bitstream
 *           EDEBUG activates on-screen information
 *
 * Modifies: 
 * Ensures:  
 */

bool D_Frame::Decode_Block(PSC_Fifo& input, short *symbols, bool intra, bool coded) {
	int i, count;
	short index, run, level;
	short coeffs[128]; // Run, length (After last coeff, run = 65, level = 0;
	short AICcoeffs[128]; // Run, length
	short *coeffsptr, *AICcoeffsptr;
	int AIV_NR, Norm_NR;
	short numcoeffs;
	bool last;
	bool sign;

	count = 0;
	if (intra && !_advanced_intra_coding_mode) { // Process INTRADC
		// INTRADC not a special case for Advanced Intra Coding Mode
		// INTRADC - DC Coefficient for INTRA blocks - 8 bits
		// Only present for MB Types #3 or #4
		level = 0;
		input.ReadNBits(_ed_bits,8);
		for (i = 0; i < 8; i++) {
			level = (short) ((level << 1) + _ed_bits[i]);
		}
		if (level == 0 || level == 128) {
			cout << "Invalid INTRADC: " << level << endl;
			return(false);
		}
		*symbols++ = level;
		count++;
		if (EDEBUG) { cout << "INTRADC " << level << " "; cout.flush(); }
	}

	if (coded) {
		// If AIV or AIC is on...
		if ((_alternative_inter_vlc_mode && !intra) || (_advanced_intra_coding_mode && intra)) {
			coeffsptr = coeffs;
			AICcoeffsptr = AICcoeffs;
			AIV_NR = 0; Norm_NR = 0;
			numcoeffs = 0;
			last = false;
			
			// TCOEF - Transform coefficient - VLC
			while (!last && (AIV_NR < 64 || Norm_NR < 64)) {
				if(_TCOEF_Tree->Read_Entry(&index, input)) {
					if (index == 102) { // FLC coding
						last = input.ReadBit();		// Last
						run = 0;					// Run
						input.ReadNBits(_ed_bits,6);
						for (i = 0; i < 6; i++) {
							run = (short) ((run << 1) + _ed_bits[i]);
						}
						level = 0;					// Level
						input.ReadNBits(_ed_bits,8);
						if (_ed_bits[0]) level = -1;
						for (i = 1; i < 8; i++) {
							level = (short) ((level << 1) + _ed_bits[i]);
						}
						if (level == 0) {
							cout << "TCOEF FLC level is 0" << endl;
							return (false);
						}
						*AICcoeffsptr++ = *coeffsptr++ = run;
						*AICcoeffsptr++ = *coeffsptr++ = level;
						AIV_NR += run + 1; Norm_NR += run + 1;
						if (EDEBUG) cout << "(E " << *(AICcoeffsptr-2) << "," << *(AICcoeffsptr-1) << ") ";
					}
					else {
						last = (index > 57);		// Last
						sign = input.ReadBit();		// Sign

						run = _RunLevel[index][0];	// Run
						*coeffsptr++ = run;
						level = _RunLevel[index][1];	// Level
						if (sign) level = (short) -level; // Sign
						*coeffsptr++ = level;
						Norm_NR += run + 1;
						if (EDEBUG) cout << "(N " << *(coeffsptr-2) << "," << *(coeffsptr-1) << ") ";

						run = _AIC_RunLevel[index][0]; // Run
						*AICcoeffsptr++ = run;
						level = _AIC_RunLevel[index][1];	// Level
						if (sign) level = (short) -level; // Sign
						*AICcoeffsptr++ = level;
						AIV_NR += run + 1;
						if (EDEBUG) cout << "(A " << *(AICcoeffsptr-2) << "," << *(AICcoeffsptr-1) << ") ";
					}
				}
				else {
					cout << "Invalid TCOEF" << endl;
					return (false);
				}
				if (EDEBUG) cout << "(" << AIV_NR << ") ";
				numcoeffs++;
			} // while (count < max_count)
			if (EDEBUG) cout << endl;

			// Check for AIC
			if (_advanced_intra_coding_mode && intra) {
				if (AIV_NR > 64) {
					cout << "Overflow of Run Length" << endl;
					return (false);
				}
				coeffsptr = AICcoeffs;
				if (EDEBUG) { cout << "AIC: "; }
			}
			// Must be AIC or Normal VLC
			else if (Norm_NR > 64) { // Normal VLC failed
				if (AIV_NR > 64) {
					cout << "Overflow of Run Length" << endl;
					return (false);
				}
				coeffsptr = AICcoeffs;
				if (EDEBUG) { cout << "AIV: "; }
			}
			// Must be Normal VLC
			else coeffsptr = coeffs;

			for (index = 0; index < numcoeffs; index++) {
				run = *coeffsptr++;
				for (i=0; i < run; i++) {
					*symbols++ = 0;
					if (EDEBUG) { cout << "0 "; cout.flush(); }
				}
				*symbols++ = level = *coeffsptr++;
				count += run + 1;
				if (EDEBUG) { cout << level << " "; cout.flush(); }
			}
			if (EDEBUG) { cout << "LAST" << count-1 << endl; cout.flush(); }
			while (count < 64) { // Fill zeros after last
				*symbols++ = 0;
				count++;
			}
		}
		
		/******************************************************/
		// Normal operation
		else {
			// TCOEF - Transform coefficient - VLC
			while (count < 64) {
				if(_TCOEF_Tree->Read_Entry(&index, input)) {
					if (index == 102) { // FLC coding
						last = input.ReadBit();		// Last
						run = 0;					// Run
						input.ReadNBits(_ed_bits,6);
						for (i = 0; i < 6; i++) {
							run = (short) ((run << 1) + _ed_bits[i]);
						}
						level = 0;					// Level
						input.ReadNBits(_ed_bits,8);
						if (_ed_bits[0]) level = -1;
						for (i = 1; i < 8; i++) {
							level = (short) ((level << 1) + _ed_bits[i]);
						}
						if (level == 0) {
							cout << "TCOEF FLC level is 0" << endl;
							return (false);
						}
					}
					else {
						last = (index > 57);		// Last
						run = _RunLevel[index][0];	// Run
						level = _RunLevel[index][1];	// Level
						if (input.ReadBit()) level = (short) -level; // Sign
					}
				}
				else {
					cout << "Invalid TCOEF" << endl;
					return (false);
				}
				// Check for overflow of run lengths
				if ((run + count) > 63) {
					cout << "Overflow of Run Length" << endl;
					return (false);
				}
				for (i=0; i < run; i++) { // Fill in zeros defined by run
					*symbols++ = 0;
					if (EDEBUG) { cout << "0 "; cout.flush(); }
				}
				*symbols++ = level;
				count += run + 1;
				if (EDEBUG) { if (index == 102) cout << "E"; cout << level << " "; cout.flush(); }
				if (last) {
					if (EDEBUG) { cout << "LAST" << count-1 << endl; cout.flush(); }
					while (count < 64) { // Fill zeros after last
						*symbols++ = 0;
						count++;
					}
				}
			} // while (count < max_count)
		} // if (cbp & 32)
	}
	else { // Zero out this block
		while (count < 64) {
			*symbols++ = 0;
			count++;
		}
		if (EDEBUG) { cout << endl; cout.flush(); }
	}

	return (true);
}

#endif