
#ifndef __D_FRAME_DECODE_BIT_C__
#define __D_FRAME_DECODE_BIT_C__

#include "D_Frame.h"
#include "SAC.h"
#include "PSC_Fifo.h"
#include "Serialdecoder.h"

extern HWND          ghWndTTY;

/*
 * bool D_Frame::Decode_Bit (PSC_Fifo& input, yuv_video *yuv_post)
 * Finite state machine which controls whether the next bits are
 * a Picture Layer, GOB Layer, or MB Layer
 *
 * Requires: input Bitstream and yuv_video object
 *           EDEBUG activates on-screen information
 *
 * Modifies: _fr_num (Frame number)
 *           _zigzaged_central (bitstream data)
 *           _fast_frame (coefficients or residues)
 *           _shift_frame (last frame motion compensated)
 *           
 * Ensures:  Calls Header_Decode() to see what is header is next on the bitstream
 *           It will call either Picture_Decode(), GOB_Decode(), or MB_Decode().
 *           If the bitstream EOF, then it will stop
 *           After each frame is completed, decoding, motion compensation,
 *           subpixel interpolation, and output to a YUV file is done
 */
bool D_Frame::Decode_Bit(PSC_Fifo& input) {
	D_GOB *ptr_GOB;
	int i;
	int skip;
	yuv_video yuv_post;
	char output[150];

	_fr_num = -1;
	_ME_enabled = true;
	_psc_found = false;	// One PSC must be shown at least once
	_want_header = false;

	while (1) {
		// Headers - PSC & EOS & GBSC
		// PSC - Picture Start Code - 22 bits - (byte aligned)
		// 0000 0000 0000 0000 1 00000
		// EOS - End of Sequence - 22 bits - (optionally byte aligned) Optional
		// 0000 0000 0000 0000 1 11111
		// GSBC - Group of Block Start Code - 16 bits (Optionally byte aligned) Optional
		// 0000 0000 0000 0000 1
		// Changes needed: Need to make sure PSC is byte aligned
		if (Decode_Header(input, _want_header)) { // Find out what header is next on the bitstream
			if (_ed_header == 0) {	// If header is a PSC
				if (_syntax_arithmetic_coding_mode & _Created_Data_Structures) {
					input.Disable_SAC_Zero_Run();
					sac->reset=false;
				}
				if (_fr_num > -1) {	// Process zigzaged_central after the 1st frame is read in
					if (!_rectangular_submode)
						_slice_size[_ed_gn] = (short) (_ed_mba - _slice_MBA[_ed_gn]);

					skip = _ed_tr - _ed_last_tr;
					if (skip < 0) skip += 256;
					_trd = skip;

					if (_PB_frame_mode) {
						_PB_conditions_checked = true;
						_PB_Ppicture_flag = true;
						D_GOB::_PB_Ppicture_flag = true;
						D_Macroblock::_PB_Ppicture_flag = true;
						for (i = 0; i < _trb-1; i++) {	// Skip frames here up to B frame
							sprintf(output, "YUV (skipped frame)\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						}

						if (_inter_frame_mode) {
							if(_advanced_prediction_mode) Make_OPMC_Frame(false);
							else Temporal_Prediction_Module();
						}

						// Decode P-pictures
						sprintf(output, "D-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB(true);
							ptr_GOB++;
						}
						sprintf(output, "MC-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						Image_Recovery_Module(true);
						//Deblocking_Filter();      // For improved PB frame later
						Transform_1D_To_2D(true);

						sprintf(output, "Subpixel-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						if(_advanced_prediction_mode) 
							Make_UMV_Padded_Frame(_decoded_frame);
						Subpixel_Interpolation_Module();

						// Decode B-pictures
						Interpolate_Bpicture_Motion_Vectors();
						Temporal_Prediction_Module(true);
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB(false);
							ptr_GOB++;
						}
						Image_Recovery_Module(false);		// Reconstruct B-picture
						Transform_1D_To_2D(false);			// map 1D decoded frame to 2D representation for B picture

						// Dump a frame to yuv_post object
						sprintf(output, "B-picture-> YUV\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);

						sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						// Dump(true);

						for (i = _trd - _trb - 1; i > 0; i--) {	// Skip frames here up to B frame
							sprintf(output, "YUV (skipped frame)\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						}
						memcpy(_decoded_frame, (_decoded_frame + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_half_full, (_decoded_frame_half_full + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_full_half, (_decoded_frame_full_half + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_half_half, (_decoded_frame_half_half + _PB_offset), sizeof(unsigned char) * _buffer_size);

						// Dump a P-picture to yuv_post object
						sprintf(output, "P-picture-> YUV\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
					}
					else {
						for (; skip > 1; skip--) {	// Skip frames here
							sprintf(output, "YUV (skipped frame)\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						}

						if (_slice_mode) {
							_SLICE_per_frame = _ed_gn + 1;
							if (_arbitrary_order_submode) Sort_Segment(0, _SLICE_per_frame-1);
						}

						if (_inter_frame_mode) {
							if(_advanced_prediction_mode) {
								Make_OPMC_Frame(false);
							}
							else Temporal_Prediction_Module();
						}
						else {
							Reset_Segment();
							Update_Segment();
						}
						sprintf(output, "D-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB();
							ptr_GOB++;
						}
						sprintf(output, "MC-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						Image_Recovery_Module();
						if ( _deblocking_filter_mode) {
							Deblocking_Filter();
						}
						Transform_1D_To_2D();
						// Dump();
						sprintf(output, "Subpixel-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						if(_advanced_prediction_mode && !_reference_picture_selection) {
							Make_UMV_Padded_Frame(_decoded_frame);
						}
						Subpixel_Interpolation_Module();
						if (_reference_picture_selection) StoreDecodedFrames();
						// Dump a frame to yuv_post object
						sprintf(output, "YUV\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
					}
				}
				sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
				_ed_last_tr = _ed_tr;
				_ed_last_ptype = _ed_ptype;
				if (EDEBUG) { sprintf(output, "Decoded PSC\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output)); }
				if (!Decode_Picture(input, yuv_post)) {
					sprintf(output, "(sync) "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
					_want_header = true; // Entropy Decode Picture Data
				}
				else _psc_found = true;
				_ed_gn = 0; _ed_last_gn = 0;
				_ed_mba = 0;
				if (_slice_mode) {	// Since first slice follows Picture Layer
					if (!Decode_Slice(input, true)) {
						sprintf(output, "(sync) "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						_want_header = true; // Entropy Decode Slice Data
					}
				}
			}
			else if (_ed_header == 31) { // If header is EOS
				_psc_found = false;
				if (EDEBUG) { sprintf(output, "Decoded EOS\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output)); }
			}
			else { // Positive values
				if (_psc_found) {  // If header is GOB or a Slice
					if (_syntax_arithmetic_coding_mode){
						input.Disable_SAC_Zero_Run();
						sac->reset=false;
					}
					if (_slice_mode) {
						if (!_rectangular_submode) _slice_size[_ed_gn] = (short) (_ed_mba - _slice_MBA[_ed_gn]);
						_ed_gn++;
						if (EDEBUG) { sprintf(output, "Decoded SLICE %d\n\r", _ed_gn); OutputABufferToWindow(ghWndTTY, output, strlen(output)); }
						if (!Decode_Slice(input, false)) {
							sprintf(output, "(sync) "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							_want_header = true; // Entropy Decode Slice Data
						}
					}
					else {
						_ed_last_gn = _ed_gn;
						if (EDEBUG) { sprintf(output, "Decoded GOB %d\n\r", _ed_header); OutputABufferToWindow(ghWndTTY, output, strlen(output)); }
						if (!Decode_GOB(input)) {
							sprintf(output, "(sync) "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							_want_header = true; // Entropy Decode GOB Data
						}
						_ed_mba = 0;
						_cgi[_ed_gn] = true;
					}
				}
				else {
					if (_slice_mode) { sprintf(output, "Decoded GOB: PSC expected\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output)); }
					else sprintf(output, "Decoded SLICE: PSC expected\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
					sprintf(output, "(sync) "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
					_want_header = true;
				}
			}
		}
		else { // No header exists
			if (_ed_header == -31) {  // EOF - Process last frame and exit
				if (_fr_num > -1) { // Process zigzaged_central after the 1st frame is read in
					if (!_rectangular_submode)
						_slice_size[_ed_gn] = (short) (_ed_mba - _slice_MBA[_ed_gn]);
				
					skip = _ed_tr - _ed_last_tr;
					if (skip < 0) skip += 256;
					_trd = skip;

					if (_PB_frame_mode) {
						_PB_conditions_checked = true;
						_PB_Ppicture_flag = true;
						D_GOB::_PB_Ppicture_flag = true;
						D_Macroblock::_PB_Ppicture_flag = true;
						for (i = 0; i < _trb-1; i++) {	// Skip frames here up to B frame
							sprintf(output, "YUV (skipped frame)\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						}

						if (_inter_frame_mode) {
							if(_advanced_prediction_mode) Make_OPMC_Frame(false);
							else Temporal_Prediction_Module();
						}

						// Decode P-pictures
						sprintf(output, "D-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB(true);
							ptr_GOB++;
						}
						sprintf(output, "MC-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						Image_Recovery_Module(true);
						//Deblocking_Filter();   // For improved PB frame later
						Transform_1D_To_2D(true);

						sprintf(output, "Subpixel-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						if(_advanced_prediction_mode) 
							Make_UMV_Padded_Frame(_decoded_frame);
						Subpixel_Interpolation_Module();

						// Decode B-pictures
						Interpolate_Bpicture_Motion_Vectors();
						Temporal_Prediction_Module(true);
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB(false);
							ptr_GOB++;
						}
						Image_Recovery_Module(false);		// Reconstruct B-picture
						Transform_1D_To_2D(false);			// map 1D decoded frame to 2D representation for B picture


						// Dump a frame to yuv_post object
						sprintf(output, "B-picture-> YUV\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);

						sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						// Dump(true);
						for (i = _trd - _trb - 1; i > 0; i--) {	// Skip frames here up to B frame
							sprintf(output, "YUV (skipped frame)\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						}
						memcpy(_decoded_frame, (_decoded_frame + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_half_full, (_decoded_frame_half_full + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_full_half, (_decoded_frame_full_half + _PB_offset), sizeof(unsigned char) * _buffer_size);
						memcpy(_decoded_frame_half_half, (_decoded_frame_half_half + _PB_offset), sizeof(unsigned char) * _buffer_size);

						// Dump a P-picture to yuv_post object
						sprintf(output, "P-picture-> YUV\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
					}
					else {
						for (; skip > 1; skip--) {	// Skip frames here
							sprintf(output, "YUV (skipped frame)\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							yuv_post.Set_Y(_fr_num, _decoded_frame);
							yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
							yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
							sprintf(output, "Frame %3d-> ", ++_fr_num); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						}

						if (_slice_mode) {
							_SLICE_per_frame = _ed_gn + 1;
							if (_arbitrary_order_submode) Sort_Segment(0, _SLICE_per_frame-1);
						}

						if (_inter_frame_mode) {
							if(_advanced_prediction_mode) {
								Make_OPMC_Frame(false);
							}
							else Temporal_Prediction_Module();
						}
						else {
							Reset_Segment();
							Update_Segment();
						}
						sprintf(output, "D-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						ptr_GOB = _GOB_list;
						for (i=0; i<_GOB_per_frame; i++) {
							ptr_GOB->Decode_GOB();
							ptr_GOB++;
						}
						sprintf(output, "MC-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						Image_Recovery_Module();
						if ( _deblocking_filter_mode) {
							Deblocking_Filter();
						}
						Transform_1D_To_2D();
						//Dump(false);

						sprintf(output, "Subpixel-> "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						if(_advanced_prediction_mode && !_reference_picture_selection) {
							Make_UMV_Padded_Frame(_decoded_frame);
						}
						Subpixel_Interpolation_Module();

						// Dump a frame to yuv_post object
						sprintf(output, "YUV\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
						yuv_post.Set_Y(_fr_num, _decoded_frame);
						yuv_post.Set_U(_fr_num, _decoded_frame + _picture_size);
						yuv_post.Set_V(_fr_num, _decoded_frame + _picture_size + _picture_size_quarter);
					}
				}
				sprintf(output, "Bitstream ended\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output));
				return(true);
			}
			else {
				if (_psc_found) {  // Must be a MB
					// Test for invalid mba values
					if (_slice_mode) {
						if (_ed_mba > (_GOB_per_frame*_MB_per_gob) - 1) {
							sprintf(output, "Exceeded Maximum MBA: %d\n\r(sync) ", _ed_mba); OutputABufferToWindow(ghWndTTY, output, strlen(output));
							_want_header = true;
						}
						if (_rectangular_submode) {
							if (_ed_mba > (_slice_size[_ed_gn]+_slice_MBA[_ed_gn]-1)) {
								sprintf(output, "Exceeded Maximum SWI of Slice %d\n\r(sync) ", _ed_gn); OutputABufferToWindow(ghWndTTY, output, strlen(output));
								_want_header = true;
							}
						}
					}
					else {
						if (_ed_mba > _max_mba) { // _max_mba holds (# of MB's in a GOB) - 1
							_ed_last_gn = _ed_gn;
							if (++_ed_gn > _max_gn) { // _max_gn holds (# of GOB's in a picture) - 1
								sprintf(output, "Exceed Maximum GN: %d\n\r(sync) ", _ed_gn); OutputABufferToWindow(ghWndTTY, output, strlen(output));
								_want_header = true;
							}
							_ed_mba = 0;
							_cgi[_ed_gn] = false;
							_trp[_ed_gn] = _trp[_ed_gn-1];
							if (EDEBUG) { sprintf(output, "-> GOB %d\n\r", _ed_gn); OutputABufferToWindow(ghWndTTY, output, strlen(output)); }
						}
					}
					if (EDEBUG) { sprintf(output, "Decoded MB\n\r"); OutputABufferToWindow(ghWndTTY, output, strlen(output)); }
					if (!_want_header) {
						if (_syntax_arithmetic_coding_mode){
							if (sac->reset == false){
								input.Enable_SAC_Zero_Run();
								sac->decoder_reset(input);
								sac->reset = true;
							}
							if (!SAC_Decode_MB(input, sac)) {
								sprintf(output, "(sync) "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
								// Something is wrong, search for a header
								_want_header = true;
							}
							else if ((_max_gn == _ed_gn) && (_max_mba == _ed_mba))
								_want_header = true;
							else _ed_mba++;
						}
						else {
							if (!Decode_MB(input)) {
								// Something is wrong, search for a header
								sprintf(output, "(sync) "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
								_want_header = true;
							}
							else if ((_max_gn == _ed_gn) && (_max_mba == _ed_mba))
								_want_header = true;
							else _ed_mba++;
						}
					}
				}
				else {
					sprintf(output, "Decoded MB: PSC expected\n\r(sync) "); OutputABufferToWindow(ghWndTTY, output, strlen(output));
					_want_header = true;
				}
			}
		}
	}
}


#endif

