#ifndef __D_FRAME_DEBLOCKING_FILTER_C__
#define __D_FRAME_DEBLOCKING_FILTER_C__

#include "D_Frame.h"

/*
 * void D_Frame::Deblocking_Filter(viod)
 *
 * Optional block edge filter
 * to reduce luminance and chrominance blocking artifacts
 *
 * Requires:  D_Frame::Image_Recovery_Module(void) must be
 *            called immediately before the use of this method. 
 *
 * Modifies:  _recov_frame
 * Ensures:   sets of four pixel values on horizontal and vertical
 *            block boundaries are filtered in case of the required
 *            conditions fulfilled. 
 *
 */

void D_Frame::Deblocking_Filter(void)
{

	int i, j, k, m, n, ij;
	bool *ptr_cmi;
	short *ptr_mtype, *ptr_mquant;
	short *ptr_df_Y_s, *ptr_df_U_s, *ptr_df_V_s;
	short *four_p, tmp_four[4];
	int pa;
	short _bbquant;

	// Initializing pointers
	ptr_cmi = _cmi;
	ptr_mtype = _mtype;
	ptr_mquant = _mquant;
	ptr_df_Y_s = _recov_frame;
	ptr_df_U_s = _recov_frame + _picture_size;
	ptr_df_V_s = _recov_frame + _picture_size + _picture_size_quarter;
	four_p = tmp_four;

    // Deblocking a frame
	for (i=0; i<_GOB_per_frame; i++)
	{
		for (j=0; j<_MB_per_gob; j++) 
		{
			// Deblocking edges related to a macroblock
			ij = i*_GOB_per_frame + j;

			// If current macroblock is a coded one
			if (*(ptr_cmi + ij) == 0 || *(ptr_mtype +ij) == 3 || *(ptr_mtype +ij) == 4)
			{
				_bbquant = *(ptr_mquant + ij);

				// Filtering luminance blocks
				for (k=0; k<4; k++)
				{
					// Across a horizontal luminance edge
					if (i==0 && k<2);
					else
					{
						for (m=0; m<8; m++)
						{
							pa = 176 - 256 * _MB_per_gob;   
							if (k==2||k==3) pa = -80;       
						 	*(four_p) = *(ptr_df_Y_s + pa);
					        *(four_p + 1) = *(ptr_df_Y_s + pa + 8);
    	 				    *(four_p + 2) = *(ptr_df_Y_s);
				  			*(four_p + 3) = *(ptr_df_Y_s + 8);
					    	_DF_Four_Pixels(four_p, _bbquant);
						    *(ptr_df_Y_s + pa) = *(four_p);
				    		*(ptr_df_Y_s + pa + 8) = *(four_p + 1);
						  	*(ptr_df_Y_s) = *(four_p + 2);
						    *(ptr_df_Y_s + 8) = *(four_p + 3);
  
    						ptr_df_Y_s++;
						}

						ptr_df_Y_s -= 8;
				
					}

					// Across a vertical luminance edge
			    	if (j==0 && (k==0 || k==2)) ptr_df_Y_s += 64;
				    else
					{
						for (m=0; m<8; m++)
						{
							pa = - 186;                      
							if (k==1||k==3) pa = - 58;       
		    				*(four_p) = *(ptr_df_Y_s + pa);
			    		    *(four_p + 1) = *(ptr_df_Y_s + pa + 1);
						    *(four_p + 2) = *(ptr_df_Y_s);
						    *(four_p + 3) = *(ptr_df_Y_s + 1);
							_DF_Four_Pixels(four_p, _bbquant);
    	    				*(ptr_df_Y_s + pa) = *(four_p);
		        			*(ptr_df_Y_s + pa + 1) = *(four_p + 1);
						   	*(ptr_df_Y_s) = *(four_p + 2);
					 	    *(ptr_df_Y_s + 1) = *(four_p + 3);

				        	ptr_df_Y_s += 8;
						}
					}
				}
				
                // Filtering chrominance across a horizontal edge
                if (i==0);
    			else
				{
					for (n=0; n<8; n++)
					{
						pa = 48 - 64 * _MB_per_gob;     

						// Filtering chrominance U
						*(four_p) = *(ptr_df_U_s + pa);
					    *(four_p + 1) = *(ptr_df_U_s + pa + 8);
   	 					*(four_p + 2) = *(ptr_df_U_s);
					    *(four_p + 3) = *(ptr_df_U_s + 8);
						_DF_Four_Pixels(four_p, _bbquant);
   						*(ptr_df_U_s + pa) = *(four_p);
	    				*(ptr_df_U_s + pa + 8) = *(four_p + 1);
		        		*(ptr_df_U_s) = *(four_p + 2);
				        *(ptr_df_U_s + 8) = *(four_p + 3);

						ptr_df_U_s ++;
	
 				    	// Filtering chrominance V
						*(four_p) = *(ptr_df_V_s + pa);
				        *(four_p + 1) = *(ptr_df_V_s + pa + 8);
   	 				    *(four_p + 2) = *(ptr_df_V_s);
	    				*(four_p + 3) = *(ptr_df_V_s + 8);
					   	_DF_Four_Pixels(four_p, _bbquant);
   						*(ptr_df_V_s + pa) = *(four_p);
    				 	*(ptr_df_V_s + pa + 8) = *(four_p + 1);
						*(ptr_df_V_s) = *(four_p + 2);
					    *(ptr_df_V_s + 8) = *(four_p + 3);

						ptr_df_V_s ++;
					}
					
					ptr_df_U_s -= 8;
					ptr_df_V_s -= 8;
				}
			
                // Filtering chrominance across a vertical edge
				if (j==0)
				{
					ptr_df_U_s += 64;
					ptr_df_V_s += 64;
				}
				else
				{

					for (n=0; n<8; n++)
					{
				
						pa = - 58;                           

	   					// Filtering chrominance U
						*(four_p) = *(ptr_df_U_s + pa);
					    *(four_p + 1) = *(ptr_df_U_s + pa + 1);
	   				    *(four_p + 2) = *(ptr_df_U_s);
	    				*(four_p + 3) = *(ptr_df_U_s + 1);
		        		_DF_Four_Pixels(four_p, _bbquant);
						*(ptr_df_U_s + pa) = *(four_p);
	       				*(ptr_df_U_s + pa + 1) = *(four_p + 1);
						*(ptr_df_U_s) = *(four_p + 2);
	    				*(ptr_df_U_s + 1) = *(four_p + 3);

						ptr_df_U_s += 8;
	
		   				// Filtering chrominance V
						*(four_p) = *(ptr_df_V_s + pa);
	   				    *(four_p + 1) = *(ptr_df_V_s + pa + 1);
	   				    *(four_p + 2) = *(ptr_df_V_s);
	    			    *(four_p + 3) = *(ptr_df_V_s + 1);
	        			_DF_Four_Pixels(four_p, _bbquant);
	        			*(ptr_df_V_s + pa) = *(four_p);
		       			*(ptr_df_V_s + pa + 1) = *(four_p + 1);
					 	*(ptr_df_V_s) = *(four_p + 2);
	    				*(ptr_df_V_s + 1) = *(four_p + 3);

						ptr_df_V_s += 8;

					}

				}

			}

			// Current macroblock is not a coded one.
			else
			{
				// If the macroblock right above the current one is coded
				if((i != 0) && (*(ptr_cmi + ij - _MB_per_gob) == 0 || *(ptr_mtype + ij - _MB_per_gob) 
					== 3 || *(ptr_mtype + ij - _MB_per_gob) == 4))
				{
					_bbquant = *(ptr_mquant + ij - 11);
					
					// Filtering horizontal luminance edges
					for (k=0; k<2; k++)
					{
						for (m=0; m<8; m++)
						{
							pa = 176 - 256 * _MB_per_gob;        
						 	*(four_p) = *(ptr_df_Y_s + pa);
					        *(four_p + 1) = *(ptr_df_Y_s + pa + 8);
    	 				    *(four_p + 2) = *(ptr_df_Y_s);
				  			*(four_p + 3) = *(ptr_df_Y_s + 8);
					    	_DF_Four_Pixels(four_p, _bbquant);
						    *(ptr_df_Y_s + pa) = *(four_p);
				    		*(ptr_df_Y_s + pa + 8) = *(four_p + 1);
						  	*(ptr_df_Y_s) = *(four_p + 2);
						    *(ptr_df_Y_s + 8) = *(four_p + 3);
  
    						ptr_df_Y_s++;
						}

						ptr_df_Y_s -= 8;
					}
				
					// Filtering horizontal chrominance edges
					for (n=0; n<8; n++)
					{
						pa = 48 - 64 * _MB_per_gob;     

						// Filtering chrominance U
						*(four_p) = *(ptr_df_U_s + pa);
					    *(four_p + 1) = *(ptr_df_U_s + pa + 8);
   	 					*(four_p + 2) = *(ptr_df_U_s);
					    *(four_p + 3) = *(ptr_df_U_s + 8);
						_DF_Four_Pixels(four_p, _bbquant);
   						*(ptr_df_U_s + pa) = *(four_p);
	    				*(ptr_df_U_s + pa + 8) = *(four_p + 1);
		        		*(ptr_df_U_s) = *(four_p + 2);
				        *(ptr_df_U_s + 8) = *(four_p + 3);

						ptr_df_U_s ++;
	
 				    	// Filtering chrominance V
						*(four_p) = *(ptr_df_V_s + pa);
				        *(four_p + 1) = *(ptr_df_V_s + pa + 8);
   	 				    *(four_p + 2) = *(ptr_df_V_s);
	    				*(four_p + 3) = *(ptr_df_V_s + 8);
					   	_DF_Four_Pixels(four_p, _bbquant);
   						*(ptr_df_V_s + pa) = *(four_p);
    				 	*(ptr_df_V_s + pa + 8) = *(four_p + 1);
						*(ptr_df_V_s) = *(four_p + 2);
					    *(ptr_df_V_s + 8) = *(four_p + 3);

						ptr_df_V_s ++;
					}
					
					ptr_df_U_s -= 8;
					ptr_df_V_s -= 8;

				}

				// If the macroblock immediately before the current one is coded
				if((j != 0) && (*(ptr_cmi + ij - 1) == 0 || *(ptr_mtype + ij - 1) == 3 ||
					*(ptr_mtype + ij - 1) == 4))
				{

					_bbquant = *(ptr_mquant + ij - 1);
					
					// Filtering vertical luminance edges
					for (k=0; k<2; k++)
					{
						for (m=0; m<8; m++)
						{
							pa = - 186;                           
		    				*(four_p) = *(ptr_df_Y_s + pa);
			    		    *(four_p + 1) = *(ptr_df_Y_s + pa + 1);
						    *(four_p + 2) = *(ptr_df_Y_s);
						    *(four_p + 3) = *(ptr_df_Y_s + 1);
							_DF_Four_Pixels(four_p, _bbquant);
    	    				*(ptr_df_Y_s + pa) = *(four_p);
		        			*(ptr_df_Y_s + pa + 1) = *(four_p + 1);
						   	*(ptr_df_Y_s) = *(four_p + 2);
					 	    *(ptr_df_Y_s + 1) = *(four_p + 3);

				        	ptr_df_Y_s += 8;
						}

						ptr_df_Y_s += 64;
					}
			
                    // Filtering vertical chrominance edges
					for (n=0; n<8; n++)
					{
				
						pa = - 58;                              

	   					// Filtering chrominance U
						*(four_p) = *(ptr_df_U_s + pa);
					    *(four_p + 1) = *(ptr_df_U_s + pa + 1);
	   				    *(four_p + 2) = *(ptr_df_U_s);
	    				*(four_p + 3) = *(ptr_df_U_s + 1);
		        		_DF_Four_Pixels(four_p, _bbquant);
						*(ptr_df_U_s + pa) = *(four_p);
	       				*(ptr_df_U_s + pa + 1) = *(four_p + 1);
						*(ptr_df_U_s) = *(four_p + 2);
	    				*(ptr_df_U_s + 1) = *(four_p + 3);

						ptr_df_U_s += 8;
	
		   				// Filtering chrominance V
						*(four_p) = *(ptr_df_V_s + pa);
	   				    *(four_p + 1) = *(ptr_df_V_s + pa + 1);
	   				    *(four_p + 2) = *(ptr_df_V_s);
	    			    *(four_p + 3) = *(ptr_df_V_s + 1);
	        			_DF_Four_Pixels(four_p, _bbquant);
	        			*(ptr_df_V_s + pa) = *(four_p);
		       			*(ptr_df_V_s + pa + 1) = *(four_p + 1);
					 	*(ptr_df_V_s) = *(four_p + 2);
	    				*(ptr_df_V_s + 1) = *(four_p + 3);

						ptr_df_V_s += 8;

					}

				}

				// No filtering applied to the current macroblock
				else
				{
					ptr_df_Y_s += 256;
					ptr_df_U_s += 64;
					ptr_df_V_s += 64;
				}
			}
		}

	}
	
}
	
	
/*
 * void D_Frame::_DF_Four_Pixels(short *four_p, short _bbquant)
 *
 * Filtering a set of four pixel values on a edge
 *
 *
 */

void D_Frame::_DF_Four_Pixels(short *four_p, short _bbquant)
{
	short _strength;
	short A, B, C, D;
	short d, d1, d2;

	if (_bbquant < 9)
		_strength = (short) ((_bbquant + 1) / 2);
	else
	{
		if (_bbquant < 14)
			_strength = (short) (_bbquant / 2);
		else _strength = (short) ((_bbquant + 7) / 3);
	}

	A = *(four_p);
	B = *(four_p + 1);
	C = *(four_p + 2);
	D = *(four_p + 3);
	
	d = (short)((A - 4 * B + 4 * C - D) / 8);
	d1 = _DF_UpDownRamp(d, _strength);
	d2 = _DF_Clip_d1((short) (( A - D) / 4), (short) (d1 / 2));

	*(four_p) = (short) (A - d2);
	*(four_p + 1) = _DF_Clip((short)(B + d1));
	*(four_p + 2) = _DF_Clip((short)(C - d1));
    *(four_p + 3) = (short) (D + d2);

}

/*
 * short D_Frame::_DF_Clip(short x)
 *
 * Clipping x outside [0, 255] to 0 or 255
 *
 *
 */
short D_Frame::_DF_Clip(short x)
{
	short y;
	y = (short)((x < 0 )?   0 : ((x < 255) ?  x : 255));
	return y;
}

/*
 * short D_Frame::_DF_Clip_d1(short x, short lim)
 *
 * Clipping x outside [-lim, lim] to -lim or lim
 *
 *
 */
short D_Frame::_DF_Clip_d1(short x, short lim)
{
	short y;
	lim = _DF_abs(lim);
	y = (short)((x < -lim )?  -lim : ((x < lim) ?  x : lim));
	return y;
}

/*
 * short D_Frame::_DF_UpDownRamp(short x, short s)
 *
 * A special function defined in Annex J
 * to filter pixel values on a edge.
 *
 */
short D_Frame::_DF_UpDownRamp(short x, short s)
{
	short y;
	y = _DF_Max0((short)(2 * (_DF_abs(x) - s)));
	y = _DF_Max0((short)(_DF_abs(x) - y));
	y = (short)(_DF_Sign(x) * y);
	return y;
}

/*
 * short D_Frame::_DF_Max0(short x)
 *
 * Picking up the bigger value in 0 and x
 *
 *
 */
short D_Frame::_DF_Max0(short x)
{
	short y;
	y = (short)((x < 0 )?   0 : x);
	return y;
}

/*
 * short D_Frame::_DF_abs(short x)
 *
 * Taking the absolute value of x
 *
 *
 */
short D_Frame::_DF_abs(short x)
{
	short y;
	y = (short)((x < 0 )?   -x : x);
	return y;
}

/*
 * short D_Frame::_DF_Sign(short x)
 *
 * Taking the sign value of x
 *
 *
 */
short D_Frame::_DF_Sign(short x)
{
	short y;
	y = (short)((x < 0 )?   -1 : 1);
	return y;
}


#endif






