
#ifndef __D_FRAME_CREATE_DATA_STRUCTURE_C__
#define __D_FRAME_CREATE_DATA_STRUCTURE_C__

#include "D_Frame.h"


/*
 * D_Frame::Create_Data_Structure(void)
 * 
 * Create Data Structures given CIF type
 *
 * Requires:	nothing
 * Modifies:	_frame_xsize, D_Macroblock::_sformat
 *				_MB_per_gob, _MB_Y_offset, _MB_UV_offset
 *				_MB_list
 * Ensures:		. Set (_frame_xsize, D_Macroblock::ptype) according to picture format 
 *				. _MB_per_gob dynamically set according to picture format
 *				. _MB_Y_offset = 256
 *				. _MB_UV_offset = 64
 *				. _MB_list is dynamically allocated according to picture format
 *
 * Warning:		
 */
void D_Frame::Create_Data_Structure(const bool encode) {
	
	D_GOB *ptr_GOB;
	D_Slice *ptr_SLICE;
	D_Macroblock *ptr_MB;
	int i, j, k;
	short *ptr_s1, *ptr_s2;

	_encode_mode = encode;
	D_GOB::_encode_mode = encode;
	D_Macroblock::_encode_mode = encode;
	D_Slice::_encode_mode = encode;
	D_Block::_encode_mode = encode;

	switch (_sformat) {
	case (SQCIF):
		_frame_xsize = SQCIFX;
		_frame_ysize = SQCIFY;
		_MB_per_gob    = SQCIFX >> 4;
		_GOB_per_frame = SQCIFY >> 4;
		break;
	case (QCIF):
		_frame_xsize = QCIFX;
		_frame_ysize = QCIFY;
		_MB_per_gob    = QCIFX >> 4;
		_GOB_per_frame = QCIFY >> 4;
		break;
	case (CIF):
		_frame_xsize = CIFX;
		_frame_ysize = CIFY;
		_MB_per_gob    = CIFX >> 4;
		_GOB_per_frame = CIFY >> 4;
		break;
	case (CIF4):
		_frame_xsize = CIFX4;
		_frame_ysize = CIFY4;
		_MB_per_gob    = CIFX4 >> 4;
		_GOB_per_frame = CIFY4 >> 4;
		break;
	case (CIF16):
		_frame_xsize = CIFX16;
		_frame_ysize = CIFY16;
		_MB_per_gob    = CIFX16 >> 4;
		_GOB_per_frame = CIFY16 >> 4;
		break;
	}
	
	_frame_xsize_half = (_frame_xsize >> 1);
	_frame_ysize_half = (_frame_ysize >> 1);	
	_picture_size = (_frame_xsize * _frame_ysize);
	_picture_size_quarter = (_picture_size >> 2);
	_buffer_size = _picture_size + (_picture_size_quarter << 1);
	_PB_offset = _buffer_size;


	// Pass class information to lower class
	D_GOB::_sformat = _sformat;
	D_GOB::_PB_frame_mode = _PB_frame_mode;
	D_GOB::_PB_offset = _PB_offset;
	D_GOB::_coded_mvd_flag = _coded_mvd_flag;
	D_GOB::_advanced_prediction_mode = _advanced_prediction_mode;
	D_GOB::_reference_picture_selection = _reference_picture_selection;
	D_Block::_alternative_inter_vlc_mode = _alternative_inter_vlc_mode;
	D_Macroblock::_advanced_intra_coding_mode = _advanced_intra_coding_mode;
	D_Block::_advanced_intra_coding_mode = _advanced_intra_coding_mode;
	D_GOB::_syntax_arithmetic_coding_mode = _syntax_arithmetic_coding_mode;
	D_Slice::_syntax_arithmetic_coding_mode = _syntax_arithmetic_coding_mode;
	

	// Replicate Slice code here
	D_Slice::_sformat = _sformat;
	D_Slice::_PB_frame_mode = _PB_frame_mode;
	D_Slice::_PB_offset = _PB_offset;
	D_Slice::_coded_mvd_flag = _coded_mvd_flag;
	D_Slice::_advanced_prediction_mode = _advanced_prediction_mode;

	// Allocate memory for GOB layer
	_cgi = new bool[_GOB_per_frame];
	_GOB_Y_offset =  (_picture_size/_GOB_per_frame);
	_GOB_UV_offset = (_GOB_Y_offset >> 2);
	_GOB_list = new D_GOB[_GOB_per_frame];

	// Allocate memory for Slice layer
	if (_encode_mode) _SLICE_per_frame = _GOB_per_frame << 1;
	else _SLICE_per_frame = _MB_per_gob *_GOB_per_frame;
	_SLICE_list = new D_Slice[_SLICE_per_frame];
	_slice_size = new short[_SLICE_per_frame];
	_slice_MBA =  new short[_SLICE_per_frame];
	
	// Insertion @ Codec v3.0; structural changes
	// Allocate memory for all Macroblocks and Blocks
	_MB_list = new D_Macroblock[_MB_per_gob *_GOB_per_frame];
	if (_encode_mode && !_PB_frame_mode)
		_BLK_list = new D_Block[_MB_per_gob * _GOB_per_frame * 6];
	else _BLK_list = new D_Block[_MB_per_gob * _GOB_per_frame * 12];

	// Modified insertion in Codec v.3
	ptr_GOB = _GOB_list;
	ptr_MB = _MB_list;
	for (i=0; i<_GOB_per_frame; i++) {
		ptr_GOB->Create_Data_Structure(ptr_MB);
		ptr_GOB++;
		ptr_MB += _MB_per_gob;
	}

	// Hard coded, very bad
	ptr_SLICE = _SLICE_list;
	ptr_MB = _MB_list;
	ptr_s1 = _slice_size;
	ptr_s2 = _slice_MBA;
	_Segment_per_frame = _SLICE_per_frame;
	
	if (_slice_mode & _encode_mode) {
		for (i=0, j=0, k=0; i<_SLICE_per_frame; i+=2) {
			
			j = _MB_per_gob - 1 - ((j * _GOB_per_frame) + i + 1) % _MB_per_gob;
			if (j <= 0) j = 1;

			ptr_SLICE++->Create_Data_Structure(ptr_MB);
			*ptr_s1++ = (short) j; 	*ptr_s2++ = (short) k;
			ptr_MB += j;
			k += j;
			j = _MB_per_gob - j;
			
			ptr_SLICE++->Create_Data_Structure(ptr_MB);
			*ptr_s1++ = (short) j; 	*ptr_s2++ = (short) k;
			ptr_MB += j;
			k += j;
		}
	}

	
	// Allocate memory for Macroblock layer
	_cmi = new bool[_MB_per_gob * _GOB_per_frame];
	_flag_zero_mv = new bool[_MB_per_gob * _GOB_per_frame];
	_mcbpc  = new short[_MB_per_gob * _GOB_per_frame];
	_mcbpy  = new short[_MB_per_gob * _GOB_per_frame];
	_mquant = new short[_MB_per_gob * _GOB_per_frame];
	_mtype  = new short[_MB_per_gob * _GOB_per_frame];


	// Insertion @ Codec v3.0; structural changes
	// Allocate memory for video segment data
	_fake_ID =		new short(-1);
	_seg_ID =		new short[_MB_per_gob * _GOB_per_frame];
	_seg_size =		new short[_MB_per_gob * _GOB_per_frame];
	_right_span =	new short[_MB_per_gob * _GOB_per_frame];
	_left_span  =	new short[_MB_per_gob * _GOB_per_frame];
	
	_mvx0_low =		new short[_MB_per_gob * _GOB_per_frame];
	_mvx1_low =		new short[_MB_per_gob * _GOB_per_frame];
	_mvx2_low =		new short[_MB_per_gob * _GOB_per_frame];
	_mvx3_low =		new short[_MB_per_gob * _GOB_per_frame];
	_mvx4_low =		new short[_MB_per_gob * _GOB_per_frame];

	_mvx0_high =	new short[_MB_per_gob * _GOB_per_frame];
	_mvx1_high =	new short[_MB_per_gob * _GOB_per_frame];
	_mvx2_high =	new short[_MB_per_gob * _GOB_per_frame];
	_mvx3_high =	new short[_MB_per_gob * _GOB_per_frame];
	_mvx4_high =	new short[_MB_per_gob * _GOB_per_frame];

	_mvy0_low =		new short[_MB_per_gob * _GOB_per_frame];
	_mvy1_low =		new short[_MB_per_gob * _GOB_per_frame];
	_mvy2_low =		new short[_MB_per_gob * _GOB_per_frame];
	_mvy3_low =		new short[_MB_per_gob * _GOB_per_frame];
	_mvy4_low =		new short[_MB_per_gob * _GOB_per_frame];

	_mvy0_high =	new short[_MB_per_gob * _GOB_per_frame];
	_mvy1_high =	new short[_MB_per_gob * _GOB_per_frame];
	_mvy2_high =	new short[_MB_per_gob * _GOB_per_frame];
	_mvy3_high =	new short[_MB_per_gob * _GOB_per_frame];
	_mvy4_high =	new short[_MB_per_gob * _GOB_per_frame];
	
	_x_bound_low =	new short[_MB_per_gob * _GOB_per_frame];
	_x_bound_high =	new short[_MB_per_gob * _GOB_per_frame];
	_y_bound_low =	new short[_MB_per_gob * _GOB_per_frame];
	_y_bound_high =	new short[_MB_per_gob * _GOB_per_frame];

	_mvx_border_high = new bool[_MB_per_gob * _GOB_per_frame];
	_mvy_border_high = new bool[_MB_per_gob * _GOB_per_frame];
	_mvx_border_low = new bool[_MB_per_gob * _GOB_per_frame];
	_mvy_border_low = new bool[_MB_per_gob * _GOB_per_frame];


	// 4 motion vectors are ALWAYS created
	// Necessary to support standalone decoder
	// No advance knowledge of encoding options...
	_mv_type1 = new short[_MB_per_gob * _GOB_per_frame];
	_mv_x1    = new short[_MB_per_gob * _GOB_per_frame];
	_mv_y1    = new short[_MB_per_gob * _GOB_per_frame];
	_mv_type2 = new short[_MB_per_gob * _GOB_per_frame];
	_mv_x2    = new short[_MB_per_gob * _GOB_per_frame];
	_mv_y2    = new short[_MB_per_gob * _GOB_per_frame];
	_mv_type3 = new short[_MB_per_gob * _GOB_per_frame];
	_mv_x3    = new short[_MB_per_gob * _GOB_per_frame];
	_mv_y3    = new short[_MB_per_gob * _GOB_per_frame];
	_mv_type4 = new short[_MB_per_gob * _GOB_per_frame];
	_mv_x4    = new short[_MB_per_gob * _GOB_per_frame];
	_mv_y4    = new short[_MB_per_gob * _GOB_per_frame];

	_mvd_type = new short[_MB_per_gob * _GOB_per_frame];			// Delta motion vector
	_mvd_x	  = new short[_MB_per_gob * _GOB_per_frame];
	_mvd_y	  = new short[_MB_per_gob * _GOB_per_frame];

	if (_PB_frame_mode || !_encode_mode) {
		_mcbpb	= new short[_MB_per_gob * _GOB_per_frame];
		_bquant = new short[_MB_per_gob * _GOB_per_frame];
		
		_mv_type1_f = new short[_MB_per_gob * _GOB_per_frame];		// Forward motion vectors
		_mv_x1_f    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_y1_f    = new short[_MB_per_gob * _GOB_per_frame];		
		_mv_type2_f = new short[_MB_per_gob * _GOB_per_frame];
		_mv_x2_f    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_y2_f    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_type3_f = new short[_MB_per_gob * _GOB_per_frame];
		_mv_x3_f    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_y3_f    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_type4_f = new short[_MB_per_gob * _GOB_per_frame];
		_mv_x4_f    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_y4_f    = new short[_MB_per_gob * _GOB_per_frame];
		
		_mv_type1_b = new short[_MB_per_gob * _GOB_per_frame];		// Backward motion vectors
		_mv_x1_b    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_y1_b    = new short[_MB_per_gob * _GOB_per_frame];		
		_mv_type2_b = new short[_MB_per_gob * _GOB_per_frame];
		_mv_x2_b    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_y2_b    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_type3_b = new short[_MB_per_gob * _GOB_per_frame];
		_mv_x3_b    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_y3_b    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_type4_b = new short[_MB_per_gob * _GOB_per_frame];
		_mv_x4_b    = new short[_MB_per_gob * _GOB_per_frame];
		_mv_y4_b    = new short[_MB_per_gob * _GOB_per_frame];
		
		_mv_type_uv_f = new short[_MB_per_gob * _GOB_per_frame];	// Chrominance forward motion vector
		_mv_uvx_f     = new short[_MB_per_gob * _GOB_per_frame];
		_mv_uvy_f     = new short[_MB_per_gob * _GOB_per_frame];	
		_mv_type_uv_b = new short[_MB_per_gob * _GOB_per_frame];	// Chrominance backware motion vector
		_mv_uvx_b     = new short[_MB_per_gob * _GOB_per_frame];
		_mv_uvy_b     = new short[_MB_per_gob * _GOB_per_frame];	
	}


	// Initialize structure needed to store multiple previous frames
	if (_reference_picture_selection || !_encode_mode) 
	{
		_prev_frames = new FrameQueue(_max_frame_stored);
		_prev_half_full = new FrameQueue(_max_frame_stored);
		_prev_full_half = new FrameQueue(_max_frame_stored);
		_prev_half_half = new FrameQueue(_max_frame_stored);
		if (_slice_mode || !_encode_mode) _trp = new int[_SLICE_per_frame];
		else _trp = new int[_GOB_per_frame];
	}

	// Initialize memory space for this frame object
	if (_PB_frame_mode || !_encode_mode) {
		_this_2D_frame = new unsigned char[_buffer_size << 1];
		_this_1D_frame = new unsigned char[_buffer_size << 1];

		_decoded_frame = new unsigned char[_buffer_size << 1];
		_decoded_frame_half_full = new unsigned char[_buffer_size << 1];
		_decoded_frame_full_half = new unsigned char[_buffer_size << 1];
		_decoded_frame_half_half = new unsigned char[_buffer_size << 1];

		_shift_frame   = new unsigned char[_buffer_size << 1];
		_fast_frame    = new short[_buffer_size << 1];
	}
	else {
		_this_2D_frame = new unsigned char[_buffer_size];
		_this_1D_frame = new unsigned char[_buffer_size];

		_decoded_frame			 = new unsigned char[_buffer_size];
		_decoded_frame_half_full = new unsigned char[_buffer_size];
		_decoded_frame_full_half = new unsigned char[_buffer_size];
		_decoded_frame_half_half = new unsigned char[_buffer_size];

		if (!_evil_speed_mode) _shift_frame   = new unsigned char[_buffer_size];
		else _evil_predict_frame = new short[_buffer_size];

		_fast_frame    = new short[_buffer_size];
	}

	_left_shift		= new unsigned char[_buffer_size];
	_upper_shift		= new unsigned char[_buffer_size];
	_upper_left_shift	= new unsigned char[_buffer_size];
	_recov_frame		= new short[_buffer_size];
	

	// Unrestricted Motion Vector Mode needs additional structure
	if(_unrestricted_motion_vector_mode || _advanced_prediction_mode || !_encode_mode) {
		_padded_UMV_frame = new unsigned char[3*((_frame_xsize + 32) * (_frame_ysize + 32)) >> 1];
		_padded_UMV_frame_full_half = new unsigned char[3*((_frame_xsize + 32) * (_frame_ysize + 32)) >> 1];
		_padded_UMV_frame_half_full = new unsigned char[3*((_frame_xsize + 32) * (_frame_ysize + 32)) >> 1];
		_padded_UMV_frame_half_half = new unsigned char[3*((_frame_xsize + 32) * (_frame_ysize + 32)) >> 1];
		_padded_left_shift = new unsigned char[3*((_frame_xsize + 32) * (_frame_ysize + 32)) >> 1];
		_padded_upper_shift = new unsigned char[3*((_frame_xsize + 32) * (_frame_ysize + 32)) >> 1];
		_padded_upper_left_shift = new unsigned char[3*((_frame_xsize + 32) * (_frame_ysize + 32)) >> 1];
	}

	if(_independent_segment_mode && _advanced_prediction_mode || !_encode_mode) {
		int extrapolated_picture_size = (_frame_xsize + 32) * (_frame_ysize + 32);
		int extrapolated_picture_size_quarter = (extrapolated_picture_size >> 2);
		int extrapolated_buffer_size = extrapolated_picture_size + (extrapolated_picture_size_quarter << 1);
		_ISD_extrapolated_frame = new unsigned char[extrapolated_buffer_size];
		_ISD_extrapolated_frame_half_full = new unsigned char[extrapolated_buffer_size];
		_ISD_extrapolated_frame_full_half = new unsigned char[extrapolated_buffer_size];
		_ISD_extrapolated_frame_half_half = new unsigned char[extrapolated_buffer_size];
	}


	// Initialize memory space for performance-enhanced data structure
	_zero_mv_type = new short(1);	// Motion Vector Type 0 is illegal
	_zero_mv_x = new short(0);
	_zero_mv_y = new short(0);
	
	if (_PB_frame_mode || !_encode_mode) _zigzaged_central = new short[_buffer_size << 1];
	else _zigzaged_central = new short[_buffer_size];

	if (_syntax_arithmetic_coding_mode || !_encode_mode) sac = new symbol;
	
	_Created_Data_Structures = true;

	Init_Structure();
}


#endif