
#ifndef __D_FRAME_ADVANCED_OPTIONS_MODE_C__
#define __D_FRAME_ADVANCED_OPTIONS_MODE_C__

#include "D_Frame.h"
#include "D_Block.h"

/*
 * void D_Frame::Disable_UMV_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Disable_UMV_Mode(void)
{
	_unrestricted_motion_vector_mode = false;
}


/*
 * void D_Frame::Enable_UMV_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Enable_UMV_Mode(void)
{
	fprintf(stdout, "Unrestricted Motion Vectors not implemented yet\n");
	_unrestricted_motion_vector_mode = true;
	fflush(stdout);
}


/*
 * void D_Frame::Disable_SAC_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Disable_SAC_Mode(void)
{
	_syntax_arithmetic_coding_mode = false;
	D_GOB::_syntax_arithmetic_coding_mode = false;
	D_Slice::_syntax_arithmetic_coding_mode = false;
}


/*
 * void D_Frame::Enable_SAC_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Enable_SAC_Mode(void)
{
	fprintf(stdout, "Enabling Syntax Arithmetic Coding\n");
	_syntax_arithmetic_coding_mode = true;
	D_GOB::_syntax_arithmetic_coding_mode = true;
	D_Slice::_syntax_arithmetic_coding_mode = true;
	if (_alternative_inter_vlc_mode) {
		fprintf(stdout, "SAC and AIV cannot co-exist: Disabling Alternative Inter VLC\n");
		Disable_AIV_Mode();
	}
	fflush(stdout);
}

/*
 * void D_Frame::Disable_AIV_Mode(void)
 * 
 * Turns off Alternative INTER VLC coding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_alternative_inter_vlc_mode of Frame and block layers
 * Ensures:		AIV is turned off
 *
 * Warning:		
 */
void D_Frame::Disable_AIV_Mode(void)
{
	_alternative_inter_vlc_mode = false;
	D_Macroblock::_alternative_inter_vlc_mode = false;
	D_Block::_alternative_inter_vlc_mode = false;
}


/*
 * void D_Frame::Enable_AIV_Mode(void)
 * 
 * Turns on Alternative INTER VLC coding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_alternative_inter_vlc_mode of Frame and block layers
 * Ensures:		AIV is turned on
 *
 * Warning:		
 */
void D_Frame::Enable_AIV_Mode(void)
{
	if (!_syntax_arithmetic_coding_mode) {
		if (!_PB_frame_mode) {
			fprintf(stdout, "Enabling Alternative Inter VLC\n");
			_alternative_inter_vlc_mode = true;
			D_Macroblock::_alternative_inter_vlc_mode = true;
			D_Block::_alternative_inter_vlc_mode = true;
		}
		else fprintf(stdout, "PB and AIV cannot coexist: Disabling Alternative Inter VLC\n");
	}
	else fprintf(stdout, "SAC and AIV cannot co-exist: Disabling Alternative Inter VLC\n");
	fflush(stdout);
}

/*
 * void D_Frame::Enable_AIC_Mode(void)
 * 
 * Turns on Advanced Intra coding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_advanced_intra_coding_mode of Frame and block layers
 * Ensures:		AIC is turned on
 *
 * Warning:		
 */
void D_Frame::Enable_AIC_Mode(void)
{
	if (!_PB_frame_mode) {
		fprintf(stdout, "Enabling Advanced INTRA Coding\n");
		_advanced_intra_coding_mode = true;
		D_Macroblock::_advanced_intra_coding_mode = true;
		D_Block::_advanced_intra_coding_mode = true;
	}
	else fprintf(stdout, "PB and AIC cannot coexist: Disabling Advanced INTRA Coding\n");
	fflush(stdout);
}

/*
 * void D_Frame::Disable_AIC_Mode(void)
 * 
 * Turns off Advanced Intra coding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_advanced_intra_coding_mode of Frame and block layers
 * Ensures:		AIC is turned off
 *
 * Warning:		
 */
void D_Frame::Disable_AIC_Mode(void)
{
	_advanced_intra_coding_mode = false;
	D_Macroblock::_advanced_intra_coding_mode = false;
	D_Block::_advanced_intra_coding_mode = false;
}

/*
 * void D_Frame::Enable_DF_Mode(void)
 * 
 * Turns on Deblocking Filter
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_deblocking_filter_mode on Frame level
 * Ensures:		DF is turned on
 *
 * Warning:		
 */
void D_Frame::Enable_DF_Mode(void)
{
	if (!_PB_frame_mode) {
		fprintf(stdout, "Enabling Deblocking Filter\n");
		_deblocking_filter_mode = true;
	}
	else fprintf(stdout, "PB and DF cannot coexist: Disabling Deblocking Filter\n");
	fflush(stdout);
}

/*
 * void D_Frame::Disable_DF_Mode(void)
 * 
 * Turns off Deblocking Filter
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_deblocking_filter_mode on Frame level
 * Ensures:		DF is turned off
 *
 * Warning:		
 */
void D_Frame::Disable_DF_Mode(void)
{
	_deblocking_filter_mode = false;
}

/*
 * void D_Frame::Disable_AP_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Disable_AP_Mode(void)
{
	_advanced_prediction_mode = false;
	D_GOB::_advanced_prediction_mode = false;
	D_Slice::_advanced_prediction_mode = false;
	D_Macroblock::_advanced_prediction_mode = false;
}


/*
 * void D_Frame::Enable_AP_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Enable_AP_Mode(void)
{
	fprintf(stdout, "Enabling Advanced Prediction\n");
	_advanced_prediction_mode = true;
	D_GOB::_advanced_prediction_mode = true;
	D_Slice::_advanced_prediction_mode = true;
	D_Macroblock::_advanced_prediction_mode = true;
	fflush(stdout);
}


/*
 * void D_Frame::Disable_PB_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Disable_PB_Mode(void)
{
	_PB_frame_mode = false;
}


/*
 * void D_Frame::Enable_PB_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Enable_PB_Mode(void)
{
	fprintf(stdout, "Enabling PB-frames\n");
	_PB_conditions_checked = false;
	_PB_frame_mode = true;

	if (_independent_segment_mode) {
		fprintf(stdout, "PB and ISD cannot coexist: Disabling Independent Segment Decoding\n");
		Disable_ISD_Mode();
	}
	if (_slice_mode) {
		fprintf(stdout, "PB and SLICE cannot coexist: Disabling Slice Mode\n");
		Disable_SLICE_Mode();
	}
	if (_reference_picture_selection) {
		fprintf(stdout, "PB and RPS cannot coexist: Disabling Reference Picture Selection\n");
		Disable_RPS_Mode();
	}
	if (_alternative_inter_vlc_mode) {
		fprintf(stdout, "PB and AIV cannot coexist: Disabling Alternative Inter VLC\n");
		Disable_AIV_Mode();
	}
	if (_advanced_intra_coding_mode) {
		fprintf(stdout, "PB and AIC cannot coexist: Disabling Advanced INTRA Coding\n");
		Disable_AIC_Mode();
	}
	fflush(stdout);
}


/*
 * void D_Frame::Formal_Verify_PB_Preconditions(void)
 * 
 * double check preconditions to ensure proper settings for PB frame mode
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Formal_Verify_PB_Preconditions(void)
{
	_PB_conditions_checked = true;
	_PB_frame_mode = true;

	Enable_ME();
	Set_Frame_Mode_INTER();
	Disable_ISD_Mode();
	Disable_SLICE_Mode();
	Disable_RPS_Mode();
	Disable_AIV_Mode();
	Disable_AIC_Mode();
}


/*
 * void D_Frame::Disable_FEC_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Disable_FEC_Mode(void)
{
	_forward_error_correction_mode = false;
}


/*
 * void D_Frame::Enable_FEC_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Enable_FEC_Mode(void)
{
	fprintf(stdout, "Forward Error Correction mode implemented in separate module\n");
	_forward_error_correction_mode = true;
	fflush(stdout);
}


/*
 * void D_Frame::Disable_ES_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Disable_ES_Mode(void)
{
	_evil_speed_mode = false;
}


/*
 * void D_Frame::Enable_ES_Mode(void)
 * 
 * turn on INTER frame encoding
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_inter_frame_mode of Frame, GOB, macroblock, and block layers
 * Ensures:		The video coder can code in INTRA and INTER mode
 *
 * Warning:		
 */
void D_Frame::Enable_ES_Mode(void)
{
	_evil_speed_mode = true;
	fprintf(stdout, "\nEvil speed mode is turned on\n\n");

	Disable_AIV_Mode();
	Disable_AP_Mode();
	Disable_FEC_Mode();
	Disable_ISD_Mode();
	Disable_PB_Mode();
	Disable_RPS_Mode();
	Disable_SAC_Mode();
	Disable_SLICE_Mode();
	Disable_UMV_Mode();
	fflush(stdout);
}

/*
 * void D_Frame::Disable_ISD_Mode(void)
 * 
 * disable independent segment decoding mode
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_indepdendent_segment_mode
 * Ensures:		Independent segment decoding mode is turned off
 *
 * Warning:		
 */

void D_Frame::Disable_ISD_Mode(void){
	_independent_segment_mode = false;
	D_GOB::_independent_segment_mode = false;
	D_Slice::_independent_segment_mode = false;
	D_Macroblock::_independent_segment_mode = false;
}


/*
 * void D_Frame::Enable_ISD_Mode(void)
 * 
 * enable independent segment decoding mode
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_indepdendent_segment_mode
 * Ensures:		Independent segment decoding mode is turned on
 *
 * Warning:		
 */

void D_Frame::Enable_ISD_Mode(void){
	if (!_PB_frame_mode) {
		fprintf(stdout, "Enabling Independent Segment Decoding\n");

		_independent_segment_mode = true;
		D_GOB::_independent_segment_mode = true;
		D_Slice::_independent_segment_mode = true;
		D_Macroblock::_independent_segment_mode = true;

		if (_slice_mode && !_rectangular_submode) {
			fprintf(stdout, "ISD and Slice w/o rect submode cannot co-exist: Disabling Slice Mode\n");
			Disable_SLICE_Mode();
		}
	}
	else fprintf(stdout, "PB and ISD cannot co-exist: Disabling Independent Segment Decoding\n");
	fflush(stdout);
}


/*
 * void D_Frame::Disable_RPS_Mode(void)
 * 
 * enable reference picture selection mode
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_reference_picture_selection
 * Ensures:		Reference picture selection mode is turned off
 *
 * Warning:		
 */
void D_Frame::Disable_RPS_Mode(void)
{
	_reference_picture_selection = false;
	D_GOB::_reference_picture_selection = false;
	D_Slice::_reference_picture_selection = false;
}


/*
 * void D_Frame::Enable_RPS_Mode(void)
 * 
 * enable reference picture selection mode
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_reference_picture_selection, _max_frame_stored, _frame_count
 * Ensures:		The video coder can store multiple previous frames
 *
 * Warning:		
 */
void D_Frame::Enable_RPS_Mode(void)
{
	if (!_PB_frame_mode) {
		fprintf(stdout, "Enabling Reference Picture Selection\n");
		
		const int MAX_FRAME = 16;
		_max_frame_stored = MAX_FRAME;
		_frame_count = 0;
		_reference_picture_selection = true;
		D_GOB::_reference_picture_selection = true;
		D_Slice::_reference_picture_selection = true;
		srand(999);
	}
	else fprintf(stdout, "PB and RPS cannot co-exist: Disabling Reference Picture Selection\n");
	fflush(stdout);
}


/*
 * void D_Frame::Disable_Slice_Mode(void)
 * 
 * disable slice structure mode
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_slice_mode
 * Ensures:		_slice_mode is set to false
 *
 * Warning:		
 */
void D_Frame::Disable_SLICE_Mode(void)
{
	_slice_mode = false;
	D_Macroblock::_slice_mode = false;
	D_Block::_slice_mode = false;
}


/*
 * void D_Frame::Enable_Slice_Mode(
 *		const bool rect_submode, const bool arbitrary_submode, const bool encode)
 * 
 * enable slice structure mode
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_slice mode, _rectangular_submode, _arbitrary_order_submode
 * Ensures:		_slice_mode is set to true
 *
 * Warning:		
 */

void D_Frame::Enable_SLICE_Mode(const bool rect_submode,
								const bool arbitrary_submode)
{
	if (!_PB_frame_mode) {
		if (_independent_segment_mode && !rect_submode) {
			fprintf(stdout, "ISD and Slice w/o rect submode cannot co-exist: Disabling Slice Mode\n");
		}
		else {
			fprintf(stdout, "Enabling SLICE mode");
			_slice_mode = true;
			D_Macroblock::_slice_mode = true;
			D_Block::_slice_mode = true;

			_rectangular_submode = rect_submode;
			D_Slice::_rectangular_submode = rect_submode;
			D_Macroblock::_rectangular_submode = rect_submode;
			if (!rect_submode) fprintf(stdout, " with non-rectangular submode");

			_arbitrary_order_submode = arbitrary_submode;
			D_Slice::_arbitrary_order_submode = arbitrary_submode;
			D_Macroblock::_arbitrary_order_submode = arbitrary_submode;
			if (arbitrary_submode) fprintf(stdout, " with arbitrary order");
			fprintf(stdout, "\n");
		}
	}
	else fprintf(stdout, "PB and SLICE cannot co-exist: Disabling Slice mode\n");
	fflush(stdout);
}


#endif

