
#ifndef __D_BLOCK_ZIGZAG_SCAN_C__
#define __D_BLOCK_ZIGZAG_SCAN_C__

#include "D_Block.h"


/*
 * void D_Block::Zigzag_Scan(void)
 * 
 * Re-arrange coefficients into transmission order, according to the zigzag table
 * This is a private method
 *
 * Requires:	Quantize() and Encode_Clip_Non_INTRA_DC() is called before invoking this method
 * Modifies:	_zigzaged_coef
 * Ensures:		_zigzaged_coef[ZIGZAG_ORDER[i]] = _quantized_coef[i]
 *
 * Warning:
*/
void D_Block::Zigzag_Scan(void)
{
	int i;
	const short *ptr_src_i = _quantized_coef;
	if (!_advanced_intra_coding_mode){
		for (i=0; i<64; i++) 
			_zigzaged_coef[ZIGZAG_ORDER[i]] = *ptr_src_i++;
	} else {
		switch(_advanced_intra_prediction_mode) {
		case 1:
			for (i=0; i<64; i++) 
				_zigzaged_coef[HORIZONTAL_ZIGZAG_ORDER[i] - 1] = *ptr_src_i++;
			break;
		case 2:
			for (i=0; i<64; i++) 
				_zigzaged_coef[VERTICAL_ZIGZAG_ORDER[i] - 1] = *ptr_src_i++;
			break;
		default:
			for (i=0; i<64; i++) 
				_zigzaged_coef[ZIGZAG_ORDER[i]] = *ptr_src_i++;
			break;
		}
	}
}


#endif

