
#ifndef __D_BLOCK_SAC_ENCODER_C__
#define __D_BLOCK_SAC_ENCODER_C__

#include "D_Block.h"


/*
* void D_Block::SAC_Encoder(PSC_Fifo &bit_ostream, symbol *sac)
* 
* apply SAC to encode the current block
* This is a public method
*
* Requires:	Encode_BLK() is called before invoking this method from the Macroblock layer
* Modifies:	bit_ostream
* Ensures:		Entropy encode the transformed coefficients according to VLC table
*
* Warning:		baseline implementation
*/
void D_Block::SAC_Encoder(PSC_Fifo &bit_ostream, symbol *sac)
{
	// Non-Last Entries
	static int Last0_Level1[27] = 
	{ 0, 12, 18, 22, 25, 28, 31, 34, 36, 38, 40, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57 };
	
	static int Last0_Level2[11] = { 1, 13, 19, 23, 26, 29, 32, 35, 37, 39, 41 };
	static int Last0_Level3[7] = { 2, 14, 20, 24, 27, 30, 33 };
	static int Last0_Level4[3] = { 3, 15, 21 };
	static int Last0_Level5[2] = { 4, 16 };
	static int Last0_Level6[2] = { 5, 17 };
	static int Last0_Level7_12[6] = { 6, 7, 8, 9, 10, 11 };
	
	// LAST Entries
	static int Last1_Level1[41] =
	{ 58, 61, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81,
	82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101 };
	
	static int Last1_Level2[2] = { 59, 62 };
	static int Last1_Level3[2] = {60};
	
	// Variable declarations
	int i, bitcount, k, l, run, sign, level, slevel, tcoefn;
	short *ptr_s;
	bool *ptr_b;
	bool FLC_mode, bits[1408];			// Worst case: 64 FLCs
	
	
	ptr_s = _zigzaged_coef;
	ptr_b = bits;
	i = 0;
	k = 0;
	tcoefn = 0;
	bitcount = 0;
	
	if (!_PB_B_frame && !_advanced_intra_coding_mode) {
		// INTRADC - DC coefficient for INTRA blocks - 8 bits
		if ( (*_mtype == INTRA) || (*_mtype == INTRAQ) ) {
			k =  *ptr_s++;
			if (EDEBUG) { fprintf(stdout, "INTRADC %d ", k); fflush(stdout); }
			if (k == 255) k = 127;
			else k -= 1;
			ptr_b = sac->encode(cumf_INTRADC, k, bitcount, ptr_b);
			i = 1;
		}
	}
	
	if (_last_non_zero_index == -1) { 	// shortcut, if INTRADC is all we have
		bit_ostream.WriteNBits(bits, bitcount);
		return;
	}
	
	// TCOEF - Transform Coefficient - (Variable Length)
	for (run=0; i<_last_non_zero_index; i++) {	// We deal with last index outside loop
		
		level = *ptr_s++;
		slevel = level;
		if (level == 0) {	// Run check
			run++;
			if (EDEBUG) { fprintf (stdout, "0 "); fflush(stdout); }
			continue;
		}
		
		if (level < 0) {	// Sign check
			level = -level;
			sign = 1;
		}
		else sign = 0;
		
		FLC_mode = false;
		switch (level) {	// SAC table lookup for non-last TCOEFs
		case 1:
			if (run <= 26) k = Last0_Level1[run];
			else FLC_mode = true;
			break;
		case 2:
			if (run <= 10) k = Last0_Level2[run];
			else FLC_mode = true;
			break;
		case 3:
			if (run <= 6) k = Last0_Level3[run];
			else FLC_mode = true;
			break;
		case 4:
			if (run <= 2) k = Last0_Level4[run];
			else FLC_mode = true;
			break;
		case 5:
			if (run <= 1) k = Last0_Level5[run];
			else FLC_mode = true;
			break;
		case 6:
			if (run <= 1) k = Last0_Level6[run];
			else FLC_mode = true;
			break;
		default:
			if ((run == 0) && (level >= 7) && (level <= 12)) {
				l = level - 7;
				k = Last0_Level7_12[l];
			}
			else FLC_mode = true;
		}
		
		
		if (FLC_mode == false) {
			if (EDEBUG) { fprintf(stdout, "%d ", slevel); fflush(stdout); }
			
			if ((*_mtype == INTRA) || (*_mtype == INTRAQ)){
				switch (tcoefn) {
				case 0:
					ptr_b = sac->encode(cumf_TCOEF1_intra, k, bitcount, ptr_b);
					break;
				case 1:
					ptr_b = sac->encode(cumf_TCOEF2_intra, k, bitcount, ptr_b);
					break;
				case 2:
					ptr_b = sac->encode(cumf_TCOEF3_intra, k, bitcount, ptr_b);
					break;
				default:
					ptr_b = sac->encode(cumf_TCOEFr_intra, k, bitcount, ptr_b);
					break;
				}
			}
			else {

				switch (tcoefn) {
				case 0:
					ptr_b = sac->encode(cumf_TCOEF1, k, bitcount, ptr_b);
					break;
				case 1:
					ptr_b = sac->encode(cumf_TCOEF2, k, bitcount, ptr_b);
					break;
				case 2:
					ptr_b = sac->encode(cumf_TCOEF3, k, bitcount, ptr_b);
					break;
				default:
					ptr_b = sac->encode(cumf_TCOEFr, k, bitcount, ptr_b);
					break;
				}
			}
			
			ptr_b = sac->encode(cumf_SIGN, sign, bitcount, ptr_b);
			tcoefn++;
			
		}
		else {	// FLC - Fixed Length Coding - NOTE: tcoefn is now incremented!!!

			// Escape
			if ((*_mtype == INTRA) || (*_mtype == INTRAQ)) {
				
				switch(tcoefn){
				case 0:
					ptr_b = sac->encode(cumf_TCOEF1_intra, 102, bitcount, ptr_b);
					break;
				case 1:
					ptr_b = sac->encode(cumf_TCOEF2_intra, 102, bitcount, ptr_b);
					break;
				case 2:
					ptr_b = sac->encode(cumf_TCOEF3_intra, 102, bitcount, ptr_b);
					break;
				default:
					ptr_b = sac->encode(cumf_TCOEFr_intra, 102, bitcount, ptr_b);
					break;
				}
				
			}
			else {
				switch(tcoefn){
				case 0:
					ptr_b = sac->encode(cumf_TCOEF1, 102, bitcount, ptr_b);
					break;
				case 1:
					ptr_b = sac->encode(cumf_TCOEF2, 102, bitcount, ptr_b);
					break;
				case 2:
					ptr_b = sac->encode(cumf_TCOEF3, 102, bitcount, ptr_b);
					break;
				default:
					ptr_b = sac->encode(cumf_TCOEFr, 102, bitcount, ptr_b);
					break;
				}
			}

			tcoefn++;

			if ((*_mtype == INTRA) || (*_mtype == INTRAQ)){
				// LAST - 1 bit - Last TCOEF is handled later
				ptr_b = sac->encode(cumf_LAST_intra, 0, bitcount, ptr_b);
				ptr_b = sac->encode(cumf_RUN_intra, run, bitcount, ptr_b);
				// level, 8 bit
				if (EDEBUG) { fprintf(stdout, "E%d ", slevel); fflush(stdout); }
				if ((slevel > -128) && (slevel < 128)) {
					if (slevel > 0) slevel += 126;
					else slevel += 127;
					ptr_b = sac->encode(cumf_LEVEL_intra, slevel, bitcount, ptr_b);
					
				}	
				else fprintf(stdout, "\nIllegal value at entropy encoder, %d: %d run %d\n", i, run, slevel);

			} else {
				// LAST - 1 bit - Last TCOEF is handled later
				ptr_b = sac->encode(cumf_LAST, 0, bitcount, ptr_b);
				ptr_b = sac->encode(cumf_RUN, run, bitcount, ptr_b);
				// level, 8 bit
				if (EDEBUG) { fprintf(stdout, "E%d ", slevel); fflush(stdout); }
				if ((slevel > -128) && (slevel < 128) && (slevel != 0)) {
					if (slevel > 0) slevel += 126;
					else slevel += 127;
					ptr_b = sac->encode(cumf_LEVEL, slevel, bitcount, ptr_b);
					
				}	
				else fprintf(stdout, "\nIllegal value at entropy encoder, %d: %d run %d\n", i, run, slevel);
			}
		} // else {	// FLC - Fixed Length Coding - NOTE: tcoefn is now incremented!!!
		run = 0;

	} // for (run=0; i<_last_non_zero_index; i++)

	// Last coefficient processing
	level = *ptr_s++;
	slevel = level;
	
	if (level < 0) {	// Sign check
		level = -level;
		sign = 1;
	}
	else sign = 0;
	
	FLC_mode = false;
	switch (level) {
	case 1:
		if (run <= 40) k = Last1_Level1[run];
		else FLC_mode = true;
		break;
	case 2:
		if (run <= 1) k = Last1_Level2[run];
		else FLC_mode = true;
		break;
	case 3:
		if (run == 0) k = Last1_Level3[run];
		else FLC_mode = true;
		break;
	default:
		FLC_mode = true;
	}
	
	if (FLC_mode == false) {
		if (EDEBUG) { fprintf(stdout, "%d LAST%d\n", slevel, i); fflush(stdout); }
		if ((*_mtype == INTRA) || (*_mtype == INTRAQ)) {

			switch(tcoefn){
			case 0:
				ptr_b = sac->encode(cumf_TCOEF1_intra, k, bitcount, ptr_b);
				break;
			case 1:
				ptr_b = sac->encode(cumf_TCOEF2_intra, k, bitcount, ptr_b);
				break;
			case 2:
				ptr_b = sac->encode(cumf_TCOEF3_intra, k, bitcount, ptr_b);
				break;
			default:
				ptr_b = sac->encode(cumf_TCOEFr_intra, k, bitcount, ptr_b);
				break;
			}

		}
		else {
			switch(tcoefn){
			case 0:
				ptr_b = sac->encode(cumf_TCOEF1, k, bitcount, ptr_b);
				break;
			case 1:
				ptr_b = sac->encode(cumf_TCOEF2, k, bitcount, ptr_b);
				break;
			case 2:
				ptr_b = sac->encode(cumf_TCOEF3, k, bitcount, ptr_b);
				break;
			default:
				ptr_b = sac->encode(cumf_TCOEFr, k, bitcount, ptr_b);
				break;
			}
		}
		ptr_b = sac->encode(cumf_SIGN, sign, bitcount, ptr_b);

	}
	// FLC - Fixed Length Coding
	else {
		// Escape
		if ((*_mtype == INTRA) || (*_mtype == INTRAQ)){
			switch(tcoefn){
			case 0:
				ptr_b = sac->encode(cumf_TCOEF1_intra, 102, bitcount, ptr_b);
				break;
			case 1:
				ptr_b = sac->encode(cumf_TCOEF2_intra, 102, bitcount, ptr_b);
				break;
			case 2:
				ptr_b = sac->encode(cumf_TCOEF3_intra, 102, bitcount, ptr_b);
				break;
			default:
				ptr_b = sac->encode(cumf_TCOEFr_intra, 102, bitcount, ptr_b);
				break;
			}
		} else {
			switch(tcoefn){
			case 0:
				ptr_b = sac->encode(cumf_TCOEF1, 102, bitcount, ptr_b);
				break;
			case 1:
				ptr_b = sac->encode(cumf_TCOEF2, 102, bitcount, ptr_b);
				break;
			case 2:
				ptr_b = sac->encode(cumf_TCOEF3, 102, bitcount, ptr_b);
				break;
			default:
				ptr_b = sac->encode(cumf_TCOEFr, 102, bitcount, ptr_b);
				break;
			}
		}
		
		if ((*_mtype == INTRA) || (*_mtype == INTRAQ)){
			// LAST - 1 bit - Last is handled here
			ptr_b = sac->encode(cumf_LAST_intra, 1, bitcount, ptr_b);
			ptr_b = sac->encode(cumf_RUN_intra, run, bitcount, ptr_b);
			// level, 8 bit
			if (EDEBUG) { fprintf(stdout, "E%d LAST%d\n", slevel, i); fflush(stdout); }
			if ((slevel > -128) && (slevel < 128)) {
				if (slevel > 0)	slevel += 126;
				else slevel += 127;
				
				ptr_b = sac->encode(cumf_LEVEL_intra, slevel, bitcount, ptr_b);
				
			}	
			else fprintf(stdout, "\nIllegal value a entropy encoder, %d: %d zeros %d LAST\n", i, run, slevel);

		} else {
			// LAST - 1 bit - Last is handled here
			ptr_b = sac->encode(cumf_LAST, 1, bitcount, ptr_b);
			ptr_b = sac->encode(cumf_RUN, run, bitcount, ptr_b);
			// level, 8 bit
			if (EDEBUG) { fprintf(stdout, "E%d LAST%d Done\n", slevel, i); fflush(stdout); }
			if ((slevel > -128) && (slevel < 128)) {
				if (slevel > 0)	slevel += 126;
				else slevel += 127;
				
				ptr_b = sac->encode(cumf_LEVEL, slevel, bitcount, ptr_b);
				
			}	
			else fprintf(stdout, "\nIllegal value at entropy encoder, %d: %d zeros %d LAST\n", i, run, slevel);
		}

	} // FLC_mode

	if (EDEBUG) {
		ptr_b = bits;
		fprintf(stdout, "Block Bits: ");
		for (i=0; i < bitcount; i++) {
			if (*ptr_b++) fprintf(stdout, "1");
			else fprintf(stdout, "0");
		}
		fprintf(stdout, "\n");
		fflush(stdout);
	}
	bit_ostream.WriteNBits(bits, bitcount);
}


#endif

