
#ifndef __D_BLOCK_QUANTIZE_C__
#define __D_BLOCK_QUANTIZE_C__

#include "D_Block.h"


/*
 * void D_Block::Quantize(const int mquant)
 * 
 * Quantize the DCT coefficents
 * This is a private method
 *
 * Requires:	mquant, *_mtype, and _dct_coef set DCT()
 * Modifies:	_quantied_dct_coef
 * Ensures:		. if intra mode, the DC coefficient is quantized with no dead-zone and step 8 and no deadzone
 *					. if quantized to 0, reset to 1
 *					. if quantized to 128, set to 255
 *					. if quantized to 255, set to 254
 *				. if inter mode, the DC coefficient is treated as AC coefficients
 *				. AC coefficients are quantized with dead-zone and step=2*mquant
 *
 * Warning:
 */
void D_Block::Quantize(const int mquant)
{  
	int i, k, l, step, mtype;
	short *ptr_des_i;
	const short *ptr_src_i;
	
	mtype = *_mtype;
	step = mquant * 2;		// default: DC value cannot be 0

	ptr_des_i = _quantized_coef;
	ptr_src_i = _dct_coef;
	if (_advanced_intra_coding_mode && ((mtype == INTRA) || (mtype == INTRAQ))){
		//AIC Quantization
		ptr_des_i = _quantized_coef;
		ptr_src_i = _aic_coef;
		for (i=0; i<64; i++) *ptr_des_i++ = (short) (*ptr_src_i++ / step);
	
	} else {
		ptr_des_i = _quantized_coef;
		ptr_src_i = _dct_coef;
		i = 1;					// default to non-DC coefficient
		
		// Intra mode
		k = *ptr_src_i++;
		if ( ((mtype == INTRA) || (mtype == INTRAQ)) && (!_B_picture) ) {
			
			l = (k>0) ? ((k+4)/8) : ((k-4)/8);		// non-dead-zone quantization
			l &= 0x0000ffff;						// Clipping to between 0 and 255
			
			switch (l) {							// Note: 0 and 128 are not used, so reset to something else
			case 0:
				l = 1; break;						// level 0 is not allowed
			case 128:
				l = 255; break;						// level 128 is represented as 255, per standard document
			case 255:		
				l = 254; break;						// level 254 is the highest value possible
			default:
				break;
			}
		}
		else {
			l = k / step;
			if (l > 127) l = 127;
			if (l < -128) l = -128;
		}
		
		*ptr_des_i++ = (short) l;
		
		// Quantization with dead-zone for AC Coeff with step
		for (; i<64; i++) *ptr_des_i++ = (short) (*ptr_src_i++ / step);
	}
}


#endif

