
#ifndef __D_BLOCK_INIT_C__
#define __D_BLOCK_INIT_C__

#include "D_Block.h"


/*
 * void D_Block::Reset_Hierarchy(const bool **const cgi, const short **const seg_ID,
 *			const int *const clock, const int row_ID, const int MB_ID, const int BLK_ID)
 * 
 * Reset the hierarchy info for this Block in the Video tree
 * This is a public method
 *
 * Requires:	**cgi, **seg_ID, row_ID, MB_ID, BLK_ID
 * Modifies:	_group_id, macroblock_id, _block_id, _clock
 * Ensures:		. initializes physical location info:
 *					_group_ID, _macroblock_ID, _block_id
 *				. initializes _cgi, _seg_ID, and *_clock
 *
 * Warning:		
 */
void D_Block::Reset_Hierarchy(const bool **const cgi, const short **const seg_ID,
		const int *const clock, const int row_ID, const int MB_ID, const int BLK_ID)
{
	_cgi = cgi;
	_clock = clock;
	_seg_ID = seg_ID;
	_group_id = row_ID;
	_macroblock_id = MB_ID;
	_block_id = BLK_ID;

	// Set the pointer to the corresponding block above
	if (_group_id != 0) _top = this - (_MB_per_gob * 6 );
	else _top = NULL;

	// Set the pointer to the corresponding block below
	if ((_GOB_per_frame - _group_id) > 1) _bottom = this + (_MB_per_gob * 6 );
	else _bottom = NULL;

	// Set the pointer to the corresponding block to the left
	if (_macroblock_id != 0) _left = this - 6;
	else _left = NULL;

	// Set the pointer to the corresponding block to the right
	if ((_MB_per_gob - _macroblock_id) > 1) _right = this + 6;
	else _right = NULL;

}


/*
 * void D_Block::Init_Structure(const unsigned char *src_c)
 * 
 * Initialize basic data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_group_id, _macroblock_id, _block_id, _data_1D
 * Ensures:		Set block ID and set pointer to origianl pixel frame in the frame layer
 *
 * Warning:		
 */
void D_Block::Init_Structure(const unsigned char *src_c)
{
	_data_1D = src_c;
	
	if ((_block_id == 5) || (_block_id == 6)) 
		_ROW_offset = (_frame_xsize >> 1);		// U and V blocks have different row offset
}


/*
 * void D_Block::Fast_Structure(const short *const src_mtype, short *const src_s, short *const zsrc_s)
 * 
 * Initialize fast data structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_mtype, _data_fast, _zigzaged_coef
 * Ensures:		Set mtype, _data_fast, and _zigzaged_coef to src_mtype, src_s, and zsrc_c respectively
 *
 * Warning:		
 */
void D_Block::Fast_Structure(const short *const src_mtype, short *const src_s, short *const zsrc_s)
{
	_mtype = src_mtype;
	_data_fast = src_s;
	_zigzaged_coef = zsrc_s;
}


/*
 * void D_Block::Fast_Decoded_Structure(const unsigned char *const src_c)
 * 
 * Initialize fast decoded structure
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_decoded_coef
 * Ensures:		_decoded_coef is set to src_c, pointing to corresponding memory region in _decoded_frame
 *
 * Warning:		
 */
void D_Block::Fast_Decoded_Structure(const unsigned char *const src_c)
{
	_decoded_coef = src_c;
}


#endif

