
#ifndef __D_BLOCK_ENTROPY_ENCODER_C__
#define __D_BLOCK_ENTROPY_ENCODER_C__

#include "D_Frame.h"
#include "D_Block.h"


/*
 * void D_Block::Entropy_Encoder(PSC_Fifo &bit_ostream)
 * 
 * Entropy encode the current block
 * This is a public method
 *
 * Requires:	Encode_BLK() is called before invoking this method from the Macroblock layer
 * Modifies:	bit_ostream
 * Ensures:		Entropy encode the transformed coefficients according to VLC table
 *
 * Warning:		baseline implementation
 */
void D_Block::Entropy_Encoder(PSC_Fifo &bit_ostream)
{
	static char *ESCAPE = "0000011";

	// Non-Last Entries
	static char *Last0_Level1[27][2] = 
	{ "100", "101", "1100", "1101", "11100", "11101", "011010", "011011", "011000", "011001", "010110", "010111",
	"0100110", "0100111", "0100100", "0100101", "0100010", "0100011", "0100000", "0100001", "00101100", "00101101",
	"00101010", "00101011", "00101000", "00101001", "000111000", "000111001", "000110110", "000110111", 
	"0001000010", "0001000011", "0001000000", "0001000001", "0000111110", "0000111111", "0000111100", "0000111101",
	"0000111010", "0000111011", "0000111000", "0000111001", "0000110110", "0000110111", "0000110100", "0000110101",
	"000001000100", "000001000101", "000001000110", "000001000111", "0000010101100", "0000010101101",
	"0000010101110", "0000010101111" };

	static char *Last0_Level2[11][2] =
	{ "11110", "11111", "0101000", "0101001", "000111010", "000111011", "0001000110", "0001000111", 
	"0001000100", "0001000101", "00000011000", "00000011001", "00000010110", "00000010111",
	"00000010100", "00000010101", "00000010010", "00000010011", "00000010000", "00000010001",
	"0000010101010", "0000010101011" };

	static char *Last0_Level3[7][2] =
	{ "0101010", "0101011", "000111100", "000111101", "00000011100", "00000011101", "00000011010", "00000011011",
	"0000010100100", "0000010100101", "0000010100110", "0000010100111", "0000010101000", "0000010101001" };

	static char *Last0_Level4[3][2] =
	{ "00101110", "00101111", "00000011110", "00000011111", "0000010100010", "0000010100011" };

	static char *Last0_Level5[2][2] =
	{ "000111110", "000111111", "000001000010", "000001000011" };

	static char *Last0_Level6[2][2] =
	{ "0001001010", "0001001011", "0000010100000", "0000010100001" };

	static char *Last0_Level7_12[6][2] =
	{ "0001001000", "0001001001", "00001000010", "00001000011", "00001000000", "00001000001",
	"000000001110", "000000001111", "000000001100", "000000001101", "000001000000", "000001000001" };

	// LAST Entries
	static char *Last1_Level1[41][2] =
	{ "01110", "01111", "0011110", "0011111", "0011100", "0011101", "0011010", "0011011", "0011000", "0011001",
	"00100110", "00100111", "00100100", "00100101", "00100010", "00100011", "00100000", "00100001",
	"000110100", "000110101", "000110010", "000110011", "000110000", "000110001", "000101110", "000101111",
	"000101100", "000101101", "000101010", "000101011", "000101000", "000101001", "000100110", "000100111",
	"0000110000", "0000110001", "0000101110", "0000101111", "0000101100", "0000101101", "0000101010", "0000101011",
	"0000101000", "0000101001", "0000100110", "0000100111", "0000100100", "0000100101", "0000100010", "0000100011",
	"00000001110", "00000001111", "00000001100", "00000001101", "00000001010", "00000001011",
	"00000001000", "00000001001", "000001001000", "000001001001", "000001001010", "000001001011",
	"000001001100", "000001001101", "000001001110", "000001001111", "0000010110000", "0000010110001",
	"0000010110010", "0000010110011", "0000010110100", "0000010110101", "0000010110110", "0000010110111",
	"0000010111000", "0000010111001", "0000010111010", "0000010111011", "0000010111100", "0000010111101",
	"0000010111110", "0000010111111" };

	static char *Last1_Level2[2][2] =
	{ "0000110010", "0000110011", "000000001000", "000000001001" };

	static char *Last1_Level3[2] = { "000000001010", "000000001011" };

	// Code Length entries
	static int EL = 7;
	static int L0L1[27] = 
	{ 3, 4, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 13, 13 };
	static int L0L2[11] = { 5, 7, 9, 10, 10, 11, 11, 11, 11, 11, 13 };
	static int L0L3[7] = { 7, 9, 11, 11, 13, 13, 13 };
	static int L0L4[3] = { 8, 11, 13 };
	static int L0L5[2] = { 9, 12 };
	static int L0L6[2] = { 10, 13 };
	static int L0L7_12[6] = { 10, 11, 11, 12, 12, 12 };
	static int L1L1[41] = 
	{ 5, 7, 7, 7, 7, 8, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 11,
	12, 12, 12, 12, 13, 13, 13, 13, 13, 13, 13, 13 }; 
	static int L1L2[2] = { 10, 12 };
	static int L1L3 = 12;

	// AIC INTRA TCOEF VLC tables
	static char *AIC_Last0_Level1[14][2] =
	{ "100", "101", "11110", "11111", "010110", "010111", "0101010", "0101011", "0100110", "0100111",
	"00101110", "00101111", "000111000", "000111001", "000111110", "000111111", "0001001010", "0001001011",
	"0001001000", "0001001001", "00001000010", "00001000011", "00001000000", "00001000001",
	"00000010000", "00000010001", "000001000000", "000001000001" };

	static char *AIC_Last0_Level2[10][2] =
	{ "1100", "1101", "0101000", "0101001", "00101010", "00101011", "000111010", "000111011",
	"0001000110", "0001000111", "0001000100", "0001000101", "00000011000", "00000011001",
	"00000010110", "00000010111", "00000010100", "00000010101", "000000001100", "000000001101" };

	static char *AIC_Last0_Level3[6][2] = 
	{ "11100", "11101", "00101000", "00101001", "00000011100", "00000011101", "00000011010", "00000011011",
	"000000001110", "000000001111", "0000010100100", "0000010100101" };

	static char *AIC_Last0_Level4[4][2] =
	{ "011000", "011001", "000111100", "000111101", "00000010010", "00000010011", "0000010100010", "0000010100011" };

	static char *AIC_Last0_Level5[2][2] = 
	{ "011010", "011011", "00000011110", "00000011111" };

	static char *AIC_Last0_Level6[2][2] =
	{ "0100000", "0100001", "000001000010", "000001000011" };

	static char *AIC_Last0_Level7[2][2] = 
	{ "0100010", "0100011", "0000010100000", "0000010100001" };

	static char *AIC_Last0_Level8_25[18][2] = 
	{ "0100100", "0100101", "00101100", "00101101", "000110110", "000110111", "0001000000", "0001000001",
	"0001000010", "0001000011", "0000110100", "0000110101", "0000110110", "0000110111",
	"0000111000", "0000111001", "0000111010", "0000111011", "0000111100", "0000111101",
	"0000111110", "0000111111", "000001000110", "000001000111", "000001000100", "000001000101",
	"0000010101110", "0000010101111", "0000010101100", "0000010101101", "0000010101010", "0000010101011",
	"0000010101000", "0000010101001", "0000010100110", "0000010100111" };

	static char *AIC_Last1_Level1[24][2] =
	{ "01110", "01111", "0011110", "0011111", "0011100", "0011101", "0011010", "0011011", "00100010", "00100011",
	"00100110", "00100111", "00100100", "00100101", "000101000", "000101001", "000101010", "000101011",
	"000110100", "000110101", "000110010", "000110011", "000110000", "000110001", "000101110", "000101111",
	"000101100", "000101101", "0000110010", "0000110011", "0000101010", "0000101011",
	"0000101100", "0000101101", "0000110000", "0000110001", "0000101110", "0000101111",
	"000000001000", "000000001001", "000000001010", "000000001011", "0000010110000", "0000010110001",
	"0000010110010", "0000010110011", "0000010110100", "0000010110101" };

	static char *AIC_Last1_Level2[8][2] = 
	{ "0011000", "0011001", "0000100110", "0000100111", "0000101000", "0000101001", "00000001100", "00000001101",
	"00000001110", "00000001111", "0000010111010", "0000010111011", "0000010111000", "0000010111001",
	"0000010110110", "0000010110111" };

	static char *AIC_Last1_Level3[4][2] = 
	{ "00100000", "00100001", "00000001010", "00000001011", "000001001000", "000001001001",
	"0000010111100", "0000010111101" };

	static char *AIC_Last1_Level4[2][2] =
	{ "000100110", "000100111", "000001001010", "000001001011" };

	static char *AIC_Last1_Level5_10[6][2] = 
	{ "0000100010", "0000100011", "0000100100", "0000100101", "00000001000", "00000001001",
	"000001001110", "000001001111", "000001001100", "000001001101", "0000010111110", "0000010111111" };

	// AIC Code Length entries
	static int AIC_L0L1[14] = { 3, 5, 6, 7, 7, 8, 9, 9, 10, 10, 11, 11, 11, 12 };
	static int AIC_L0L2[10] = { 4, 7, 8, 9, 10, 10, 11, 11, 11, 12 };
	static int AIC_L0L3[6] = { 5, 8, 11, 11, 12, 13};
	static int AIC_L0L4[4] = { 6, 9, 11, 13 };
	static int AIC_L0L5[2] = { 6, 11 };
	static int AIC_L0L6[2] = { 7, 12 };
	static int AIC_L0L7[2] = { 7, 13 };
	static int AIC_L0L8_25[18] = { 7, 8, 9, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 13, 13, 13, 13, 13 };
	static int AIC_L1L1[24] = { 5, 7, 7, 7, 8, 8, 8, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10, 12, 12, 13, 13, 13 };
	static int AIC_L1L2[8] = { 7, 10, 10, 11, 11, 13, 13, 13 };
	static int AIC_L1L3[4] = { 8, 11, 12, 13 };
	static int AIC_L1L4[2] = { 9, 12 };
	static int AIC_L1L5_10[6] = { 10, 10, 11, 12, 12, 13 };

	// AIC Normal VLC Run Length Equivalents + 1 (includes the coefficient itself) (for AIV calculations)
	static int AIC_NR_L0L1[14] = { 1, 1, 6, 1, 7, 1, 14, 1, 1, 1, 1, 1, 10, 1 };
	static int AIC_NR_L0L2[10] = { 2, 2, 12, 3, 4, 5, 6, 7, 8, 1 };
	static int AIC_NR_L0L3[6] = { 3, 13, 3, 4, 1, 5 };
	static int AIC_NR_L0L4[4] = { 5, 2, 9, 3 };
	static int AIC_NR_L0L5[2] = { 4, 2 };
	static int AIC_NR_L0L6[2] = { 10, 2 };
	static int AIC_NR_L0L7[2] = { 9, 2 };
	static int AIC_NR_L0L8_25[18] = { 8, 11, 15, 17, 16, 23, 22, 21, 20, 19, 18, 25, 24, 27, 26, 11, 7, 6 };
	static int AIC_NR_L1L1[24] = { 1, 2, 3, 4, 8, 6, 7, 16, 15, 10, 11, 12, 13, 14, 1, 21, 20, 18, 19, 2, 1, 34, 35, 36};
	static int AIC_NR_L1L2[8] = { 5, 23, 22, 27, 26, 39, 38, 37};
	static int AIC_NR_L1L3[4] = { 9, 28, 30, 40};
	static int AIC_NR_L1L4[2] = { 17, 31};
	static int AIC_NR_L1L5_10[6] = { 25, 24, 29, 33, 32, 41};

	// Variable declarations
	int i, AIV_i, bitcount, AIV_bitcount, k, l, run, sign, level, slevel;
	short *ptr_s, *ptr_AIV_s;
	bool *ptr_b, *ptr_AIV_b;
	const char *ptr_c;
	bool FLC_mode, bits[1408];			// Worst case: 64 FLCs
	bool AIV_bits[1408];
	short AIV_NR;
	bool use_AIV, use_AIC;

	ptr_s = _zigzaged_coef;
	ptr_c = NULL;
	ptr_b = bits;
	bitcount = 0;
	i = 0;
	k = 0;
	AIV_NR = 0;
	AIV_bitcount = 0;


	if (!_PB_B_frame && !_advanced_intra_coding_mode) {
		// INTRADC - DC coefficient for INTRA blocks - 8 bits
		if ( (*_mtype == INTRA) || (*_mtype == INTRAQ) ) {
			k =  *ptr_s++;
			if (EDEBUG) fprintf(stdout, "INTRADC %d ", k);
			
			bitcount = 8;
			for (l=0; l<8; l++, k <<= 1) {	// Restricted value dealt with in quantizer
				if (k & 128) *ptr_b++ = true;
				else *ptr_b++ = false;
			}
			i = 1;
			bit_ostream.WriteNBits(bits, bitcount);
			bitcount = 0;
			ptr_b = bits;
		}
	}

	// shortcut, if INTRADC is all we have
	if (_last_non_zero_index == -1) {
		if (EDEBUG) fprintf(stdout, "\n");
		return;
	}

	// Only when AIV or AIC is on...
	use_AIV = _alternative_inter_vlc_mode && (*_mtype <= 2 || *_mtype == 5);
	use_AIC = _advanced_intra_coding_mode && (*_mtype == INTRA || *_mtype == INTRAQ);
	if (use_AIV || use_AIC) {
		ptr_AIV_s = _zigzaged_coef;
		ptr_AIV_b = AIV_bits;
		AIV_bitcount = 0;
		AIV_i = 0;
		AIV_NR = 0;

		if (EDEBUG) {
			if (*_mtype == INTRA || *_mtype == INTRAQ) fprintf (stdout, "AIC: ");
			else fprintf (stdout, "AIV: ");
		}
		// TCOEF - Transform Coefficient - (Variable Length)
		for (run=0; AIV_i<_last_non_zero_index; AIV_i++) {	// We deal with last index outside loop
			level = *ptr_AIV_s++;
			slevel = level;
			
			if (level == 0) {	// Run check
				run++;
				if (EDEBUG) fprintf (stdout, "0 ");
				continue;
			}
			if (level < 0) {	// Sign check
				level = -level;
				sign = 1;
			}
			else sign = 0;
			
			FLC_mode = false;
			switch (level) {	// VLC table lookup for non-last TCOEFs
			case 1:
				if (run <= 13) {
					ptr_c = AIC_Last0_Level1[run][sign];
					k = AIC_L0L1[run];
					AIV_NR = (short) (AIV_NR + AIC_NR_L0L1[run]);
				}
				else FLC_mode = true;
				break;
			case 2:
				if (run <= 9) {
					ptr_c = AIC_Last0_Level2[run][sign];
					k = AIC_L0L2[run];
					AIV_NR = (short) (AIV_NR + AIC_NR_L0L2[run]);
				}
				else FLC_mode = true;
				break;
			case 3:
				if (run <= 5) {
					ptr_c = AIC_Last0_Level3[run][sign];
					k = AIC_L0L3[run];
					AIV_NR = (short) (AIV_NR + AIC_NR_L0L3[run]);
				} 
				else FLC_mode = true;
				break;
			case 4:
				if (run <= 3) {
					ptr_c = AIC_Last0_Level4[run][sign];
					k = AIC_L0L4[run];
					AIV_NR = (short) (AIV_NR + AIC_NR_L0L4[run]);
				} 
				else FLC_mode = true;
				break;
			case 5:
				if (run <= 1) {
					ptr_c = AIC_Last0_Level5[run][sign];
					k = AIC_L0L5[run];
					AIV_NR = (short) (AIV_NR + AIC_NR_L0L5[run]);
				} 
				else FLC_mode = true;
				break;
			case 6:
				if (run <= 1) {
					ptr_c = AIC_Last0_Level6[run][sign];
					k = AIC_L0L6[run];
					AIV_NR = (short) (AIV_NR + AIC_NR_L0L6[run]);
				} 
				else FLC_mode = true;
				break;
			case 7:
				if (run <= 1) {
					ptr_c = AIC_Last0_Level7[run][sign];
					k = AIC_L0L7[run];
					AIV_NR = (short) (AIV_NR + AIC_NR_L0L7[run]);
				}
				else FLC_mode = true;
				break;
			default:
				if ((run == 0) && (level >= 8) && (level <= 25)) {
					l = level - 8;
					ptr_c = AIC_Last0_Level8_25[l][sign];
					k = AIC_L0L8_25[l];
					AIV_NR = (short) (AIV_NR + AIC_NR_L0L8_25[l]);
				}
				else FLC_mode = true;
			}
			
			if (FLC_mode == false) {
				AIV_bitcount += k;
				for (l=0; l<k; l++) {
					if (*ptr_c++ == '1') *ptr_AIV_b++ = true;
					else *ptr_AIV_b++ = false;
				}
				if (EDEBUG) fprintf(stdout, "%d ", slevel);
			}
			// FLC - Fixed Length Coding
			else {
				AIV_bitcount += 22;
				// ESCAPE - 7 bits
				ptr_c = ESCAPE;
				for (l=0; l<EL; l++) {
					if (*ptr_c++ == '1') *ptr_AIV_b++ = true;
					else *ptr_AIV_b++ = false;
				}
				// LAST - 1 bit - Last TCOEF is handled later
				*ptr_AIV_b++ = false;
				// RUN - 6 bits
				if (run == 0) {
					for (l=0; l<6; l++) *ptr_AIV_b++ = false;
				}
				else {
					k = run;
					for (l=0; l<6; l++, k <<= 1) {
						if (k & 32) *ptr_AIV_b++ = true;
						else *ptr_AIV_b++ = false;
					}
				}
				// LEVEL - 8 bits
				if ((slevel > -128) && (slevel < 128)) {
					k = slevel;
					for (l=0; l<8; l++, k <<= 1) {
						if (k & 128) *ptr_AIV_b++ = true;
						else *ptr_AIV_b++ = false;
					}
					if (EDEBUG) fprintf(stdout, "E%d ", slevel);
				}
				else {
					fprintf(stdout, "\nIllegal value at entropy encoder, %d: %d run %d\n", AIV_i, run, slevel);
				}
				AIV_NR = (short) (AIV_NR + run + 1);
			} // FLC - Fixed Length Coding
			run = 0;
		} // for (run=0; i<_last_non_zero_index; i++)
		
		// Last coefficient processing
		level = *ptr_AIV_s++;
		slevel = level;
		
		if (level < 0) {	// Sign check
			level = -level;
			sign = 1;
		}
		else sign = 0;	
		
		FLC_mode = false;
		switch (level) {
		case 1:
			if (run <= 23) {
				ptr_c = AIC_Last1_Level1[run][sign];
				k = AIC_L1L1[run];
				AIV_NR = (short) (AIV_NR + AIC_NR_L1L1[run]);
			}
			else FLC_mode = true;
			break;
		case 2:
			if (run <= 7) {
				ptr_c = AIC_Last1_Level2[run][sign];
				k = AIC_L1L2[run];
				AIV_NR = (short) (AIV_NR + AIC_NR_L1L2[run]);
			}
			else FLC_mode = true;
			break;
		case 3:
			if (run <= 3) {
				ptr_c = AIC_Last1_Level3[run][sign];
				k = AIC_L1L3[run];
				AIV_NR = (short) (AIV_NR + AIC_NR_L1L3[run]);
			} 
			else FLC_mode = true;
			break;
		case 4:
			if (run <= 1) {
				ptr_c = AIC_Last1_Level4[run][sign];
				k = AIC_L1L4[run];
				AIV_NR = (short) (AIV_NR + AIC_NR_L1L4[run]);
			} 
			else FLC_mode = true;
			break;
		default:
			if ((run == 0) && (level >= 5) && (level <= 10)) {
				l = level - 5;
				ptr_c = AIC_Last1_Level5_10[l][sign];
				k = AIC_L1L5_10[l];
				AIV_NR = (short) (AIV_NR + AIC_NR_L1L5_10[l]);
			}
			else FLC_mode = true;
		}
		
		if (FLC_mode == false) {
			AIV_bitcount += k;
			for (l=0; l<k; l++) {
				if (*ptr_c++ == '1') *ptr_AIV_b++ = true;
				else *ptr_AIV_b++ = false;
			}
			if (EDEBUG) fprintf(stdout, "%d LAST%d\n", slevel, AIV_i);
		}
		// FLC - Fixed Length Coding
		else {
			AIV_bitcount += 22;
			// ESCAPE - 7 bits
			ptr_c = ESCAPE;
			for (l=0; l<EL; l++) {
				if (*ptr_c++ == '1') *ptr_AIV_b++ = true;
				else *ptr_AIV_b++ = false;
			}
			
			// LAST - 1 bit - Last is handled here
			*ptr_AIV_b++ = true;
			// RUN - 6 bits
			if (run == 0) {
				for (l=0; l<6; l++) *ptr_AIV_b++ = false;
			}
			else {
				k = run;
				for (l=0; l<6; l++, k <<= 1) {
					if (k & 32) *ptr_AIV_b++ = true;
					else *ptr_AIV_b++ = false;
				}
			}
			// LEVEL - 8 bits
			if ((slevel > -128) && (slevel < 128)) {
				k = slevel;
				for (l=0; l<8; l++, k <<= 1) {
					if (k & 128) *ptr_AIV_b++ = true;
					else *ptr_AIV_b++ = false;
				}
				if (EDEBUG) fprintf(stdout, "E%d LAST%d\n", slevel, AIV_i);
			}
			else {
				fprintf(stdout, "\nIllegal value at entropy encoder, %d: %d zeros %d LAST\n", AIV_i, run, slevel);
			}
			AIV_NR = (short) (AIV_NR + run + 1);
		} // FLC - Fixed Length Coding
	}
	if (_advanced_intra_coding_mode && (*_mtype == INTRA || *_mtype == INTRAQ)) goto AIC_BYPASS;
	/***************************************************************/
	// Normal VLC tables

	// TCOEF - Transform Coefficient - (Variable Length)
	for (run=0; i<_last_non_zero_index; i++) {	// We deal with last index outside loop
		level = *ptr_s++;
		slevel = level;

		if (level == 0) {	// Run check
			run++;
			if (EDEBUG) fprintf (stdout, "0 ");
			continue;
		}
		if (level < 0) {	// Sign check
			level = -level;
			sign = 1;
		}
		else sign = 0;
		
		FLC_mode = false;
		switch (level) {	// VLC table lookup for non-last TCOEFs
		case 1:
			if (run <= 26) {
				ptr_c = Last0_Level1[run][sign];
				k = L0L1[run];
			}
			else FLC_mode = true;
			break;
		case 2:
			if (run <= 10) {
				ptr_c = Last0_Level2[run][sign];
				k = L0L2[run];
			}
			else FLC_mode = true;
			break;
		case 3:
			if (run <= 6) {
				ptr_c = Last0_Level3[run][sign];
				k = L0L3[run];
			} 
			else FLC_mode = true;
			break;
		case 4:
			if (run <= 2) {
				ptr_c = Last0_Level4[run][sign];
				k = L0L4[run];
			} 
			else FLC_mode = true;
			break;
		case 5:
			if (run <= 1) {
				ptr_c = Last0_Level5[run][sign];
				k = L0L5[run];
			} 
			else FLC_mode = true;
			break;
		case 6:
			if (run <= 1) {
				ptr_c = Last0_Level6[run][sign];
				k = L0L6[run];
			} 
			else FLC_mode = true;
			break;
		default:
			if ((run == 0) && (level >= 7) && (level <= 12)) {
				l = level - 7;
				ptr_c = Last0_Level7_12[l][sign];
				k = L0L7_12[l];
			}
			else FLC_mode = true;
		}
		
		if (FLC_mode == false) {
			bitcount += k;
			for (l=0; l<k; l++) {
				if (*ptr_c++ == '1') *ptr_b++ = true;
				else *ptr_b++ = false;
			}
			if (EDEBUG) fprintf(stdout, "%d ", slevel);
		}
		// FLC - Fixed Length Coding
		else {
			bitcount += 22;
			// ESCAPE - 7 bits
			ptr_c = ESCAPE;
			for (l=0; l<EL; l++) {
				if (*ptr_c++ == '1') *ptr_b++ = true;
				else *ptr_b++ = false;
			}
			// LAST - 1 bit - Last TCOEF is handled later
			*ptr_b++ = false;
			// RUN - 6 bits
			if (run == 0) {
				for (l=0; l<6; l++) *ptr_b++ = false;
			}
			else {
				k = run;
				for (l=0; l<6; l++, k <<= 1) {
					if (k & 32) *ptr_b++ = true;
					else *ptr_b++ = false;
				}
			}
			// LEVEL - 8 bits
			if ((slevel > -128) && (slevel < 128)) {
				k = slevel;
				for (l=0; l<8; l++, k <<= 1) {
					if (k & 128) *ptr_b++ = true;
					else *ptr_b++ = false;
				}
				if (EDEBUG) fprintf(stdout, "E%d ", slevel);
			}
			else {
				fprintf(stdout, "\nIllegal value at entropy encoder, %d: %d run %d\n", i, run, slevel);
			}
		} // FLC - Fixed Length Coding
		run = 0;
	} // for (run=0; i<_last_non_zero_index; i++)

	// Last coefficient processing
	level = *ptr_s++;
	slevel = level;

	if (level < 0) {	// Sign check
		level = -level;
		sign = 1;
	}
	else sign = 0;	
	
	FLC_mode = false;
	switch (level) {
	case 1:
		if (run <= 40) {
			ptr_c = Last1_Level1[run][sign];
			k = L1L1[run];
		}
		else FLC_mode = true;
		break;
	case 2:
		if (run <= 1) {
			ptr_c = Last1_Level2[run][sign];
			k = L1L2[run];
		}
		else FLC_mode = true;
		break;
	case 3:
		if (run == 0) {
			ptr_c = Last1_Level3[sign];
			k = L1L3;
		} 
		else FLC_mode = true;
		break;
	default:
		FLC_mode = true;
	}
	
	if (FLC_mode == false) {
		bitcount += k;
		for (l=0; l<k; l++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		if (EDEBUG) fprintf(stdout, "%d LAST%d\n", slevel, i);
	}
	// FLC - Fixed Length Coding
	else {
		bitcount += 22;
		// ESCAPE - 7 bits
		ptr_c = ESCAPE;
		for (l=0; l<EL; l++) {
			if (*ptr_c++ == '1') *ptr_b++ = true;
			else *ptr_b++ = false;
		}
		
		// LAST - 1 bit - Last is handled here
		*ptr_b++ = true;
		// RUN - 6 bits
		if (run == 0) {
			for (l=0; l<6; l++) *ptr_b++ = false;
		}
		else {
			k = run;
			for (l=0; l<6; l++, k <<= 1) {
				if (k & 32) *ptr_b++ = true;
				else *ptr_b++ = false;
			}
		}
		// LEVEL - 8 bits
		if ((slevel > -128) && (slevel < 128)) {
			k = slevel;
			for (l=0; l<8; l++, k <<= 1) {
				if (k & 128) *ptr_b++ = true;
				else *ptr_b++ = false;
			}
			if (EDEBUG) fprintf(stdout, "E%d LAST%d\n", slevel, i);
		}
		else {
			fprintf(stdout, "\nIllegal value at entropy encoder, %d: %d zeros %d LAST\n", i, run, slevel);
		}
	} // FLC - Fixed Length Coding
AIC_BYPASS:
	// Decide whether or not AIV should be used or not
	if ((use_AIV && (AIV_bitcount < bitcount) && (AIV_NR > 64)) || use_AIC) {
		bit_ostream.WriteNBits(AIV_bits, AIV_bitcount);
		if (EDEBUG) if (*_mtype <= 2 || *_mtype == 5) fprintf(stdout, "AIV_used");
	}
	else bit_ostream.WriteNBits(bits, bitcount);
}


#endif

