
#ifndef __D_BLOCK_ENCODE_CLIP_NON_INTRA_DC_C__
#define __D_BLOCK_ENCODE_CLIP_NON_INTRA_DC_C__

#include "D_Block.h"


/*
 * void D_Block::Encode_Clip_Non_INTRA_DC(void)
 * 
 * Clip quantized AC coefficients during encoding process to between ~127 and 127
 * This is a private method
 *
 * Requires:	Quantize() called before this
 * Modifies:	_quantized_coef
 * Ensures:		Clip AC (incl. INTER DC) to -127 if < -127, or 127 if > 127
 *
 * Warning:		
 */
void D_Block::Encode_Clip_Non_INTRA_DC(void)
{
	int i, mtype;
	short *ptr_s;

	ptr_s = _quantized_coef;
	mtype = *_mtype;
	i = 0;

	if (((mtype == INTRA) || (mtype == INTRAQ)) && (_advanced_intra_coding_mode == false)) {
		i = 1;
		ptr_s++;
	}

	for (; i<64; i++, ptr_s++) {
		if (*ptr_s > 127) {
			*ptr_s = 127;
			continue;
		}
		if (*ptr_s < -127) *ptr_s = -127;
	}
}


#endif

