
#ifndef __D_BLOCK_DECODED_CLIP_NON_INTRA_DC_C__
#define __D_BLOCK_DECODED_CLIP_NON_INTRA_DC_C__

#include "D_Block.h"


/*
 * void D_Block::Decoded_Clip_Non_INTRA_DC(void)
 * 
 * Clip the output of De_Quantize() in _dct_coef to range of -2048 and 2047
 * This is a private method
 *
 * Requires:	De_Quantize() is called before invoking this method
 * Modifies:	_dct_coef
 * Ensures:		Clip AC (incl. INTER DC) to -2048 if < -2048, or 2047 if > 2047
 *
 * Warning:		
 */
void D_Block::Decode_Clip_Non_INTRA_DC(void)
{
	int i, mtype;
	short *ptr_i;

	ptr_i = _dct_coef;
	mtype = *_mtype;
	i = 0;
	if ( (mtype == INTRA) || (mtype == INTRAQ) ) {
		i = 1;
		ptr_i++;
	}

	for (; i<64; i++, ptr_i++) {
		if (*ptr_i > 2047) {
			*ptr_i = 2047;
			continue;
		}
		if (*ptr_i < -2048) *ptr_i = -2048;
	}
}


#endif

