
#ifndef __D_BLOCK_DECODE_BLK_C__
#define __D_BLOCK_DECODE_BLK_C__

#include "D_Block.h"

/*
 * void D_Block::Decode_BLK(const int mquant, const bool B_picture)
 * 
 * Intiates coefficient inverse transformation sequence
 * This is a private method
 *
 * Requires:	Encode_BLK() and Entropy_Encoder() are called already
 * Modifies:	nothing
 * Ensures:		call De_Zigzag_Scan(), De_Quantize(), Decode_Clip_Non_INTRA_DC(), Inverse_DCT()
 *
 * Warning:		
 */
void D_Block::Decode_BLK(const int mquant, const bool B_picture)
{
	_B_picture = B_picture;
	De_Zigzag_Scan();
	if (_advanced_intra_coding_mode && (*_mtype == INTRA || *_mtype == INTRAQ)){
		De_Quantize(mquant);
		AIC_Predictor();
		Advanced_Intra_Reconstructor();
		AIC_ReInitValues();
	} else {
		De_Quantize(mquant);
		Decode_Clip_Non_INTRA_DC();
	}
	Inverse_DCT();
}


#endif

