
#ifndef __D_BLOCK_DE_ZIGZAG_SCAN_C__
#define __D_BLOCK_DE_ZIGZAG_SCAN_C__

#include "D_Block.h"


/*
 * void D_Block::De_ZigZag_Scan(void)
 * 
 * De-Re-Arrange transmitted coefficients or undo the ZigZag Scan in Encode_BLK()
 * This is a private method
 *
 * Requires:	Entropy_Encoder() is called before invoking this method
 * Modifies:	_quantized_coef
 * Ensures:		_quantized_coef[i] = _zigzag_coef[ZIGZAG_ORDER[i]]
 *
 * Warning:		
*/
void D_Block::De_Zigzag_Scan(void)
{
	int i;
	short *ptr_des_i = _quantized_coef;
	if (!_advanced_intra_coding_mode){
		for (i=0; i<64; i++)
			*ptr_des_i++ = _zigzaged_coef[ZIGZAG_ORDER[i]];
	}else {
		switch(_advanced_intra_prediction_mode) {
		case 1:
			for (i=0; i<64; i++) 
				*ptr_des_i++ = _zigzaged_coef[HORIZONTAL_ZIGZAG_ORDER[i] - 1];
			break;
		case 2:
			for (i=0; i<64; i++) 
				*ptr_des_i++ = _zigzaged_coef[VERTICAL_ZIGZAG_ORDER[i] - 1];
			break;
		default:
			for (i=0; i<64; i++) 
				*ptr_des_i++ = _zigzaged_coef[ZIGZAG_ORDER[i]];
			break;
		}
	}
}


#endif

