
#ifndef __D_BLOCK_DE_QUANTIZE_C__
#define __D_BLOCK_DE_QUANTIZE_C__

#include "D_Block.h"


/*
 * void D_Block::De_Quantiz(const in mquant)
 *
 * De_Quantize the encoded coefficients; call De_Zigzag_Scan() first
 * This is a private method
 *
 * Requires:	_quantized_coef initialized by De_Zigzag_Scan()
 * Modifies:	_dct_coef
 * Ensures:		. if intra mode, the DC coefficient is treated as the following:
 *					. if 0 or 128, generate error message and exit the program
 *					. if 255, value reconstructed to 1024 (= 128 * 8)
 *					. Anything else, des[0] = src[0] * 8
 *				. if inter mode, the DC coefficient is treated in the same way as AC coefficients
 *				. For AC coefficients
 *					. des[i] = sign(src[i]) * {step * src[i] + mquant}, if mquant is odd
 *					. des[i] = sign(src[i]) * (step * src[i] + mquant - 1}, if mquant is even
 *					. des[i] is then clipped to be in the range of -2048 and 2047
 *
 * Warning:
 */
void D_Block::De_Quantize(const int mquant)
{
	int i, j, k, l, step, mtype;
	short *ptr_des_i;
	const short *ptr_src_i;

	mtype = *_mtype;
	step = mquant << 1;
	i = 0;						// default: start with DC coefficient
	ptr_des_i = _dct_coef;
	ptr_src_i = _quantized_coef;
	
	if (_advanced_intra_coding_mode && ((mtype == INTRA) || (mtype == INTRAQ))) {
		// AIC DeQuantization
		for (i=0; i<64; i++) {
			k = *ptr_src_i++;
			*ptr_des_i++ = (short)(step * k);
		}
	} else {
		// Intra mode 
		if ( ((mtype == INTRA) || (mtype == INTRAQ)) && (!_B_picture) ) {
			i = 1;					// intra mode: index reset to start with AC coefficient
			k = *ptr_src_i++;
			
			switch (k) {
			case 0:
			case 128:
				cout << "Illegal encoded intra DC value: " << k << endl << endl;
				exit(-9);
				break;
			case 255:
				*ptr_des_i++ = (short) 1024;
				break;
			default:
				*ptr_des_i++ = (short) (k * 8);
			}
		}
		
		// All other coefficients, including DC coefficient in inter mode
		if ((mquant%2) == 0) {	// MQUANT is an even number
			
			for (j=mquant-1; i<64; i++) {
				k = *ptr_src_i++;
				l = step * abs(k) + j;
				if (k < 0) l *= -1;
				else if (k == 0) l = 0;
				*ptr_des_i++ = (short) l;
			}
			
		} else {				// MQUANT is an odd number
			
			for (j=mquant; i<64; i++) {
				k = *ptr_src_i++;
				l = step * abs(k) + j;
				if (k < 0) l *= -1;
				else if (k == 0) l = 0;
				*ptr_des_i++ = (short) l;
			}
		}
	}

}


#endif

