
#ifndef __D_BLOCK_DCT_C__
#define __D_BLOCK_DCT_C__

#include "D_Block.h"


/*
 * void D_Block::DCT(void)
 * 
 * Quantize the DCT coefficents
 * This is a private method
 *
 * Requires:	_fast_frame is intialized with residual pixels
 * Modifies:	_dct_coef
 * Ensures:		. if intra mode, the DC coefficient is quantized with no dead-zone and step 8 and no deadzone
 *					. if quantized to 0, reset to 1
 *					. if quantized to 128, set to 255
 *					. if quantized to 255, set to 254
 *				. if inter mode, the DC coefficient is treated as AC coefficients
 *				. AC coefficients are quantized with dead-zone and step=2*mquant
 *
 * Warning:
 */
void D_Block::DCT(void)
{
    double y0, y1, y2, y3, z0, z1, z2, z3;
	double tmp0, tmp1;
	double *wptr, workspace[64];
	int i;
	short *inptr;
	short *coefptr;

    inptr = _data_fast;
	wptr = workspace;

	for (i=0; i<8; i++)
	{
		y0 = (inptr[2] - inptr[5]) * 0.899976223;		// *c[5]
		y1 = (inptr[3] - inptr[4]) * 2.562915448;		// *c[7]
        y2 = (inptr[1] - inptr[6]) * 0.601344887;		// *c[3]
		y3 = (inptr[0] - inptr[7]) * 0.509795579;		// *c[1]
		
		z0 = (y2 - y0) * 1.306562965;		            // c[6]=1.3065629649 
		z2 = (y3 - y1) * 0.541196100;					// c[2]=0.5411961001 
		z1 = (y2 + y0);
		z3 = (y3 + y1);
		
		y0 = (z2 - z0);                            
		y2 = (z3 - z1);
		y1 = (z2 + z0) * 1.414213562;					// 1.0/c[4]=1.41421356237
		y3 = (z3 + z1) * 1.414213562;					// 1.0/c[4]=1.41421356237
        
		tmp0 = y1 + y0;
		
		wptr[8]  = tmp0 + y3;
		wptr[24] = tmp0 + y2;
		wptr[40] = y0 + y2;
		wptr[56] = y0;
		
		y0 = inptr[2] + inptr[5];
		y1 = inptr[3] + inptr[4];
		y2 = inptr[1] + inptr[6];
        y3 = inptr[0] + inptr[7];
		
		z0 = (y2 - y0) * 1.306562965;					// c[6]
		z2 = (y3 - y1) * 0.541196100;					// c[2]
		z1 = (y2 + y0);
		z3 = (y3 + y1);
		
		tmp0 = (z2 - z0);
		tmp1 = (z2 + z0) * 1.414213562;
		
		wptr[0]  = z3 + z1;
		wptr[16] = tmp0 + tmp1;  
		wptr[32] = z3 - z1;    
		wptr[48] = z2 - z0;
		
		wptr ++;
		inptr += 8;
	}
	
	wptr = workspace;
	coefptr =_dct_coef;
	
    for (i= 0; i<8; i++)
	{
		y0 = (wptr[2] - wptr[5]) * 0.1124970279;		// c[5]*0.125
		y1 = (wptr[3] - wptr[4]) * 0.3203644310;		// c[7]*0.125
        y2 = (wptr[1] - wptr[6]) * 0.0751681109;		// c[3]*0.125
		y3 = (wptr[0] - wptr[7]) * 0.0637244474;		// c[1]*0.125
		
		z0 = (y2 - y0) * 1.306562965;					// c[6]
		z1 = (y2 + y0);
		z2 = (y3 - y1) * 0.541196100;					// c[2]
		z3 = (y3 + y1);
		
		y0 = (z2 - z0);
		y1 = (z2 + z0) * 1.414213562;					// 1/c[4]
		y2 = (z3 - z1);    
		y3 = (z3 + z1) * 1.414213562;					// 1/c[4]
		
		tmp0 = y1 + y0;
		
		coefptr[8]  = (short) (tmp0 + y3);
		coefptr[24] = (short) (tmp0 + y2);
		coefptr[40] = (short) (y0 + y2);
		coefptr[56] = (short) (y0);
		
		y0 = wptr[2] + wptr[5];
		y1 = wptr[3] + wptr[4];
		y2 = wptr[1] + wptr[6];
        y3 = wptr[0] + wptr[7];
		
		z0 = (y2 - y0) * 0.163320371;					// c[6]*0.125;
		z1 = (y2 + y0) * 0.125;                         
		z2 = (y3 - y1) * 0.067649513;					// c[2]*0.125;
		z3 = (y3 + y1) * 0.125;
		
        tmp0 = (z2 + z0) * 1.414213562;
		tmp1 = (z2 - z0);
		
		coefptr[48] = (short) (tmp1);
		coefptr[32] = (short) (z3 - z1);
		coefptr[16] = (short) (tmp1 + tmp0);
		coefptr[0]  = (short) (z3 + z1);
		
		wptr += 8;  
		coefptr++;
	}
}


#endif

