
#ifndef __D_BLOCK_AIC_PREDICTOR_C__
#define __D_BLOCK_AIC_PREDICTOR_C__

#include "D_Block.h"


void D_Block::AIC_ReInitValues(void)
{
	int i;
	const short *ptr_sr, *ptr_sl;

	ptr_sr = _dct_coef;
	ptr_sl = _dct_coef;
	for (i=0; i<8; i++) {
		_row_value[i] = *ptr_sr;
		_col_value[i] = *ptr_sl;
		ptr_sr++;
		ptr_sl += 8;
	}
}
/*
 * void D_Block::AIC_Predictor(void)
 * 
 * Get the predictors used in Advanced Intra Coding
 * This is a private method
 *
 * Requires:	Reset_Hierarchy() is called, _cgi, _mtype
 * Modifies:	_row_predictor, _col_predictor, _row_value, _col_value
 * Ensures:		. Get DCT coefficients from _top
 *				. Get DCT coefficients from _left
 *				. accounting for all coding parameters, set both predictors			
 *
 * Warning:		
 */
void D_Block::AIC_Predictor(void)
{
	int i;
	const short *ptr_sr, *ptr_sl;
	const short *ptr_s;
	bool safe;
	
	// If this block is no INTRA coded, no need to execute
	//if (!((*_mtype == INTRA) || (*_mtype == INTRAQ))) return;

	// Prepare row/col values
	ptr_sr = _dct_coef;
	ptr_sl = _dct_coef;
	for (i=0; i<8; i++) {
		_row_value[i] = *ptr_sr;
		_col_value[i] = *ptr_sl;
		ptr_sr++;
		ptr_sl += 8;
	}

	// Get INTRA coefficients from corresponding in the macroblock above
	safe = false;
	ptr_s = NULL;
	if ((_top != NULL) && (**_cgi == false)) 
		 ptr_s = _top->Get_Predictor(*_clock, _seg_ID, false, &safe);

	if (safe) {
		_row_predictor[0] = ptr_s[0];
		_row_predictor[1] = ptr_s[1];
		_row_predictor[2] = ptr_s[2];
		_row_predictor[3] = ptr_s[3];
		_row_predictor[4] = ptr_s[4];
		_row_predictor[5] = ptr_s[5];
		_row_predictor[6] = ptr_s[6];
		_row_predictor[7] = ptr_s[7];
	}
	else {
		_row_predictor[0] = (short) 1024;
		_row_predictor[1] = (short) 0;
		_row_predictor[2] = (short) 0;
		_row_predictor[3] = (short) 0;
		_row_predictor[4] = (short) 0;
		_row_predictor[5] = (short) 0;
		_row_predictor[6] = (short) 0;
		_row_predictor[7] = (short) 0;
	}

	// Get INTRA coefficients from corresponding in the macroblock to the left
	safe = false;
	ptr_s = NULL;
	if (_left != NULL) ptr_s = _left->Get_Predictor(*_clock, _seg_ID, true, &safe);

	if (safe) {
		_col_predictor[0] = ptr_s[0];
		_col_predictor[1] = ptr_s[1];
		_col_predictor[2] = ptr_s[2];
		_col_predictor[3] = ptr_s[3];
		_col_predictor[4] = ptr_s[4];
		_col_predictor[5] = ptr_s[5];
		_col_predictor[6] = ptr_s[6];
		_col_predictor[7] = ptr_s[7];
	}
	else {
		_col_predictor[0] = (short) 1024;
		_col_predictor[1] = (short) 0;
		_col_predictor[2] = (short) 0;
		_col_predictor[3] = (short) 0;
		_col_predictor[4] = (short) 0;
		_col_predictor[5] = (short) 0;
		_col_predictor[6] = (short) 0;
		_col_predictor[7] = (short) 0;
	}
/*
	// Test code
	Show_ID();
	int j=0;
	short *ptr_i;
	fprintf(stdout, " clock %i cgo %i\n", *_clock, (int) **_cgi);
	ptr_i = _dct_coef;
	for (i=0; i<8; i++) {
		for (j=0; j<8; j++) {
			fprintf(stdout, "%4i ", *ptr_i++);
		}
		fprintf(stdout, "\n");
	}

	fprintf(stdout, "\n");
	for (i=0; i<8; i++) {
		fprintf(stdout, "%4i ", _row_value[i]);
	}
	fprintf(stdout, "\n");
	for (i=0; i<8; i++) {
		fprintf(stdout, "%4i ", _col_value[i]);
	}
	fprintf(stdout, "\n");
	
	for (i=0; i<8; i++) {
		fprintf(stdout, "%4i ", _row_predictor[i]);
	}
	fprintf(stdout, "\n");
	for (i=0; i<8; i++) {
		fprintf(stdout, "%4i ", _col_predictor[i]);
	}
	fprintf(stdout, "\n");
*/
}


/*
 * const short *const D_Block::Get_Predictor(const int clock, 
 *		const short **const seg_ID,	const bool need_column, bool *const safe)
 * 
 * Return AIC predictor information to the caller
 * This is a private method
 *
 * Requires:	only if caller is INTRRA coded and in a corresponding position in a neighbour macroblock
 * Modifies:	*safe
 * Ensures:		. Check internal clock and caller's clock, to account for arbitrary slide order submode
 *				. Check coding type (INTRA or INTER) of this block
 *				. Check caller and callee belong to same segment in slice case
 *				. Set *safe to true if these 3 checks succeed
 *				. accounting for all coding parameters, set both predictors			
 *
 * Note: clock solves 2 problems: arbitrary slice order and a not-coded block (redundant?)
 *
 * Warning:		
 */
const short *const D_Block::Get_Predictor(const int clock, const short **const seg_ID, 
		const bool need_column, bool *const safe)
{
	// Set safe according to macroblock type as well as slice information
	// Necessary to check clock value to take care of arbitrary slice order submode
	*safe = false;
	if ((clock == *_clock) && ((*_mtype == INTRA) || (*_mtype == INTRAQ))) {
		
		// Suppsedly, we can just check the ID tag
		// This requires codec to guarantee, however, ID tag is being
		// properly updated at all times
		// Let's shoot for this in the near future

		if (!_slice_mode) *safe = true;
		else {
			if (**_seg_ID == **seg_ID) *safe = true;
			else *safe = false;
		}
//		Show_ID();
//		fprintf(stdout, "%i %i\n", (int) need_column, (int) *safe);
	}

	if (need_column) return _col_value;
	else return _row_value;
}


#endif

