
#ifndef __D_BLOCK_ADVANCED_INTRA_CODING_C__
#define __D_BLOCK_ADVANCED_INTRA_CODING_C__

#include "D_Block.h"

short D_Block::AIC_Calculate_Mode()
{
	short *aicptr;
	int n, v_sum, h_sum, dc_sum;
		
	DCT();
	AIC_Predictor();

	aicptr = _aic_coef;
	_advanced_intra_prediction_mode = 1;
	Advanced_Intra_Predictor();
	h_sum = 0;
	for (n=0; n<8; n++) {
		h_sum += *aicptr * *aicptr;
		aicptr++;
	}

	aicptr = _aic_coef;
	_advanced_intra_prediction_mode = 2;
	Advanced_Intra_Predictor();
	v_sum = 0;
	for (n=0; n<8; n+=8) {
		v_sum += *aicptr * *aicptr;
		aicptr += 8;
	}
	if (v_sum < h_sum){
		
		aicptr = _aic_coef;
		_advanced_intra_prediction_mode = 0;
		Advanced_Intra_Predictor();
		dc_sum = 0;
		for (n=0; n<8; n+=8) {
			dc_sum += *aicptr * *aicptr;
			aicptr += 8;
		}

		if (dc_sum < v_sum) return 0;
		else return 2;
	}
	else{
		
		aicptr = _aic_coef;
		_advanced_intra_prediction_mode = 0;
		Advanced_Intra_Predictor();
		dc_sum = 0;
		for (n=0; n<8; n+=8) {
			dc_sum += *aicptr * *aicptr;
			aicptr ++;
		}
		if (dc_sum < h_sum) return 0;
		else return 1;
	}

}
void D_Block::Advanced_Intra_Predictor()
{
	short * me, *output;
	int n;
	bool safe_t, safe_l;

	safe_t = safe_l = false;

	if (_advanced_intra_prediction_mode == 0) {
		me = _dct_coef;
		output = _aic_coef;
		safe_t = safe_t = false;
		if ((_top != NULL) && (**_cgi == false)) 
			_top->Get_Predictor(*_clock, _seg_ID, false, &safe_t);
		if (_left != NULL)
			_left->Get_Predictor(*_clock, _seg_ID, true, &safe_l);

		if (safe_t && safe_l) 
			*output = (short) (*me - (_row_predictor[0] + _col_predictor[0])/2);
		else if (safe_t)
			*output = (short) (*me - _row_predictor[0]);
		else if (safe_l)
			*output = (short) (*me - _col_predictor[0]);
		else
			*output = (short) (*me - 1024);

		output++; me++;
		for (n=1;n<64;n++){
			*output = (short) ClipAC(*me);
			output++; me++;
		}

	} else if (_advanced_intra_prediction_mode == 1) {
		intra_H_prediction();
	} else if (_advanced_intra_prediction_mode == 2) {
		intra_V_prediction();
	}
}

void D_Block::Advanced_Intra_Reconstructor()
{
	short * me;
	int n;
	bool safe_t, safe_l;

	safe_l = safe_t = false;
	
	if (_advanced_intra_prediction_mode == 0) {
		me = _dct_coef;
		safe_t = safe_t = false;
		if ((_top != NULL) && (**_cgi == false)) 
			_top->Get_Predictor(*_clock, _seg_ID, false, &safe_t);
		if (_left != NULL)
			 _left->Get_Predictor(*_clock, _seg_ID, true, &safe_l);

		if (safe_t && safe_l) 
			*me = (short) OddifyClipDC(*me + (_row_predictor[0] + _col_predictor[0])/2);
		else if (safe_t)
			*me = (short) OddifyClipDC(*me + _row_predictor[0]);
		else if (safe_l)
			*me = (short) OddifyClipDC(*me + _col_predictor[0]);
		else
			*me = (short) OddifyClipDC(*me + 1024);
		me++;
		for(n=1; n<64; n++) {
			*me = (short) ClipAC(*me);
			me++;
		}
	} else if (_advanced_intra_prediction_mode == 1){
		intra_H_reconstruction();
	} else if (_advanced_intra_prediction_mode == 2) {
		intra_V_reconstruction();
	}
}

void D_Block::intra_V_prediction()
{
	int n;
	short * output, * me;

	me = _dct_coef;
	output = _aic_coef;
	for (n=0;n<64;n++){
		*output = *me;
		output++;me++;
	}

	me = _dct_coef;
	output = _aic_coef;

	*output = (short) (*me - _col_predictor[0]);
	output += 8; me += 8;

	for (n=1; n<8; n++) {
		*output = (short) ClipAC(*me - _col_predictor[n]);
		me += 8;
		output += 8;
	}
}

void D_Block::intra_V_reconstruction()
{
	int n;
	short * me;
	me = _dct_coef;

	*me = (short) OddifyClipDC(*me + _col_predictor[0]);
	me += 8;
	for (n=1; n < 8; n++) {
		*me = (short) ClipAC(*me + _col_predictor[n]);
		me += 8;
	}
}

void D_Block::intra_H_prediction()
{
	int n;
	short * me, * output;

	me = _dct_coef;
	output = _aic_coef;	
	for (n=0;n<64;n++){
		*output = *me;
		output++;me++;
	}

	me = _dct_coef;
	output = _aic_coef;

	*output = (short) (*me - _row_predictor[0]);
	output++; me++;

	for (n=1; n<8; n++) {
		*output = (short) ClipAC(*me - _row_predictor[n]);
		me++;
		output++;
	}
}

void D_Block::intra_H_reconstruction()
{
	int n;
	short *me;

	me = _dct_coef;
	*me = (short) OddifyClipDC(*me + _row_predictor[0]);
	me++;

	for (n=1;n<8;n++){
		*me = (short) (*me + _row_predictor[n]);
		me++;
	}
}

int D_Block::ClipAC(int level) {
	if (level > 2047) return 2047;
	else if (level < -2048) return -2048;
	else return level;
}

int D_Block::ClipDC(int level) {
	if (level < 0)
		return 0;
	else if (level > 2047)
		return 2047;
	else
		return level;
}

int D_Block::OddifyClipDC(int level) {
	if (level % 2 == 0)
		return ClipDC(level + 1);
	else
		return ClipDC(level);
}

#endif
