
#ifndef __D_BLOCK_C__
#define __D_BLOCK_C__

#include "D_Block.h"


/*
 * D_Block::D_Block(void)
 * 
 * Constructor
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	_frame_xsize, _ROW_offset
 * Ensures:		Set according to picture format
 *
 * Warning:		
 */
D_Block::D_Block(void) 
{
	switch (_sformat) {
	case (SQCIF):
		_frame_xsize = SQCIFX; 
		_frame_ysize = SQCIFY;
		_MB_per_gob    = SQCIFX >> 4;
		_GOB_per_frame = SQCIFY >> 4;
		break;
	case (QCIF):
		_frame_xsize = QCIFX; 
		_frame_ysize = QCIFY;
		_MB_per_gob    = QCIFX >> 4;
		_GOB_per_frame = QCIFY >> 4;
		break;
	case (CIF):
		_frame_xsize = CIFX; 
		_frame_ysize = CIFY;
		_MB_per_gob    = CIFX >> 4;
		_GOB_per_frame = CIFY >> 4;
		break;
	case (CIF4):
		_frame_xsize = CIFX4; 
		_frame_ysize = CIFY4;
		_MB_per_gob    = CIFX4 >> 4;
		_GOB_per_frame = CIFY4 >> 4;
		break;
	case (CIF16):
		_frame_xsize = CIFX16; 
		_frame_ysize = CIFY16;
		_MB_per_gob    = CIFX16 >> 4;
		_GOB_per_frame = CIFY16 >> 4;
		break;
	}
	
	_ROW_offset = _frame_xsize;
	_PB_B_frame = false;
}


/*
 * D_Block::~D_Block(void)
 * 
 * Destructor, does nothing
 * This is a public method
 *
 * Requires:	nothing
 * Modifies:	nothing
 * Ensures:		nothing
 *
 * Warning:		
 */
D_Block::~D_Block(void) 
{
	;
}


#endif

