 
#ifndef CONSTANTS_H
#define CONSTANTS_H    /* To stop multiple inclusions */

// Standard-Defined Picture Types
const int SQCIF  = 0;
const int SQCIFX = 128;
const int SQCIFY = 96;

const int QCIF   = 1;
const int QCIFX  = 176;
const int QCIFY  = 144;

const int CIF    = 2;
const int CIFX   = 352;
const int CIFY   = 288;

const int CIF4   = 3;
const int CIFX4  = 704;
const int CIFY4  = 576;

const int CIF16  = 4;
const int CIFX16 = 1408;
const int CIFY16 = 1152;


// Invariant...
const int BLOCK_PER_MACROBLOCK = 6;


// Development Switches
#define DEBUG true
#define EDEBUG false

// Macroblock Type
const int INTER    = 0;
const int INTERQ   = 1;
const int INTER4V  = 2;
const int INTRA    = 3;
const int INTRAQ   = 4;
const int INTER4VQ = 5;

/*
const int ZIGZAG_TABLE[64]={
  0,	1,	5,	6,	14,	15,	27,	28,	
  2,	4,	7,	13,	16,	26,	29,	42,	
  3,	8,	12,	17,	25,	30,	41,	43,	
  9,	11,	18,	24,	31,	40,	44,	53,	
  10,	19,	23,	32,	39,	45,	52,	54,	
  20,	22,	33,	38,	46,	51,	55,	60,	
  21,	34,	37,	47,	50,	56,	59,	61,	
  35,	36,	48,	49,	57,	58,	62,	63
};	//for zigzag scan

template <class T> void zigzag_scan(T* src, T* des)
{
  for(int i=0;i<DCTSIZE2;i++)
    des[ZIGZAG_TABLE[i]]=src[i];
}


template <class T> void dezigzag_scan(T* src, T* des)
{
  for(int i=0;i<DCTSIZE2;i++)
    des[i]=src[ZIGZAG_TABLE[i]];
}
*/

#endif
